/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import org.teasoft.bee.mongodb.MongodbBeeSql;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.api.Condition;
import org.teasoft.bee.osql.api.Suid;
import org.teasoft.honey.osql.core.AbstractCommOperate;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.ConditionImpl;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core._ObjectToSQLHelper;
import org.teasoft.honey.util.StringUtils;

public class MongodbObjSQL
extends AbstractCommOperate
implements Suid {
    private MongodbBeeSql mongodbBeeSql;

    public <T> List<T> select(T entity) {
        if (entity == null) {
            return null;
        }
        this.checkPackage(entity);
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        List list = this.getMongodbBeeSql().select(entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> int update(T entity) {
        if (entity == null) {
            return 0;
        }
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        int updateNum = this.getMongodbBeeSql().update(entity);
        this.doBeforeReturn();
        return updateNum;
    }

    public <T> int insert(T entity) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.INSERT);
        _ObjectToSQLHelper.setInitIdByAuto(entity);
        int insertNum = 0;
        insertNum = this.getMongodbBeeSql().insert(entity);
        HoneyUtil.revertId(entity);
        this.doBeforeReturn();
        return insertNum;
    }

    public <T> long insertAndReturnId(T entity) {
        if (entity == null) {
            return -1L;
        }
        this.doBeforePasreEntity(entity, SuidType.INSERT);
        _ObjectToSQLHelper.setInitIdByAuto(entity);
        long insertNum = 0L;
        insertNum = this.getMongodbBeeSql().insertAndReturnId(entity, null);
        HoneyUtil.revertId(entity);
        this.doBeforeReturn();
        return insertNum;
    }

    public int delete(Object entity) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.DELETE);
        int deleteNum = 0;
        deleteNum = this.getMongodbBeeSql().delete(entity);
        this.doBeforeReturn();
        return deleteNum;
    }

    public <T> List<T> select(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        this.regCondition(condition);
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        if (condition != null) {
            condition.setSuidType(SuidType.SELECT);
        }
        List list = null;
        if (condition != null) {
            ConditionImpl conditionImpl = (ConditionImpl)condition;
            String[] selectFields = conditionImpl.getSelectField();
            if (selectFields != null && selectFields.length == 1 && StringUtils.isNotBlank(selectFields[0])) {
                selectFields = selectFields[0].split(",");
            } else if (condition.getSelectField() == null) {
                condition.selectField(new String[]{HoneyUtil.getColumnNames(entity)});
                HoneyContext.setTrueInSysCommStrLocal("_SYS_Bee_MongoDB_select_all_fields");
            }
        }
        list = this.getMongodbBeeSql().select(entity, condition);
        HoneyContext.removeSysCommStrLocal("_SYS_Bee_MongoDB_select_all_fields");
        this.doBeforeReturn(list);
        return list;
    }

    public <T> int delete(T entity, Condition condition) {
        if (entity == null) {
            return -1;
        }
        this.regCondition(condition);
        this.doBeforePasreEntity(entity, SuidType.DELETE);
        int deleteNum = 0;
        deleteNum = this.getMongodbBeeSql().delete(entity);
        this.doBeforeReturn();
        return deleteNum;
    }

    public Suid setDynamicParameter(String para, String value) {
        OneTimeParameter.setAttribute(para, value);
        return this;
    }

    public void beginSameConnection() {
        OneTimeParameter.setTrueForKey("_SYS_Bee_SAME_CONN_BEGIN");
        if (OneTimeParameter.isTrue("_SYS_Bee_SAME_CONN_EXCEPTION")) {
            Logger.warn("Last SameConnection do not have endSameConnection() or do not run endSameConnection() after having exception.");
        }
    }

    public void endSameConnection() {
        HoneyContext.endSameConnection();
    }

    private <T> void checkPackage(T entity) {
        HoneyUtil.checkPackage(entity);
    }

    public MongodbBeeSql getMongodbBeeSql() {
        if (this.mongodbBeeSql == null) {
            return BeeFactory.getHoneyFactory().getMongodbBeeSql();
        }
        return this.mongodbBeeSql;
    }

    public void setMongodbBeeSql(MongodbBeeSql mongodbBeeSql) {
        this.mongodbBeeSql = mongodbBeeSql;
    }
}

