/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.util.List;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.MoreObjToSQL;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.api.Condition;
import org.teasoft.bee.osql.api.MoreTable;
import org.teasoft.bee.osql.api.SuidRich;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.honey.osql.core.AbstractCommOperate;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MoreInsertUtils;
import org.teasoft.honey.osql.core.MoreTableInsertStruct;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.util.AnnoUtil;

public class MoreObjSQL
extends AbstractCommOperate
implements MoreTable {
    private BeeSql beeSql;
    private MoreObjToSQL moreObjToSQL;
    private static final String SELECT_SQL = "select SQL: ";
    private SuidRich suidRich;

    public <T> List<T> select(T entity) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity);
        String sql = this.getMoreObjToSQL().toSelectSQL(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().moreTableSelect(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> select(T entity, int start, int size) {
        if (entity == null) {
            return null;
        }
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need >0 .");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need >=0 .");
        }
        this.doBeforePasreEntity(entity);
        String sql = this.getMoreObjToSQL().toSelectSQL(entity, start, size);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().moreTableSelect(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> select(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        this.regCondition(condition);
        this.doBeforePasreEntity(entity);
        String sql = this.getMoreObjToSQL().toSelectSQL(entity, condition);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().moreTableSelect(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public MoreObjSQL setDynamicParameter(String para, String value) {
        OneTimeParameter.setAttribute(para, value);
        return this;
    }

    private void doBeforePasreEntity(Object entity) {
        super.doBeforePasreEntity(entity, SuidType.SELECT);
        OneTimeParameter.setAttribute("_SYS_Bee_InterceptorChainForMoreTable", this.getInterceptorChain());
    }

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            this.beeSql = BeeFactory.getHoneyFactory().getBeeSql();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    public MoreObjToSQL getMoreObjToSQL() {
        if (this.moreObjToSQL == null) {
            return BeeFactory.getHoneyFactory().getMoreObjToSQL();
        }
        return this.moreObjToSQL;
    }

    public void setMoreObjToSQL(MoreObjToSQL moreObjToSQL) {
        this.moreObjToSQL = moreObjToSQL;
    }

    public SuidRich getSuidRich() {
        if (this.suidRich == null) {
            this.suidRich = BeeFactory.getHoneyFactory().getSuidRich();
        }
        return this.suidRich;
    }

    public void setSuidRich(SuidRich suidRich) {
        this.suidRich = suidRich;
    }

    public <T> int insert(T entity) {
        return this.modify(entity, SuidType.INSERT);
    }

    public <T> int update(T entity) {
        return this.modify(entity, SuidType.UPDATE);
    }

    public <T> int delete(T entity) {
        return this.modify(entity, SuidType.DELETE);
    }

    private <T> int modify(T entity, SuidType suidType) {
        long returnId = this.modifyOneEntity(entity, suidType);
        if (returnId <= 0L) {
            return (int)returnId;
        }
        MoreTableInsertStruct struct = MoreInsertUtils._getMoreTableInsertStruct(entity);
        if (struct != null) {
            int len = struct.subField.length;
            try {
                for (int k = 0; k < len; ++k) {
                    if (k == 0 && struct.oneHasOne) {
                        OneHasOne t = this.moreInsert(struct, k, returnId, entity, suidType);
                        if (t != null) {
                            ++k;
                            this.moreInsert(struct, 1, t.returnId1, t.subEntity, suidType);
                            continue;
                        }
                        if (SuidType.DELETE != suidType && SuidType.UPDATE != suidType) continue;
                        ++k;
                        continue;
                    }
                    this.moreInsert(struct, k, returnId, entity, suidType);
                }
            }
            catch (IllegalAccessException e) {
                throw ExceptionHelper.convert(e);
            }
            catch (NoSuchFieldException e) {
                throw ExceptionHelper.convert(e);
            }
        }
        if (SuidType.INSERT == suidType) {
            return 1;
        }
        return (int)returnId;
    }

    private OneHasOne moreInsert(MoreTableInsertStruct struct, int i, long returnId, Object currentEntity, SuidType suidType) throws IllegalAccessException, NoSuchFieldException {
        if (struct.subIsList[i]) {
            HoneyUtil.setAccessibleTrue(struct.subField[i]);
            List listSubI = (List)struct.subField[i].get(currentEntity);
            boolean setFlag = false;
            for (Object item : listSubI) {
                for (int propIndex = 0; propIndex < struct.foreignKey[i].length; ++propIndex) {
                    Field fkField = item.getClass().getDeclaredField(struct.foreignKey[i][propIndex]);
                    setFlag = SuidType.INSERT == suidType ? this.setPkField(struct, i, returnId, currentEntity, item, fkField, propIndex) : this.setPkField2(struct, i, returnId, currentEntity, item, fkField, propIndex);
                }
                if (!setFlag) continue;
                if (SuidType.DELETE == suidType) {
                    this.getSuidRich().delete(listSubI.get(i));
                    continue;
                }
                if (SuidType.UPDATE != suidType) continue;
                this.getSuidRich().update(listSubI.get(i));
            }
            if (SuidType.INSERT == suidType) {
                this.getSuidRich().insert(listSubI);
            }
        } else {
            if (struct.subField[i] == null) {
                return null;
            }
            HoneyUtil.setAccessibleTrue(struct.subField[i]);
            Object subEntity = struct.subField[i].get(currentEntity);
            if (subEntity == null) {
                return null;
            }
            for (int propIndex = 0; propIndex < struct.foreignKey[i].length; ++propIndex) {
                Field f = subEntity.getClass().getDeclaredField(struct.foreignKey[i][propIndex]);
                boolean setFlag = SuidType.INSERT == suidType ? this.setPkField(struct, i, returnId, currentEntity, subEntity, f, propIndex) : this.setPkField2(struct, i, returnId, currentEntity, subEntity, f, propIndex);
                if (setFlag || SuidType.INSERT == suidType) continue;
                return null;
            }
            long returnId1 = this.modifyOneEntity(subEntity, suidType);
            if (i == 0 && struct.oneHasOne) {
                OneHasOne t = new OneHasOne();
                t.returnId1 = returnId1;
                t.subEntity = subEntity;
                return t;
            }
        }
        return null;
    }

    private boolean setPkField(MoreTableInsertStruct struct, int i, long returnId, Object currentEntity, Object subEntity, Field fkField, int propIndex) throws IllegalAccessException, NoSuchFieldException {
        boolean useReturnId = false;
        if ("id".equalsIgnoreCase(struct.ref[i][propIndex])) {
            useReturnId = true;
        } else {
            Field refField = currentEntity.getClass().getDeclaredField(struct.ref[i][propIndex]);
            if (AnnoUtil.isPrimaryKey(refField)) {
                useReturnId = true;
            } else {
                HoneyUtil.setAccessibleTrue(fkField);
                HoneyUtil.setAccessibleTrue(refField);
                HoneyUtil.setFieldValue(fkField, subEntity, refField.get(currentEntity));
            }
        }
        if (useReturnId) {
            HoneyUtil.setAccessibleTrue(fkField);
            HoneyUtil.setFieldValue(fkField, subEntity, returnId);
        }
        return true;
    }

    private boolean setPkField2(MoreTableInsertStruct struct, int i, long returnId, Object currentEntity, Object subEntity, Field fkField, int propIndex) throws IllegalAccessException, NoSuchFieldException {
        Field refField = currentEntity.getClass().getDeclaredField(struct.ref[i][propIndex]);
        HoneyUtil.setAccessibleTrue(fkField);
        HoneyUtil.setAccessibleTrue(refField);
        Object v = refField.get(currentEntity);
        if (v == null) {
            Object v2 = fkField.get(subEntity);
            if (v2 == null) {
                return false;
            }
        } else {
            HoneyUtil.setFieldValue(fkField, subEntity, v);
        }
        return true;
    }

    private <T> long modifyOneEntity(T entity, SuidType suidType) {
        long returnId = 0L;
        if (SuidType.INSERT == suidType) {
            returnId = this.getSuidRich().insertAndReturnId(entity);
        } else if (SuidType.UPDATE == suidType) {
            returnId = this.getSuidRich().update(entity);
        } else if (SuidType.DELETE == suidType) {
            returnId = this.getSuidRich().delete(entity);
        }
        return returnId;
    }

    private class OneHasOne {
        long returnId1;
        Object subEntity;

        private OneHasOne() {
        }
    }
}

