/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.api.PreparedSql;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.bee.osql.exception.SqlNullException;
import org.teasoft.honey.osql.core.AbstractCommOperate;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.SqlValueWrap;
import org.teasoft.honey.osql.core.TokenUtil;
import org.teasoft.honey.util.ObjectUtils;

public class PreparedSqlLib
extends AbstractCommOperate
implements PreparedSql {
    private BeeSql beeSql;
    private static final String SELECT_SQL = "PreparedSql select SQL: ";
    private static final String SELECT_MoreTable_SQL = "PreparedSql select MoreTable SQL: ";
    private static final String SELECT_SOME_FIELD_SQL = "PreparedSql selectSomeField SQL: ";
    private static final String SELECT_JSON_SQL = "PreparedSql selectJson SQL: ";
    private static final String STRING_IS_NULL = "sql statement string is Null !";
    private static final String START_GREAT_EQ_0 = "Parameter 'start' need >=0 .";
    private static final String SIZE_GREAT_0 = "Parameter 'size' need >0 .";
    private static boolean showSQL = HoneyConfig.getHoneyConfig().showSQL;
    private static final String INDEX1 = "_SYS[index";
    private static final String INDEX2 = "]_End ";
    private static final String INDEX3 = "]";

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            this.beeSql = BeeFactory.getHoneyFactory().getBeeSql();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    private DbFeature getDbFeature() {
        return BeeFactory.getHoneyFactory().getDbFeature();
    }

    public <T> List<T> select(String sql, Class<T> entityClass, Object[] preValues) {
        this.doBeforePasreEntity(entityClass, SuidType.SELECT);
        this.initPreparedValues(sql, preValues, entityClass);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().select(sql, entityClass);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> select(String sql, Class<T> entityClass) {
        Object[] preValues = null;
        return this.select(sql, entityClass, preValues);
    }

    public <T> List<T> select(String sql, Class<T> entityClass, Object[] preValues, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.doBeforePasreEntity(entityClass, SuidType.SELECT);
        this.regPagePlaceholder();
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = this._toTableName(entityClass);
            OneTimeParameter.setAttribute("_SYS_Bee_TableName", tableName);
            HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entityClass, tableName);
            OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
        }
        sql = this.getDbFeature().toPageSql(sql, start, size);
        this.initPreparedValues(sql, preValues, entityClass);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().select(sql, entityClass);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> select(String sqlStr, T entity, Map<String, Object> map) {
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.initPrepareValuesViaMap(sqlStr, map, entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().select(sql, this.toClassT(entity));
        this.doBeforeReturn(list);
        return list;
    }

    private <T> Class<T> toClassT(T entity) {
        return entity.getClass();
    }

    public <T> List<T> select(String sqlStr, T entity, Map<String, Object> map, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        this.regPagePlaceholder();
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = this._toTableName(entity);
            OneTimeParameter.setAttribute("_SYS_Bee_TableName", tableName);
            HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
            OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
        }
        String pageSql = this.getDbFeature().toPageSql(sqlStr, start, size);
        String sql = this.initPrepareValuesViaMap(pageSql, map, entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().select(sql, this.toClassT(entity));
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> selectSomeField(String sql, T entity, Object[] preValues) {
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        this.initPreparedValues(sql, preValues, entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SOME_FIELD_SQL, sql);
        List list = this.getBeeSql().selectSomeField(sql, this.toClassT(entity));
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> selectSomeField(String sql, T entity, Object[] preValues, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        this.regPagePlaceholder();
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = this._toTableName(entity);
            OneTimeParameter.setAttribute("_SYS_Bee_TableName", tableName);
            HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
            OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
        }
        sql = this.getDbFeature().toPageSql(sql, start, size);
        this.initPreparedValues(sql, preValues, entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SOME_FIELD_SQL, sql);
        List list = this.getBeeSql().selectSomeField(sql, this.toClassT(entity));
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> selectSomeField(String sqlStr, T entity, Map<String, Object> map) {
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.initPrepareValuesViaMap(sqlStr, map, entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SOME_FIELD_SQL, sql);
        List list = this.getBeeSql().selectSomeField(sql, this.toClassT(entity));
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> selectSomeField(String sqlStr, T entity, Map<String, Object> map, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        this.regPagePlaceholder();
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = this._toTableName(entity);
            OneTimeParameter.setAttribute("_SYS_Bee_TableName", tableName);
            HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
            OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
        }
        String pageSql = this.getDbFeature().toPageSql(sqlStr, start, size);
        String sql = this.initPrepareValuesViaMap(pageSql, map, entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SOME_FIELD_SQL, sql);
        List list = this.getBeeSql().selectSomeField(sql, this.toClassT(entity));
        this.doBeforeReturn(list);
        return list;
    }

    public String selectFun(String sql, Object[] preValues) {
        this.doBeforePasreEntity();
        this.initPreparedValues(sql, preValues);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("PreparedSql selectFun SQL: ", sql);
        String s = this.getBeeSql().selectFun(sql);
        this.doBeforeReturn();
        return s;
    }

    public String selectFun(String sqlStr, Map<String, Object> parameterMap) {
        this.doBeforePasreEntity();
        String sql = this.initPrepareValuesViaMap(sqlStr, parameterMap);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("PreparedSql selectFun SQL: ", sql);
        String s = this.getBeeSql().selectFun(sql);
        this.doBeforeReturn();
        return s;
    }

    public List<String[]> select(String sql, Object[] preValues) {
        this.doBeforePasreEntity();
        this.initPreparedValues(sql, preValues);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().select(sql);
        this.doBeforeReturn();
        return list;
    }

    public List<String[]> select(String sql, Object[] preValues, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.doBeforePasreEntity();
        this.regPagePlaceholder();
        sql = this.getDbFeature().toPageSql(sql, start, size);
        this.initPreparedValues(sql, preValues);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().select(sql);
        this.doBeforeReturn();
        return list;
    }

    public List<String[]> select(String sqlStr, Map<String, Object> map) {
        this.doBeforePasreEntity();
        String sql = this.initPrepareValuesViaMap(sqlStr, map);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().select(sql);
        this.doBeforeReturn();
        return list;
    }

    public List<String[]> select(String sqlStr, Map<String, Object> map, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.doBeforePasreEntity();
        this.regPagePlaceholder();
        String pageSql = this.getDbFeature().toPageSql(sqlStr, start, size);
        String sql = this.initPrepareValuesViaMap(pageSql, map);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().select(sql);
        this.doBeforeReturn();
        return list;
    }

    @Deprecated
    public int modify(String sql, Object[] preValues) {
        this.doBeforePasreEntity2();
        this.initPreparedValues(sql, preValues);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("PreparedSql modify SQL: ", sql);
        int r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    @Deprecated
    public int modify(String sqlStr, Map<String, Object> map) {
        this.doBeforePasreEntity2();
        String sql = this.initPrepareValuesViaMap(sqlStr, map);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("PreparedSql modify SQL: ", sql);
        int r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    @Deprecated
    public int modify(String sql) {
        Object[] preValues = null;
        return this.modify(sql, preValues);
    }

    public String selectJson(String sql, Object[] preValues) {
        this.doBeforePasreEntity();
        this.initPreparedValues(sql, preValues);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_JSON_SQL, sql);
        String json = this.getBeeSql().selectJson(sql);
        this.doBeforeReturn();
        return json;
    }

    public String selectJson(String sql, Object[] preValues, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.doBeforePasreEntity();
        this.regPagePlaceholder();
        sql = this.getDbFeature().toPageSql(sql, start, size);
        this.initPreparedValues(sql, preValues);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_JSON_SQL, sql);
        String json = this.getBeeSql().selectJson(sql);
        this.doBeforeReturn();
        return json;
    }

    public String selectJson(String sqlStr, Map<String, Object> map) {
        this.doBeforePasreEntity();
        String sql = this.initPrepareValuesViaMap(sqlStr, map);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_JSON_SQL, sql);
        String json = this.getBeeSql().selectJson(sql);
        this.doBeforeReturn();
        return json;
    }

    public String selectJson(String sqlStr, Map<String, Object> map, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.doBeforePasreEntity();
        this.regPagePlaceholder();
        String pageSql = this.getDbFeature().toPageSql(sqlStr, start, size);
        String sql = this.initPrepareValuesViaMap(pageSql, map);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_JSON_SQL, sql);
        String json = this.getBeeSql().selectJson(sql);
        this.doBeforeReturn();
        return json;
    }

    public String selectJson(String sql) {
        Object[] preValues = null;
        return this.selectJson(sql, preValues);
    }

    public List<String[]> select(String sql) {
        Object[] preValues = null;
        return this.select(sql, preValues);
    }

    public String selectFun(String sql) {
        Object[] preValues = null;
        return this.selectFun(sql, preValues);
    }

    private <T> void initPreparedValues(String sql, Object[] preValues, T entity) {
        List list = this._initPreparedValues(sql, preValues);
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = (String)OneTimeParameter.getAttribute("_SYS_Bee_TableName");
            if (tableName == null) {
                tableName = this._toTableName(entity);
            }
        } else {
            tableName = this._toTableName(entity);
        }
        HoneyUtil.setPageNum(list);
        HoneyContext.setContext(sql, list, tableName);
    }

    private void initPreparedValues(String sql, Object[] preValues) {
        List list = this._initPreparedValues(sql, preValues);
        HoneyUtil.setPageNum(list);
        HoneyContext.setPreparedValue(sql, list);
    }

    private List _initPreparedValues(String sql, Object[] preValues) {
        if (sql == null || "".equals(sql.trim())) {
            throw new SqlNullException(STRING_IS_NULL);
        }
        PreparedValue preparedValue = null;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        for (int i = 0; preValues != null && i < preValues.length; ++i) {
            preparedValue = new PreparedValue();
            preparedValue.setType(preValues[i].getClass().getName());
            preparedValue.setValue(preValues[i]);
            list.add(preparedValue);
        }
        return list;
    }

    private <T> Map<String, Object> mergeMap(Map<String, Object> prameterMap, T entity) {
        Map<String, Object> columnMap = HoneyUtil.getColumnMapByEntity(entity);
        if (prameterMap != null) {
            columnMap.putAll(prameterMap);
        }
        return columnMap;
    }

    private <T> String initPrepareValuesViaMap(String sqlStr, Map<String, Object> parameterMap, T entity) {
        String reSql;
        if (sqlStr == null || "".equals(sqlStr.trim())) {
            throw new SqlNullException(STRING_IS_NULL);
        }
        parameterMap = this.mergeMap(parameterMap, entity);
        SqlValueWrap wrap = this.processSql2(sqlStr, parameterMap);
        ArrayList<PreparedValue> list = null;
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = (String)OneTimeParameter.getAttribute("_SYS_Bee_TableName");
            if (tableName == null) {
                tableName = this._toTableName(entity);
            }
        } else {
            tableName = this._toTableName(entity);
        }
        if (wrap == null) {
            reSql = sqlStr;
            list = new ArrayList();
        } else {
            String sql = wrap.getSql();
            list = wrap.getList();
            reSql = sql;
        }
        HoneyUtil.setPageNum(list);
        HoneyContext.setContext(reSql, list, tableName);
        return reSql;
    }

    private String initPrepareValuesViaMap(String sqlStr, Map<String, Object> map) {
        if (sqlStr == null || "".equals(sqlStr.trim())) {
            throw new SqlNullException(STRING_IS_NULL);
        }
        SqlValueWrap wrap = this.processSql2(sqlStr, map);
        if (wrap == null || ObjectUtils.isEmpty(map)) {
            return sqlStr;
        }
        String sql = wrap.getSql();
        List<PreparedValue> list = wrap.getList();
        HoneyUtil.setPageNum(list);
        HoneyContext.setPreparedValue(sql, list);
        return sql;
    }

    private List _initPreparedValues(String[] keys, Map<String, Object> map) {
        PreparedValue preparedValue = null;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        for (int i = 0; i < keys.length; ++i) {
            preparedValue = new PreparedValue();
            Object value = map.get(keys[i]);
            preparedValue.setValue(value);
            if (value != null) {
                preparedValue.setType(value.getClass().getName());
            } else {
                preparedValue.setType(Object.class.getName());
            }
            list.add(preparedValue);
        }
        return list;
    }

    private SqlValueWrap processSql(String sql) {
        return TokenUtil.process(sql, "#{", "}", "?");
    }

    private SqlValueWrap processSql2(String sql, Map map) {
        return TokenUtil.process2(sql, "#{", "}", "?", map);
    }

    private String _toTableName(Object entity) {
        return HoneyUtil.toTableName(entity);
    }

    private void regPagePlaceholder() {
        HoneyUtil.regPagePlaceholder();
    }

    private boolean isNeedRealTimeDb() {
        return HoneyContext.isNeedRealTimeDb();
    }

    public List<Map<String, Object>> selectMapList(String sql) {
        return this.selectMapList(sql, null);
    }

    public List<Map<String, Object>> selectMapList(String sqlStr, Map<String, Object> parameterMap) {
        this.doBeforePasreEntity();
        String sql = this.initPrepareValuesViaMap(sqlStr, parameterMap);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("PreparedSql selectMapList SQL: ", sql);
        List list = this.getBeeSql().selectMapList(sql);
        this.doBeforeReturn();
        return list;
    }

    public List<Map<String, Object>> selectMapList(String sqlStr, Map<String, Object> parameterMap, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.doBeforePasreEntity();
        this.regPagePlaceholder();
        String pageSql = this.getDbFeature().toPageSql(sqlStr, start, size);
        String sql = this.initPrepareValuesViaMap(pageSql, parameterMap);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("PreparedSql selectMapList SQL: ", sql);
        List list = this.getBeeSql().selectMapList(sql);
        this.doBeforeReturn();
        return list;
    }

    public <T> List<T> moreTableSelect(String sqlStr, T returnType) {
        return this.moreTableSelect(sqlStr, returnType, null);
    }

    public <T> List<T> moreTableSelect(String sqlStr, T entity, Map<String, Object> map) {
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.initPrepareValuesViaMap(sqlStr, map, entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_MoreTable_SQL, sql);
        List list = this.getBeeSql().select(sql, this.toClassT(entity));
        this.doBeforeReturn(list);
        return list;
    }

    private <T> String _moreTableSelect(String sqlStr, T entity, Map<String, Object> map, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        this.regPagePlaceholder();
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = this._toTableName(entity);
            OneTimeParameter.setAttribute("_SYS_Bee_TableName", tableName);
            HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
            OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
        }
        String pageSql = this.getDbFeature().toPageSql(sqlStr, start, size);
        String sql = this.initPrepareValuesViaMap(pageSql, map, entity);
        sql = this.doAfterCompleteSql(sql);
        return sql;
    }

    public <T> List<T> moreTableSelect(String sqlStr, T entity, Map<String, Object> map, int start, int size) {
        String sql = this._moreTableSelect(sqlStr, entity, map, start, size);
        Logger.logSQL(SELECT_MoreTable_SQL, sql);
        List list = this.getBeeSql().moreTableSelect(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public int insertBatch(String sqlStr, List<Map<String, Object>> parameterMapList, int batchSize) {
        if (sqlStr == null || "".equals(sqlStr.trim())) {
            throw new SqlNullException(STRING_IS_NULL);
        }
        if (ObjectUtils.isEmpty(parameterMapList)) {
            Logger.warn("parameterMapList is empty!");
            return 0;
        }
        sqlStr = HoneyUtil.deleteLastSemicolon(sqlStr);
        this.doBeforePasreEntity2();
        int size = parameterMapList.size();
        SqlValueWrap wrap = this.processSql(sqlStr);
        if (wrap == null || ObjectUtils.isEmpty(parameterMapList.get(0))) {
            return 0;
        }
        String[] insertSql = new String[size];
        insertSql[0] = wrap.getSql();
        String mapKeys = wrap.getValueBuffer().toString();
        String[] keys = mapKeys.split(",");
        insertSql[0] = this.doAfterCompleteSql(insertSql[0]);
        String sql_i = null;
        ArrayList<PreparedValue> preparedValueList = new ArrayList<PreparedValue>();
        for (int i = 0; i < size; ++i) {
            List oneRecoreList = this._initPreparedValues(keys, parameterMapList.get(i));
            sql_i = INDEX1 + i + INDEX2 + insertSql[0];
            if (HoneyUtil.isMysql()) {
                if (i == 0) {
                    OneTimeParameter.setAttribute("_SYS_Bee_PlaceholderValue", this.getPlaceholderValue(keys.length));
                    HoneyContext.setPreparedValue(sql_i, oneRecoreList);
                }
                preparedValueList.addAll(oneRecoreList);
                if ((i + 1) % batchSize == 0) {
                    HoneyContext.setPreparedValue(insertSql[0] + "  [Batch:" + i / batchSize + INDEX3, preparedValueList);
                    preparedValueList = new ArrayList();
                } else if (i == size - 1) {
                    HoneyContext.setPreparedValue(insertSql[0] + "  [Batch:" + i / batchSize + INDEX3, preparedValueList);
                }
            }
            if (HoneyUtil.isMysql() && !showSQL) continue;
            HoneyContext.setPreparedValue(sql_i, oneRecoreList);
        }
        int a = this.getBeeSql().batch(insertSql, batchSize);
        this.doBeforeReturn();
        return a;
    }

    private String getPlaceholderValue(int size) {
        return HoneyUtil.getPlaceholderValue(size);
    }

    public int insertBatch(String sqlStr, List<Map<String, Object>> parameterMapList) {
        int batchSize = HoneyConfig.getHoneyConfig().insertBatchSize;
        return this.insertBatch(sqlStr, parameterMapList, batchSize);
    }

    private void doBeforePasreEntity() {
        Object entity = null;
        super.doBeforePasreEntity((Object)entity, SuidType.SELECT);
    }

    private void doBeforePasreEntity2() {
        Object entity = null;
        super.doBeforePasreEntity((Object)entity, SuidType.MODIFY);
    }
}

