/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.dialect.sqlserver;

import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.dialect.sqlserver.AbstractSqlServerFeature;
import org.teasoft.honey.osql.dialect.sqlserver.SqlServerPagingStruct;
import org.teasoft.honey.util.StringUtils;

public class SqlServerFeature2012
extends AbstractSqlServerFeature
implements DbFeature {
    private static String PAGING = " order by id offset #start row fetch next #size rows only";
    private static String DISTINCT = "distinct";
    private boolean initFlag = false;

    private void init() {
        if (HoneyUtil.isSqlKeyWordUpper()) {
            PAGING = PAGING.toUpperCase();
            DISTINCT = DISTINCT.toUpperCase();
        }
    }

    public String toPageSql(String sql, int start, int size) {
        sql = HoneyUtil.deleteLastSemicolon(sql);
        if (!this.initFlag) {
            this.init();
            this.initFlag = true;
        }
        if (start <= 0 && sql.indexOf(DISTINCT) > -1) {
            return this.toPageSql(sql, size);
        }
        String processSql = PAGING;
        SqlServerPagingStruct struct = HoneyContext.getAndRemoveSqlServerPagingStruct(sql);
        if (struct != null) {
            String pkName = struct.getOrderColumn();
            String orderType = struct.getOrderType().getName();
            boolean hasOrderBy = struct.isHasOrderBy();
            processSql = hasOrderBy ? this.adjustSqlServerPaging11(processSql) : this.adjustSqlServerPagingPk11(processSql, pkName, orderType);
        }
        sql = HoneyUtil.isSqlKeyWordUpper() ? sql + processSql.replace("#START", start + "").replace("#SIZE", size + "") : sql + processSql.replace("#start", start + "").replace("#size", size + "");
        return sql;
    }

    @Override
    public String toPageSql(String sql, int size) {
        if (!this.initFlag) {
            this.init();
            this.initFlag = true;
        }
        return super.toPageSql(sql, size);
    }

    private String adjustSqlServerPagingPk11(String processSql, String pkName, String orderType) {
        if (StringUtils.isBlank(pkName)) {
            return processSql;
        }
        String ID = "id";
        if (HoneyUtil.isSqlKeyWordUpper()) {
            ID = ID.toUpperCase();
            orderType = orderType.toUpperCase();
        }
        if ("desc".equalsIgnoreCase(orderType)) {
            return processSql.replace(ID, pkName + " " + orderType);
        }
        return processSql.replace(ID, pkName);
    }

    private String adjustSqlServerPaging11(String processSql) {
        String str = " order by id ";
        if (HoneyUtil.isSqlKeyWordUpper()) {
            str = str.toUpperCase();
        }
        return processSql.replace(str, " ");
    }
}

