/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.interccept.annotation;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import org.teasoft.bee.osql.annotation.Dict;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.util.StringUtils;

public class DictHandler {
    private static final String placeholderStr = "@#placeholderStr(default do not process)";

    private DictHandler() {
    }

    public static void process(Field field, List list) {
        try {
            int i;
            Dict anno = field.getAnnotation(Dict.class);
            String mapStr = anno.map();
            HashMap<String, String> dictMap = new HashMap<String, String>();
            if (StringUtils.isNotBlank(mapStr)) {
                String[] kvPair = mapStr.split(",");
                for (i = 0; i < kvPair.length; ++i) {
                    String[] kv = kvPair[i].split("=");
                    dictMap.put(kv[0], kv[1]);
                }
            }
            boolean isReplaceNull = false;
            String nullToValue = anno.nullToValue();
            if (!placeholderStr.equals(nullToValue)) {
                isReplaceNull = true;
            }
            for (i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                Field f = obj.getClass().getDeclaredField(field.getName());
                HoneyUtil.setAccessibleTrue(f);
                Object value = f.get(obj);
                if (value == null) {
                    if (!isReplaceNull) continue;
                    HoneyUtil.setFieldValue(f, obj, nullToValue);
                    continue;
                }
                String v = (String)dictMap.get((String)value);
                if (v == null) continue;
                HoneyUtil.setFieldValue(f, obj, v);
            }
        }
        catch (Exception e) {
            Logger.warn(e.getMessage(), e);
        }
    }
}

