/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teasoft.bee.osql.Op;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.api.Condition;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.bee.osql.exception.ShardingErrorException;
import org.teasoft.bee.sharding.DsTabStruct;
import org.teasoft.bee.sharding.ShardingBean;
import org.teasoft.bee.sharding.ShardingSimpleStruct;
import org.teasoft.honey.osql.core.ConditionImpl;
import org.teasoft.honey.osql.core.Expression;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.interccept.EmptyInterceptor;
import org.teasoft.honey.osql.util.AnnoUtil;
import org.teasoft.honey.sharding.MultiTenancyHandlerController;
import org.teasoft.honey.sharding.ShardingAnnoHandlerController;
import org.teasoft.honey.sharding.ShardingDsTabHandler;
import org.teasoft.honey.sharding.ShardingReg;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.config.ShardingRegistry;
import org.teasoft.honey.util.ObjectUtils;
import org.teasoft.honey.util.SetList;
import org.teasoft.honey.util.StringUtils;

public class ShardingInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = 1595293159217L;
    private final String partKey = "_SYS_Bee_ShardingInterceptor";
    private boolean showShardingSQL = this.getShowShardingSQL();
    private static final String DoNotSetTabShadngValue = "Do not set the sharding value for table!";
    private List<String> dsNameListForBatch = null;
    private List<String> tabNameListForBatch = null;
    private Set<String> dsNameSetForBatch = null;
    private Set<String> tabNameSetForBatch = null;
    private boolean batchInsert = false;

    private boolean getShowShardingSQL() {
        return HoneyConfig.getHoneyConfig().showSQL && HoneyConfig.getHoneyConfig().showShardingSQL;
    }

    @Override
    public Object beforePasreEntity(Object entity, SuidType suidType) {
        String key;
        Boolean flag;
        boolean isSharding = ShardingUtil.isSharding();
        if (!isSharding) {
            return entity;
        }
        if (HoneyContext.isInterceptorSubEntity()) {
            return entity;
        }
        if (this.isSkip(entity, suidType)) {
            return entity;
        }
        String tableName = this._toTableName(entity);
        if (isSharding && ShardingRegistry.isBroadcastTab(tableName)) {
            if (suidType == SuidType.SELECT) {
                this.ds = ShardingRegistry.getRandDs(tableName);
            } else {
                this.regFullInModifyAllNodes(suidType);
            }
            return entity;
        }
        if (isSharding && suidType == SuidType.DDL) {
            this.regFullInModifyAllNodes(suidType);
            return entity;
        }
        if (this.isHintBoth()) {
            return entity;
        }
        if (this.isHintTab()) {
            String t_ds = ShardingRegistry.getDsByTab(HoneyContext.getAppointTab());
            if (StringUtils.isNotBlank(t_ds)) {
                HoneyContext.setAppointDS(t_ds);
                return entity;
            }
        } else if (this.isHintDs()) {
            this.ds = HoneyContext.getAppointDS();
        }
        if (Boolean.FALSE.equals(flag = HoneyContext.getCustomFlagMap(key = "_SYS_Bee_ShardingInterceptor_beforePasreEntity" + entity.getClass().getName()))) {
            return entity;
        }
        Field[] fields = entity.getClass().getDeclaredFields();
        int len = fields.length;
        boolean isHas = false;
        int annoCounter = 0;
        DsTabStruct dsTabStruct = null;
        ShardingBean shardingBean = null;
        Condition condition = HoneyContext.getConditionLocal();
        for (int i = 0; i < len; ++i) {
            if (ShardingUtil.isSharding() && AnnoUtil.isShardingAnno(fields[i])) {
                if (flag == null && !isHas) {
                    isHas = true;
                }
                ++annoCounter;
                ShardingSimpleStruct shardingSimpleStruct = null;
                if (condition != null) {
                    shardingSimpleStruct = new ShardingSimpleStruct();
                    shardingSimpleStruct.setTabName(tableName);
                }
                dsTabStruct = ShardingAnnoHandlerController.process(fields[i], entity, suidType, shardingSimpleStruct);
                if (condition == null) continue;
                shardingBean = new ShardingBean(shardingSimpleStruct);
                shardingBean.setTabField(fields[i].getName());
                shardingBean.setDsField(fields[i].getName());
                continue;
            }
            if (!AnnoUtil.isMultiTenancyAnno(fields[i])) continue;
            if (flag == null && !isHas) {
                isHas = true;
            }
            ++annoCounter;
            dsTabStruct = MultiTenancyHandlerController.process(fields[i], entity, suidType);
        }
        if (annoCounter > 1) {
            throw new BeeErrorGrammarException("One Class just allow one field has MultiTenancy or Sharding Annotaion!");
        }
        if (annoCounter == 1) {
            if (condition == null) {
                if (dsTabStruct != null) {
                    this.adjustValue(dsTabStruct, entity);
                    this.setValeueForOneDsOneTab(dsTabStruct, suidType);
                } else {
                    this.regFullorHintDsFull(suidType);
                }
                if (flag == null) {
                    HoneyContext.addCustomFlagMap(key, isHas);
                }
                return entity;
            }
            boolean sharded = this.processCondition(entity, shardingBean, condition, dsTabStruct, suidType);
            if (!sharded && dsTabStruct == null) {
                this.regFullorHintDsFull(suidType);
            }
        } else if (ShardingUtil.isSharding()) {
            shardingBean = ShardingRegistry.getShardingBean(entity.getClass());
            if (shardingBean == null) {
                shardingBean = ShardingRegistry.getShardingBean(this._toTableName(entity));
            }
            int type = 0;
            if (shardingBean != null) {
                if (ObjectUtils.isNotEmpty(shardingBean.getTabField())) {
                    ++type;
                    shardingBean.setTabShardingValue(this.getFieldValue(entity, shardingBean.getTabField()));
                }
                if (ObjectUtils.isNotEmpty(shardingBean.getDsField())) {
                    type += 2;
                    shardingBean.setDsShardingValue(this.getFieldValue(entity, shardingBean.getDsField()));
                }
                if (type == 0) {
                    if (flag == null) {
                        HoneyContext.addCustomFlagMap(key, isHas);
                    }
                    return entity;
                }
                if (StringUtils.isBlank(shardingBean.getTabName())) {
                    shardingBean.setTabName(tableName);
                }
                if (flag == null && !isHas) {
                    isHas = true;
                }
                dsTabStruct = new ShardingDsTabHandler().process((ShardingSimpleStruct)shardingBean);
                if (condition == null) {
                    if (dsTabStruct != null) {
                        this.adjustValue(dsTabStruct, entity);
                        this.setValeueForOneDsOneTab(dsTabStruct, suidType);
                    } else {
                        this.regFullorHintDsFull(suidType);
                    }
                } else if (condition != null) {
                    boolean sharded = this.processCondition(entity, shardingBean, condition, dsTabStruct, suidType);
                    if (dsTabStruct == null && !sharded) {
                        this.regFullorHintDsFull(suidType);
                    }
                }
            } else {
                Logger.debug("Confirm whether had set sharding config for entity: " + entity.getClass().getName());
            }
        }
        if (flag == null) {
            HoneyContext.addCustomFlagMap(key, isHas);
        }
        return entity;
    }

    private boolean isHintBoth() {
        return ShardingUtil.isTrueInSysCommStrLocal("_SYS_Bee_HintDs") && ShardingUtil.isTrueInSysCommStrLocal("_SYS_Bee_HintTab");
    }

    private boolean isHintDs() {
        return ShardingUtil.isTrueInSysCommStrLocal("_SYS_Bee_HintDs");
    }

    private boolean isHintTab() {
        return ShardingUtil.isTrueInSysCommStrLocal("_SYS_Bee_HintTab");
    }

    private void regFullorHintDsFull(SuidType suidType) {
        if (this.isHintDs()) {
            ShardingReg.regSomeDsFull(suidType);
            ArrayList<String> dsList = new ArrayList<String>();
            dsList.add(HoneyContext.getAppointDS());
            ShardingReg.regShardingJustDs(dsList);
        } else {
            ShardingReg.regFull(suidType);
        }
    }

    private void regFullInModifyAllNodes(SuidType suidType) {
        ShardingReg.regFullInModifyAllNodes(suidType);
    }

    private boolean processCondition(Object entity, ShardingBean shardingBean, Condition condition, DsTabStruct dsTabStruct0, SuidType suidType) {
        DsTabStruct dsTabStruct = null;
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        List<Expression> expList = conditionImpl.getExpList();
        Expression expression = null;
        SetList<String> dsNameList = new SetList<String>();
        SetList<String> tabNameList = new SetList<String>();
        SetList<String> tabSuffixList = new SetList<String>();
        HashMap<String, String> tab2DsMap = new HashMap<String, String>();
        this.setValeueForSharding(dsTabStruct0, dsNameList, tabNameList, tabSuffixList, tab2DsMap);
        shardingBean.setDsShardingValue(null);
        shardingBean.setTabShardingValue(null);
        boolean sharded = false;
        for (int j = 0; j < expList.size(); ++j) {
            List inList;
            expression = expList.get(j);
            if (!this.isShardingField(shardingBean, expression.getFieldName())) continue;
            String opType = expression.getOpType();
            boolean foundSharding = false;
            if (Op.eq.getOperator().equalsIgnoreCase(opType)) {
                foundSharding = this.checkAndProcessShardingField(shardingBean, expression.getFieldName(), expression.getValue());
                if (!foundSharding) continue;
                dsTabStruct = new ShardingDsTabHandler().process((ShardingSimpleStruct)shardingBean);
                if (dsTabStruct != null) {
                    sharded = true;
                }
                this.setValeueForSharding(dsTabStruct, dsNameList, tabNameList, tabSuffixList, tab2DsMap);
                shardingBean.setDsShardingValue(null);
                shardingBean.setTabShardingValue(null);
                continue;
            }
            if (!Op.in.getOperator().equalsIgnoreCase(opType) && !(" " + K.between + " ").equalsIgnoreCase(opType)) continue;
            Object v = expression.getValue();
            if (Op.in.getOperator().equalsIgnoreCase(opType)) {
                inList = ShardingInterceptor.processIn(v);
            } else {
                String tableName = this._toTableName(entity);
                int tabSize = ShardingRegistry.getTabSize(tableName);
                Object v2 = expression.getValue2();
                inList = ShardingInterceptor.processBetween(v, v2, tabSize);
            }
            int len = inList.size();
            for (Object value : inList) {
                foundSharding = this.checkAndProcessShardingField(shardingBean, expression.getFieldName(), value);
                if (!foundSharding) continue;
                dsTabStruct = new ShardingDsTabHandler().process((ShardingSimpleStruct)shardingBean);
                if (dsTabStruct != null) {
                    sharded = true;
                }
                this.setValeueForSharding(dsTabStruct, dsNameList, tabNameList, tabSuffixList, tab2DsMap);
                shardingBean.setDsShardingValue(null);
                shardingBean.setTabShardingValue(null);
            }
        }
        if (this.showShardingSQL) {
            Logger.debug("dsNameList: " + ((Object)dsNameList).toString());
            Logger.debug("tabNameList: " + ((Object)tabNameList).toString());
            Logger.debug("tabSuffixList: " + ((Object)tabSuffixList).toString());
            Logger.debug("tab2DsMap: " + ((Object)tab2DsMap).toString());
        }
        if (tabSuffixList.size() == 0 && dsNameList.size() > 0) {
            ShardingReg.regSomeDsFull(suidType);
            ShardingReg.regShardingJustDs(dsNameList);
        } else if (dsNameList.size() > 1 || tabNameList.size() > 1 || tabSuffixList.size() > 1) {
            ShardingReg.regHadSharding();
            if (tabSuffixList.size() > 1 && tabNameList.size() < 1) {
                String tableName = this._toTableName(entity);
                for (int i = 0; i < tabSuffixList.size(); ++i) {
                    String tab = tableName.replace("[$#(index)#$]", (CharSequence)tabSuffixList.get(i));
                    tabNameList.add(tab);
                    tab2DsMap.put(tab, (String)tab2DsMap.get(tabSuffixList.get(i)));
                }
            }
            this.tabName = null;
            this.tabName = null;
            this.tabSuffix = null;
            String dsName = "";
            for (int i = 0; i < tabNameList.size(); ++i) {
                if (this.isHintDs()) {
                    dsName = HoneyContext.getAppointDS();
                } else {
                    dsName = (String)tab2DsMap.get(tabSuffixList.get(i));
                    if (StringUtils.isBlank(dsName)) {
                        dsName = ShardingRegistry.getDsByTab((String)tabNameList.get(i));
                    }
                }
                if (StringUtils.isNotBlank(dsName)) {
                    dsNameList.add(dsName);
                    continue;
                }
                Logger.error("Table name :" + (String)tabNameList.get(i) + " , can not find its dataSoure name!");
            }
            ShardingReg.regShardingManyTables(dsNameList, tabNameList, tabSuffixList, tab2DsMap);
            if (this.showShardingSQL) {
                Logger.debug("after process: ");
                Logger.debug("dsNameList: " + ((Object)dsNameList).toString());
                Logger.debug("tabNameList: " + ((Object)tabNameList).toString());
                Logger.debug("tabSuffixList: " + ((Object)tabSuffixList).toString());
                Logger.debug("tab2DsMap: " + ((Object)tab2DsMap).toString());
            }
        } else {
            dsTabStruct = new DsTabStruct();
            if (dsNameList.size() == 1) {
                dsTabStruct.setDsName((String)dsNameList.get(0));
            }
            if (tabNameList.size() == 1) {
                dsTabStruct.setTabName((String)tabNameList.get(0));
            }
            if (tabSuffixList.size() == 1) {
                dsTabStruct.setTabSuffix((String)tabSuffixList.get(0));
            }
            this.adjustValue(dsTabStruct, entity);
            this.setValeueForOneDsOneTab(dsTabStruct, suidType);
        }
        return sharded;
    }

    private boolean isShardingField(ShardingBean shardingBean, String fieldName) {
        boolean foundSharding = false;
        String dsField = shardingBean.getDsField();
        String tabField = shardingBean.getTabField();
        if (dsField != null && dsField.equals(fieldName)) {
            foundSharding = true;
        }
        if (tabField != null && tabField.equals(fieldName)) {
            foundSharding = true;
        }
        return foundSharding;
    }

    private boolean checkAndProcessShardingField(ShardingBean shardingBean, String fieldName, Object value) {
        boolean foundSharding = false;
        String dsField = shardingBean.getDsField();
        String tabField = shardingBean.getTabField();
        if (dsField != null && dsField.equals(fieldName)) {
            shardingBean.setDsShardingValue(value);
            foundSharding = true;
        }
        if (tabField != null && tabField.equals(fieldName)) {
            shardingBean.setTabShardingValue(value);
            foundSharding = true;
        }
        return foundSharding;
    }

    private static List processIn(Object v) {
        ArrayList<Object> inList = new ArrayList<Object>();
        if (List.class.isAssignableFrom(v.getClass()) || Set.class.isAssignableFrom(v.getClass())) {
            Collection c = (Collection)v;
            for (Object e : c) {
                inList.add(e);
            }
        } else if (HoneyUtil.isNumberArray(v.getClass())) {
            Number[] n;
            for (Number number : n = (Number[])v) {
                inList.add(number);
            }
        } else if (String.class.equals(v.getClass())) {
            String[] values;
            for (String e : values = v.toString().trim().split(",")) {
                inList.add(e);
            }
        } else {
            inList.add(v);
        }
        return inList;
    }

    private static List processBetween(Object v, Object v2, int tabSize) {
        ArrayList<Integer> inList = new ArrayList<Integer>();
        try {
            int r;
            int r2 = 0;
            String value = v.toString();
            if (value.contains(".")) {
                Double d = Double.parseDouble(value);
                r = d.intValue();
                Double d2 = Double.parseDouble(v2.toString());
                r2 = d2.intValue();
            } else {
                r = Integer.parseInt(value);
                r2 = Integer.parseInt(v2.toString());
            }
            for (int i = r; i <= r2 && r2 <= i + tabSize; ++i) {
                inList.add(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inList;
    }

    private void setValeueForOneDsOneTab(DsTabStruct dsTabStruct, SuidType suidType) {
        if (dsTabStruct == null) {
            return;
        }
        if (!this.batchInsert) {
            if (StringUtils.isBlank(dsTabStruct.getTabSuffix()) && StringUtils.isNotBlank(dsTabStruct.getDsName())) {
                ShardingReg.regSomeDsFull(suidType);
                ArrayList<String> dsList = new ArrayList<String>();
                dsList.add(dsTabStruct.getDsName());
                ShardingReg.regShardingJustDs(dsList);
                return;
            }
            if (StringUtils.isNotBlank(dsTabStruct.getDsName())) {
                this.ds = dsTabStruct.getDsName();
            }
            if (StringUtils.isNotBlank(dsTabStruct.getTabName())) {
                this.tabName = dsTabStruct.getTabName();
            } else if (StringUtils.isNotBlank(dsTabStruct.getTabSuffix())) {
                this.tabSuffix = dsTabStruct.getTabSuffix();
            } else if (SuidType.INSERT == suidType) {
                this.triggerDoNotSetTabShadngValueException();
            } else {
                Logger.warn(DoNotSetTabShadngValue);
            }
        } else {
            if (StringUtils.isBlank(dsTabStruct.getTabName()) && StringUtils.isBlank(dsTabStruct.getTabSuffix())) {
                this.triggerDoNotSetTabShadngValueException();
            }
            this.dsNameListForBatch.add(dsTabStruct.getDsName());
            this.tabNameListForBatch.add(dsTabStruct.getTabName());
            this.dsNameSetForBatch.add(dsTabStruct.getDsName());
            this.tabNameSetForBatch.add(dsTabStruct.getTabName());
        }
    }

    private void triggerDoNotSetTabShadngValueException() {
        this.clearContext();
        throw new ShardingErrorException(DoNotSetTabShadngValue);
    }

    private void adjustValue(DsTabStruct dsTabStruct, Object entity) {
        if (dsTabStruct == null) {
            return;
        }
        String tabName = dsTabStruct.getTabName();
        if (StringUtils.isNotBlank(dsTabStruct.getTabSuffix()) && StringUtils.isBlank(dsTabStruct.getTabName())) {
            tabName = this._toTableName(entity) + dsTabStruct.getTabSuffix();
            dsTabStruct.setTabName(tabName);
        }
        if (StringUtils.isBlank(dsTabStruct.getDsName())) {
            dsTabStruct.setDsName(ShardingRegistry.getDsByTab(tabName));
        }
    }

    private void setValeueForSharding(DsTabStruct dsTabStruct, List<String> dsNameList, List<String> tabNameList, List<String> tabSuffixList, Map<String, String> tab2DsMap) {
        if (dsTabStruct == null) {
            return;
        }
        if (StringUtils.isNotBlank(dsTabStruct.getDsName())) {
            dsNameList.add(dsTabStruct.getDsName());
        }
        if (StringUtils.isNotBlank(dsTabStruct.getTabName())) {
            tabNameList.add(dsTabStruct.getTabName());
            tab2DsMap.put(dsTabStruct.getTabName(), dsTabStruct.getDsName());
        }
        if (StringUtils.isNotBlank(dsTabStruct.getTabSuffix())) {
            tabSuffixList.add(dsTabStruct.getTabSuffix());
            tab2DsMap.put(dsTabStruct.getTabSuffix(), dsTabStruct.getDsName());
        }
    }

    private Object getFieldValue(Object entity, String fieldName) {
        if (fieldName == null) {
            return null;
        }
        try {
            Field field = entity.getClass().getDeclaredField(fieldName);
            HoneyUtil.setAccessibleTrue(field);
            return field.get(entity);
        }
        catch (Exception e) {
            Logger.debug(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public Object[] beforePasreEntity(Object[] entityArray, SuidType suidType) {
        boolean isSharding = ShardingUtil.isSharding();
        if (!isSharding) {
            return entityArray;
        }
        if (entityArray == null || entityArray.length < 1 || entityArray[0] == null) {
            return entityArray;
        }
        boolean isBroadcastTab = false;
        if (isSharding && SuidType.INSERT == suidType && entityArray.length > 1) {
            this.batchInsert = true;
            this.dsNameListForBatch = new ArrayList<String>();
            this.tabNameListForBatch = new ArrayList<String>();
            this.dsNameSetForBatch = new HashSet<String>();
            this.tabNameSetForBatch = new HashSet<String>();
        }
        String tableName = "";
        if (isSharding && ShardingRegistry.isBroadcastTab(tableName = this._toTableName(entityArray[0]))) {
            isBroadcastTab = true;
        }
        for (int i = 0; i < entityArray.length; ++i) {
            this.beforePasreEntity(entityArray[i], suidType);
            if (isBroadcastTab && suidType != SuidType.SELECT) break;
        }
        if (this.batchInsert && this.tabNameListForBatch.size() > 1 && (this.tabNameSetForBatch.size() > 1 || this.dsNameSetForBatch.size() > 1)) {
            ShardingReg.regBatchInsert(this.tabNameListForBatch, this.dsNameListForBatch);
        }
        if (isBroadcastTab && suidType != SuidType.SELECT) {
            List<String> allDsList = ShardingRegistry.getAllDs(tableName);
            ArrayList<String> tabList = new ArrayList<String>();
            for (int k = 0; k < allDsList.size(); ++k) {
                tabList.add(tableName);
            }
            ShardingReg.regBatchInsert(tabList, allDsList);
        }
        return entityArray;
    }

    @Override
    public String afterCompleteSql(String sql) {
        return sql;
    }

    @Override
    public void beforeReturn(List list) {
        this.clearContext();
    }

    @Override
    public void beforeReturn() {
        this.clearContext();
    }

    private void clearContext() {
        ShardingReg.clearContext();
    }

    private String _toTableName(Object entity) {
        return HoneyUtil.toTableName(entity);
    }
}

