/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.honey.osql.core.ShardingLogReg;
import org.teasoft.honey.osql.core.SimpleRewriteSql;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.engine.ResultMergeEngine;
import org.teasoft.honey.sharding.engine.ShardingAbstractBeeSQLExecutorEngine;
import org.teasoft.honey.sharding.engine.ThreadPoolUtil;

public class ShardingModifyEngine {
    public <T> int asynProcess(String sql, Class entityClass, BeeSql beeSql) {
        String[] sqls = null;
        String[] dsArray = null;
        List<String[]> list = ShardingUtil.hadShardingFullSelect() ? SimpleRewriteSql.createSqlsForFull(sql, entityClass) : SimpleRewriteSql.createSqlsAndInit(sql);
        sqls = list.get(0);
        dsArray = list.get(1);
        if (sqls == null || sqls.length == 0) {
            return 0;
        }
        ExecutorService executor = ThreadPoolUtil.getThreadPool(sqls.length);
        ExecutorCompletionService<Integer> completionService = new ExecutorCompletionService<Integer>(executor);
        ArrayList<ShardingBeeSQLModifyExecutorEngine> tasks = new ArrayList<ShardingBeeSQLModifyExecutorEngine>();
        for (int i = 0; sqls != null && i < sqls.length; ++i) {
            tasks.add(new ShardingBeeSQLModifyExecutorEngine(sqls[i], i + 1, beeSql, dsArray[i]));
        }
        if (sqls != null) {
            ShardingLogReg.log(sqls.length);
        }
        int size = tasks.size();
        for (int i = 0; tasks != null && i < size; ++i) {
            completionService.submit((Callable)tasks.get(i));
        }
        int r = ResultMergeEngine.mergeInteger(completionService, size);
        executor.shutdown();
        return r;
    }

    private class ShardingBeeSQLModifyExecutorEngine
    extends ShardingAbstractBeeSQLExecutorEngine<Integer> {
        public ShardingBeeSQLModifyExecutorEngine(String sql, int index, BeeSql beeSql, String ds) {
            super(sql, index, beeSql, ds);
        }

        @Override
        public Integer shardingWork() {
            ShardingLogReg.regShardingSqlLog("modify SQL", this.index, this.sql);
            return this.beeSql.modify(this.sql);
        }
    }
}

