/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine.decorate;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.teasoft.bee.sharding.ShardingPageStruct;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.TransformResultSet;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.engine.decorate.CompareResult;

public class OrderByStreamResult<T> {
    private Queue<CompareResult> orderByValuesQueue;
    Class<T> entityClass;

    public OrderByStreamResult(Queue<CompareResult> orderByValuesQueue, Class<T> entityClass) {
        this.orderByValuesQueue = orderByValuesQueue;
        this.entityClass = entityClass;
    }

    public List<T> getOnePageList() {
        int type;
        ArrayList<T> onePageList = null;
        ShardingPageStruct shardingPage = HoneyContext.getCurrentShardingPage();
        if (this.orderByValuesQueue != null && shardingPage != null && (type = shardingPage.getPagingType()) != 1) {
            CompareResult cr;
            int i;
            int start = shardingPage.getStart();
            int size = shardingPage.getSize();
            int first = ShardingUtil.firstRecordIndex();
            int from = start;
            if (start == -1) {
                from = 0;
            } else if (first == 1) {
                --from;
            }
            int to = from + size;
            for (i = 0; i < from; ++i) {
                cr = this.orderByValuesQueue.poll();
                if (cr == null || !cr.hasNext()) continue;
                this.orderByValuesQueue.offer(new CompareResult(cr.getResultSet(), cr.getStruct()));
            }
            onePageList = new ArrayList(size);
            try {
                i = from;
                while (i < to && this.orderByValuesQueue.size() > 0) {
                    cr = this.orderByValuesQueue.poll();
                    if (!cr.hasNext()) continue;
                    ResultSet rs = cr.getResultSet();
                    if (this.orderByValuesQueue.size() == 0) {
                        onePageList.add(TransformResultSet.rowToEntity(rs, this.entityClass));
                        ++i;
                        while (i < to && rs.next()) {
                            onePageList.add(TransformResultSet.rowToEntity(rs, this.entityClass));
                            ++i;
                        }
                        continue;
                    }
                    if (rs.isAfterLast()) continue;
                    onePageList.add(TransformResultSet.rowToEntity(rs, this.entityClass));
                    ++i;
                    this.orderByValuesQueue.offer(new CompareResult(rs, cr.getStruct()));
                }
            }
            catch (Exception e) {
                throw ExceptionHelper.convert(e);
            }
        }
        if (onePageList == null) {
            onePageList = new ArrayList<T>();
        }
        return onePageList;
    }
}

