/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine.decorate;

import java.util.ArrayList;
import java.util.List;
import org.teasoft.bee.sharding.ShardingPageStruct;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.sharding.ShardingUtil;

public class ResultPagingDecorator {
    public static <T> void pagingList(List<T> rsList) {
        int type;
        ShardingPageStruct shardingPage = HoneyContext.getCurrentShardingPage();
        if (shardingPage != null && (type = shardingPage.getPagingType()) != 1) {
            int start = shardingPage.getStart();
            int size = shardingPage.getSize();
            int first = ShardingUtil.firstRecordIndex();
            int from = start;
            if (start == -1) {
                from = 0;
            } else if (first == 1) {
                --from;
            }
            int to = from + size;
            ArrayList<T> onePageList = new ArrayList<T>(size);
            for (int i = from; i < to && i < rsList.size(); ++i) {
                onePageList.add(rsList.get(i));
            }
            rsList.clear();
            rsList.addAll(onePageList);
        }
    }
}

