/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine.decorate;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.sharding.FunStruct;
import org.teasoft.bee.sharding.GroupFunStruct;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.util.ObjectCreatorFactory;
import org.teasoft.honey.util.StringUtils;
import org.teasoft.honey.util.currency.CurrencyArithmetic;

public class ShardingGroupByDecorator {
    public static <T> void groupAndAggregateEntity(List<T> list) {
        GroupFunStruct groupFunStruct = HoneyContext.getCurrentGroupFunStruct();
        ShardingGroupByDecorator.groupAndAggregateEntity(list, groupFunStruct);
    }

    public static <T> void groupAndAggregateEntity(List<T> list, GroupFunStruct groupFunStruct) {
        if (list == null || list.size() <= 1 || groupFunStruct == null) {
            return;
        }
        List groupFields = groupFunStruct.getGroupFields();
        if (groupFields == null || groupFields.size() == 0) {
            return;
        }
        List funStructs = groupFunStruct.getFunStructs();
        if (funStructs == null || funStructs.size() == 0) {
            return;
        }
        Field field = null;
        Field oldField = null;
        HashMap valueMap = new HashMap();
        Class<?> elementClass = list.get(0).getClass();
        boolean isMax = false;
        boolean isMin = false;
        try {
            LinkedHashMap<String, T> groupEntityMap = new LinkedHashMap<String, T>();
            for (int i = 0; i < list.size(); ++i) {
                Map t;
                T currentEntity = list.get(i);
                String groupKey = "";
                for (int j = 0; j < groupFields.size(); ++j) {
                    String fieldName0 = ShardingGroupByDecorator._toFieldName((String)groupFields.get(j), elementClass);
                    field = currentEntity.getClass().getDeclaredField(fieldName0);
                    HoneyUtil.setAccessibleTrue(field);
                    groupKey = groupKey + field.get(currentEntity) + ",";
                }
                Object old = groupEntityMap.get(groupKey);
                if (old == null) {
                    groupEntityMap.put(groupKey, currentEntity);
                    continue;
                }
                for (int k = 0; k < funStructs.size(); ++k) {
                    Object oldFun;
                    String fieldName = ShardingGroupByDecorator._toFieldName(((FunStruct)funStructs.get(k)).getFieldName(), elementClass);
                    field = currentEntity.getClass().getDeclaredField(fieldName);
                    HoneyUtil.setAccessibleTrue(field);
                    Object fun = field.get(currentEntity);
                    t = (Map)valueMap.get(groupKey);
                    if (t == null) {
                        oldFun = null;
                        valueMap.put(groupKey, new LinkedHashMap());
                    } else {
                        oldFun = t.get(((FunStruct)funStructs.get(k)).getFieldName());
                    }
                    if (oldFun == null) {
                        oldField = old.getClass().getDeclaredField(fieldName);
                        HoneyUtil.setAccessibleTrue(oldField);
                        oldFun = oldField.get(old);
                    }
                    if (FunctionType.COUNT.getName().equalsIgnoreCase(((FunStruct)funStructs.get(k)).getFunctionType())) {
                        if (fun == null || !StringUtils.isNotBlank(fun.toString())) continue;
                        long r = Long.parseLong(fun.toString());
                        if (oldFun != null && StringUtils.isNotBlank(oldFun.toString())) {
                            long r0 = Long.parseLong(oldFun.toString());
                            ((Map)valueMap.get(groupKey)).put(((FunStruct)funStructs.get(k)).getFieldName(), r0 + r);
                            continue;
                        }
                        ((Map)valueMap.get(groupKey)).put(((FunStruct)funStructs.get(k)).getFieldName(), fun);
                        continue;
                    }
                    if (FunctionType.SUM.getName().equalsIgnoreCase(((FunStruct)funStructs.get(k)).getFunctionType())) {
                        if (fun == null || !StringUtils.isNotBlank(fun.toString())) continue;
                        if (oldFun != null && StringUtils.isNotBlank(oldFun.toString())) {
                            ((Map)valueMap.get(groupKey)).put(((FunStruct)funStructs.get(k)).getFieldName(), CurrencyArithmetic.add(fun.toString(), oldFun.toString()));
                            continue;
                        }
                        ((Map)valueMap.get(groupKey)).put(((FunStruct)funStructs.get(k)).getFieldName(), fun);
                        continue;
                    }
                    isMax = FunctionType.MAX.getName().equalsIgnoreCase(((FunStruct)funStructs.get(k)).getFunctionType());
                    if (!isMax && !(isMin = FunctionType.MIN.getName().equalsIgnoreCase(((FunStruct)funStructs.get(k)).getFunctionType())) || fun == null || !StringUtils.isNotBlank(fun.toString())) continue;
                    if (oldFun != null && StringUtils.isNotBlank(oldFun.toString())) {
                        double d = Double.parseDouble(fun.toString());
                        double d0 = Double.parseDouble(oldFun.toString());
                        if (!(isMax && d > d0) && (!isMin || !(d < d0))) continue;
                        ((Map)valueMap.get(groupKey)).put(((FunStruct)funStructs.get(k)).getFieldName(), fun);
                        continue;
                    }
                    ((Map)valueMap.get(groupKey)).put(((FunStruct)funStructs.get(k)).getFieldName(), fun);
                }
                t = null;
            }
            for (Map.Entry entryKey : valueMap.entrySet()) {
                Object tempEntity = groupEntityMap.get(entryKey.getKey());
                for (Map.Entry entry : ((Map)entryKey.getValue()).entrySet()) {
                    try {
                        String fieldName2 = ShardingGroupByDecorator._toFieldName((String)entry.getKey(), elementClass);
                        Field funField = tempEntity.getClass().getDeclaredField(fieldName2);
                        HoneyUtil.setAccessibleTrue(funField);
                        Object v = entry.getValue();
                        if (v != null) {
                            v = ObjectCreatorFactory.create(v.toString(), funField.getType());
                        }
                        HoneyUtil.setFieldValue(funField, tempEntity, v);
                    }
                    catch (Exception e) {
                        Logger.warn(e.getMessage(), e);
                    }
                }
            }
            if (list.size() != groupEntityMap.size()) {
                list.clear();
                for (Map.Entry entry : groupEntityMap.entrySet()) {
                    list.add(entry.getValue());
                }
            }
            groupEntityMap = null;
            valueMap = null;
        }
        catch (Exception e) {
            Logger.debug(e.getMessage(), e);
        }
    }

    private static String _toFieldName(String columnName, Class entityClass) {
        return NameTranslateHandle.toFieldName(columnName, entityClass);
    }

    public static void groupAndAggregateStringArray(List<String[]> list) {
        GroupFunStruct groupFunStruct = HoneyContext.getCurrentGroupFunStruct();
        ShardingGroupByDecorator.groupAndAggregateStringArray(list, groupFunStruct);
    }

    public static void groupAndAggregateStringArray(List<String[]> list, GroupFunStruct groupFunStruct) {
        if (list == null || list.size() <= 1 || groupFunStruct == null) {
            return;
        }
        List groupFields = groupFunStruct.getGroupFields();
        if (groupFields == null || groupFields.size() == 0) {
            return;
        }
        List funStructs = groupFunStruct.getFunStructs();
        if (funStructs == null || funStructs.size() == 0) {
            return;
        }
        HashMap valueMap = new HashMap();
        boolean isMax = false;
        boolean isMin = false;
        boolean hasAvg = false;
        ArrayList<Integer> avgNum = new ArrayList<Integer>();
        try {
            LinkedHashMap<String, String[]> groupEntityMap = new LinkedHashMap<String, String[]>();
            for (int i = 0; i < list.size(); ++i) {
                Map t;
                String[] currentStringArray = list.get(i);
                String groupKey = "";
                for (int j = 0; groupFields != null && j < groupFields.size(); ++j) {
                    groupKey = groupKey + currentStringArray[groupFunStruct.getIndexByColumn((String)groupFields.get(j))] + ",";
                }
                String[] old = (String[])groupEntityMap.get(groupKey);
                if (old == null) {
                    groupEntityMap.put(groupKey, currentStringArray);
                    continue;
                }
                for (int k = 0; k < funStructs.size(); ++k) {
                    String oldFun;
                    int funIndex = groupFunStruct.getIndexByColumn(((FunStruct)funStructs.get(k)).getFieldName());
                    String fun = currentStringArray[funIndex];
                    t = (Map)valueMap.get(groupKey);
                    if (t == null) {
                        oldFun = null;
                        valueMap.put(groupKey, new LinkedHashMap());
                    } else {
                        oldFun = (String)t.get(((FunStruct)funStructs.get(k)).getFieldName());
                    }
                    if (oldFun == null) {
                        oldFun = old[groupFunStruct.getIndexByColumn(((FunStruct)funStructs.get(k)).getFieldName())];
                    }
                    if (FunctionType.SUM.getName().equalsIgnoreCase(((FunStruct)funStructs.get(k)).getFunctionType()) || FunctionType.COUNT.getName().equalsIgnoreCase(((FunStruct)funStructs.get(k)).getFunctionType())) {
                        if (fun == null || !StringUtils.isNotBlank(fun.toString())) continue;
                        if (oldFun != null && StringUtils.isNotBlank(oldFun)) {
                            ((Map)valueMap.get(groupKey)).put(((FunStruct)funStructs.get(k)).getFieldName(), CurrencyArithmetic.add(fun, oldFun));
                            continue;
                        }
                        ((Map)valueMap.get(groupKey)).put(((FunStruct)funStructs.get(k)).getFieldName(), fun);
                        continue;
                    }
                    isMax = FunctionType.MAX.getName().equalsIgnoreCase(((FunStruct)funStructs.get(k)).getFunctionType());
                    if (isMax || (isMin = FunctionType.MIN.getName().equalsIgnoreCase(((FunStruct)funStructs.get(k)).getFunctionType()))) {
                        if (fun == null || !StringUtils.isNotBlank(fun.toString())) continue;
                        if (oldFun != null && StringUtils.isNotBlank(oldFun.toString())) {
                            double d = Double.parseDouble(fun.toString());
                            double d0 = Double.parseDouble(oldFun.toString());
                            if (!(isMax && d > d0) && (!isMin || !(d < d0))) continue;
                            ((Map)valueMap.get(groupKey)).put(((FunStruct)funStructs.get(k)).getFieldName(), fun);
                            continue;
                        }
                        ((Map)valueMap.get(groupKey)).put(((FunStruct)funStructs.get(k)).getFieldName(), fun);
                        continue;
                    }
                    if (!FunctionType.AVG.getName().equalsIgnoreCase(((FunStruct)funStructs.get(k)).getFunctionType())) continue;
                    hasAvg = true;
                    if (i != 0) continue;
                    avgNum.add(funIndex);
                }
                t = null;
            }
            for (Map.Entry entryKey : valueMap.entrySet()) {
                String[] tempEntity = (String[])groupEntityMap.get(entryKey.getKey());
                for (Map.Entry entry : ((Map)entryKey.getValue()).entrySet()) {
                    try {
                        int index = groupFunStruct.getIndexByColumn((String)entry.getKey());
                        tempEntity[index] = (String)entry.getValue();
                    }
                    catch (Exception e) {
                        Logger.warn(e.getMessage(), e);
                    }
                }
            }
            if (list.size() != groupEntityMap.size()) {
                list.clear();
                for (Map.Entry entry : groupEntityMap.entrySet()) {
                    list.add(ShardingGroupByDecorator.adjust((String[])entry.getValue(), hasAvg, avgNum));
                }
            }
            groupEntityMap = null;
            valueMap = null;
        }
        catch (Exception e) {
            Logger.warn(e.getMessage(), e);
        }
    }

    private static String[] adjust(String[] old, boolean hasAvg, List<Integer> avgNum) {
        if (!hasAvg) {
            return old;
        }
        int num = avgNum.size();
        String[] tempArray = new String[old.length - num * 2];
        for (Integer index : avgNum) {
            tempArray[index.intValue()] = CurrencyArithmetic.divide(tempArray[index + 1], tempArray[index + 2]);
        }
        int k = 0;
        for (int i = 0; i < old.length; ++i) {
            tempArray[k++] = old[i];
            if (!ShardingGroupByDecorator.existInList(avgNum, i)) continue;
            i += 2;
        }
        return tempArray;
    }

    private static boolean existInList(List<Integer> avgNum, int index) {
        for (Integer i : avgNum) {
            if (index != i) continue;
            return true;
        }
        return false;
    }
}

