/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine.decorate;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.teasoft.bee.sharding.ShardingSortStruct;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.sharding.engine.decorate.CompareUtil;

public class SortListDecorator {
    public static <T> void sort(List<T> rsList) {
        Collections.sort(rsList, new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                ShardingSortStruct struct = HoneyContext.getCurrentShardingSort();
                if (struct == null) {
                    return 0;
                }
                String[] orderFields = struct.getOrderFields();
                if (orderFields != null) {
                    int i = 0;
                    for (String orderField : orderFields) {
                        int result = CompareUtil.compareTo(SortListDecorator.getValue(a, orderField), SortListDecorator.getValue(b, orderField), struct, i);
                        if (result != 0) {
                            return result;
                        }
                        ++i;
                    }
                }
                return 0;
            }
        });
    }

    private static <T> String getValue(T t, String fieldName) {
        if (t == null) {
            return null;
        }
        try {
            Field field = t.getClass().getDeclaredField(fieldName);
            HoneyUtil.setAccessibleTrue(field);
            Object obj = field.get(t);
            if (obj != null) {
                return obj.toString();
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }
}

