/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.teasoft.honey.util.StringUtils;

public class ObjectCreator {
    private ObjectCreator() {
    }

    public static Long createLong(String s) {
        if (StringUtils.isBlank(s)) {
            return null;
        }
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            if (s.endsWith(".0")) {
                return Long.parseLong(s.substring(0, s.length() - 2));
            }
            if (s.endsWith(".00")) {
                return Long.parseLong(s.substring(0, s.length() - 3));
            }
            if (s.endsWith(".000")) {
                return Long.parseLong(s.substring(0, s.length() - 4));
            }
            Double d = ObjectCreator.createDouble(s);
            if (d != null) {
                return d.longValue();
            }
            return null;
        }
    }

    public static Integer createInt(String s) {
        if (StringUtils.isBlank(s)) {
            return null;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            if (s.endsWith(".0")) {
                return Integer.parseInt(s.substring(0, s.length() - 2));
            }
            if (s.endsWith(".00")) {
                return Integer.parseInt(s.substring(0, s.length() - 3));
            }
            if (s.endsWith(".000")) {
                return Integer.parseInt(s.substring(0, s.length() - 4));
            }
            Double d = ObjectCreator.createDouble(s);
            if (d != null) {
                return d.intValue();
            }
            return null;
        }
    }

    public static String createString(String s) {
        return s;
    }

    public static Short createShort(String s) {
        if (StringUtils.isBlank(s)) {
            return null;
        }
        return Short.parseShort(s);
    }

    public static Byte createByte(String s) {
        if (StringUtils.isBlank(s)) {
            return null;
        }
        return Byte.parseByte(s);
    }

    public static Boolean createBoolean(String s) {
        if (StringUtils.isBlank(s)) {
            return false;
        }
        return Boolean.parseBoolean(s);
    }

    public static Double createDouble(String s) {
        if (StringUtils.isBlank(s)) {
            return null;
        }
        return Double.parseDouble(s);
    }

    public static Float createFloat(String s) {
        if (StringUtils.isBlank(s)) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(s));
    }

    public static BigDecimal createBigDecimal(String v) {
        return new BigDecimal(v);
    }

    public static BigInteger createBigInteger(String v) {
        return new BigInteger(v);
    }
}

