/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.util.currency;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teasoft.honey.util.StringUtils;
import org.teasoft.honey.util.currency.CurrencyExpressionArith;
import org.teasoft.honey.util.currency.LongExpressionArith;

public class LongCalculator {
    private LongCalculator() {
    }

    public static String preCheckExpression(String exp) {
        return CurrencyExpressionArith.preCheckExpression(exp);
    }

    public static String calculate(String expression) {
        return LongExpressionArith.arith(CurrencyExpressionArith.inToPostList(expression));
    }

    public static String calculate(String expression, String value) {
        List<String> list = CurrencyExpressionArith.inToPostList(expression, false);
        if (list == null) {
            return "";
        }
        for (int i = 0; list != null && i < list.size(); ++i) {
            String listV = list.get(i);
            if (!StringUtils.isContainLetter(listV)) continue;
            list.set(i, value);
        }
        return LongExpressionArith.arith(list);
    }

    public static String calculate(String expression, Map<String, String> pairKV) {
        List<String> list = CurrencyExpressionArith.inToPostList(expression, false);
        ArrayList<String> newList = new ArrayList<String>();
        for (int i = 0; list != null && i < list.size(); ++i) {
            String listV = list.get(i);
            String mapV = pairKV.get(listV);
            if (mapV != null) {
                newList.add(mapV);
                continue;
            }
            newList.add(listV);
        }
        return LongExpressionArith.arith(newList);
    }
}

