/*
 * Copyright 2016-2021 the original author.All rights reserved.
 * Kingstar(honeysoft@126.com)
 * The license,see the LICENSE file.
 */

package org.teasoft.honey.osql.autogen;

import org.teasoft.bee.osql.api.PreparedSql;
import org.teasoft.bee.osql.api.SuidRich;
import org.teasoft.honey.osql.core.BeeFactoryHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.osql.shortcut.BF;

/**
 * 根据Javabean创建表.Create table according to Javabean
 * @author Kingstar
 * @since  1.9
 */
public class Ddl {

	//多种数据库时,static变量,不能改变.
//	private static PreparedSql preparedSql = BeeFactoryHelper.getPreparedSql();
//	private static SuidRich suidRich = BF.getSuidRich();

	private Ddl() {}
	
	/**
	 * @param entityClass
	 * @return
	 * @since 2.0
	 */
	public static <T> boolean createTable(Class<T> entityClass) {
		return createTable(entityClass, false);
	}
	
	/**
	 * @param entityClass
	 * @param isDropExistTable
	 * @return
	 * @since 2.0
	 */
	public static <T> boolean createTable(Class<T> entityClass, boolean isDropExistTable) {
		SuidRich suidRich = BF.getSuidRich();
		return suidRich.createTable(entityClass, isDropExistTable);
		
	}

	/**
	 * 根据Javabean生成数据库表,Javabean无需配置过多的字段信息.此方法只考虑通用情况,若有详细需求,不建议采用
	 * <br>According to the database table generated by JavaBean, JavaBean does not need to configure 
	 * <br>too much field information. This method only considers the general situation, and is not 
	 * <br>recommended if there are detailed requirements.
	 * @param entity Javabean entity.
	 * @return flag whether create successfully.
	 * @deprecated
	 */
	public static <T> boolean createTable(T entity) {
		return createTable(entity, false);
	}
	
	/**
	 * 
	 * @param entity
	 * @param isDropExistTable
	 * @return
	 * @deprecated
	 */
	public static <T> boolean createTable(T entity, boolean isDropExistTable) {
		if (isDropExistTable) {
			PreparedSql preparedSql = BeeFactoryHelper.getPreparedSql();
			String tableName = _toTableName(entity);
			boolean second = false;
			try {
				String sql0 = "";

				if (HoneyUtil.isOracle() || HoneyUtil.isSqlServer()) {
					sql0 = "DROP TABLE " + tableName;
				} else {
					sql0 = " DROP TABLE IF EXISTS " + tableName;
					second = true;
				}
				preparedSql.modify(sql0);
			} catch (Exception e) {
				if (second) {
					try {
						preparedSql.modify("DROP TABLE " + tableName);
					} catch (Exception e2) {
						Logger.warn(e2.getMessage());
					}
				}
			}
			return _createTable(entity, tableName);

		} else {// donot Drop ExistTable
			if (isExistTable(entity)) return true; // V1.17 已存在,则不创建
			return _createTable(entity,null);
		}

	}

	/**
	 * check whether the table exist or not.
	 * @param entity
	 * @return if exist true, otherwise false.
	 * @since 1.17
	 */
	public static <T> boolean isExistTable(T entity) {
		boolean flag = false;
		try {
			SuidRich suidRich = BF.getSuidRich();
			suidRich.select(entity, 1);
			flag = true;
			String tableName = _toTableName(entity);
			Logger.warn("The database exist the table : " + tableName);
		} catch (Exception e) {

		}
		return flag;
	}

	private static <T> boolean _createTable(T entity, String tableName) {
		boolean result = false;
		try {
			ddlModify(DdlToSql.toCreateTableSQL(entity.getClass(), tableName));
			result = true;
		} catch (Exception e) {
			Logger.error(e.getMessage(), e);
			result = false;
		}

		return result;
	}

	@SuppressWarnings("deprecation")
	private static void ddlModify(String sql) {
		// V1.11 创建语句的可执行语句与占位的是一样的,无需要重复输出.
		boolean old = HoneyConfig.getHoneyConfig().showSql_showExecutableSql;
		if (old) HoneyConfig.getHoneyConfig().showSql_showExecutableSql = false;
		PreparedSql preparedSql = BeeFactoryHelper.getPreparedSql();
		preparedSql.modify(sql);
		if (old) HoneyConfig.getHoneyConfig().showSql_showExecutableSql = old;
	}


	public static void setDynamicParameter(String para, String value) {
		BeeFactoryHelper.getSuid().setDynamicParameter(para, value);
	}

	private static String _toTableName(Object entity) {
		return HoneyUtil.toTableName(entity);
	}

	/**
	 * 创建通用索引.create normal index
	 * @param entity table's entity(do not allow null).
	 * @param fields  field name,if more than one,separate with comma.
	 */
	public static <T> void indexNormal(Class<T> entityClass, String fields) {
		indexNormal(entityClass, fields, null);
	}

	/**
	 * 创建通用索引.create normal index
	 * @param entity table's entity(do not allow null).
	 * @param fields  field name,if more than one,separate with comma.
	 * @param indexName  index name
	 */
	public static <T> void indexNormal(Class<T> entityClass, String fields, String indexName) {
		SuidRich suidRich = BF.getSuidRich();
		suidRich.indexNormal(entityClass, fields, indexName);
	}

	/**
	 * 创建唯一索引.create unique index
	 * @param entity table's entity(do not allow null).
	 * @param fields  field name,if more than one,separate with comma.
	 */
	public static <T> void unique(Class<T> entityClass, String fields) {
		unique(entityClass, fields, null);
	}

	/**
	 * 创建唯一索引.create unique index
	 * @param entityClass table's entityClass(do not allow null).
	 * @param fields  field name,if more than one,separate with comma.
	 * @param indexName  index name
	 */
	public static <T> void unique(Class<T> entityClass, String fields, String indexName) {
		SuidRich suidRich = BF.getSuidRich();
		suidRich.unique(entityClass, fields,indexName);
	}

	public static <T> void primaryKey(Class<T> entityClass, String fields) {
		primaryKey(entityClass, fields, null);
	}

	/**
	 * 创建主键,一般是多字段联合主键.create primary key
	 * @param entity table's entity(do not allow null).
	 * @param fields  field name,if more than one,separate with comma.
	 * @param keyName  key name
	 */
	public static <T> void primaryKey(Class<T> entityClass, String fields, String keyName) {
        
//		String primaryKeySql=DdlToSql.toPrimaryKeySql(entityClass, fields, keyName);
//		ddlModify(primaryKeySql);
		SuidRich suidRich = BF.getSuidRich();
		suidRich.primaryKey(entityClass, fields, keyName);
	}
	
	public static <T> void dropIndex(Class<T> entityClass,  String indexName) {
		SuidRich suidRich = BF.getSuidRich();
		suidRich.dropIndex(entityClass, indexName);
	}
}
