/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.autogen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.teasoft.honey.osql.autogen.ColumnBean;
import org.teasoft.honey.osql.autogen.GenBean;
import org.teasoft.honey.osql.autogen.Table;
import org.teasoft.honey.osql.core.HoneyUtil;

public class ColumnUtil {
    private ColumnUtil() {
    }

    public static List<ColumnBean> getColumnList(String tableName) {
        GenBean bean = new GenBean(null);
        Table table = bean.getTableInfo(tableName);
        if (table == null || table.getColumnNames() == null) {
            return Collections.emptyList();
        }
        List<String> columnNames = table.getColumnNames();
        List<String> columnTypes = table.getColumnTypes();
        Map<String, String> commentMap = table.getCommentMap();
        List<Boolean> ynNulls = table.getYnNulls();
        String newTableName = table.getTableName();
        String tableComment = commentMap.get(newTableName);
        ArrayList<ColumnBean> list = new ArrayList<ColumnBean>();
        ColumnBean columnBean = null;
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            String columnType = columnTypes.get(i);
            boolean ynNull = ynNulls.get(i) == null ? true : ynNulls.get(i);
            String comment = commentMap.get(columnName);
            columnBean = new ColumnBean();
            columnBean.setName(columnName);
            columnBean.setType(HoneyUtil.getFieldType(columnType));
            columnBean.setLabel(comment);
            columnBean.setYnnull(ynNull);
            columnBean.setTablename(newTableName);
            columnBean.setTablecomment(tableComment);
            columnBean.setYnkey(ColumnUtil.isKey(columnName, table.getPrimaryKeyNames()));
            list.add(columnBean);
        }
        return list;
    }

    private static boolean isKey(String col, Map<String, String> primaryKeyMap) {
        if (primaryKeyMap == null || col == null) {
            return false;
        }
        return primaryKeyMap.get(col) != null;
    }
}

