/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.DataSource;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.NameTranslate;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.api.Condition;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.bee.osql.exception.ShardingErrorException;
import org.teasoft.bee.sharding.GroupFunStruct;
import org.teasoft.bee.sharding.ShardingPageStruct;
import org.teasoft.bee.sharding.ShardingSortStruct;
import org.teasoft.honey.database.DatabaseClientConnection;
import org.teasoft.honey.distribution.ds.RouteStruct;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.BeeInitPreLoadService;
import org.teasoft.honey.osql.core.CacheSuidStruct;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.SessionFactory;
import org.teasoft.honey.osql.dialect.sqlserver.SqlServerPagingStruct;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.util.ObjectUtils;

public final class HoneyContext {
    private static ConcurrentMap<String, String> beanMap;
    private static ConcurrentMap<String, String> beanCustomPKey;
    private static ConcurrentMap<String, Map<String, String>> customMap;
    private static ThreadLocal<Map<String, List<PreparedValue>>> sqlPreValueLocal;
    private static ThreadLocal<Integer> sqlIndexLocal;
    private static ThreadLocal<Condition> conditionLocal;
    private static ThreadLocal<Map<String, CacheSuidStruct>> cacheLocal;
    private static ThreadLocal<Map<String, SqlServerPagingStruct>> sqlServerPaging;
    private static ThreadLocal<Map<String, Map<String, String>>> customMapLocal;
    private static ThreadLocal<Map<String, String>> sysCommStrLocal;
    private static ThreadLocal<Map<String, List<String>>> listLocal;
    private static ThreadLocal<RouteStruct> currentRoute;
    private static ThreadLocal<ShardingPageStruct> currentShardingPage;
    private static ThreadLocal<ShardingSortStruct> currentShardingSort;
    private static ThreadLocal<GroupFunStruct> currentGroupFunStruct;
    private static ThreadLocal<Connection> currentConnection;
    private static ConcurrentMap<String, Connection> conneForSelectRs;
    private static ThreadLocal<Object> currentAppDB;
    private static ThreadLocal<NameTranslate> currentNameTranslate;
    private static ThreadLocal<String> sameConnectionDoing;
    private static ThreadLocal<String> jdbcTranWriterDs;
    private static ThreadLocal<String> appointDS;
    private static ThreadLocal<String> tempDS;
    private static ThreadLocal<String> appointTab;
    private static ThreadLocal<String> tabSuffix;
    private static ThreadLocal<String> tempLang;
    private static String lang;
    private static ConcurrentMap<String, String> entity2table;
    private static ConcurrentMap<String, String> table2entity;
    private static Map<String, String> entityList_includes_Map;
    private static Map<String, String> entityList_excludes_Map;
    private static List<String> entityListWithStar_in;
    private static List<String> entityListWithStar_ex;
    private static Map<String, String> entityList_levelTwo_Map;
    private static List<String> entityListWithStar_levelTwo;
    private static Map<String, String> dsName2DbName;
    private static ConcurrentMap<String, Boolean> modifiedFlagMapForCache2;
    private static ConcurrentMap<String, Boolean> entityInterceptorFlag;
    private static ConcurrentMap<String, Boolean> customFlagMap;
    private static boolean configRefresh;
    private static boolean dsMapConfigRefresh;

    private HoneyContext() {
    }

    static void initLoad() {
        BeeInitPreLoadService.initLoad();
    }

    static ConcurrentMap<String, String> getEntity2tableMap() {
        return entity2table;
    }

    static synchronized ConcurrentMap<String, String> getTable2entityMap() {
        if (table2entity == null) {
            table2entity = new ConcurrentHashMap<String, String>();
            HoneyContext.initTable2Entity();
        }
        return table2entity;
    }

    private static void initEntity2Table() {
        String entity2tableMappingList = HoneyConfig.getHoneyConfig().naming_entity2tableMappingList;
        if (entity2tableMappingList != null) {
            String[] entity2table_array = entity2tableMappingList.split(",");
            for (int i = 0; i < entity2table_array.length; ++i) {
                String[] item = entity2table_array[i].trim().split(":");
                if (item.length != 2) {
                    Logger.error("[" + entity2table_array[i].trim() + "] wrong formatter,separate option is not colon(:). (in bee.properties file, key: bee.osql.name.mapping.entity2table)");
                    continue;
                }
                entity2table.put(item[0].trim(), item[1].trim());
            }
        }
    }

    private static void initTable2Entity() {
        String entity2tableMappingList = HoneyConfig.getHoneyConfig().naming_entity2tableMappingList;
        if (entity2tableMappingList != null) {
            String[] entity2table_array = entity2tableMappingList.split(",");
            for (int i = 0; i < entity2table_array.length; ++i) {
                String[] item = entity2table_array[i].trim().split(":");
                if (item.length != 2) {
                    Logger.error("[" + entity2table_array[i].trim() + "] wrong formatter,separate option is not colon(:). (in bee.properties file, key: bee.osql.name.mapping.entity2table)");
                    continue;
                }
                if (table2entity.containsKey(item[1].trim())) {
                    Logger.warn((String)table2entity.get(item[1].trim()) + " and " + item[0].trim() + " mapping same table: " + item[1].trim());
                }
                table2entity.put(item[1].trim(), item[0].trim());
            }
        }
    }

    static void addBeanField(String key, String value) {
        if (key == null) {
            return;
        }
        if (HoneyConfig.getHoneyConfig().naming_useMoreTranslateType) {
            key = key + NameTranslateHandle.getNameTranslate().getClass().getName();
        }
        beanMap.put(key, value);
    }

    public static String getBeanField(String key) {
        if (key == null) {
            key = "";
        }
        if (HoneyConfig.getHoneyConfig().naming_useMoreTranslateType) {
            key = key + NameTranslateHandle.getNameTranslate().getClass().getName();
        }
        return (String)beanMap.get(key);
    }

    static void clearFieldNameCache() {
        beanMap.clear();
    }

    static void addBeanCustomPKey(String key, String value) {
        if (key == null) {
            return;
        }
        if (HoneyConfig.getHoneyConfig().naming_useMoreTranslateType) {
            key = key + NameTranslateHandle.getNameTranslate().getClass().getName();
        }
        beanCustomPKey.put(key, value);
    }

    public static String getBeanCustomPKey(String mapKey) {
        if (mapKey == null) {
            return null;
        }
        if (HoneyConfig.getHoneyConfig().naming_useMoreTranslateType) {
            mapKey = mapKey + NameTranslateHandle.getNameTranslate().getClass().getName();
        }
        return (String)beanCustomPKey.get(mapKey);
    }

    public static void addCustomMap(String key, Map<String, String> mapValue) {
        if (key == null) {
            Logger.warn("Do not support the null key!", (Throwable)new BeeIllegalParameterException("Do not support the null key!"));
            return;
        }
        customMap.put(key, mapValue);
    }

    public static Map<String, String> getCustomMap(String key) {
        if (key == null) {
            return null;
        }
        return (Map)customMap.get(key);
    }

    public static String getCustomMapValue(String key1, String key2) {
        if (key1 == null || key2 == null) {
            return null;
        }
        Map map = (Map)customMap.get(key1);
        if (map != null) {
            return (String)map.get(key2);
        }
        return null;
    }

    public static void removeCustomMap(String key) {
        if (customMap.containsKey(key)) {
            customMap.remove(key);
        }
    }

    public static void setCustomMapLocal(String key, Map<String, String> mapValue) {
        if (mapValue == null) {
            return;
        }
        if (key == null || "".equals(key.trim())) {
            return;
        }
        Map<String, Map<String, String>> map = customMapLocal.get();
        if (null == map) {
            map = new ConcurrentHashMap<String, Map<String, String>>();
        }
        map.put(key, mapValue);
        customMapLocal.set(map);
    }

    public static Map<String, String> getCustomMapLocal(String key) {
        Map<String, Map<String, String>> map = customMapLocal.get();
        if (null == map || key == null) {
            return null;
        }
        return map.get(key);
    }

    public static void removeCustomMapLocal(String key) {
        Map<String, Map<String, String>> map = customMapLocal.get();
        if (null == map || key == null) {
            return;
        }
        if (map.containsKey(key)) {
            map.remove(key);
        }
    }

    public static void setSysCommStrLocal(String key, String sysCommStr) {
        if (sysCommStr == null) {
            return;
        }
        if (key == null || "".equals(key.trim())) {
            return;
        }
        Map<String, String> map = sysCommStrLocal.get();
        if (null == map) {
            map = new ConcurrentHashMap<String, String>();
        }
        map.put(key, sysCommStr);
        sysCommStrLocal.set(map);
    }

    public static String getSysCommStrLocal(String key) {
        Map<String, String> map = sysCommStrLocal.get();
        if (map == null || key == null) {
            return null;
        }
        return map.get(key);
    }

    public static void removeSysCommStrLocal(String key) {
        Map<String, String> map = sysCommStrLocal.get();
        if (map != null) {
            map.remove(key);
        }
    }

    public static void setTrueInSysCommStrLocal(String key) {
        HoneyContext.setSysCommStrLocal(key, "tRue");
    }

    public static boolean isTrueInSysCommStrLocal(String key) {
        return "tRue".equals(HoneyContext.getSysCommStrLocal(key));
    }

    public static void setListLocal(String key, List<String> listString) {
        if (listString == null) {
            return;
        }
        if (key == null || "".equals(key.trim())) {
            return;
        }
        Map<String, List<String>> map = listLocal.get();
        if (null == map) {
            map = new ConcurrentHashMap<String, List<String>>();
        }
        map.put(key, listString);
        listLocal.set(map);
    }

    public static List<String> getListLocal(String key) {
        Map<String, List<String>> map = listLocal.get();
        if (map == null || key == null) {
            return null;
        }
        return map.get(key);
    }

    public static void removeListLocal(String key) {
        Map<String, List<String>> map = listLocal.get();
        if (map != null) {
            map.remove(key);
        }
    }

    private static boolean isShowExecutableSql() {
        return HoneyConfig.getHoneyConfig().showSql_showExecutableSql;
    }

    static void setPreparedValue(String sqlStr, List<PreparedValue> list) {
        if (list == null) {
            return;
        }
        if (sqlStr == null || "".equals(sqlStr.trim())) {
            return;
        }
        if (list.size() == 0 && !HoneyContext.isShowExecutableSql()) {
            return;
        }
        Map<String, List<PreparedValue>> map = sqlPreValueLocal.get();
        if (null == map) {
            map = new ConcurrentHashMap<String, List<PreparedValue>>();
        }
        map.put(sqlStr, list);
        sqlPreValueLocal.set(map);
    }

    static List<PreparedValue> justGetPreparedValue(String sqlStr) {
        Map<String, List<PreparedValue>> map = sqlPreValueLocal.get();
        if (null == map || sqlStr == null) {
            return null;
        }
        return map.get(sqlStr);
    }

    static void clearPreparedValue(String sqlStr) {
        Map<String, List<PreparedValue>> map = sqlPreValueLocal.get();
        if (null == map || sqlStr == null) {
            return;
        }
        if (map.containsKey(sqlStr)) {
            map.remove(sqlStr);
        }
    }

    static List<PreparedValue> getAndClearPreparedValue(String sqlStr) {
        Map<String, List<PreparedValue>> map = sqlPreValueLocal.get();
        if (null == map || sqlStr == null) {
            return null;
        }
        List<PreparedValue> list = map.get(sqlStr);
        if (map.containsKey(sqlStr)) {
            map.remove(sqlStr);
        }
        return list;
    }

    static void setCacheInfo(String sqlStr, CacheSuidStruct cacheInfo) {
        if (cacheInfo == null) {
            return;
        }
        if (sqlStr == null || "".equals(sqlStr.trim())) {
            return;
        }
        Map<String, CacheSuidStruct> map = cacheLocal.get();
        if (null == map) {
            map = new ConcurrentHashMap<String, CacheSuidStruct>();
        }
        map.put(sqlStr, cacheInfo);
        cacheLocal.set(map);
    }

    public static CacheSuidStruct getCacheInfo(String sqlStr) {
        Map<String, CacheSuidStruct> map = cacheLocal.get();
        if (null == map || sqlStr == null) {
            return null;
        }
        return map.get(sqlStr);
    }

    static void deleteCacheInfo(String sqlStr) {
        Map<String, CacheSuidStruct> map = cacheLocal.get();
        if (map != null) {
            map.remove(sqlStr);
        }
    }

    public static void setSqlServerPagingStruct(String sqlStr, SqlServerPagingStruct sqlServerPagingStruct) {
        if (sqlServerPagingStruct == null) {
            return;
        }
        if (sqlStr == null || "".equals(sqlStr.trim())) {
            return;
        }
        Map<String, SqlServerPagingStruct> map = sqlServerPaging.get();
        if (null == map) {
            map = new ConcurrentHashMap<String, SqlServerPagingStruct>();
        }
        map.put(sqlStr, sqlServerPagingStruct);
        sqlServerPaging.set(map);
    }

    public static SqlServerPagingStruct getAndRemoveSqlServerPagingStruct(String sqlStr) {
        Map<String, SqlServerPagingStruct> map = sqlServerPaging.get();
        if (null == map || sqlStr == null) {
            return null;
        }
        SqlServerPagingStruct struct = map.get(sqlStr);
        if (map.containsKey(sqlStr)) {
            map.remove(sqlStr);
        }
        return struct;
    }

    public static String getDbDialect() {
        return HoneyConfig.getHoneyConfig().getDbName();
    }

    public static Connection getCurrentConnection() {
        return currentConnection.get();
    }

    public static void setCurrentConnection(Connection conn) {
        currentConnection.set(conn);
    }

    public static void removeCurrentConnection() {
        currentConnection.remove();
    }

    public static synchronized void regConnForSelectRs(Connection conn) {
        String threadFlag = HoneyContext.getSysCommStrLocal("_SYS_Bee_ShardingSelectRs_ThreadID");
        Integer subThreadIndex = HoneyContext.getSqlIndexLocal();
        String key = threadFlag + subThreadIndex;
        conneForSelectRs.put(key, conn);
    }

    public static synchronized void clearConnForSelectRs(String key) {
        Connection conn = (Connection)conneForSelectRs.get(key);
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception e) {
                Logger.debug(e.getMessage(), e);
            }
            finally {
                conneForSelectRs.remove(key);
            }
        }
    }

    public static Object getCurrentAppDB() {
        return currentAppDB.get();
    }

    public static void setCurrentAppDB(Object appDB) {
        if (HoneyContext.isAppDBObject(appDB.getClass().getName())) {
            currentAppDB.set(appDB);
        }
    }

    public static void setCurrentAppDBIfNeed(Object appDB) {
        if (HoneyContext.isAppDBObject(appDB.getClass().getName()) && OneTimeParameter.isTrue("_SYS_Bee_SAME_CONN_BEGIN")) {
            currentAppDB.set(appDB);
        }
    }

    public static void removeCurrentAppDB() {
        currentAppDB.remove();
    }

    private static boolean isAppDBObject(String className) {
        return "android.database.sqlite.SQLiteDatabase".equals(className) || "ohos.data.rdb.RdbStore".equals(className);
    }

    public static NameTranslate getCurrentNameTranslate() {
        return currentNameTranslate.get();
    }

    public static void setCurrentNameTranslate(NameTranslate nameTranslate) {
        HoneyContext.clearFieldNameCache();
        currentNameTranslate.set(nameTranslate);
    }

    public static void removeCurrentNameTranslate() {
        currentNameTranslate.remove();
    }

    public static String getSameConnectionDoing() {
        return sameConnectionDoing.get();
    }

    private static void setSameConnectionDoing() {
        sameConnectionDoing.set("tRue");
    }

    private static void removesameConnectionDoing() {
        sameConnectionDoing.remove();
    }

    public static String getJdbcTranWriterDs() {
        String s = jdbcTranWriterDs.get();
        jdbcTranWriterDs.remove();
        return s;
    }

    public static void setJdbcTranWriterDs() {
        jdbcTranWriterDs.set("tRue");
    }

    public static String getAppointDS() {
        return appointDS.get();
    }

    public static void setAppointDS(String dsName) {
        if (HoneyContext.isMultiDs()) {
            appointDS.set(dsName);
        }
    }

    public static void removeAppointDS() {
        if (HoneyContext.isMultiDs()) {
            appointDS.remove();
        }
    }

    public static String getTempDS() {
        return tempDS.get();
    }

    static void setTempDS(String dsName) {
        if (HoneyContext.isMultiDs()) {
            tempDS.set(dsName);
        }
    }

    static void removeTempDS() {
        if (HoneyContext.isMultiDs()) {
            tempDS.remove();
        }
    }

    public static boolean isMultiDs() {
        return HoneyConfig.getHoneyConfig().multiDS_enable;
    }

    public static String getAppointTab() {
        return appointTab.get();
    }

    public static void setAppointTab(String tabName) {
        appointTab.set(tabName);
    }

    public static void removeAppointTab() {
        appointTab.remove();
    }

    public static String getTabSuffix() {
        return tabSuffix.get();
    }

    public static void setTabSuffix(String suffix) {
        tabSuffix.set(suffix);
    }

    public static void removeTabSuffix() {
        tabSuffix.remove();
    }

    public static Integer getSqlIndexLocal() {
        return sqlIndexLocal.get();
    }

    public static void setSqlIndexLocal(int index) {
        sqlIndexLocal.set(index);
    }

    public static void removeSqlIndexLocal() {
        sqlIndexLocal.remove();
    }

    public static Condition getConditionLocal() {
        return conditionLocal.get();
    }

    public static void setConditionLocal(Condition condition) {
        conditionLocal.set(condition);
    }

    public static void removeConditionLocal() {
        conditionLocal.remove();
    }

    public static String getTempLang() {
        return tempLang.get();
    }

    public static void setTempLang(String dsName) {
        if (HoneyContext.isMultiDs()) {
            tempLang.set(dsName);
        }
    }

    public static void removeTempLang() {
        if (HoneyContext.isMultiDs()) {
            tempLang.remove();
        }
    }

    public static String getLang() {
        String lang0 = HoneyContext.getTempLang();
        if (lang0 != null) {
            return lang0;
        }
        return lang;
    }

    public static void setLang(String lang) {
        HoneyContext.lang = lang;
    }

    static void endSameConnection() {
        if (HoneyConfig.getHoneyConfig().isAndroid || HoneyConfig.getHoneyConfig().isHarmony) {
            if (OneTimeParameter.isTrue("_SYS_Bee_SAME_CONN_BEGIN")) {
                Logger.warn("Do not get the new Connection in the SameConnection.Maybe all the results get from cache! ");
            }
            HoneyContext.removeCurrentAppDB();
            return;
        }
        if (OneTimeParameter.isTrue("_SYS_Bee_SAME_CONN_BEGIN")) {
            Logger.warn("Do not get the new Connection in the SameConnection.Maybe all the results get from cache! ");
        } else if (!"tRue".equals(HoneyContext.getSameConnectionDoing())) {
            if (OneTimeParameter.isTrue("_SYS_Bee_SAME_CONN_EXCEPTION")) {
                Logger.warn("Do not use same Connection, because have exception in between the begin and end SameConnection !");
            } else {
                Logger.warn("Calling the endSameConnection(), but miss the beginSameConnection()");
            }
        } else if ("tRue".equals(HoneyContext.getSameConnectionDoing())) {
            OneTimeParameter.setTrueForKey("_SYS_Bee_SAME_CONN_END");
            HoneyContext.checkClose(null, HoneyContext.getCurrentConnection());
        }
        HoneyContext.removeCurrentConnection();
    }

    public static RouteStruct getCurrentRoute() {
        return currentRoute.get();
    }

    public static void setCurrentRoute(RouteStruct routeStruct) {
        currentRoute.set(routeStruct);
    }

    public static void removeCurrentRoute() {
        currentRoute.remove();
    }

    public static ShardingPageStruct getCurrentShardingPage() {
        return currentShardingPage.get();
    }

    public static void setCurrentShardingPage(ShardingPageStruct shardingPage) {
        currentShardingPage.set(shardingPage);
    }

    public static void removeCurrentShardingPage() {
        currentShardingPage.remove();
    }

    public static ShardingSortStruct getCurrentShardingSort() {
        return currentShardingSort.get();
    }

    public static void setCurrentShardingSort(ShardingSortStruct shardingSort) {
        currentShardingSort.set(shardingSort);
    }

    public static void removeCurrentShardingSort() {
        currentShardingSort.remove();
    }

    public static GroupFunStruct getCurrentGroupFunStruct() {
        return currentGroupFunStruct.get();
    }

    public static void setCurrentGroupFunStruct(GroupFunStruct groupFunStruct) {
        currentGroupFunStruct.set(groupFunStruct);
    }

    public static void removeCurrentGroupFunStruct() {
        currentGroupFunStruct.remove();
    }

    static void setContext(String sql, List<PreparedValue> list, String tableName) {
        HoneyContext.setPreparedValue(sql, list);
        HoneyContext.addInContextForCache(sql, tableName);
    }

    public static void addInContextForCache(String sql, String tableName) {
        CacheSuidStruct struct = new CacheSuidStruct();
        struct.setSql(sql);
        struct.setTableNames(tableName);
        HoneyContext.setCacheInfo(sql, struct);
    }

    static void regEntityClass(Class clazz) {
        OneTimeParameter.setAttribute("_SYS_Bee_ROUTE_EC", clazz);
    }

    static void regFunType(FunctionType functionType) {
        HoneyContext.setSysCommStrLocal("_SYS_Bee_FunType", functionType.getName());
    }

    static void regSuidType(SuidType suidType) {
        OneTimeParameter.setAttribute("_SYS_Bee_SuidType", suidType);
    }

    public static SuidType getSuidType() {
        return (SuidType)OneTimeParameter.getAttribute("_SYS_Bee_SuidType");
    }

    static Connection getConn() throws SQLException {
        Connection conn = null;
        conn = HoneyContext.getCurrentConnection();
        if (conn == null) {
            boolean isSameConn = OneTimeParameter.isTrue("_SYS_Bee_SAME_CONN_BEGIN");
            if (isSameConn) {
                HoneyContext.checkShadingHasMoreDs("Donot support SameConnection in more DataSources at one time!");
                HoneyContext.setSameConnectionDoing();
            }
            conn = SessionFactory.getConnection();
            if (isSameConn) {
                HoneyContext.setCurrentConnection(conn);
            }
        }
        return conn;
    }

    public static DatabaseClientConnection getDatabaseConnection() {
        DatabaseClientConnection conn = null;
        conn = SessionFactory.getDatabaseConnection();
        return conn;
    }

    public static void checkShadingHasMoreDs(String exceptionMsg) {
        List<String> dsNameListLocal;
        if (ShardingUtil.hadSharding() && (dsNameListLocal = HoneyContext.getListLocal("_SYS_Bee_DsNameListLocal")) != null && dsNameListLocal.size() > 1) {
            throw new ShardingErrorException(exceptionMsg);
        }
    }

    static void closeConn(Connection conn) {
        try {
            if (conn != null && conn.getAutoCommit()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
        finally {
            HoneyContext.removeCurrentConnection();
            if ("tRue".equals(HoneyContext.getSameConnectionDoing())) {
                HoneyContext.removesameConnectionDoing();
                OneTimeParameter.setTrueForKey("_SYS_Bee_SAME_CONN_EXCEPTION");
            }
        }
    }

    public static void checkClose(Statement stmt, Connection conn) {
        HoneyContext.checkClose(null, stmt, conn);
    }

    public static void checkClose(ResultSet rs, Statement stmt, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw ExceptionHelper.convert(e);
            }
        }
        if (conn != null) {
            try {
                if ("tRue".equals(HoneyContext.getSameConnectionDoing())) {
                    if (OneTimeParameter.isTrue("_SYS_Bee_SAME_CONN_END")) {
                        HoneyContext.removesameConnectionDoing();
                        if (conn != null) {
                            conn.close();
                        }
                    }
                } else if (conn != null && conn.getAutoCommit()) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                Logger.debug(e.getMessage());
                throw ExceptionHelper.convert(e);
            }
        }
    }

    static boolean updateInfoInCache(String sql, String returnType, SuidType suidType, Class entityClass) {
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            struct.setReturnType(returnType);
            struct.setSuidType(suidType.getType());
            struct.setEntityClass(entityClass);
            HoneyContext.setCacheInfo(sql, struct);
            return true;
        }
        return false;
    }

    static void initRoute(SuidType suidType, Class clazz, String sql) {
        if (clazz == null) {
            clazz = (Class)OneTimeParameter.getAttribute("_SYS_Bee_ROUTE_EC");
        }
        RouteStruct routeStruct = new RouteStruct();
        routeStruct.setSuidType(suidType);
        routeStruct.setEntityClass(clazz);
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            routeStruct.setTableNames(struct.getTableNames());
        }
        HoneyContext.setCurrentRoute(routeStruct);
    }

    static void initRouteWhenParseSql(SuidType suidType, Class clazz, String tableNames) {
        if (clazz == null) {
            clazz = (Class)OneTimeParameter.getAttribute("_SYS_Bee_ROUTE_EC");
        }
        RouteStruct routeStruct = new RouteStruct();
        routeStruct.setSuidType(suidType);
        routeStruct.setEntityClass(clazz);
        routeStruct.setTableNames(tableNames);
        HoneyContext.setCurrentRoute(routeStruct);
    }

    private static void parseEntityListToMap() {
        String entityList_includes = HoneyConfig.getHoneyConfig().genid_includesEntityList;
        HoneyContext._parseListToMap(entityList_includes, entityList_includes_Map, entityListWithStar_in);
        String entityList_excludes = HoneyConfig.getHoneyConfig().genid_excludesEntityList;
        HoneyContext._parseListToMap(entityList_excludes, entityList_excludes_Map, entityListWithStar_ex);
        String levelTwoEntityList = HoneyConfig.getHoneyConfig().cache_levelTwoEntityList;
        HoneyContext._parseListToMap(levelTwoEntityList, entityList_levelTwo_Map, entityListWithStar_levelTwo);
    }

    private static void _parseListToMap(String str, Map<String, String> map, List<String> starList) {
        if (str == null || "".equals(str.trim())) {
            return;
        }
        String[] strArray = str.trim().split(",");
        for (int k = 0; k < strArray.length; ++k) {
            if (strArray[k].trim().endsWith(".**")) {
                starList.add(strArray[k].trim());
            }
            map.put(strArray[k].trim(), "1");
        }
    }

    private static boolean isConfigForEntityIN(Class clazz) {
        return HoneyContext._isConfig(clazz, entityList_includes_Map, entityListWithStar_in);
    }

    private static boolean isConfigForEntityEX(Class clazz) {
        return HoneyContext._isConfig(clazz, entityList_excludes_Map, entityListWithStar_ex);
    }

    private static boolean _isConfig(Class clazz, Map<String, String> map, List<String> starList) {
        if (clazz == null) {
            return false;
        }
        String fullName = clazz.getName();
        String ds = null;
        ds = map.get(fullName);
        if (ds != null) {
            return true;
        }
        if (clazz.getPackage() != null) {
            String packageName = clazz.getPackage().getName();
            ds = map.get(packageName + ".*");
            if (ds != null) {
                return true;
            }
            for (int i = 0; i < starList.size(); ++i) {
                String prePath;
                String s = starList.get(i);
                if (!s.endsWith(".**") || !fullName.startsWith(prePath = s.substring(0, s.length() - 2))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNeedGenId(Class clazz) {
        boolean needGenId = false;
        boolean genAll = HoneyConfig.getHoneyConfig().genid_forAllTableLongId;
        needGenId = genAll ? !HoneyContext.isConfigForEntityEX(clazz) : (HoneyContext.isConfigForEntityEX(clazz) ? false : HoneyContext.isConfigForEntityIN(clazz));
        return needGenId;
    }

    public static boolean isConfigLevelTwoCache(Class clazz) {
        return HoneyContext._isConfig(clazz, entityList_levelTwo_Map, entityListWithStar_levelTwo);
    }

    static boolean isNeedRealTimeDb() {
        boolean enableMultiDs = HoneyConfig.getHoneyConfig().multiDS_enable;
        boolean isDifferentDbType = HoneyConfig.getHoneyConfig().multiDS_differentDbType;
        if (enableMultiDs && isDifferentDbType) {
            return true;
        }
        return HoneyContext.useStructForLevel2();
    }

    static boolean useStructForLevel2() {
        boolean useLevelTwo = HoneyConfig.getHoneyConfig().cache_useLevelTwo;
        boolean levelOneTolevelTwo = HoneyConfig.getHoneyConfig().cache_levelOneTolevelTwo;
        return useLevelTwo && !levelOneTolevelTwo;
    }

    static String getRealTimeDbName() {
        String dbName = null;
        if (HoneyContext.isNeedRealTimeDb()) {
            return HoneyConfig.getHoneyConfig().getDbName();
        }
        return dbName;
    }

    public static boolean isNeedDs() {
        if (HoneyContext.isMultiDs()) {
            int multiDsType = HoneyConfig.getHoneyConfig().multiDS_type;
            boolean differentDbType = HoneyConfig.getHoneyConfig().multiDS_differentDbType;
            return multiDsType != 1 || differentDbType;
        }
        return false;
    }

    static boolean isAlreadySetRoute() {
        return OneTimeParameter.isTrue("_SYS_Bee_ALREADY_SET_ROUTE");
    }

    public static Map<String, String> getDsName2DbName() {
        return dsName2DbName;
    }

    public static void setDsName2DbName(Map<String, String> dsName2DbName) {
        HoneyContext.dsName2DbName = dsName2DbName;
    }

    public static boolean isConfigRefresh() {
        return configRefresh;
    }

    public static boolean isDsMapConfigRefresh() {
        return dsMapConfigRefresh;
    }

    public static void setDsMapConfigRefresh(boolean dsMapConfigRefresh) {
        HoneyContext.dsMapConfigRefresh = dsMapConfigRefresh;
    }

    public static void setConfigRefresh(boolean configRefresh) {
        HoneyContext.configRefresh = configRefresh;
        HoneyConfig.setChangeDataSource(true);
    }

    public static void updateConfig(Map<String, Object> map) {
        if (ObjectUtils.isEmpty(map)) {
            return;
        }
        HoneyConfig obj = HoneyConfig.getHoneyConfig();
        Class<?> clazz = obj.getClass();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            try {
                Field field = clazz.getDeclaredField(entry.getKey());
                field.setAccessible(true);
                field.set(obj, entry.getValue());
            }
            catch (Exception e) {
                throw ExceptionHelper.convert(e);
            }
        }
        HoneyContext.setConfigRefresh(true);
        HoneyContext.setDsMapConfigRefresh(true);
    }

    public static boolean getModifiedFlagForCache2(String tableName) {
        Boolean f = (Boolean)modifiedFlagMapForCache2.get(tableName);
        return f == null ? false : f;
    }

    public static void addModifiedFlagForCache2(String tableName, boolean isModified) {
        if (tableName == null) {
            return;
        }
        modifiedFlagMapForCache2.put(tableName, isModified);
    }

    public static Boolean getEntityInterceptorFlag(String fullClassName) {
        return (Boolean)entityInterceptorFlag.get(fullClassName);
    }

    public static void addEntityInterceptorFlag(String fullClassName, boolean isHas) {
        if (fullClassName == null) {
            return;
        }
        entityInterceptorFlag.put(fullClassName, isHas);
    }

    public static Boolean getCustomFlagMap(String key) {
        return (Boolean)customFlagMap.get(key);
    }

    public static void addCustomFlagMap(String key, boolean flag) {
        if (key == null) {
            return;
        }
        customFlagMap.put(key, flag);
    }

    public static boolean isInterceptorSubEntity() {
        return OneTimeParameter.isTrue("_SYS_Bee_InterceptorSubEntity");
    }

    public static void setDataSource(DataSource dataSource) {
        BeeFactory.getInstance().setDataSource(dataSource);
        HoneyContext.setConfigRefresh(true);
    }

    public static void setDataSourceMap(Map<String, DataSource> dataSourceMap) {
        BeeFactory.getInstance().setDataSourceMap(dataSourceMap);
    }

    static {
        table2entity = null;
        entityList_includes_Map = new ConcurrentHashMap<String, String>();
        entityList_excludes_Map = new ConcurrentHashMap<String, String>();
        entityListWithStar_in = new CopyOnWriteArrayList<String>();
        entityListWithStar_ex = new CopyOnWriteArrayList<String>();
        entityList_levelTwo_Map = new ConcurrentHashMap<String, String>();
        entityListWithStar_levelTwo = new CopyOnWriteArrayList<String>();
        beanMap = new ConcurrentHashMap<String, String>();
        beanCustomPKey = new ConcurrentHashMap<String, String>();
        customMap = new ConcurrentHashMap<String, Map<String, String>>();
        if (cacheLocal != null) {
            cacheLocal.remove();
        }
        if (sqlServerPaging != null) {
            sqlServerPaging.remove();
        }
        if (customMapLocal != null) {
            customMapLocal.remove();
        }
        if (sysCommStrLocal != null) {
            sysCommStrLocal.remove();
        }
        if (listLocal != null) {
            listLocal.remove();
        }
        if (sqlPreValueLocal != null) {
            sqlPreValueLocal.remove();
        }
        if (sqlIndexLocal != null) {
            sqlIndexLocal.remove();
        }
        if (conditionLocal != null) {
            conditionLocal.remove();
        }
        sqlPreValueLocal = new InheritableThreadLocal<Map<String, List<PreparedValue>>>();
        sqlIndexLocal = new InheritableThreadLocal<Integer>();
        conditionLocal = new InheritableThreadLocal<Condition>();
        cacheLocal = new InheritableThreadLocal<Map<String, CacheSuidStruct>>();
        sqlServerPaging = new ThreadLocal();
        customMapLocal = new ThreadLocal();
        sysCommStrLocal = new InheritableThreadLocal<Map<String, String>>();
        listLocal = new ThreadLocal();
        currentConnection = new ThreadLocal();
        conneForSelectRs = new ConcurrentHashMap<String, Connection>();
        currentAppDB = new ThreadLocal();
        currentNameTranslate = new ThreadLocal();
        sameConnectionDoing = new ThreadLocal();
        jdbcTranWriterDs = new ThreadLocal();
        appointDS = new InheritableThreadLocal<String>();
        tempDS = new ThreadLocal();
        appointTab = new ThreadLocal();
        tabSuffix = new ThreadLocal();
        tempLang = new ThreadLocal();
        currentRoute = new InheritableThreadLocal<RouteStruct>();
        currentShardingPage = new ThreadLocal();
        currentShardingSort = new InheritableThreadLocal<ShardingSortStruct>();
        currentGroupFunStruct = new InheritableThreadLocal<GroupFunStruct>();
        entity2table = new ConcurrentHashMap<String, String>();
        HoneyContext.initEntity2Table();
        HoneyContext.parseEntityListToMap();
        modifiedFlagMapForCache2 = new ConcurrentHashMap<String, Boolean>();
        entityInterceptorFlag = new ConcurrentHashMap<String, Boolean>();
        customFlagMap = new ConcurrentHashMap<String, Boolean>();
        HoneyContext.initLoad();
        configRefresh = false;
        dsMapConfigRefresh = false;
    }
}

