/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.IncludeType;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.ObjToSQLRich;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.api.Condition;
import org.teasoft.bee.osql.api.SuidRich;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.honey.osql.autogen.DdlToSql;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.BeeFactoryHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.ObjSQL;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.config.ShardingRegistry;
import org.teasoft.honey.sharding.engine.batch.ShardingBatchInsertEngine;
import org.teasoft.honey.sharding.engine.batch.ShardingForkJoinBatchInsertEngine;
import org.teasoft.honey.util.ObjectUtils;
import org.teasoft.honey.util.SuidHelper;

public class ObjSQLRich
extends ObjSQL
implements SuidRich,
Serializable {
    private static final long serialVersionUID = 1596710362258L;
    private ObjToSQLRich objToSQLRich;
    private static final String SELECT_SQL = "select SQL: ";
    private static final String SELECT_JSON_SQL = "selectJson SQL: ";
    private static final String DELETE_BY_ID_SQL = "deleteById SQL: ";
    private static final String SELECT_BY_ID_SQL = "selectById SQL: ";
    private static final String UPDATE_SQL_WHERE_FIELDS = "update SQL(whereFields) :";
    private static final String UPDATE_SQL_UPDATE_FIELDS = "update SQL(updateFields) :";
    private static final String ID_IS_NULL = "in method selectById,id is null! ";
    private static final String START_GREAT_EQ_0 = "Parameter 'start' need >=0 .";
    private static final String SIZE_GREAT_0 = "Parameter 'size' need >0 .";
    private static final String TIP_SIZE_0 = "The size is 0, but it should be greater than 0 (>0)";
    private int defaultBatchSize;

    public ObjSQLRich() {
        this.defaultBatchSize = HoneyConfig.getHoneyConfig().insertBatchSize;
    }

    public ObjToSQLRich getObjToSQLRich() {
        if (this.objToSQLRich == null) {
            this.objToSQLRich = BeeFactory.getHoneyFactory().getObjToSQLRich();
        }
        return this.objToSQLRich;
    }

    public void setObjToSQLRich(ObjToSQLRich objToSQLRich) {
        this.objToSQLRich = objToSQLRich;
    }

    public <T> List<T> select(T entity, int size) {
        if (entity == null) {
            return null;
        }
        if (size == 0) {
            Logger.warn(TIP_SIZE_0);
            return Collections.emptyList();
        }
        if (size < 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, -1, size);
        sql = this.doAfterCompleteSql(sql);
        List list = this.getBeeSql().select(sql, this.toClassT(entity));
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> select(T entity, int start, int size) {
        if (entity == null) {
            return null;
        }
        if (size == 0) {
            Logger.warn(TIP_SIZE_0);
            return Collections.emptyList();
        }
        if (size < 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, start, size);
        sql = this.doAfterCompleteSql(sql);
        List list = this.getBeeSql().select(sql, this.toClassT(entity));
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> select(T entity, String ... selectFields) {
        if (entity == null) {
            return null;
        }
        List list = null;
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, selectFields);
        sql = this.doAfterCompleteSql(sql);
        list = this.getBeeSql().selectSomeField(sql, this.toClassT(entity));
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> select(T entity, int start, int size, String ... selectFields) {
        if (entity == null) {
            return null;
        }
        if (size == 0) {
            Logger.warn(TIP_SIZE_0);
            return Collections.emptyList();
        }
        if (size < 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        List list = null;
        String sql = this.getObjToSQLRich().toSelectSQL(entity, start, size, selectFields);
        sql = this.doAfterCompleteSql(sql);
        list = this.getBeeSql().selectSomeField(sql, this.toClassT(entity));
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> selectOrderBy(T entity, String orderFields) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        List list = null;
        String sql = this.getObjToSQLRich().toSelectOrderBySQL(entity, orderFields);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("selectOrderBy SQL: ", sql);
        list = this.getBeeSql().select(sql, this.toClassT(entity));
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> selectOrderBy(T entity, String orderFields, OrderType[] orderTypes) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        List list = null;
        String sql = this.getObjToSQLRich().toSelectOrderBySQL(entity, orderFields, orderTypes);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("selectOrderBy SQL: ", sql);
        list = this.getBeeSql().select(sql, this.toClassT(entity));
        this.doBeforeReturn(list);
        return list;
    }

    public <T> int insert(T[] entity) {
        return this.insert(entity, this.defaultBatchSize, "");
    }

    public <T> int insert(T[] entity, String excludeFields) {
        return this.insert(entity, this.defaultBatchSize, "");
    }

    public <T> int insert(T[] entity, int batchSize) {
        return this.insert(entity, batchSize, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int insert(T[] entity, int batchSize, String excludeFields) {
        if (entity == null || entity.length < 1) {
            return -1;
        }
        this.checkNull(entity);
        if (batchSize <= 0) {
            batchSize = 10;
        }
        if (ShardingUtil.isShardingBatchInsertDoing()) {
            return this._insert(entity, batchSize, excludeFields);
        }
        HoneyUtil.setInitArrayIdByAuto(entity);
        this.doBeforePasreEntity(entity, SuidType.INSERT);
        int a = 0;
        List<String> tabNameListForBatch = HoneyContext.getListLocal("_SYS_Bee_TabNameListForBatchLocal");
        List<String> dsNameListForBatch = HoneyContext.getListLocal("_SYS_Bee_DsNameListForBatchLocal");
        if (!ShardingUtil.isSharding() || ObjectUtils.isEmpty(tabNameListForBatch) && ObjectUtils.isEmpty(dsNameListForBatch)) {
            a = this._insert(entity, batchSize, excludeFields);
        } else {
            try {
                String tableName = this._toTableName(entity[0]);
                Logger.logSQL("Batch insert, tableName:" + tableName + "  dsNameList:" + dsNameListForBatch + "  tabNameList:" + tabNameListForBatch);
                boolean isBroadcastTab = ShardingRegistry.isBroadcastTab(tableName);
                boolean forkJoin = HoneyConfig.getHoneyConfig().sharding_forkJoinBatchInsert;
                a = forkJoin && !isBroadcastTab ? new ShardingForkJoinBatchInsertEngine<T>().batchInsert(entity, batchSize, excludeFields, tabNameListForBatch, this) : new ShardingBatchInsertEngine<T>().batchInsert(entity, batchSize, excludeFields, tabNameListForBatch, this);
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), e);
            }
            finally {
                HoneyContext.removeSysCommStrLocal("_SYS_Bee_ShardingBatchInsertDoing");
            }
        }
        HoneyUtil.revertId(entity);
        this.doBeforeReturn();
        return a;
    }

    private <T> int _insert(T[] entity, int batchSize, String excludeFields) {
        String[] insertSql = this.getObjToSQLRich().toInsertSQL((Object[])entity, batchSize, excludeFields);
        this._regEntityClass1(entity[0]);
        insertSql[0] = this.doAfterCompleteSql(insertSql[0]);
        int a = this.getBeeSql().batch(insertSql, batchSize);
        return a;
    }

    private String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private <T> void checkNull(T[] entity) {
        for (int i = 0; i < entity.length; ++i) {
            if (entity[i] != null) continue;
            throw new ObjSQLException("entity[] have null element, index: " + i);
        }
    }

    public <T> int update(T entity, String ... updateFields) {
        return this._update(entity, updateFields);
    }

    private <T> int _update(T entity, String ... updateFields) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, updateFields);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(UPDATE_SQL_UPDATE_FIELDS, sql);
        r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> T selectOne(T entity) {
        if (entity == null) {
            return null;
        }
        List<T> list = this.select(entity, 2);
        if (list == null || list.size() != 1) {
            return null;
        }
        return list.get(0);
    }

    public <T> T selectFirst(T entity, Condition condition) {
        List<T> list;
        if (entity == null) {
            return null;
        }
        if (condition == null) {
            list = this.select(entity, 1);
        } else {
            condition.size(Integer.valueOf(1));
            list = this.select(entity, condition);
        }
        if (list == null || list.size() < 1) {
            return null;
        }
        return list.get(0);
    }

    public <T> String selectWithFun(T entity, FunctionType functionType, String fieldForFun) {
        return this.selectWithFun(entity, functionType, fieldForFun, null);
    }

    public <T> String selectWithFun(T entity, FunctionType functionType, String fieldForFun, Condition condition) {
        if (entity == null) {
            return null;
        }
        this.regCondition(condition);
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String s = null;
        String sql = this.getObjToSQLRich().toSelectFunSQL(entity, functionType, fieldForFun, condition);
        this._regEntityClass1(entity);
        this._regFunType(functionType);
        sql = this.doAfterCompleteSql(sql);
        s = this.getBeeSql().selectFun(sql);
        this.doBeforeReturn();
        return s;
    }

    public <T> int count(T entity) {
        return this.count(entity, null);
    }

    public <T> int count(T entity, Condition condition) {
        String total = this.selectWithFun(entity, FunctionType.COUNT, "*", condition);
        return total == null ? 0 : Integer.parseInt(total);
    }

    public <T> int update(T entity, IncludeType includeType, String ... updateFields) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, includeType, updateFields);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(UPDATE_SQL_UPDATE_FIELDS, sql);
        r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> List<T> select(T entity, IncludeType includeType) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, includeType);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().select(sql, this.toClassT(entity));
        this.doBeforeReturn(list);
        return list;
    }

    public <T> int update(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, includeType);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("update SQL: ", sql);
        int r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> int insert(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.INSERT);
        String sql = this.getObjToSQLRich().toInsertSQL(entity, includeType);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("insert SQL: ", sql);
        int r = this.getBeeSql().modify(sql);
        HoneyUtil.revertId(entity);
        this.doBeforeReturn();
        return r;
    }

    public <T> long insertAndReturnId(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1L;
        }
        this.doBeforePasreEntity(entity, SuidType.INSERT);
        String sql = this.getObjToSQLRich().toInsertSQL(entity, includeType);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("insert SQL: ", sql);
        return this._insertAndReturnId(entity, sql);
    }

    public <T> int delete(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.DELETE);
        String sql = this.getObjToSQLRich().toDeleteSQL(entity, includeType);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("delete SQL: ", sql);
        int r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> List<String[]> selectString(T entity) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        List list = null;
        String sql = this.getObjToSQLRich().toSelectSQL(entity);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("select SQL(return List<String[]>): ", sql);
        list = this.getBeeSql().select(sql);
        this.doBeforeReturn();
        return list;
    }

    public <T> List<String[]> selectString(T entity, String ... selectFields) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        List list = null;
        String sql = this.getObjToSQLRich().toSelectSQL(entity, selectFields);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        list = this.getBeeSql().select(sql);
        this.doBeforeReturn();
        return list;
    }

    public <T> List<String[]> selectString(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        this.regCondition(condition);
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        OneTimeParameter.setTrueForKey("_SYS_Bee_Check_Group_ForSharding");
        List list = null;
        String sql = this.getObjToSQLRich().toSelectSQL(entity, condition);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("select SQL(return List<String[]>): ", sql);
        list = this.getBeeSql().select(sql);
        this.doBeforeReturn();
        return list;
    }

    public <T> String selectJson(T entity) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_JSON_SQL, sql);
        String json = this.getBeeSql().selectJson(sql);
        this.doBeforeReturn();
        return json;
    }

    public <T> String selectJson(T entity, IncludeType includeType) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, includeType);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_JSON_SQL, sql);
        String json = this.getBeeSql().selectJson(sql);
        this.doBeforeReturn();
        return json;
    }

    public <T> String selectJson(T entity, String ... selectField) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, selectField);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("selectJson(T entity, String selectField) SQL: ", sql);
        String json = this.getBeeSql().selectJson(sql);
        this.doBeforeReturn();
        return json;
    }

    public <T> String selectJson(T entity, int start, int size, String ... selectFields) {
        if (entity == null) {
            return null;
        }
        if (size == 0) {
            Logger.warn(TIP_SIZE_0);
            return null;
        }
        if (size < 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, start, size, selectFields);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("selectJson(T entity, String selectField, int start, int size) SQL: ", sql);
        String json = this.getBeeSql().selectJson(sql);
        this.doBeforeReturn();
        return json;
    }

    public <T> T selectById(Class<T> entityClass, Integer id) {
        if (entityClass == null) {
            return null;
        }
        if (id == null) {
            Logger.warn(ID_IS_NULL);
            return null;
        }
        this.doBeforePasreEntity(entityClass, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectByIdSQL(entityClass, id);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_BY_ID_SQL, sql);
        List list = this.getBeeSql().select(sql, entityClass);
        return this.getIdEntity(list);
    }

    public <T> T selectById(Class<T> entityClass, Long id) {
        if (entityClass == null) {
            return null;
        }
        if (id == null) {
            Logger.warn(ID_IS_NULL);
            return null;
        }
        this.doBeforePasreEntity(entityClass, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectByIdSQL(entityClass, id);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_BY_ID_SQL, sql);
        List list = this.getBeeSql().select(sql, entityClass);
        return this.getIdEntity(list);
    }

    public <T> T selectById(Class<T> entityClass, String id) {
        if (entityClass == null) {
            return null;
        }
        if (id == null) {
            Logger.warn(ID_IS_NULL);
            return null;
        }
        if (id.contains(",")) {
            throw new BeeIllegalParameterException("The parameter 'id' of method selectById does not allow to contain comma!");
        }
        this.doBeforePasreEntity(entityClass, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectByIdSQL(entityClass, id);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_BY_ID_SQL, sql);
        List list = this.getBeeSql().select(sql, entityClass);
        return this.getIdEntity(list);
    }

    public <T> List<T> selectByIds(Class<T> entityClass, String ids) {
        if (entityClass == null) {
            return null;
        }
        if (ids == null) {
            Logger.warn("in method selectByIds,ids is null! ");
            return null;
        }
        this.doBeforePasreEntity(entityClass, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectByIdSQL(entityClass, ids);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("selectByIds SQL: ", sql);
        List list = this.getBeeSql().select(sql, entityClass);
        this.doBeforeReturn(list);
        return list;
    }

    private <T> T getIdEntity(List<T> list) {
        if (list == null || list.size() < 1) {
            this.doBeforeReturn();
            return null;
        }
        this.doBeforeReturn(list);
        return list.get(0);
    }

    public int deleteById(Class c, Integer id) {
        if (id == null) {
            Logger.warn("in method deleteById,id is null! ");
        }
        if (c == null || id == null) {
            return 0;
        }
        this.doBeforePasreEntity(c, SuidType.DELETE);
        String sql = this.getObjToSQLRich().toDeleteByIdSQL(c, id);
        this._regEntityClass2(c);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(DELETE_BY_ID_SQL, sql);
        int a = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return a;
    }

    public int deleteById(Class c, Long id) {
        if (id == null) {
            Logger.warn("in method deleteById,id is null! ");
        }
        if (c == null || id == null) {
            return 0;
        }
        this.doBeforePasreEntity(c, SuidType.DELETE);
        String sql = this.getObjToSQLRich().toDeleteByIdSQL(c, id);
        this._regEntityClass2(c);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(DELETE_BY_ID_SQL, sql);
        int a = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return a;
    }

    public int deleteById(Class c, String ids) {
        if (ids == null) {
            Logger.warn("in method deleteById,ids is null! ");
        }
        if (c == null || ids == null) {
            return 0;
        }
        this.doBeforePasreEntity(c, SuidType.DELETE);
        String sql = this.getObjToSQLRich().toDeleteByIdSQL(c, ids);
        this._regEntityClass2(c);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(DELETE_BY_ID_SQL, sql);
        int a = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return a;
    }

    @Deprecated
    public <T> List<T> select(T entity, IncludeType includeType, Condition condition) {
        if (entity == null) {
            return null;
        }
        if (includeType != null) {
            if (condition == null) {
                condition = BeeFactoryHelper.getCondition();
            }
            condition.setIncludeType(includeType);
        }
        return this.select(entity, condition);
    }

    public <T> String selectJson(T entity, IncludeType includeType, Condition condition) {
        if (entity == null) {
            return null;
        }
        if (includeType != null) {
            if (condition == null) {
                condition = BeeFactoryHelper.getCondition();
            }
            condition.setIncludeType(includeType);
        }
        return this.selectJson(entity, condition);
    }

    public <T> String selectJson(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        this.regCondition(condition);
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        this._regEntityClass1(entity);
        OneTimeParameter.setTrueForKey("_SYS_Bee_Check_Group_ForSharding");
        String sql = this.getObjToSQLRich().toSelectSQL(entity, condition);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_JSON_SQL, sql);
        String json = this.getBeeSql().selectJson(sql);
        this.doBeforeReturn();
        return json;
    }

    public <T> int updateBy(T entity, String ... whereFields) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateBySQL(entity, whereFields);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(UPDATE_SQL_WHERE_FIELDS, sql);
        r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> int updateBy(T entity, IncludeType includeType, String ... whereFields) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateBySQL(entity, includeType, whereFields);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(UPDATE_SQL_WHERE_FIELDS, sql);
        r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> int updateBy(T entity, Condition condition, String ... whereFields) {
        if (entity == null) {
            return -1;
        }
        this.regCondition(condition);
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateBySQL(entity, condition, whereFields);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(UPDATE_SQL_WHERE_FIELDS, sql);
        r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> int updateById(T entity, Condition condition) {
        String pkName = "";
        try {
            entity.getClass().getDeclaredField("id");
            pkName = "id";
        }
        catch (NoSuchFieldException e) {
            pkName = HoneyUtil.getPkFieldName(entity);
        }
        return this.updateBy(entity, condition, pkName);
    }

    public <T> int update(T entity, Condition condition, String ... updateFields) {
        if (entity == null) {
            return -1;
        }
        this.regCondition(condition);
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, condition, updateFields);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(UPDATE_SQL_UPDATE_FIELDS, sql);
        r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> int update(T entity, Condition condition) {
        if (entity == null) {
            return -1;
        }
        this.regCondition(condition);
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, condition, new String[]{""});
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("update SQL(condition) :", sql);
        r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> int insert(List<T> entityList) {
        if (entityList == null || entityList.size() < 1) {
            return -1;
        }
        T[] entity = this.toEntityArray(entityList);
        return this.insert(entity);
    }

    public <T> int insert(List<T> entityList, int batchSize) {
        if (entityList == null || entityList.size() < 1) {
            return -1;
        }
        T[] entity = this.toEntityArray(entityList);
        return this.insert(entity, batchSize);
    }

    public <T> int insert(List<T> entityList, String excludeFields) {
        if (entityList == null || entityList.size() < 1) {
            return -1;
        }
        T[] entity = this.toEntityArray(entityList);
        return this.insert(entity, excludeFields);
    }

    public <T> int insert(List<T> entityList, int batchSize, String excludeFields) {
        if (entityList == null || entityList.size() < 1) {
            return -1;
        }
        T[] entity = this.toEntityArray(entityList);
        return this.insert(entity, batchSize, excludeFields);
    }

    private <T> void _regEntityClass1(T entity) {
        if (entity == null) {
            return;
        }
        HoneyContext.regEntityClass(entity.getClass());
    }

    private void _regEntityClass2(Class clazz) {
        HoneyContext.regEntityClass(clazz);
    }

    private <T> void _regFunType(FunctionType functionType) {
        HoneyContext.regFunType(functionType);
    }

    private <T> T[] toEntityArray(List<T> entityList) {
        int len = entityList.size();
        Object[] entity = new Object[len];
        for (int i = 0; i < len; ++i) {
            entity[i] = entityList.get(i);
        }
        return entity;
    }

    public SuidRich setDynamicParameter(String para, String value) {
        OneTimeParameter.setAttribute(para, value);
        return this;
    }

    public <T> boolean exist(T entity) {
        int r = this.count(entity);
        return r > 0;
    }

    public <T> int update(T oldEntity, T newEntity) {
        if (oldEntity == null || newEntity == null) {
            return -1;
        }
        if (newEntity.getClass() == String.class) {
            return this._update(oldEntity, newEntity.toString());
        }
        String oldEntityFullName = oldEntity.getClass().getName();
        String newEntityFullName = newEntity.getClass().getName();
        Logger.debug(oldEntityFullName);
        Logger.debug(newEntityFullName);
        if (!oldEntityFullName.equals(newEntityFullName)) {
            throw new BeeErrorGrammarException("BeeErrorGrammarException: the oldEntity and newEntity must be same type!");
        }
        this.doBeforePasreEntity(newEntity, SuidType.UPDATE);
        Map<String, Object> newMap = SuidHelper.entityToMap(newEntity);
        Condition condition = BeeFactoryHelper.getCondition();
        for (Map.Entry<String, Object> entry : newMap.entrySet()) {
            if (HoneyUtil.isNumber(entry.getValue())) {
                condition.set(entry.getKey(), (Number)entry.getValue());
                continue;
            }
            condition.set(entry.getKey(), (String)entry.getValue());
        }
        Logger.logSQL("update(T oldEntity, T newEntity), ", "");
        return this.update(oldEntity, (T)condition);
    }

    public <T> int save(T entity) {
        if (entity == null) {
            return 0;
        }
        Object id = HoneyUtil.getIdValue(entity);
        if (id == null) {
            return this.insert(entity);
        }
        Object one = this.selectById(entity.getClass(), id.toString());
        if (one != null) {
            return this.update(entity);
        }
        return this.insert(entity);
    }

    public <T> boolean createTable(Class<T> entityClass, boolean isDropExistTable) {
        block9: {
            block10: {
                if (entityClass == null) {
                    return false;
                }
                this.doBeforePasreEntity(entityClass, SuidType.DDL);
                this._regEntityClass2(entityClass);
                if (!isDropExistTable) break block10;
                String dropSql = DdlToSql.toDropTableSql(entityClass);
                try {
                    dropSql = this.doAfterCompleteSql(dropSql);
                    Logger.logSQL("Drop SQL:", dropSql);
                    this._doModifyForDdl(dropSql);
                    this.doBeforeReturn();
                }
                catch (Exception e) {
                    if (HoneyUtil.isOracle() || HoneyUtil.isSqlServer()) break block9;
                    try {
                        this.doBeforePasreEntity(entityClass, SuidType.DDL);
                        dropSql = DdlToSql.toDropTableSimpleSql(entityClass);
                        dropSql = this.doAfterCompleteSql(dropSql);
                        Logger.logSQL("Drop SQL:", dropSql);
                        this._doModifyForDdl(dropSql);
                        this.doBeforeReturn();
                        break block9;
                    }
                    catch (Exception e2) {
                        Logger.warn(e2.getMessage());
                    }
                }
                break block9;
            }
            boolean isSharding = ShardingUtil.isSharding();
            if (!isSharding) {
                try {
                    int c = this.count(entityClass.newInstance());
                    if (c > 0) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.doBeforePasreEntity(entityClass, SuidType.DDL);
        String sql = DdlToSql.toCreateTableSQL(entityClass);
        return this._ddlModify(entityClass, sql);
    }

    public <T> void indexNormal(Class<T> entityClass, String fields, String indexName) {
        String PREFIX = "idx_";
        String IndexTypeTip = "normal";
        String IndexType = "";
        this._index(entityClass, fields, indexName, PREFIX, IndexTypeTip, IndexType);
    }

    public <T> void unique(Class<T> entityClass, String fields, String indexName) {
        String PREFIX = "uie_";
        String IndexTypeTip = "unique";
        String IndexType = "UNIQUE ";
        this._index(entityClass, fields, indexName, PREFIX, IndexTypeTip, IndexType);
    }

    private <T> void _index(Class<T> entityClass, String fields, String indexName, String PREFIX, String IndexTypeTip, String IndexType) {
        this.doBeforePasreEntity(entityClass, SuidType.DDL);
        this._regEntityClass2(entityClass);
        String indexSql = DdlToSql.toIndexSql(entityClass, fields, indexName, PREFIX, IndexTypeTip, IndexType);
        this._ddlModify(entityClass, indexSql);
    }

    public <T> void primaryKey(Class<T> entityClass, String fields, String keyName) {
        this.doBeforePasreEntity(entityClass, SuidType.DDL);
        this._regEntityClass2(entityClass);
        String primaryKeySql = DdlToSql.toPrimaryKeySql(entityClass, fields, keyName);
        this._ddlModify(entityClass, primaryKeySql);
    }

    private void _doModifyForDdl(String sql) {
        boolean old = HoneyConfig.getHoneyConfig().showSql_showExecutableSql;
        if (old) {
            HoneyConfig.getHoneyConfig().showSql_showExecutableSql = false;
        }
        this.getBeeSql().modify(sql);
        if (old) {
            HoneyConfig.getHoneyConfig().showSql_showExecutableSql = old;
        }
    }

    private <T> boolean _ddlModify(Class<T> entityClass, String sql) {
        boolean f = false;
        try {
            this.doBeforePasreEntity(entityClass, SuidType.DDL);
            this._regEntityClass2(entityClass);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL("DDL SQL:", sql);
            this._doModifyForDdl(sql);
            this.doBeforeReturn();
            f = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public <T> void dropIndex(Class<T> entityClass, String indexName) {
        this.doBeforePasreEntity(entityClass, SuidType.DDL);
        this._regEntityClass2(entityClass);
        String dropIndexSql = DdlToSql.toDropIndexSql(entityClass, indexName);
        this._ddlModify(entityClass, dropIndexSql);
    }
}

