/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.sql.Connection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.teasoft.bee.ds.DataSourceBuilder;
import org.teasoft.bee.ds.DataSourceBuilderFactory;
import org.teasoft.bee.osql.exception.ConfigWrongException;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.JdkSerializer;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.util.Converter;
import org.teasoft.honey.util.StringUtils;

class ProcessDataSourceMap {
    ProcessDataSourceMap() {
    }

    static void parseDbNameByDsMap(Map<String, DataSource> dsMap) {
        if (dsMap == null) {
            return;
        }
        int i = 0;
        String dbName = "";
        LinkedHashMap<String, String> dsName2DbName = new LinkedHashMap<String, String>();
        for (Map.Entry<String, DataSource> entry : dsMap.entrySet()) {
            dsName2DbName.put(entry.getKey(), ProcessDataSourceMap.getDbName(entry.getValue()));
            if (i != 0) continue;
            dbName = (String)dsName2DbName.get(entry.getKey());
            ++i;
        }
        Logger.info("[Bee] Parse DataSourceMap: dataSource name to database name , result: " + dsName2DbName);
        HoneyConfig.getHoneyConfig().setDbName(dbName);
        HoneyContext.setDsName2DbName(dsName2DbName);
        HoneyUtil.refreshSetParaAndResultTypeHandlerRegistry();
    }

    static Map<String, DataSource> refreshDataSourceMap() {
        List<Map<String, String>> dbsList = HoneyConfig.getHoneyConfig().getDbs();
        if (dbsList == null || dbsList.size() == 0) {
            return null;
        }
        boolean extendFirst = HoneyConfig.getHoneyConfig().extendFirst;
        ProcessDataSourceMap.notifyClass("DataSourceToolRegHandler");
        int size = dbsList.size();
        String[] dsNames = new String[size];
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        Map<String, String> base0 = null;
        Map<String, String> copyMap = null;
        for (int i = 0; i < size; ++i) {
            String url;
            String type;
            Map<String, String> map = dbsList.get(i);
            map = Converter.transferKey(map);
            dsNames[i] = map.get("dsName");
            map.remove("dsName");
            if (extendFirst) {
                if (i == 0) {
                    base0 = map;
                } else {
                    copyMap = ProcessDataSourceMap.copyMap(base0);
                    if (copyMap != null) {
                        copyMap.putAll(map);
                        map = copyMap;
                    }
                }
            }
            if (StringUtils.isBlank(type = map.get("type")) && (url = map.get("url")) != null && url.startsWith("mongodb://")) {
                type = "BeeMongo";
            }
            if (StringUtils.isBlank(type)) {
                type = "Hikari";
            } else if ("BeeMongo".equalsIgnoreCase(type)) {
                ProcessDataSourceMap.notifyClass("BeeMongodbRegHandler");
            }
            DataSourceBuilder builder = DataSourceBuilderFactory.getDataSourceBuilder((String)type);
            if (builder == null) {
                throw new ConfigWrongException("Did not config the DataSourceBuilder for " + type);
            }
            dataSourceMap.put(dsNames[i], builder.build(map));
        }
        return dataSourceMap;
    }

    private static void notifyClass(String className) {
        try {
            Class.forName("org.teasoft.beex.ds." + className);
        }
        catch (Exception e) {
            Logger.debug(e.getMessage(), e);
        }
    }

    private static Map<String, String> copyMap(Map<String, String> obj) {
        try {
            JdkSerializer jdks = new JdkSerializer();
            return (Map)jdks.unserialize(jdks.serialize(obj));
        }
        catch (Exception e) {
            Logger.debug(e.getMessage(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDbName(DataSource ds) {
        Connection conn = null;
        String dbName = null;
        try {
            conn = ds.getConnection();
            if (conn != null && (dbName = conn.getMetaData().getDatabaseProductName()).contains("Microsoft Access")) {
                Logger.debug("Transform the dbName:'" + dbName + "' to '" + "Microsoft Access" + "'");
                dbName = "Microsoft Access";
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e2) {
                Logger.error(e2.getMessage(), e2);
            }
        }
        return dbName;
    }
}

