/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.teasoft.bee.osql.exception.NoConfigException;
import org.teasoft.bee.osql.transaction.Transaction;
import org.teasoft.honey.database.ClientDataSource;
import org.teasoft.honey.database.DatabaseClientConnection;
import org.teasoft.honey.mongodb.MongodbConnection;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.JndiDataSource;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.transaction.JdbcTransaction;
import org.teasoft.honey.util.StringUtils;

public final class SessionFactory {
    private static BeeFactory beeFactory = null;
    private static boolean isFirst = true;
    private static boolean isFirstWithOriginal = true;

    public static BeeFactory getBeeFactory() {
        if (beeFactory == null) {
            beeFactory = BeeFactory.getInstance();
        }
        return beeFactory;
    }

    public void setBeeFactory(BeeFactory beeFactory) {
        SessionFactory._setBeeFactory(beeFactory);
    }

    private static void _setBeeFactory(BeeFactory beeFactory0) {
        beeFactory = beeFactory0;
    }

    public static DatabaseClientConnection getDatabaseConnection() {
        DatabaseClientConnection dbConnection;
        block16: {
            dbConnection = null;
            try {
                DataSource ds = SessionFactory.getBeeFactory().getDataSource();
                if (ds == null) break block16;
                try (Connection conn = ds.getConnection();){
                    String dbName = conn.getMetaData().getDatabaseProductName();
                    if ("MongoDB".equalsIgnoreCase(dbName)) {
                        dbConnection = new DatabaseClientConnection((ClientDataSource)ds);
                    }
                }
            }
            catch (SQLException e) {
                Logger.debug(e.getMessage());
                throw ExceptionHelper.convert(e);
            }
            catch (Exception e) {
                throw ExceptionHelper.convert(e);
            }
        }
        return dbConnection;
    }

    public static Connection getConnection() {
        Connection conn = null;
        try {
            boolean isJndiType;
            DataSource ds = SessionFactory.getBeeFactory().getDataSource();
            if (ds == null && (isJndiType = HoneyConfig.getHoneyConfig().jndiType) && (ds = new JndiDataSource().getDataSource()) != null) {
                SessionFactory.getBeeFactory().setDataSource(ds);
            }
            if (ds != null) {
                conn = ds.getConnection();
            } else {
                conn = SessionFactory.getOriginalConn();
                if (isFirstWithOriginal || HoneyConfig.getHoneyConfig().multiDS_enable) {
                    isFirstWithOriginal = false;
                    Logger.debug("Use OriginalConn!");
                }
            }
        }
        catch (SQLException e) {
            Logger.debug(e.getMessage());
            throw ExceptionHelper.convert(e);
        }
        catch (ClassNotFoundException e) {
            Logger.error("Can not find the Database driver!  " + e.getMessage());
            throw new NoConfigException("Can not find the Database driver(maybe miss the jar file).");
        }
        catch (Exception e) {
            Logger.error("Have Exception when getConnection: " + e.getMessage());
            throw ExceptionHelper.convert(e);
        }
        return conn;
    }

    public static Transaction getTransaction() {
        Transaction tran = null;
        if (SessionFactory.getBeeFactory().getTransaction() == null) {
            boolean isAndroid = HoneyConfig.getHoneyConfig().isAndroid;
            boolean isHarmony = HoneyConfig.getHoneyConfig().isHarmony;
            if (isAndroid || isHarmony) {
                String c = "";
                if (isAndroid) {
                    c = "org.teasoft.beex.android.SQLiteTransaction";
                } else if (isHarmony) {
                    c = "org.teasoft.beex.harmony.SQLiteTransaction";
                }
                try {
                    return (Transaction)Class.forName(c).newInstance();
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), e);
                }
            } else if (HoneyUtil.isMongoDB()) {
                String c = "org.teasoft.beex.mongodb.MongodbTransaction";
                try {
                    return (Transaction)Class.forName(c).newInstance();
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), e);
                }
            }
            tran = new JdbcTransaction();
        } else {
            tran = SessionFactory.getBeeFactory().getTransaction();
        }
        return tran;
    }

    private static Connection getOriginalConn() throws ClassNotFoundException, SQLException, Exception {
        String driverName = HoneyConfig.getHoneyConfig().getDriverName();
        String url = HoneyConfig.getHoneyConfig().getUrl();
        String username = HoneyConfig.getHoneyConfig().getUsername();
        String password = HoneyConfig.getHoneyConfig().getPassword();
        return SessionFactory.getOriginalConnForIntra(url, username, password, driverName);
    }

    public static Connection getOriginalConnForIntra(String url, String username, String password, String driverName) throws ClassNotFoundException, SQLException, Exception {
        String nullInfo = "";
        String DO_NOT_CONFIG = " do not config; ";
        if (driverName == null) {
            nullInfo = nullInfo + "bee.db.driverName do not config; ";
        }
        if (url == null) {
            nullInfo = nullInfo + "bee.db.url do not config; ";
        }
        if (url == null) {
            if (HoneyConfig.getHoneyConfig().multiDS_enable) {
                Logger.warn("Now is multi-DataSource model, please confirm whether set the config !!!");
            }
            throw new Exception("The url can not be null when get the Connection directly from DriverManager!  (" + nullInfo + ")");
        }
        if (username == null) {
            nullInfo = nullInfo + "bee.db.username do not config; ";
        }
        if (password == null) {
            nullInfo = nullInfo + "bee.db.password do not config; ";
        }
        if (!"".equals(nullInfo) && isFirst) {
            Logger.warn("Do not set the database info: " + nullInfo);
            isFirst = false;
        }
        Connection conn = null;
        if (StringUtils.isNotBlank(driverName)) {
            Class.forName(driverName);
        }
        if (username != null && password != null) {
            if (url.trim().startsWith("mongodb:")) {
                return new MongodbConnection();
            }
            conn = DriverManager.getConnection(url, username, password);
        } else {
            if (url.trim().startsWith("mongodb:")) {
                return new MongodbConnection();
            }
            conn = DriverManager.getConnection(url);
        }
        return conn;
    }
}

