/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.dialect;

import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.honey.osql.core.HoneyUtil;

public class OffsetFetchPaging
implements DbFeature {
    private static final String PagingLower = " offset #1# rows fetch next #2# rows";
    private static final String PagingUpper = " OFFSET #1# ROWS FETCH NEXT #2# ROWS";

    public String toPageSql(String sql, int start, int size) {
        String paging = this.isUpper() ? PagingUpper : PagingLower;
        sql = HoneyUtil.deleteLastSemicolon(sql);
        String forUpdateClause = null;
        boolean isForUpdate = false;
        int forUpdateIndex = sql.toLowerCase().lastIndexOf("for update");
        if (forUpdateIndex > -1) {
            forUpdateClause = sql.substring(forUpdateIndex);
            sql = sql.substring(0, forUpdateIndex - 1);
            isForUpdate = true;
        }
        if (HoneyUtil.isRegPagePlaceholder()) {
            paging = paging.replace("#1#", "?").replace("#2#", "?");
            int[] array = new int[]{start, size};
            HoneyUtil.regPageNumArray(array);
        } else {
            paging = paging.replace("#1#", start + "").replace("#2#", size + "");
        }
        sql = sql + paging;
        if (isForUpdate) {
            sql = sql + " " + forUpdateClause;
        }
        return sql;
    }

    public String toPageSql(String sql, int size) {
        return this.toPageSql(sql, 0, size);
    }

    private boolean isUpper() {
        return HoneyUtil.isSqlKeyWordUpper();
    }
}

