/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionService;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.util.ObjectUtils;

public class ResultMergeEngine {
    public static <T> List<T> merge(CompletionService<List<T>> completionService, int size) {
        ArrayList<T> rsList = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            try {
                List<T> t = completionService.take().get();
                if (!ObjectUtils.isNotEmpty(t)) continue;
                rsList.addAll(t);
                continue;
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), e);
            }
        }
        return rsList;
    }

    public static List<String> mergeJsonResult(CompletionService<String> completionService, int size) {
        ArrayList<String> rsList = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            try {
                String tempStr = completionService.take().get();
                if (!ObjectUtils.isNotEmpty(tempStr) || "[]".equals(tempStr)) continue;
                rsList.add(tempStr);
                continue;
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), e);
            }
        }
        return rsList;
    }

    public static List<String> mergeFunResult(CompletionService<String> completionService, int size) {
        ArrayList<String> rsList = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            try {
                String tempStr = completionService.take().get();
                if (!ObjectUtils.isNotEmpty(tempStr)) continue;
                rsList.add(tempStr);
                continue;
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), e);
            }
        }
        return rsList;
    }

    public static int mergeInteger(CompletionService<Integer> completionService, int size) {
        int r = 0;
        for (int i = 0; i < size; ++i) {
            try {
                Integer part = completionService.take().get();
                if (part == null) continue;
                r += part.intValue();
                continue;
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), e);
            }
        }
        return r;
    }
}

