/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine.batch;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.teasoft.bee.osql.api.SuidRich;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.JdkSerializer;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.ShardingLogReg;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.sharding.ShardingReg;
import org.teasoft.honey.sharding.config.ShardingRegistry;
import org.teasoft.honey.sharding.engine.ResultMergeEngine;
import org.teasoft.honey.sharding.engine.batch.ShardingBatchInsertTemplate;
import org.teasoft.honey.util.StringUtils;

public class ShardingBatchInsertEngine<T> {
    public int batchInsert(T[] entity, int batchSize, String excludeFields, List<String> tabNameListForBatch, SuidRich suidRich) {
        ShardingReg.regShardingBatchInsertDoing();
        ArrayList<String> taskDs = new ArrayList<String>();
        ArrayList<String> taskTab = new ArrayList();
        List<String> dsNameListForBatch = HoneyContext.getListLocal("_SYS_Bee_DsNameListForBatchLocal");
        boolean isBroadcastTabBatchInsert = false;
        String tableName = this._toTableName(entity[0]);
        if (ShardingRegistry.isBroadcastTab(tableName)) {
            isBroadcastTabBatchInsert = true;
        }
        int time = 0;
        ExecutorService executor = Executors.newCachedThreadPool();
        ExecutorCompletionService<Integer> completionService = new ExecutorCompletionService<Integer>(executor);
        ArrayList<ShardingBeeSQLBatchInsertExecutorEngine> tasks = new ArrayList<ShardingBeeSQLBatchInsertExecutorEngine>();
        if (!isBroadcastTabBatchInsert) {
            ArrayList<Object[]> newEntityArrayList = new ArrayList<Object[]>();
            Map<String, List<Integer>> tabMap = this.groupElement(tabNameListForBatch);
            for (Map.Entry<String, List<Integer>> entry : tabMap.entrySet()) {
                String tabName = entry.getKey();
                List<Integer> indexList = entry.getValue();
                Object[] newEntity = new Object[indexList.size()];
                for (int i = 0; i < indexList.size(); ++i) {
                    newEntity[i] = entity[indexList.get(i)];
                }
                newEntityArrayList.add(newEntity);
                String dsName = dsNameListForBatch.get(indexList.get(0));
                if (StringUtils.isBlank(dsName)) {
                    dsName = ShardingRegistry.getDsByTab(tabName);
                }
                taskDs.add(dsName);
                taskTab.add(tabName);
            }
            for (int i = 0; i < newEntityArrayList.size(); ++i) {
                tasks.add(new ShardingBeeSQLBatchInsertExecutorEngine((Object[])newEntityArrayList.get(i), batchSize, excludeFields, taskDs, taskTab, suidRich, i));
            }
            time = newEntityArrayList.size();
        } else {
            time = dsNameListForBatch.size();
            taskTab = HoneyContext.getListLocal("_SYS_Bee_TabNameListForBatchLocal");
            for (int i = 0; i < time; ++i) {
                tasks.add(new ShardingBeeSQLBatchInsertExecutorEngine(entity, batchSize, excludeFields, dsNameListForBatch, taskTab, suidRich, i));
            }
        }
        ShardingLogReg.log(time);
        int size = tasks.size();
        for (int i = 0; tasks != null && i < size; ++i) {
            completionService.submit((Callable)tasks.get(i));
        }
        int r = ResultMergeEngine.mergeInteger(completionService, size);
        executor.shutdown();
        return r;
    }

    private Map<String, List<Integer>> groupElement(List<String> tabNameListForBatch) {
        LinkedHashMap<String, List<Integer>> tabMap = new LinkedHashMap<String, List<Integer>>();
        for (int i = 0; i < tabNameListForBatch.size(); ++i) {
            ArrayList<Integer> dsList = (ArrayList<Integer>)tabMap.get(tabNameListForBatch.get(i));
            if (dsList == null) {
                dsList = new ArrayList<Integer>();
            }
            dsList.add(i);
            tabMap.put(tabNameListForBatch.get(i), dsList);
        }
        return tabMap;
    }

    private String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private class ShardingBeeSQLBatchInsertExecutorEngine
    extends ShardingBatchInsertTemplate<Integer>
    implements Callable<Integer> {
        private int batchSize;
        private String excludeFields;
        private SuidRich suidRich;
        private Object[] newEntityArray;

        public ShardingBeeSQLBatchInsertExecutorEngine(Object[] newEntityArray, int batchSize, String excludeFields, List<String> taskDs, List<String> taskTab, SuidRich suidRich, int index) {
            this.batchSize = batchSize;
            this.excludeFields = excludeFields;
            this.suidRich = suidRich;
            this.newEntityArray = newEntityArray;
            this.taskDs = taskDs;
            this.taskTab = taskTab;
            this.index = index;
        }

        @Override
        public Integer shardingWork() {
            int b = this.copy(this.suidRich).insert(this.newEntityArray, this.batchSize, this.excludeFields);
            return b;
        }

        @Override
        public Integer call() throws Exception {
            return (Integer)this.doSharding();
        }

        private SuidRich copy(SuidRich suidRich) {
            try {
                JdkSerializer jdks = new JdkSerializer();
                return (SuidRich)jdks.unserialize(jdks.serialize(suidRich));
            }
            catch (Exception e) {
                Logger.debug(e.getMessage(), e);
                return suidRich;
            }
        }
    }
}

