/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine.decorate;

import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.sharding.ShardingSortStruct;
import org.teasoft.honey.util.StringUtils;

public class CompareUtil {
    private static final String EMPTY = "";

    public static int compareTo(String thisValue, String otherValue, ShardingSortStruct struct, int i) {
        boolean caseSensitive;
        if (struct == null) {
            return 0;
        }
        OrderType orderType = struct.getOrderTypes()[i];
        boolean nullFirst = struct.getNullFirst() != null ? struct.getNullFirst()[i] : false;
        boolean bl = caseSensitive = struct.getCaseSensitive() != null ? struct.getCaseSensitive()[i] : false;
        if (null == thisValue && null == otherValue) {
            return 0;
        }
        if (null == thisValue) {
            return nullFirst ? -1 : 1;
        }
        if (null == otherValue) {
            return nullFirst ? 1 : -1;
        }
        String type = struct.getType() != null ? struct.getType()[i] : EMPTY;
        Integer number = CompareUtil.compareNumber(thisValue, otherValue, type);
        if (number != null) {
            return OrderType.ASC == orderType ? number : -number.intValue();
        }
        if (!caseSensitive && thisValue instanceof String && otherValue instanceof String) {
            return CompareUtil.compareCaseInsensitiveString(thisValue, otherValue, orderType);
        }
        int t = thisValue.compareTo(otherValue);
        return OrderType.ASC == orderType ? t : -t;
    }

    private static Integer compareNumber(String thisValue, String otherValue, String type) {
        boolean oneIsZero = false;
        if (StringUtils.isBlank(thisValue)) {
            thisValue = "0";
            oneIsZero = true;
        }
        if (StringUtils.isBlank(otherValue)) {
            if (oneIsZero) {
                return 0;
            }
            otherValue = "0";
        }
        Integer number = null;
        if ("Integer".equalsIgnoreCase(type) || "int".equalsIgnoreCase(type) || "Short".equalsIgnoreCase(type) || "Byte".equalsIgnoreCase(type)) {
            number = Integer.compare(Integer.parseInt(thisValue), Integer.parseInt(otherValue));
        } else if ("Long".equalsIgnoreCase(type)) {
            number = Long.compare(Long.parseLong(thisValue), Long.parseLong(otherValue));
        } else if ("Double".equalsIgnoreCase(type)) {
            number = Double.compare(Double.parseDouble(thisValue), Double.parseDouble(otherValue));
        } else if ("Float".equalsIgnoreCase(type)) {
            number = Float.compare(Float.parseFloat(thisValue), Float.parseFloat(otherValue));
        }
        return number;
    }

    private static int compareCaseInsensitiveString(String thisValue, String otherValue, OrderType orderDirection) {
        int n = thisValue.toLowerCase().compareTo(otherValue.toLowerCase());
        return OrderType.ASC == orderDirection ? n : -n;
    }
}

