/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.util.ObjectCreatorFactory;
import org.teasoft.honey.util.ObjectUtils;
import org.teasoft.honey.util.StringUtils;

public final class SuidHelper {
    private SuidHelper() {
    }

    public static String parseFirstColumn(List<String[]> list) {
        if (list == null) {
            return "";
        }
        String str = "";
        for (int i = 0; i < list.size(); ++i) {
            str = str + list.get(i)[0];
            if (i == list.size() - 1) continue;
            str = str + ",";
        }
        return str;
    }

    public static <T> List<T> parseToEntity(List<String[]> list, int startRow, String fieldNames, T entity) {
        if (StringUtils.isBlank(fieldNames)) {
            return Collections.emptyList();
        }
        String[] fieldName = fieldNames.split(",");
        return SuidHelper.parseToEntity(list, startRow, fieldName, entity);
    }

    public static <T> List<T> parseToEntity(List<String[]> list, int startRow, int endRow, String fieldNames, T entity) {
        if (StringUtils.isBlank(fieldNames)) {
            return Collections.emptyList();
        }
        String[] fieldName = fieldNames.split(",");
        return SuidHelper.parseToEntity(list, startRow, endRow, fieldName, entity);
    }

    public static <T> List<T> parseToEntity(List<String[]> list, int startRow, String[] fieldName, T entity) {
        if (ObjectUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return SuidHelper.parseToEntity(list, startRow, list.size() - 1, fieldName, entity);
    }

    public static <T> List<T> parseToEntity(List<String[]> list, int startRow, int endRow, String[] fieldName, T entity) {
        Object targetObj = null;
        ArrayList<Object> rsList = null;
        Field field = null;
        String[] col = null;
        if (ObjectUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        rsList = new ArrayList<Object>();
        if (startRow < 0) {
            startRow = 0;
        }
        if (endRow > list.size() - 1) {
            endRow = list.size() - 1;
        }
        try {
            for (int i = startRow; i <= endRow; ++i) {
                col = list.get(i);
                if (col == null || col.length == 1 && fieldName.length != 1) continue;
                targetObj = entity.getClass().newInstance();
                for (int j = 0; j < fieldName.length; ++j) {
                    if (StringUtils.isBlank(fieldName[j])) continue;
                    try {
                        field = entity.getClass().getDeclaredField(fieldName[j]);
                    }
                    catch (NoSuchFieldException e) {
                        if (i != startRow) continue;
                        Logger.warn("Can not find the field name : " + fieldName[j]);
                        continue;
                    }
                    field.setAccessible(true);
                    try {
                        field.set(targetObj, ObjectCreatorFactory.create(col[j], field.getType()));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        Logger.error(e.getMessage());
                    }
                }
                rsList.add(targetObj);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        catch (InstantiationException e) {
            throw ExceptionHelper.convert(e);
        }
        finally {
            entity = null;
            targetObj = null;
        }
        return rsList;
    }

    public static <T> T copyEntity(Object from, T to) {
        if (from == null || to == null) {
            return to;
        }
        Field field = null;
        Field[] fields = to.getClass().getDeclaredFields();
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            int modifiers = fields[i].getModifiers();
            if (modifiers == 8 || modifiers == 16 || modifiers == 24 || modifiers == 26) continue;
            fields[i].setAccessible(true);
            try {
                field = from.getClass().getDeclaredField(fields[i].getName());
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            try {
                field.setAccessible(true);
                fields[i].set(to, field.get(from));
                continue;
            }
            catch (IllegalAccessException e) {
                throw ExceptionHelper.convert(e);
            }
        }
        return to;
    }

    public static <T> Map<String, Object> entityToMap(T entity) {
        if (entity == null) {
            return null;
        }
        LinkedHashMap<String, Object> map = null;
        Object v = null;
        Field[] fields = entity.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (i == 0) {
                map = new LinkedHashMap<String, Object>();
            }
            fields[i].setAccessible(true);
            try {
                v = fields[i].get(entity);
                if (v == null || HoneyUtil.isSkipField(fields[i])) continue;
                map.put(fields[i].getName(), v);
                continue;
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), e);
            }
        }
        return map;
    }

    public static <T> List<T> copyListEntity(List<?> fromList, Class<T> toClassType) {
        ArrayList<T> toList = null;
        if (fromList != null && fromList.size() > 0) {
            int size0 = fromList.size();
            toList = new ArrayList<T>(size0);
            try {
                for (int i = 0; i < size0; ++i) {
                    T t = toClassType.newInstance();
                    t = SuidHelper.copyEntity(fromList.get(i), t);
                    toList.add(t);
                }
            }
            catch (Exception e) {
                Logger.warn(e.getMessage(), e);
            }
        }
        return toList;
    }
}

