/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.autogen;

import org.teasoft.bee.osql.api.PreparedSql;
import org.teasoft.bee.osql.api.SuidRich;
import org.teasoft.honey.osql.autogen.DdlToSql;
import org.teasoft.honey.osql.core.BeeFactoryHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;

public class Ddl {
    private Ddl() {
    }

    public static <T> boolean createTable(Class<T> entityClass) {
        return Ddl.createTable(entityClass, false);
    }

    public static <T> boolean createTable(Class<T> entityClass, boolean isDropExistTable) {
        SuidRich suidRich = BeeFactoryHelper.getSuidRich();
        return suidRich.createTable(entityClass, isDropExistTable);
    }

    public static <T> boolean createTable(T entity) {
        return Ddl.createTable(entity, false);
    }

    public static <T> boolean createTable(T entity, boolean isDropExistTable) {
        if (isDropExistTable) {
            String tableName;
            block8: {
                PreparedSql preparedSql = BeeFactoryHelper.getPreparedSql();
                tableName = Ddl._toTableName(entity);
                boolean second = false;
                try {
                    String sql0 = "";
                    if (HoneyUtil.isOracle() || HoneyUtil.isSqlServer()) {
                        sql0 = "DROP TABLE " + tableName;
                    } else {
                        sql0 = " DROP TABLE IF EXISTS " + tableName;
                        second = true;
                    }
                    preparedSql.modify(sql0);
                }
                catch (Exception e) {
                    if (!second) break block8;
                    try {
                        preparedSql.modify("DROP TABLE " + tableName);
                    }
                    catch (Exception e2) {
                        Logger.warn(e2.getMessage());
                    }
                }
            }
            return Ddl._createTable(entity, tableName);
        }
        if (Ddl.isExistTable(entity)) {
            return true;
        }
        return Ddl._createTable(entity, null);
    }

    public static <T> boolean isExistTable(T entity) {
        boolean flag = false;
        try {
            SuidRich suidRich = BeeFactoryHelper.getSuidRich();
            suidRich.select(entity, 1);
            flag = true;
            String tableName = Ddl._toTableName(entity);
            Logger.warn("The database exist the table : " + tableName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    private static <T> boolean _createTable(T entity, String tableName) {
        boolean result = false;
        try {
            Ddl.ddlModify(DdlToSql.toCreateTableSQL(entity.getClass(), tableName));
            result = true;
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), e);
            result = false;
        }
        return result;
    }

    private static void ddlModify(String sql) {
        boolean old = HoneyConfig.getHoneyConfig().showSql_showExecutableSql;
        if (old) {
            HoneyConfig.getHoneyConfig().showSql_showExecutableSql = false;
        }
        PreparedSql preparedSql = BeeFactoryHelper.getPreparedSql();
        preparedSql.modify(sql);
        if (old) {
            HoneyConfig.getHoneyConfig().showSql_showExecutableSql = old;
        }
    }

    public static void setDynamicParameter(String para, String value) {
        BeeFactoryHelper.getSuid().setDynamicParameter(para, value);
    }

    private static String _toTableName(Object entity) {
        return HoneyUtil.toTableName(entity);
    }

    public static <T> void indexNormal(Class<T> entityClass, String fields) {
        Ddl.indexNormal(entityClass, fields, null);
    }

    public static <T> void indexNormal(Class<T> entityClass, String fields, String indexName) {
        SuidRich suidRich = BeeFactoryHelper.getSuidRich();
        suidRich.indexNormal(entityClass, fields, indexName);
    }

    public static <T> void unique(Class<T> entityClass, String fields) {
        Ddl.unique(entityClass, fields, null);
    }

    public static <T> void unique(Class<T> entityClass, String fields, String indexName) {
        SuidRich suidRich = BeeFactoryHelper.getSuidRich();
        suidRich.unique(entityClass, fields, indexName);
    }

    public static <T> void primaryKey(Class<T> entityClass, String fields) {
        Ddl.primaryKey(entityClass, fields, null);
    }

    public static <T> void primaryKey(Class<T> entityClass, String fields, String keyName) {
        SuidRich suidRich = BeeFactoryHelper.getSuidRich();
        suidRich.primaryKey(entityClass, fields, keyName);
    }

    public static <T> void dropIndex(Class<T> entityClass, String indexName) {
        SuidRich suidRich = BeeFactoryHelper.getSuidRich();
        suidRich.dropIndex(entityClass, indexName);
    }
}

