/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.util.HashMap;
import org.teasoft.bee.osql.annotation.ColumnHandler;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.util.AnnoUtil;
import org.teasoft.honey.osql.util.NameCheckUtil;
import org.teasoft.honey.util.ObjectUtils;

public class DefaultColumnHandler
implements ColumnHandler {
    private final String field2Column = "_SYS_Bee_Field2Column";

    public String toColumnName(String fieldName, Class entityClass) {
        String s1 = this.toColumnName0(fieldName, entityClass);
        if (s1 == null && DefaultColumnHandler.isOpenEntityCanExtend()) {
            Class superClass = null;
            Class currentClass = entityClass;
            while (HoneyUtil.isSuperEntity(superClass = currentClass.getSuperclass())) {
                s1 = this.toColumnName0(fieldName, superClass);
                currentClass = superClass;
                if (s1 == null) continue;
            }
        }
        return s1;
    }

    private String toColumnName0(String fieldName, Class entityClass) {
        if (HoneyUtil.isJavaPackage(entityClass)) {
            Logger.debug("\u4f20\u5165\u7684\u7c7b\u662fjava\u5e93\u7684");
            return null;
        }
        if (entityClass != null) {
            String defineColumn;
            String entityFullName = entityClass.getName();
            Boolean flag = HoneyContext.getCustomFlagMap("_SYS_Bee_Field2Column" + entityFullName);
            if (flag == null) {
                this.initDefineColumn(entityClass);
                flag = HoneyContext.getCustomFlagMap("_SYS_Bee_Field2Column" + entityFullName);
            }
            if (ObjectUtils.isTrue(flag) && (defineColumn = HoneyContext.getCustomMapValue("_SYS_Bee_Field2Column" + entityFullName, fieldName)) != null) {
                return defineColumn;
            }
        }
        return null;
    }

    public String toFieldName(String columnName, Class entityClass) {
        String s1 = this.toFieldName0(columnName, entityClass);
        if (s1 == null && DefaultColumnHandler.isOpenEntityCanExtend()) {
            Class superClass = null;
            Class currentClass = entityClass;
            while (HoneyUtil.isSuperEntity(superClass = currentClass.getSuperclass())) {
                s1 = this.toFieldName0(columnName, superClass);
                currentClass = superClass;
                if (s1 == null) continue;
            }
        }
        return s1;
    }

    private String toFieldName0(String columnName, Class entityClass) {
        if (HoneyUtil.isJavaPackage(entityClass)) {
            Logger.debug("\u4f20\u5165\u7684\u7c7b\u662fjava\u5e93\u7684");
            return null;
        }
        if (entityClass != null) {
            String fieldName;
            String entityFullName = entityClass.getName();
            Boolean flag = HoneyContext.getCustomFlagMap("_SYS_Bee_Field2Column" + entityFullName);
            if (ObjectUtils.isTrue(flag) && (fieldName = HoneyContext.getCustomMapValue("_SYS_Bee_Column2Field:" + entityFullName, columnName)) != null) {
                return fieldName;
            }
        }
        return null;
    }

    private void initDefineColumn(Class entityClass) {
        try {
            if (entityClass == null) {
                return;
            }
            if (HoneyUtil.isJavaPackage(entityClass)) {
                Logger.debug("\u4f20\u5165\u7684\u7c7b\u662fjava\u5e93\u7684");
                return;
            }
            Field[] fields = HoneyUtil.getFields(entityClass);
            String entityFullName = entityClass.getName();
            String defineColumn = "";
            String fiName = "";
            int len = fields.length;
            HashMap<String, String> kv = new HashMap<String, String>();
            HashMap<String, String> column2Field = new HashMap<String, String>();
            boolean has = false;
            for (int i = 0; i < len; ++i) {
                if (HoneyUtil.isSkipField(fields[i])) continue;
                HoneyUtil.setAccessibleTrue(fields[i]);
                if (!AnnoUtil.isColumn(fields[i])) continue;
                defineColumn = AnnoUtil.getValue(fields[i]);
                if (NameCheckUtil.isIllegal(defineColumn)) {
                    throw new BeeIllegalParameterException("Annotation Column set wrong value:" + defineColumn);
                }
                fiName = fields[i].getName();
                kv.put(fiName, defineColumn);
                column2Field.put(defineColumn, fiName);
                has = true;
            }
            if (has) {
                HoneyContext.addCustomMap("_SYS_Bee_Field2Column" + entityFullName, kv);
                HoneyContext.addCustomMap("_SYS_Bee_Column2Field:" + entityFullName, column2Field);
                HoneyContext.addCustomFlagMap("_SYS_Bee_Field2Column" + entityFullName, Boolean.TRUE);
            } else {
                HoneyContext.addCustomFlagMap("_SYS_Bee_Field2Column" + entityFullName, Boolean.FALSE);
            }
        }
        catch (Exception e) {
            Logger.debug(e.getMessage(), e);
        }
    }

    private static boolean isOpenEntityCanExtend() {
        return HoneyConfig.getHoneyConfig().openEntityCanExtend;
    }
}

