/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teasoft.bee.osql.BeeException;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.annotation.GenId;
import org.teasoft.bee.osql.annotation.GenUUID;
import org.teasoft.bee.osql.annotation.JoinTable;
import org.teasoft.bee.osql.annotation.JoinType;
import org.teasoft.bee.osql.annotation.JustFetch;
import org.teasoft.bee.osql.annotation.customizable.Json;
import org.teasoft.bee.osql.exception.BeeErrorFieldException;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.bee.osql.exception.BeeIllegalEntityException;
import org.teasoft.bee.osql.exception.BeeIllegalSQLException;
import org.teasoft.bee.osql.exception.JoinTableException;
import org.teasoft.bee.osql.exception.JoinTableParameterException;
import org.teasoft.bee.osql.interccept.InterceptorChain;
import org.teasoft.bee.osql.type.SetParaTypeConvert;
import org.teasoft.bee.spi.SqlFormat;
import org.teasoft.honey.distribution.GenIdFactory;
import org.teasoft.honey.distribution.UUID;
import org.teasoft.honey.osql.core.Check;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.JdbcToJavaType;
import org.teasoft.honey.osql.core.JdkSerializer;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MoreTableStruct;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core._ObjectToSQLHelper;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.osql.type.CharTypeHandler;
import org.teasoft.honey.osql.type.SetParaTypeConverterRegistry;
import org.teasoft.honey.osql.type.SqlDotDateTypeHandler;
import org.teasoft.honey.osql.type.TimestampTypeHandler;
import org.teasoft.honey.osql.type.TypeHandlerRegistry;
import org.teasoft.honey.osql.type.UtilDotDateTypeHandler;
import org.teasoft.honey.osql.type.UtilDotDateTypeToTimestampConvert;
import org.teasoft.honey.osql.util.AnnoUtil;
import org.teasoft.honey.osql.util.NameCheckUtil;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.spi.SpiInstanceRegister;
import org.teasoft.honey.util.ObjectUtils;
import org.teasoft.honey.util.StringUtils;

public final class HoneyUtil {
    private static Map<String, Integer> javaTypeMap = new HashMap<String, Integer>();
    private static String SET_WRONG_VALUE_IN;
    private static final String[] NumberArrayTypes;
    private static char[] ch;
    private static final String START_MARK = "[$#(";
    private static final String END_MARK = ")#$]";
    private static int index;
    private static int MAX;

    static void refreshSetParaAndResultTypeHandlerRegistry() {
        HoneyUtil.initSetParaAndResultTypeHandlerRegistry();
    }

    private HoneyUtil() {
    }

    private static void initSetParaAndResultTypeHandlerRegistry() {
        boolean closeDefaultParaResultRegistry = HoneyConfig.getHoneyConfig().closeDefaultParaResultRegistry;
        if (closeDefaultParaResultRegistry) {
            return;
        }
        SetParaTypeConverterRegistry.register(java.util.Date.class, new UtilDotDateTypeToTimestampConvert(), "PostgreSQL");
        SetParaTypeConverterRegistry.register(java.util.Date.class, new UtilDotDateTypeToTimestampConvert(), "H2");
        SetParaTypeConverterRegistry.register(java.util.Date.class, new UtilDotDateTypeToTimestampConvert(), "Microsoft SQL Server");
        SetParaTypeConverterRegistry.register(java.util.Date.class, new UtilDotDateTypeToTimestampConvert(), "Oracle");
        TypeHandlerRegistry.register(Character.TYPE, new CharTypeHandler(), true);
        if (!HoneyConfig.getHoneyConfig().multiDS_enable || HoneyContext.getDsName2DbName() != null && HoneyContext.getDsName2DbName().containsValue("SQLite")) {
            TypeHandlerRegistry.register(Timestamp.class, new TimestampTypeHandler(), "SQLite", true);
            TypeHandlerRegistry.register(java.util.Date.class, new UtilDotDateTypeHandler(), "SQLite", true);
            TypeHandlerRegistry.register(Date.class, new SqlDotDateTypeHandler(), "SQLite", true);
        }
    }

    static String getBeanField(Field[] field, Class entityClass) {
        if (field == null) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        int len = field.length;
        boolean isFirst = true;
        for (int i = 0; i < len; ++i) {
            if (HoneyUtil.isSkipField(field[i])) continue;
            if (field[i].isAnnotationPresent(JustFetch.class)) {
                if (StringUtils.isBlank(HoneyUtil.getJustFetchDefineName(field[i]))) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    s.append(",");
                }
                s.append(HoneyUtil.getJustFetchColumn(field[i]));
                continue;
            }
            if (isFirst) {
                isFirst = false;
            } else {
                s.append(",");
            }
            s.append(NameTranslateHandle.toColumnName(field[i].getName(), entityClass));
        }
        return s.toString();
    }

    private static String getJustFetchColumn(Field field) {
        String expression = HoneyUtil.getJustFetchDefineName(field);
        String c = "";
        String fName = NameTranslateHandle.toColumnName(field.getName());
        c = HoneyUtil.isSQLite() ? expression + " " + K.as + " " + fName : expression + " " + fName;
        return c;
    }

    private static String getJustFetchDefineName(Field field) {
        JustFetch justFetch = field.getAnnotation(JustFetch.class);
        String expression = justFetch.value();
        HoneyUtil.checkExpression(expression);
        return expression;
    }

    private static void checkExpression(String expression) {
        if (Check.isNotValidExpressionForJustFetch(expression)) {
            throw new BeeIllegalSQLException("The expression: '" + expression + "' is invalid in JustFetch Annotation!");
        }
    }

    static <T> MoreTableStruct[] getMoreTableStructAndCheckBefore(T entity) {
        if (entity == null) {
            return null;
        }
        String packageAndClassName = entity.getClass().getName();
        String key = "ForMoreTable:" + packageAndClassName;
        MoreTableStruct[] moreTableStruct = null;
        if (OneTimeParameter.isTrue("_SYS_Bee_MoreStruct_to_SqlLib")) {
            moreTableStruct = HoneyUtil._getMoreTableStructAndCheckBefore(entity);
            OneTimeParameter.setAttribute(key, moreTableStruct);
            if (moreTableStruct[1] == null) {
                throw new BeeErrorGrammarException("MoreTable select on " + entity.getClass().getName() + " must own at least one JoinTable annotation!");
            }
        } else {
            moreTableStruct = (MoreTableStruct[])OneTimeParameter.getAttribute(key);
        }
        return moreTableStruct;
    }

    private static <T> MoreTableStruct[] _getMoreTableStructAndCheckBefore(T entity) {
        String useSubTableName;
        String t_subAlias;
        if (entity == null) {
            return null;
        }
        String entityFullName = entity.getClass().getName();
        Field[] field = HoneyUtil.getFields(entity.getClass());
        MoreTableStruct[] moreTableStruct = new MoreTableStruct[3];
        moreTableStruct[0] = new MoreTableStruct();
        Field[] subField = new Field[2];
        int subEntityFieldNum = 0;
        HashSet<String> mainFieldSet = new HashSet<String>();
        HashMap<String, String> dulMap = new HashMap<String, String>();
        String tableName = (String)OneTimeParameter.getAttribute("_SYS_Bee_TableName");
        if (tableName == null) {
            tableName = HoneyUtil._toTableName(entity);
        }
        StringBuffer columns = new StringBuffer();
        List listOne = null;
        List listTwo = null;
        Class<?> list_T_classOne = null;
        Class<?> list_T_classTwo = null;
        boolean subOneIsList = false;
        boolean subTwoIsList = false;
        int len = field.length;
        boolean isFirst = true;
        String mailField = "";
        for (int i = 0; i < len; ++i) {
            if (HoneyUtil.isSkipFieldForMoreTable(field[i])) continue;
            if (field[i] != null && field[i].isAnnotationPresent(JoinTable.class)) {
                if (++subEntityFieldNum == 1) {
                    subField[0] = field[i];
                }
                if (subEntityFieldNum == 2) {
                    subField[1] = field[i];
                }
                if (!List.class.isAssignableFrom(field[i].getType())) continue;
                try {
                    List list;
                    HoneyUtil.setAccessibleTrue(field[i]);
                    if (subEntityFieldNum == 1) {
                        subOneIsList = true;
                        moreTableStruct[0].subOneIsList = true;
                        listOne = list = (List)field[i].get(entity);
                        if (!ObjectUtils.isNotEmpty(list)) continue;
                        list_T_classOne = list.get(0).getClass();
                        continue;
                    }
                    if (subEntityFieldNum != 2) continue;
                    subTwoIsList = true;
                    moreTableStruct[0].subTwoIsList = true;
                    listTwo = list = (List)field[i].get(entity);
                    if (!ObjectUtils.isNotEmpty(list)) continue;
                    list_T_classTwo = list.get(0).getClass();
                }
                catch (IllegalAccessException e) {
                    Logger.warn(e.getMessage());
                }
                continue;
            }
            if (isFirst) {
                isFirst = false;
            } else {
                columns.append(",");
            }
            columns.append(tableName);
            columns.append(".");
            mailField = NameTranslateHandle.toColumnName(field[i].getName(), entity.getClass());
            columns.append(mailField);
            mainFieldSet.add(mailField);
        }
        if (subEntityFieldNum > 2) {
            throw new JoinTableException("One entity only supports two JoinTable at most! " + entityFullName + " has " + subEntityFieldNum + " JoinTable now !");
        }
        JoinTable[] joinTable = new JoinTable[2];
        String[] subTableName = new String[2];
        if (subField[0] != null) {
            joinTable[0] = subField[0].getAnnotation(JoinTable.class);
            String errorMsg = HoneyUtil.checkJoinTable(joinTable[0]);
            if (!"".equals(errorMsg)) {
                throw new JoinTableParameterException("Error: mainField and subField can not just use only one." + errorMsg);
            }
            if (subOneIsList && joinTable[0].joinType() == JoinType.RIGHT_JOIN) {
                throw new JoinTableException("The List type subTable donot support JoinType.RIGHT_JOIN, you can adjust with JoinType.LEFT_JOIN.");
            }
            if (subOneIsList && list_T_classOne == null) {
                Class c = joinTable[0].subClazz();
                if (!c.equals(Object.class)) {
                    list_T_classOne = c;
                } else {
                    String subClassStr = joinTable[0].subClass();
                    list_T_classOne = HoneyUtil.createClass(subClassStr, entityFullName);
                }
            }
        }
        boolean oneHasOne = false;
        StringBuffer[] subColumnStringBuffer = new StringBuffer[2];
        if (subEntityFieldNum == 1 && !subOneIsList) {
            t_subAlias = joinTable[0].subAlias();
            if (StringUtils.isNotBlank(t_subAlias)) {
                useSubTableName = t_subAlias;
            } else {
                subTableName[0] = HoneyUtil._toTableNameByEntityName(subField[0].getType().getName());
                useSubTableName = subTableName[0];
            }
            boolean checkOneHasOne = !entity.getClass().equals(subField[0].getType());
            subColumnStringBuffer[0] = HoneyUtil._getBeanFullField_0(subField[0].getType(), useSubTableName, entityFullName, mainFieldSet, dulMap, checkOneHasOne);
        } else if (subEntityFieldNum == 1 && subOneIsList) {
            t_subAlias = joinTable[0].subAlias();
            if (StringUtils.isNotBlank(t_subAlias)) {
                useSubTableName = t_subAlias;
            } else {
                subTableName[0] = HoneyUtil._toTableNameByEntityName(list_T_classOne.getName());
                useSubTableName = subTableName[0];
            }
            subColumnStringBuffer[0] = HoneyUtil._getBeanFullField_0(list_T_classOne, useSubTableName, entityFullName, mainFieldSet, dulMap, true);
        }
        if (subEntityFieldNum == 1) {
            subField[1] = (Field)OneTimeParameter.getAttribute("_SYS_Bee_subEntityFirstAnnotationField");
            if (subField[1] != null) {
                subEntityFieldNum = 2;
                oneHasOne = true;
                moreTableStruct[0].oneHasOne = true;
            }
        }
        if (subField[1] != null) {
            String errorMsg;
            joinTable[1] = subField[1].getAnnotation(JoinTable.class);
            if (oneHasOne && List.class.isAssignableFrom(subField[1].getType())) {
                subTwoIsList = true;
            }
            if (!"".equals(errorMsg = HoneyUtil.checkJoinTable(joinTable[1]))) {
                throw new JoinTableParameterException("Annotation JoinTable, error: mainField and subField can not just use only one." + errorMsg);
            }
            if (subTwoIsList && joinTable[1].joinType() == JoinType.RIGHT_JOIN) {
                throw new JoinTableException("The List type subTable donot support JoinType.RIGHT_JOIN, you can adjust with JoinType.LEFT_JOIN.");
            }
        }
        moreTableStruct[0].tableName = tableName;
        moreTableStruct[0].joinTableNum = subEntityFieldNum;
        for (int j = 0; j < 2; ++j) {
            String useSubTableName2;
            if (subField[j] == null) continue;
            if (j == 1) {
                if (oneHasOne && subTwoIsList) {
                    try {
                        HoneyUtil.setAccessibleTrue(subField[1]);
                        moreTableStruct[0].subTwoIsList = true;
                        List list = null;
                        if (moreTableStruct[1].subObject != null) {
                            list = (List)subField[1].get(moreTableStruct[1].subObject);
                        }
                        if (ObjectUtils.isNotEmpty(list)) {
                            listTwo = list;
                            list_T_classTwo = list.get(0).getClass();
                        }
                    }
                    catch (IllegalAccessException e) {
                        Logger.warn(e.getMessage());
                    }
                }
                if (subTwoIsList && list_T_classTwo == null) {
                    Class<?> c = joinTable[1].subClazz();
                    if (!c.equals(Object.class)) {
                        list_T_classTwo = c;
                    } else {
                        String subClassStr = joinTable[1].subClass();
                        list_T_classTwo = HoneyUtil.createClass(subClassStr, entityFullName);
                    }
                }
            }
            String mainColumn = HoneyUtil._toColumnName(joinTable[j].mainField());
            String subColumn = HoneyUtil._toColumnName(joinTable[j].subField());
            subTableName[j] = j == 0 && subOneIsList ? HoneyUtil._toTableNameByEntityName(list_T_classOne.getName()) : (j == 1 && subTwoIsList ? HoneyUtil._toTableNameByEntityName(list_T_classTwo.getName()) : HoneyUtil._toTableNameByEntityName(subField[j].getType().getName()));
            moreTableStruct[1 + j] = new MoreTableStruct();
            moreTableStruct[1 + j].subEntityField = subField[j];
            moreTableStruct[1 + j].tableName = subTableName[j];
            moreTableStruct[1 + j].mainField = joinTable[j].mainField();
            moreTableStruct[1 + j].subField = joinTable[j].subField();
            moreTableStruct[1 + j].joinType = joinTable[j].joinType();
            String t_subAlias2 = joinTable[j].subAlias();
            if (t_subAlias2 != null && !"".equals(t_subAlias2)) {
                moreTableStruct[1 + j].subAlias = t_subAlias2;
                useSubTableName2 = t_subAlias2;
                moreTableStruct[1 + j].hasSubAlias = true;
            } else {
                useSubTableName2 = subTableName[j];
            }
            if (!"".equals(mainColumn) && !"".equals(subColumn)) {
                String[] subColumnArray;
                String[] mainColumnArray = mainColumn.split(",");
                if (mainColumnArray.length != (subColumnArray = subColumn.split(",")).length) {
                    throw new JoinTableException("The number of field in mainField & subField is different , mainField is: " + mainColumnArray.length + " ,subField is : " + subColumnArray.length);
                }
                moreTableStruct[1 + j].joinExpression = "";
                String firstTableName = "";
                for (int i = 0; i < mainColumnArray.length; ++i) {
                    if (i != 0) {
                        moreTableStruct[1 + j].joinExpression = moreTableStruct[1 + j].joinExpression + K.space + K.and + K.space;
                    }
                    firstTableName = oneHasOne && j == 1 ? moreTableStruct[1].useSubTableName : tableName;
                    moreTableStruct[1 + j].joinExpression = moreTableStruct[1 + j].joinExpression + firstTableName + "." + mainColumnArray[i] + "=" + useSubTableName2 + "." + subColumnArray[i];
                }
            }
            moreTableStruct[1 + j].useSubTableName = useSubTableName2;
            try {
                HoneyUtil.setAccessibleTrue(subField[j]);
                if (j == 0 && subOneIsList) {
                    if (ObjectUtils.isNotEmpty(listOne)) {
                        moreTableStruct[1 + j].subObject = listOne.get(0);
                    }
                } else if (j == 1 && subTwoIsList) {
                    if (ObjectUtils.isNotEmpty(listTwo)) {
                        moreTableStruct[1 + j].subObject = listTwo.get(0);
                    }
                } else {
                    moreTableStruct[1 + j].subObject = j == 1 && oneHasOne ? (moreTableStruct[1].subObject == null ? null : subField[j].get(moreTableStruct[1].subObject)) : subField[j].get(entity);
                }
            }
            catch (IllegalAccessException e) {
                throw ExceptionHelper.convert(e);
            }
            if (subEntityFieldNum != 1) {
                if (j == 0 && subOneIsList && !oneHasOne) {
                    subColumnStringBuffer[0] = HoneyUtil._getBeanFullField_0(list_T_classOne, useSubTableName2, entityFullName, mainFieldSet, dulMap, true);
                } else if (j == 1 && subTwoIsList) {
                    subColumnStringBuffer[1] = HoneyUtil._getBeanFullField_0(list_T_classTwo, useSubTableName2, entityFullName, mainFieldSet, dulMap, true);
                } else if (!oneHasOne || j == 1) {
                    subColumnStringBuffer[j] = HoneyUtil._getBeanFullField_0(subField[j].getType(), useSubTableName2, entityFullName, mainFieldSet, dulMap);
                }
            }
            moreTableStruct[1 + j].columnsFull = subColumnStringBuffer[j].toString();
            columns.append(",");
            columns.append(subColumnStringBuffer[j]);
        }
        if (subOneIsList) {
            moreTableStruct[1].subClass = list_T_classOne;
        }
        if (subTwoIsList) {
            moreTableStruct[2].subClass = list_T_classTwo;
        }
        moreTableStruct[0].columnsFull = columns.toString();
        moreTableStruct[0].subDulFieldMap = dulMap;
        return moreTableStruct;
    }

    private static Class createClass(String subClassStr, String packageAndClassName) {
        Class<?> newClazz = null;
        boolean isOk = false;
        if (StringUtils.isNotBlank(subClassStr)) {
            try {
                newClazz = Class.forName(subClassStr);
                isOk = true;
            }
            catch (ClassNotFoundException e) {
                try {
                    int index1 = subClassStr.indexOf(46);
                    int index2 = packageAndClassName.lastIndexOf(46);
                    if (index1 == -1 && index2 > 0) {
                        String newStr = packageAndClassName.substring(0, index2 + 1) + subClassStr;
                        newClazz = Class.forName(newStr);
                        isOk = true;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (isOk) {
            return newClazz;
        }
        throw new BeeException("MoreTable select, if use List type subEntity field , the object must have element or config the subClass with JoinTable Annotation!");
    }

    static StringBuffer _getBeanFullField_0(Class entityClass, String tableName, String entityFullName, Set<String> mainFieldSet, Map<String, String> dulMap) {
        return HoneyUtil._getBeanFullField_0(entityClass, tableName, entityFullName, mainFieldSet, dulMap, false);
    }

    static StringBuffer _getBeanFullField_0(Class entityClass, String tableName, String entityFullName, Set<String> mainFieldSet, Map<String, String> dulMap, boolean checkOneHasOne) {
        int i;
        Field[] field = entityClass.getDeclaredFields();
        String entityFieldFullName = entityClass.getName();
        StringBuffer columns = new StringBuffer();
        int len = field.length;
        boolean isFirst = true;
        String subColumnName = "";
        int currentSubNum = 0;
        Field subEntityFirstAnnotationField = null;
        ArrayList<String> WarnMsglist = new ArrayList<String>();
        for (i = 0; i < len; ++i) {
            if (HoneyUtil.isSkipFieldForMoreTable(field[i])) continue;
            if (field[i] != null && field[i].isAnnotationPresent(JoinTable.class)) {
                if (checkOneHasOne && ++currentSubNum == 1) {
                    subEntityFirstAnnotationField = field[i];
                }
                if (checkOneHasOne) {
                    WarnMsglist.add("Annotation JoinTable field: " + entityFieldFullName + "(in " + entityFullName + ") still include JoinTable field:" + field[i].getName() + "(will be ignored)!");
                    continue;
                }
                if (entityClass.equals(field[i].getType())) continue;
                Logger.warn("Annotation JoinTable field: " + entityFieldFullName + "(in " + entityFullName + ") still include JoinTable field:" + field[i].getName() + "(will be ignored)!");
                continue;
            }
            if (isFirst) {
                isFirst = false;
            } else {
                columns.append(",");
            }
            subColumnName = NameTranslateHandle.toColumnName(field[i].getName(), entityClass);
            if (field[i].isAnnotationPresent(JustFetch.class)) {
                columns.append(HoneyUtil.getJustFetchDefineName(field[i]));
            } else {
                columns.append(tableName);
                columns.append(".");
                columns.append(subColumnName);
            }
            if (mainFieldSet.add(subColumnName) || !HoneyUtil.isConfuseDuplicateFieldDB()) continue;
            if (HoneyUtil.isSQLite()) {
                dulMap.put(tableName + "." + subColumnName, tableName + "." + subColumnName);
            } else {
                dulMap.put(tableName + "." + subColumnName, tableName + "_" + subColumnName + "_$");
            }
            if (HoneyUtil.isSQLite()) {
                columns.append(" " + K.as + " '" + tableName + "." + subColumnName + "'");
                continue;
            }
            columns.append(" " + tableName + "_" + subColumnName + "_$");
        }
        if (checkOneHasOne && currentSubNum > 1) {
            subEntityFirstAnnotationField = null;
            for (i = 0; i < currentSubNum; ++i) {
                Logger.warn((String)WarnMsglist.get(i));
            }
        }
        if (checkOneHasOne && currentSubNum > 2) {
            throw new JoinTableException("One entity only supports two JoinTable at most! " + entityFieldFullName + " has " + currentSubNum + " JoinTable now !");
        }
        OneTimeParameter.setAttribute("_SYS_Bee_subEntityFirstAnnotationField", subEntityFirstAnnotationField);
        return columns;
    }

    public static String getFieldType(String jdbcType) {
        String dbName = HoneyConfig.getHoneyConfig().getDbName();
        Map<String, String> jdbc2JavaTypeMap = JdbcToJavaType.getJdbcToJavaType(dbName);
        String javaType = jdbc2JavaTypeMap.get(jdbcType);
        if (javaType != null) {
            return javaType;
        }
        if (null == jdbc2JavaTypeMap.get(jdbcType)) {
            int i;
            String tempType = jdbcType.trim();
            if (tempType.endsWith(" UNSIGNED") && (javaType = jdbc2JavaTypeMap.get(tempType.substring(0, i = tempType.indexOf(" ")))) != null) {
                return javaType;
            }
            if (javaType == null) {
                javaType = jdbc2JavaTypeMap.get(jdbcType.toLowerCase());
                if (javaType != null) {
                    return javaType;
                }
                if (javaType == null && (javaType = jdbc2JavaTypeMap.get(jdbcType.toUpperCase())) != null) {
                    return javaType;
                }
            }
            javaType = HoneyUtil.isMongoDB() ? NameTranslateHandle.toEntityName(jdbcType) : "[UNKNOWN TYPE]" + jdbcType;
            Logger.debug(javaType);
        }
        return javaType;
    }

    private static void initJavaTypeMap() {
        javaTypeMap.put("java.lang.String", 1);
        javaTypeMap.put("java.lang.Integer", 2);
        javaTypeMap.put("java.lang.Long", 3);
        javaTypeMap.put("java.lang.Double", 4);
        javaTypeMap.put("java.lang.Float", 5);
        javaTypeMap.put("java.lang.Short", 6);
        javaTypeMap.put("java.lang.Byte", 7);
        javaTypeMap.put("[B", 8);
        javaTypeMap.put("java.lang.Boolean", 9);
        javaTypeMap.put("int", 2);
        javaTypeMap.put("long", 3);
        javaTypeMap.put("double", 4);
        javaTypeMap.put("float", 5);
        javaTypeMap.put("short", 6);
        javaTypeMap.put("byte", 7);
        javaTypeMap.put("boolean", 9);
        javaTypeMap.put("java.math.BigDecimal", 10);
        javaTypeMap.put("java.sql.Date", 11);
        javaTypeMap.put("java.sql.Time", 12);
        javaTypeMap.put("java.sql.Timestamp", 13);
        javaTypeMap.put("java.sql.Blob", 14);
        javaTypeMap.put("java.sql.Clob", 15);
        javaTypeMap.put("java.sql.NClob", 16);
        javaTypeMap.put("java.sql.RowId", 17);
        javaTypeMap.put("java.sql.SQLXML", 18);
        javaTypeMap.put("java.math.BigInteger", 19);
        javaTypeMap.put("char", 20);
        javaTypeMap.put("java.util.Date", 21);
        javaTypeMap.put("java.sql.Array", 22);
        javaTypeMap.put("java.io.InputStream", 23);
        javaTypeMap.put("java.io.Reader", 24);
        javaTypeMap.put("java.sql.Ref", 25);
        javaTypeMap.put("java.net.URL", 27);
    }

    public static int getJavaTypeIndex(String javaType) {
        return javaTypeMap.get(javaType) == null ? -1 : javaTypeMap.get(javaType);
    }

    public static String firstLetterToUpperCase(String str) {
        return NameUtil.firstLetterToUpperCase(str);
    }

    public static boolean isContinue(int includeType, Object object, Field field) {
        if (field != null) {
            if (HoneyUtil.isSkipField(field)) {
                return true;
            }
            if (HoneyUtil.isSkipFieldJustFetch(field)) {
                return true;
            }
        }
        if (-3 == includeType && StringUtils.isBlank((String)object)) {
            return true;
        }
        return (includeType == -1 || includeType == 1) && object == null || (includeType == -1 || includeType == 0) && "".equals(object);
    }

    public static boolean isSkipField(Field field) {
        if (field != null) {
            if ("serialVersionUID".equals(field.getName())) {
                return true;
            }
            if (AnnoUtil.isIgnore(field)) {
                return true;
            }
            if (field.isAnnotationPresent(JoinTable.class)) {
                return true;
            }
            if (field.isSynthetic()) {
                return true;
            }
            if (AnnoUtil.isFK(field)) {
                return true;
            }
            if (AnnoUtil.isGridFs(field)) {
                return true;
            }
            if (AnnoUtil.isGridFsMetadata(field)) {
                return true;
            }
        }
        return false;
    }

    static boolean isSkipFieldForMoreTable(Field field) {
        if (field != null) {
            if ("serialVersionUID".equals(field.getName())) {
                return true;
            }
            if (AnnoUtil.isIgnore(field)) {
                return true;
            }
            if (field.isSynthetic()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSkipFieldJustFetch(Field field) {
        return field != null && field.isAnnotationPresent(JustFetch.class);
    }

    static void setPreparedValues(PreparedStatement pst, int objTypeIndex, int i, Object value) throws SQLException {
        if (null == value) {
            HoneyUtil.setPreparedNull(pst, objTypeIndex, i);
            return;
        }
        switch (objTypeIndex) {
            case 1: {
                pst.setString(i + 1, (String)value);
                break;
            }
            case 2: {
                pst.setInt(i + 1, (Integer)value);
                break;
            }
            case 3: {
                pst.setLong(i + 1, (Long)value);
                break;
            }
            case 4: {
                pst.setDouble(i + 1, (Double)value);
                break;
            }
            case 5: {
                pst.setFloat(i + 1, ((Float)value).floatValue());
                break;
            }
            case 6: {
                pst.setShort(i + 1, (Short)value);
                break;
            }
            case 7: {
                pst.setByte(i + 1, (Byte)value);
                break;
            }
            case 8: {
                pst.setBytes(i + 1, (byte[])value);
                break;
            }
            case 9: {
                pst.setBoolean(i + 1, (Boolean)value);
                break;
            }
            case 10: {
                pst.setBigDecimal(i + 1, (BigDecimal)value);
                break;
            }
            case 12: {
                pst.setTime(i + 1, (Time)value);
                break;
            }
            case 13: {
                pst.setTimestamp(i + 1, (Timestamp)value);
                break;
            }
            case 17: {
                pst.setRowId(i + 1, (RowId)value);
                break;
            }
            case 18: {
                pst.setSQLXML(i + 1, (SQLXML)value);
                break;
            }
            case 20: {
                pst.setString(i + 1, value.toString());
                break;
            }
            case 22: {
                pst.setArray(i + 1, (Array)value);
                break;
            }
            case 25: {
                pst.setRef(i + 1, (Ref)value);
                break;
            }
            case 26: {
                SetParaTypeConvert<Json> converter = SetParaTypeConverterRegistry.getConverter(Json.class);
                if (converter != null) {
                    pst.setString(i + 1, (String)converter.convert(value));
                    break;
                }
            }
            case 27: {
                pst.setURL(i + 1, (URL)value);
                break;
            }
            default: {
                SetParaTypeConvert<?> converter = SetParaTypeConverterRegistry.getConverter(value.getClass());
                if (converter != null) {
                    value = converter.convert(value);
                    pst.setObject(i + 1, value);
                    break;
                }
                if (objTypeIndex == 11) {
                    pst.setDate(i + 1, (Date)value);
                    break;
                }
                if (objTypeIndex == 14) {
                    pst.setBlob(i + 1, (Blob)value);
                    break;
                }
                if (objTypeIndex == 15) {
                    pst.setClob(i + 1, (Clob)value);
                    break;
                }
                if (objTypeIndex == 16) {
                    pst.setNClob(i + 1, (NClob)value);
                    break;
                }
                if (objTypeIndex == 23) {
                    pst.setBinaryStream(i + 1, (InputStream)value);
                    break;
                }
                if (objTypeIndex == 24) {
                    pst.setCharacterStream(i + 1, (Reader)value);
                    break;
                }
                pst.setObject(i + 1, value);
            }
        }
    }

    static Object getResultObject(ResultSet rs, String typeName, String columnName) throws SQLException {
        int k = HoneyUtil.getJavaTypeIndex(typeName);
        if (HoneyUtil.isSQLite() && "java.sql.Timestamp".equals(typeName)) {
            k = 1;
        }
        switch (k) {
            case 1: {
                return rs.getString(columnName);
            }
            case 2: {
                return rs.getInt(columnName);
            }
            case 3: {
                return rs.getLong(columnName);
            }
            case 4: {
                return rs.getDouble(columnName);
            }
            case 5: {
                return Float.valueOf(rs.getFloat(columnName));
            }
            case 6: {
                return rs.getShort(columnName);
            }
            case 7: {
                return rs.getByte(columnName);
            }
            case 8: {
                return rs.getBytes(columnName);
            }
            case 9: {
                return rs.getBoolean(columnName);
            }
            case 10: {
                return rs.getBigDecimal(columnName);
            }
            case 11: {
                return rs.getDate(columnName);
            }
            case 12: {
                return rs.getTime(columnName);
            }
            case 13: {
                return rs.getTimestamp(columnName);
            }
            case 14: {
                return rs.getBlob(columnName);
            }
            case 15: {
                return rs.getClob(columnName);
            }
            case 16: {
                return rs.getNClob(columnName);
            }
            case 17: {
                return rs.getRowId(columnName);
            }
            case 18: {
                return rs.getSQLXML(columnName);
            }
            case 21: {
                return rs.getTimestamp(columnName);
            }
            case 22: {
                return rs.getArray(columnName);
            }
            case 23: {
                return rs.getBinaryStream(columnName);
            }
            case 24: {
                return rs.getCharacterStream(columnName);
            }
            case 25: {
                return rs.getRef(columnName);
            }
            case 27: {
                return rs.getURL(columnName);
            }
        }
        return rs.getObject(columnName);
    }

    static Object getResultObjectByIndex(ResultSet rs, String typeName, int index) throws SQLException {
        int k = HoneyUtil.getJavaTypeIndex(typeName);
        if (HoneyUtil.isSQLite() && ("java.sql.Timestamp".equals(typeName) || "java.sql.Date".equals(typeName))) {
            k = 1;
        }
        switch (k) {
            case 1: {
                return rs.getString(index);
            }
            case 2: {
                return rs.getInt(index);
            }
            case 3: {
                return rs.getLong(index);
            }
            case 4: {
                return rs.getDouble(index);
            }
            case 5: {
                return Float.valueOf(rs.getFloat(index));
            }
            case 6: {
                return rs.getShort(index);
            }
            case 7: {
                return rs.getByte(index);
            }
            case 8: {
                return rs.getBytes(index);
            }
            case 9: {
                return rs.getBoolean(index);
            }
            case 10: {
                return rs.getBigDecimal(index);
            }
            case 11: {
                return rs.getDate(index);
            }
            case 12: {
                return rs.getTime(index);
            }
            case 13: {
                return rs.getTimestamp(index);
            }
            case 14: {
                return rs.getBlob(index);
            }
            case 15: {
                return rs.getClob(index);
            }
            case 16: {
                return rs.getNClob(index);
            }
            case 17: {
                return rs.getRowId(index);
            }
            case 18: {
                return rs.getSQLXML(index);
            }
            case 21: {
                return rs.getTimestamp(index);
            }
            case 22: {
                return rs.getArray(index);
            }
            case 23: {
                return rs.getBinaryStream(index);
            }
            case 24: {
                return rs.getCharacterStream(index);
            }
            case 25: {
                return rs.getRef(index);
            }
            case 27: {
                return rs.getURL(index);
            }
        }
        return rs.getObject(index);
    }

    public static void setPreparedNull(PreparedStatement pst, int objTypeIndex, int i) throws SQLException {
        pst.setNull(i + 1, 0);
    }

    public static String genSerializableNum() {
        String s = Math.random() + "";
        int end = s.length() > 12 ? 12 : s.length();
        return "159" + s.substring(2, end) + "L";
    }

    public static String deleteLastSemicolon(String sql) {
        if (sql == null) {
            return sql;
        }
        String new_sql = sql.trim();
        if (new_sql.endsWith(";")) {
            return new_sql.substring(0, new_sql.length() - 1);
        }
        sql = HoneyUtil._deletePrefix(new_sql);
        return sql;
    }

    public static String deletePrefix(String sql) {
        if (sql == null) {
            return sql;
        }
        String new_sql = sql.trim();
        return HoneyUtil._deletePrefix(new_sql);
    }

    private static String _deletePrefix(String new_sql) {
        if (new_sql.startsWith(START_MARK)) {
            return new_sql.substring(20, new_sql.length());
        }
        return new_sql;
    }

    public static <T> void checkPackage(T entity) {
        if (entity == null) {
            return;
        }
        String classFullName = entity.getClass().getName();
        if (classFullName.startsWith("java.") || classFullName.startsWith("javax.")) {
            throw new BeeIllegalEntityException("BeeIllegalEntityException: Illegal Entity, " + entity.getClass().getName());
        }
    }

    public static boolean isJavaPackage(Class<?> entityClass) {
        if (entityClass == null) {
            return false;
        }
        String classFullName = entityClass.getName();
        return classFullName.startsWith("java.") || classFullName.startsWith("javax.");
    }

    public static <T> Map<String, Object> getColumnMapByEntity(T entity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] fields = HoneyUtil.getFields(entity.getClass());
        int len = fields.length;
        try {
            for (int i = 0; i < len; ++i) {
                HoneyUtil.setAccessibleTrue(fields[i]);
                if (fields[i].get(entity) == null || HoneyUtil.isSkipField(fields[i])) continue;
                map.put(NameTranslateHandle.toColumnName(fields[i].getName(), entity.getClass()), fields[i].get(entity));
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return map;
    }

    public static String list2Value(List<PreparedValue> list, boolean needType) {
        StringBuffer b = new StringBuffer();
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return "";
        }
        String type = "";
        int size = list.size();
        Object value = null;
        for (int j = 0; j < size; ++j) {
            SetParaTypeConvert<Json> converter;
            value = list.get(j).getValue();
            Field f = list.get(j).getField();
            if (f != null && (converter = SetParaTypeConverterRegistry.getConverter(Json.class)) != null) {
                value = converter.convert(value);
            }
            b.append(value);
            type = list.get(j).getType();
            if (needType && type != null) {
                b.append("(");
                if (type.startsWith("java.lang.")) {
                    b.append(type.substring(10));
                } else {
                    b.append(type);
                }
                b.append(")");
            }
            if (j == size - 1) continue;
            b.append(",");
        }
        return b.toString();
    }

    public static String getExecutableSql(String sql, List<PreparedValue> list) {
        if (list == null || list.size() == 0) {
            return sql;
        }
        int size = list.size();
        Object value = null;
        for (int j = 0; j < size; ++j) {
            SetParaTypeConvert<Json> converter;
            value = list.get(j).getValue();
            Field f = list.get(j).getField();
            if (f != null && (converter = SetParaTypeConverterRegistry.getConverter(Json.class)) != null) {
                value = converter.convert(value);
            }
            sql = value != null && value instanceof CharSequence ? sql.replaceFirst("\\?", "'" + String.valueOf(value).replace("\\%", "\\\\%").replace("\\_", "\\\\_").replace("'", "\\\\'").replace("$", "\\$") + "'") : sql.replaceFirst("\\?", String.valueOf(value));
        }
        sql = sql + " ;";
        return sql;
    }

    public static String sqlFormat(String sql) {
        SqlFormat sqlFormat;
        boolean sqlFormatFlag = HoneyConfig.getHoneyConfig().showSql_sqlFormat;
        if (sqlFormatFlag && (sqlFormat = SpiInstanceRegister.getInstance(SqlFormat.class)) != null) {
            try {
                sql = sqlFormat.format(sql);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sql;
    }

    static <T> String checkAndProcessSelectField(T entity, String ... fieldList) {
        if (fieldList == null) {
            return null;
        }
        String packageAndClassName = entity.getClass().getName();
        String columnsdNames = HoneyContext.getBeanField(packageAndClassName);
        if (columnsdNames == null) {
            Field[] fields = HoneyUtil.getFields(entity.getClass());
            columnsdNames = HoneyUtil.getBeanField(fields, entity.getClass());
            HoneyContext.addBeanField(packageAndClassName, columnsdNames);
        }
        return HoneyUtil.checkAndProcessSelectFieldViaString(columnsdNames, null, fieldList);
    }

    public static String checkAndProcessSelectFieldViaString(String columnsdNames, Map<String, String> subDulFieldMap, String ... fields) {
        if (fields == null) {
            return null;
        }
        columnsdNames = columnsdNames.toLowerCase();
        String errorField = "";
        boolean isFirstError = true;
        String[] selectFields = fields.length == 1 ? fields[0].split(",") : fields;
        StringUtils.trim(selectFields);
        String newSelectFields = "";
        boolean isFisrt = true;
        for (String s : selectFields) {
            String newField;
            String colName = HoneyUtil._toColumnName(s);
            String checkColName = colName.toLowerCase();
            if (!(columnsdNames.contains("," + checkColName + ",") || columnsdNames.startsWith(checkColName + ",") || columnsdNames.endsWith("," + checkColName) || columnsdNames.equals(checkColName) || columnsdNames.contains("." + checkColName + ",") || columnsdNames.endsWith("." + checkColName) || columnsdNames.contains("," + checkColName + " ") || columnsdNames.startsWith(checkColName + " ") || columnsdNames.contains("." + checkColName + " "))) {
                if (isFirstError) {
                    errorField = errorField + s;
                    isFirstError = false;
                } else {
                    errorField = errorField + "," + s;
                }
            }
            if ((newField = subDulFieldMap == null ? null : subDulFieldMap.get(colName)) != null) {
                colName = HoneyUtil.isSQLite() ? colName + "  " + K.as + " '" + newField + "'" : colName + " " + newField;
            }
            if (isFisrt) {
                newSelectFields = newSelectFields + colName;
                isFisrt = false;
                continue;
            }
            newSelectFields = newSelectFields + ", " + colName;
        }
        if (!"".equals(errorField)) {
            throw new BeeErrorFieldException("ErrorField: " + errorField);
        }
        if ("".equals(newSelectFields.trim())) {
            return null;
        }
        return newSelectFields;
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private static String _toTableNameByEntityName(String entityName) {
        return NameTranslateHandle.toTableName(entityName);
    }

    private static String checkJoinTable(JoinTable joinTable) {
        String mainField = joinTable.mainField();
        String subField = joinTable.subField();
        String subAlias = joinTable.subAlias();
        String subClass = joinTable.subClass();
        if (NameCheckUtil.isIllegal(mainField)) {
            throw new JoinTableParameterException(SET_WRONG_VALUE_IN + "mainField:" + mainField);
        }
        if (NameCheckUtil.isIllegal(subField)) {
            throw new JoinTableParameterException(SET_WRONG_VALUE_IN + "subField:" + subField);
        }
        if (NameCheckUtil.isIllegal(subAlias)) {
            throw new JoinTableParameterException(SET_WRONG_VALUE_IN + "subAlias:" + subAlias);
        }
        if (NameCheckUtil.isIllegal(subClass)) {
            throw new JoinTableParameterException(SET_WRONG_VALUE_IN + "subClass:" + subClass);
        }
        String errorMsg = "";
        int errorCount = 0;
        if (mainField == null) {
            errorMsg = "mainField is null! ";
            ++errorCount;
        } else if ("".equals(mainField.trim())) {
            errorMsg = errorMsg + "mainField is empty! ";
            ++errorCount;
        }
        if (subField == null) {
            errorMsg = errorMsg + "subField is null! ";
            ++errorCount;
        } else if ("".equals(subField.trim())) {
            errorMsg = errorMsg + "subField is empty! ";
            ++errorCount;
        }
        if (errorCount == 1) {
            return errorMsg;
        }
        return "";
    }

    public static boolean isMysql() {
        return "MySQL".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName()) || "MariaDB".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static boolean isConfuseDuplicateFieldDB() {
        return "Oracle".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName()) || "SQLite".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName()) || "Microsoft SQL Server".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static boolean isSQLite() {
        return "SQLite".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static boolean isSqlServer() {
        return "Microsoft SQL Server".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static boolean isOracle() {
        return "Oracle".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static boolean isH2() {
        return "H2".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static boolean isCassandra() {
        return "Cassandra".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static boolean isHbase() {
        return "Hbase".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static boolean isMongoDB() {
        return "MongoDB".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static void setPageNum(List<PreparedValue> list) {
        int[] array = (int[])OneTimeParameter.getAttribute("_SYS_Bee_Paing_NumArray");
        for (int i = 0; array != null && i < array.length; ++i) {
            PreparedValue p = new PreparedValue();
            p.setType("java.lang.Integer");
            p.setValue(array[i]);
            if (HoneyUtil.isSqlServer()) {
                list.add(0, p);
                continue;
            }
            list.add(p);
        }
    }

    public static boolean isRegPagePlaceholder() {
        return OneTimeParameter.isTrue("_SYS_Bee_Paing_Placeholder");
    }

    public static void regPagePlaceholder() {
        if (HoneyUtil.isSqlServer()) {
            return;
        }
        if (ShardingUtil.hadSharding()) {
            return;
        }
        OneTimeParameter.setTrueForKey("_SYS_Bee_Paing_Placeholder");
    }

    public static void regPageNumArray(int[] array) {
        OneTimeParameter.setAttribute("_SYS_Bee_Paing_NumArray", array);
    }

    public static boolean isSqlKeyWordUpper() {
        String kwCase = HoneyConfig.getHoneyConfig().sqlKeyWordCase;
        return "upper".equalsIgnoreCase(kwCase);
    }

    public static <T> Field getPkField(T entity) {
        return HoneyUtil.getPkField(entity.getClass());
    }

    public static <T> Field getPkField(Class<T> entityClass) {
        Field field;
        block8: {
            field = null;
            try {
                field = HoneyUtil.getField(entityClass, "id");
            }
            catch (NoSuchFieldException e) {
                String pkName = HoneyUtil.getPkFieldNameByClass(entityClass);
                boolean hasException = false;
                if ("".equals(pkName)) {
                    hasException = true;
                } else if (pkName != null && !pkName.contains(",")) {
                    try {
                        field = HoneyUtil.getField(entityClass, pkName);
                    }
                    catch (NoSuchFieldException e2) {
                        hasException = true;
                    }
                } else {
                    Logger.warn("Don't support return id value when the primary key more than one field!");
                }
                if (!hasException) break block8;
                throw new ObjSQLException("Miss id field: the entity no id field!");
            }
        }
        return field;
    }

    public static <T> Object getIdValue(T entity) {
        Field field = HoneyUtil.getPkField(entity);
        Object obj = null;
        try {
            if (field != null) {
                HoneyUtil.setAccessibleTrue(field);
                obj = field.get(entity);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return obj;
    }

    public static <T> boolean hasGenPkAnno(T entity) {
        Field field = HoneyUtil.getPkField(entity);
        if (field != null) {
            return AnnoUtil.isGenPkAnno(field);
        }
        return false;
    }

    public static <T> void revertId(T entity) {
        Field field = null;
        if (OneTimeParameter.isTrue("_SYS_Bee_OLD_ID_FOR_AUTO_ID_EXIST")) {
            try {
                Object obj = OneTimeParameter.getAttribute("_SYS_Bee_OLD_ID_FOR_AUTO_ID");
                String pkName = (String)OneTimeParameter.getAttribute("_SYS_Bee_PK_NAME");
                field = HoneyUtil.getField(entity.getClass(), pkName);
                HoneyUtil.setAccessibleTrue(field);
                HoneyUtil.setFieldValue(field, entity, obj);
            }
            catch (NoSuchFieldException e) {
                throw new ObjSQLException("Miss id field: the entity no id field!");
            }
            catch (IllegalAccessException e) {
                throw ExceptionHelper.convert(e);
            }
        }
    }

    public static <T> void revertId(T[] entity) {
        Field field = null;
        String pkName = (String)OneTimeParameter.getAttribute("_SYS_Bee_PK_NAME");
        if (pkName == null) {
            for (int i = 0; i < entity.length; ++i) {
                OneTimeParameter.isTrue("_SYS_Bee_OLD_ID_FOR_AUTO_ID_EXIST" + i);
                OneTimeParameter.getAttribute("_SYS_Bee_OLD_ID_FOR_AUTO_ID" + i);
            }
            return;
        }
        for (int i = 0; i < entity.length; ++i) {
            if (!OneTimeParameter.isTrue("_SYS_Bee_OLD_ID_FOR_AUTO_ID_EXIST" + i)) continue;
            try {
                Object obj = OneTimeParameter.getAttribute("_SYS_Bee_OLD_ID_FOR_AUTO_ID" + i);
                field = HoneyUtil.getField(entity[i].getClass(), pkName);
                HoneyUtil.setAccessibleTrue(field);
                HoneyUtil.setFieldValue(field, entity[i], obj);
                continue;
            }
            catch (NoSuchFieldException e) {
                throw new ObjSQLException("entity[] miss id field: the element in entity[] no id field!");
            }
            catch (IllegalAccessException e) {
                throw ExceptionHelper.convert(e);
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), e);
            }
        }
    }

    public static <T> void setInitArrayIdByAuto(T[] entity) {
        if (entity == null || entity.length < 1) {
            return;
        }
        boolean hasValue = false;
        Field field0 = null;
        String pkName = "";
        String pkAlias = "";
        boolean isStringField = false;
        boolean hasGenUUIDAnno = false;
        boolean useSeparatorInUUID = false;
        try {
            long[] ids;
            boolean noId = false;
            try {
                field0 = HoneyUtil.getField(entity[0].getClass(), "id");
                pkName = "id";
            }
            catch (NoSuchFieldException e) {
                noId = true;
            }
            if (noId) {
                pkName = HoneyUtil.getPkFieldName(entity[0]);
                if ("".equals(pkName) || pkName.contains(",")) {
                    return;
                }
                field0 = HoneyUtil.getField(entity[0].getClass(), pkName);
                pkAlias = "(" + pkName + ")";
            }
            if (field0 == null) {
                return;
            }
            boolean replaceOldValue = HoneyConfig.getHoneyConfig().genid_replaceOldId;
            if (field0.isAnnotationPresent(GenId.class)) {
                GenId genId = field0.getAnnotation(GenId.class);
                replaceOldValue = replaceOldValue || genId.override();
            } else if (field0.isAnnotationPresent(GenUUID.class)) {
                GenUUID gen = field0.getAnnotation(GenUUID.class);
                replaceOldValue = replaceOldValue || gen.override();
                hasGenUUIDAnno = true;
                useSeparatorInUUID = gen.useSeparator();
            } else {
                boolean needGenId = HoneyContext.isNeedGenId(entity[0].getClass());
                if (!needGenId) {
                    return;
                }
            }
            isStringField = field0.getType().equals(String.class);
            if (hasGenUUIDAnno && !isStringField) {
                Logger.warn("Gen UUID as id just support String type field!");
                return;
            }
            if (_ObjectToSQLHelper.errorType(field0)) {
                Logger.warn("The id" + pkAlias + " field's " + field0.getType() + " is not Long/Integer, can not generate the Long/Integer id automatically!");
                return;
            }
            int len = entity.length;
            String tableKey = HoneyUtil._toTableName(entity[0]);
            long id = 0L;
            if (_ObjectToSQLHelper.isInt(field0)) {
                ids = GenIdFactory.getRangeId(tableKey, "IntSerialIdReturnLong", len);
                id = ids[0];
            } else if (!hasGenUUIDAnno) {
                ids = GenIdFactory.getRangeId(tableKey, len);
                id = ids[0];
            }
            Field field = null;
            for (int i = 0; i < len; ++i) {
                if (entity[i] != null) {
                    hasValue = false;
                    field = HoneyUtil.getField(entity[i].getClass(), pkName);
                    HoneyUtil.setAccessibleTrue(field);
                    Object obj = field.get(entity[i]);
                    if (obj != null) {
                        if (!replaceOldValue) {
                            return;
                        }
                        hasValue = true;
                    }
                    HoneyUtil.setAccessibleTrue(field);
                    try {
                        if (_ObjectToSQLHelper.isInt(field0)) {
                            HoneyUtil.setFieldValue(field, entity[i], (int)id);
                        } else if (!hasGenUUIDAnno && isStringField) {
                            HoneyUtil.setFieldValue(field, entity[i], id + "");
                        } else if (hasGenUUIDAnno && isStringField) {
                            HoneyUtil.setFieldValue(field, entity[i], UUID.getId(useSeparatorInUUID));
                        } else {
                            HoneyUtil.setFieldValue(field, entity[i], id);
                        }
                        if (hasValue) {
                            Logger.warn(" [ID WOULD BE REPLACED] entity[" + i + "] : " + entity[0].getClass() + " 's id field" + pkAlias + " value is " + obj.toString() + " would be replace by " + id);
                        }
                        OneTimeParameter.setAttribute("_SYS_Bee_PK_NAME", pkName);
                        OneTimeParameter.setTrueForKey("_SYS_Bee_OLD_ID_FOR_AUTO_ID_EXIST" + i);
                        OneTimeParameter.setAttribute("_SYS_Bee_OLD_ID_FOR_AUTO_ID" + i, obj);
                    }
                    catch (IllegalAccessException e) {
                        throw ExceptionHelper.convert(e);
                    }
                }
                ++id;
            }
        }
        catch (NoSuchFieldException e) {
            return;
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), e);
            return;
        }
    }

    public static <T> String getPkFieldName(T entity) {
        if (entity == null) {
            return null;
        }
        return HoneyUtil.getPkFieldNameByClass(entity.getClass());
    }

    public static String getPkFieldNameByClass(Class<?> c) {
        if (c == null) {
            return null;
        }
        String classFullName = c.getName();
        String pkey = HoneyContext.getBeanCustomPKey(classFullName);
        if (pkey != null) {
            return pkey;
        }
        Field[] field = HoneyUtil.getFields(c);
        int len = field.length;
        boolean isFirst = true;
        pkey = "";
        for (int i = 0; i < len; ++i) {
            if (HoneyUtil.isSkipField(field[i]) && !AnnoUtil.isFK(field[i]) || !AnnoUtil.isPrimaryKey(field[i])) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                pkey = pkey + ",";
            }
            pkey = pkey + field[i].getName();
        }
        HoneyContext.addBeanCustomPKey(classFullName, pkey);
        return pkey;
    }

    public static String getPlaceholderValue(int size) {
        StringBuffer placeholderValue = new StringBuffer(" (");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                placeholderValue.append(",");
            }
            placeholderValue.append("?");
        }
        if (size <= 0) {
            placeholderValue.append("''");
        }
        placeholderValue.append(")");
        return placeholderValue.toString();
    }

    public static boolean isNumberArray(Class<?> c) {
        if (c == null) {
            return false;
        }
        for (String type : NumberArrayTypes) {
            if (!type.equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumber(Object obj) {
        return obj instanceof Integer || obj instanceof Long || obj instanceof Short || obj instanceof Byte || obj instanceof Double || obj instanceof Float || obj instanceof BigInteger || obj instanceof BigDecimal;
    }

    public static boolean isUpperCaseDB() {
        if (HoneyUtil.isOracle()) {
            return true;
        }
        return "H2".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static InterceptorChain copy(InterceptorChain obj) {
        try {
            JdkSerializer jdks = new JdkSerializer();
            return (InterceptorChain)jdks.unserialize(jdks.serialize(obj));
        }
        catch (Exception e) {
            Logger.debug(e.getMessage(), e);
            return null;
        }
    }

    public static <T extends Serializable> Object copyObject(T obj) {
        try {
            JdkSerializer jdks = new JdkSerializer();
            return jdks.unserialize(jdks.serialize(obj));
        }
        catch (Exception e) {
            Logger.debug(e.getMessage(), e);
            return null;
        }
    }

    public static boolean isNotSupportUnionQuery() {
        return HoneyConfig.getHoneyConfig().sharding_notSupportUnionQuery || HoneyUtil.isSQLite();
    }

    public static <T> String getColumnNames(T entity) {
        Field[] fields = HoneyUtil.getFields(entity.getClass());
        String packageAndClassName = entity.getClass().getName();
        String columnNames = HoneyContext.getBeanField(packageAndClassName);
        if (columnNames == null) {
            columnNames = HoneyUtil.getBeanField(fields, entity.getClass());
            HoneyContext.addBeanField(packageAndClassName, columnNames);
        }
        return columnNames;
    }

    public static String toTableName(Object entity) {
        if (entity instanceof Class) {
            return HoneyUtil._toTableNameByClass((Class)entity);
        }
        if (entity instanceof String) {
            return HoneyUtil._toTableName2((String)entity);
        }
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private static String _toTableName2(String entityName) {
        return NameTranslateHandle.toTableName(entityName);
    }

    private static String _toTableNameByClass(Class<?> c) {
        return NameTranslateHandle.toTableName(c.getName());
    }

    public static void setFieldValue(Field field, Object targetObj, Object value) throws IllegalAccessException {
        field.set(targetObj, value);
    }

    public static void setAccessibleTrue(Field field) {
        field.setAccessible(true);
    }

    public static <T> Field[] getFields(Class<T> entityClass) {
        Field[] fields = entityClass.getDeclaredFields();
        if (HoneyUtil.isOpenEntityCanExtend()) {
            Class<T> superClass = null;
            Class<T> currentClass = entityClass;
            while (HoneyUtil.isSuperEntity(superClass = currentClass.getSuperclass()) && (fields = HoneyUtil.mergeSuperFields(fields, currentClass = superClass)) != null) {
            }
        }
        if (fields == null) {
            fields = new Field[]{};
        }
        return fields;
    }

    private static <T> Field[] mergeSuperFields(Field[] oldFields, Class<T> superClass) {
        Field[] superFields = superClass.getDeclaredFields();
        if (superFields == null || superFields.length == 0) {
            return oldFields;
        }
        int oldFieldsLength = oldFields.length;
        int superFieldsLength = superFields.length;
        Field[] mergedFields = Arrays.copyOf(oldFields, oldFieldsLength + superFieldsLength);
        System.arraycopy(superFields, 0, mergedFields, oldFieldsLength, superFieldsLength);
        return mergedFields;
    }

    public static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass;
            if (HoneyUtil.isOpenEntityCanExtend() && HoneyUtil.isSuperEntity(superClass = clazz.getSuperclass())) {
                return HoneyUtil.getField(superClass, fieldName);
            }
            throw e;
        }
    }

    public static boolean isSuperEntity(Class<?> superClass) {
        return superClass != null && superClass != Object.class && !superClass.getName().startsWith("java.") && !superClass.getName().startsWith("javax.");
    }

    private static boolean isOpenEntityCanExtend() {
        return HoneyConfig.getHoneyConfig().openEntityCanExtend;
    }

    public static String getRandomPrefix() {
        String s = Math.random() + "";
        if (index > MAX) {
            index = 0;
        }
        ++index;
        try {
            return START_MARK + s.substring(2, 13) + ch[index % 64] + END_MARK;
        }
        catch (StringIndexOutOfBoundsException e) {
            return HoneyUtil.getRandomPrefix();
        }
    }

    static {
        HoneyUtil.initJavaTypeMap();
        HoneyUtil.initSetParaAndResultTypeHandlerRegistry();
        SET_WRONG_VALUE_IN = "Annotation JoinTable set wrong value in ";
        NumberArrayTypes = new String[]{"[Ljava.lang.Long;", "[Ljava.lang.Integer;", "[Ljava.lang.Short;", "[Ljava.lang.Byte;", "[Ljava.lang.Double;", "[Ljava.lang.Float;", "[Ljava.math.BigInteger;", "[Ljava.math.BigDecimal;"};
        ch = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789XY".toCharArray();
        index = 0;
        MAX = 0x40000000;
    }
}

