/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.IncludeType;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.api.Condition;
import org.teasoft.bee.osql.api.SuidRich;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.honey.osql.core.BeeFactoryHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MongodbObjSQL;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core._ObjectToSQLHelper;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.config.ShardingRegistry;
import org.teasoft.honey.sharding.engine.batch.ShardingBatchInsertEngine;
import org.teasoft.honey.sharding.engine.batch.ShardingForkJoinBatchInsertEngine;
import org.teasoft.honey.util.ObjectUtils;
import org.teasoft.honey.util.StringUtils;
import org.teasoft.honey.util.currency.CurrencyArithmetic;

public class MongodbObjSQLRich
extends MongodbObjSQL
implements SuidRich,
Serializable {
    private static final long serialVersionUID = 1596710362263L;
    private static final String ID_IS_NULL = "in method selectById,id is null! ";
    private static final String START_GREAT_EQ_0 = "Parameter 'start' need >=0 .";
    private static final String SIZE_GREAT_0 = "Parameter 'size' need >0 .";
    private static final String TIP_SIZE_0 = "The size is 0, but it should be greater than 0 (>0)";
    private int defaultBatchSize;
    private static final String MSG = "Please use the relative method of CreateIndex or MongodbSuidRichExt in org.teasoft.beex.osql.mongodb!";

    public MongodbObjSQLRich() {
        this.defaultBatchSize = HoneyConfig.getHoneyConfig().insertBatchSize;
    }

    public <T> List<T> select(T entity, int size) {
        if (entity == null) {
            return null;
        }
        if (size == 0) {
            Logger.warn(TIP_SIZE_0);
            return Collections.emptyList();
        }
        if (size < 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        return this.select(entity, 0, size);
    }

    public <T> List<T> select(T entity, int start, int size) {
        if (entity == null) {
            return null;
        }
        if (size == 0) {
            Logger.warn(TIP_SIZE_0);
            return Collections.emptyList();
        }
        if (size < 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        Condition condition = BeeFactoryHelper.getCondition();
        condition.start(Integer.valueOf(start)).size(Integer.valueOf(size));
        return this.select(entity, condition);
    }

    public <T> List<T> select(T entity, String ... selectField) {
        if (entity == null) {
            return null;
        }
        Condition condition = BeeFactoryHelper.getCondition();
        condition.selectField(selectField);
        return this.select(entity, condition);
    }

    public <T> List<T> select(T entity, int start, int size, String ... selectFields) {
        if (entity == null) {
            return null;
        }
        if (size == 0) {
            Logger.warn(TIP_SIZE_0);
            return Collections.emptyList();
        }
        if (size < 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        Condition condition = BeeFactoryHelper.getCondition();
        condition.selectField(selectFields);
        condition.start(Integer.valueOf(start)).size(Integer.valueOf(size));
        return this.select(entity, condition);
    }

    public <T> List<T> selectOrderBy(T entity, String orderFields) {
        return this.selectOrderBy(entity, orderFields, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> selectOrderBy(T entity, String orderFields, OrderType[] orderTypes) {
        if (entity == null) {
            return null;
        }
        List list = null;
        try {
            this.doBeforePasreEntity(entity, SuidType.SELECT);
            list = this.getMongodbBeeSql().selectOrderBy(entity, orderFields, orderTypes);
        }
        catch (Throwable throwable) {
            this.doBeforeReturn(list);
            throw throwable;
        }
        this.doBeforeReturn(list);
        return list;
    }

    public <T> int insert(T[] entity) {
        return this.insert(entity, this.defaultBatchSize, "");
    }

    public <T> int insert(T[] entity, String excludeFields) {
        return this.insert(entity, this.defaultBatchSize, "");
    }

    public <T> int insert(T[] entity, int batchSize) {
        return this.insert(entity, batchSize, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int insert(T[] entity, int batchSize, String excludeFields) {
        if (entity == null || entity.length < 1) {
            return -1;
        }
        this.checkNull(entity);
        if (batchSize <= 0) {
            batchSize = 10;
        }
        if (ShardingUtil.isShardingBatchInsertDoing()) {
            return this._insert(entity, batchSize, excludeFields);
        }
        int a = 0;
        try {
            HoneyUtil.setInitArrayIdByAuto(entity);
            this.doBeforePasreEntity(entity, SuidType.INSERT);
            List<String> tabNameListForBatch = HoneyContext.getListLocal("_SYS_Bee_TabNameListForBatchLocal");
            List<String> dsNameListForBatch = HoneyContext.getListLocal("_SYS_Bee_DsNameListForBatchLocal");
            if (!ShardingUtil.isSharding() || ObjectUtils.isEmpty(tabNameListForBatch) && ObjectUtils.isEmpty(dsNameListForBatch)) {
                a = this._insert(entity, batchSize, excludeFields);
            } else {
                try {
                    String tableName = this._toTableName(entity[0]);
                    Logger.logSQL("Mongodb::batch insert, Collection:" + tableName + "  dsNameList:" + dsNameListForBatch + "  collectionNameList:" + tabNameListForBatch);
                    boolean isBroadcastTab = ShardingRegistry.isBroadcastTab(tableName);
                    boolean forkJoin = HoneyConfig.getHoneyConfig().sharding_forkJoinBatchInsert;
                    a = forkJoin && !isBroadcastTab ? new ShardingForkJoinBatchInsertEngine<T>().batchInsert(entity, batchSize, excludeFields, tabNameListForBatch, this) : new ShardingBatchInsertEngine<T>().batchInsert(entity, batchSize, excludeFields, tabNameListForBatch, this);
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), e);
                }
                finally {
                    HoneyContext.removeSysCommStrLocal("_SYS_Bee_ShardingBatchInsertDoing");
                }
            }
            HoneyUtil.revertId(entity);
        }
        finally {
            this.doBeforeReturn();
        }
        return a;
    }

    private <T> int _insert(T[] entity, int batchSize, String excludeFields) {
        return this.getMongodbBeeSql().insert((Object[])entity, batchSize, excludeFields);
    }

    private String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private <T> void checkNull(T[] entity) {
        for (int i = 0; i < entity.length; ++i) {
            if (entity[i] != null) continue;
            throw new ObjSQLException("entity[] have null element, index: " + i);
        }
    }

    public <T> int update(T entity, String ... updateFields) {
        return this._update(entity, updateFields);
    }

    public <T> int _update(T entity, String ... updateFields) {
        Condition condition = null;
        return this.update(entity, condition, updateFields);
    }

    public <T> T selectOne(T entity) {
        if (entity == null) {
            return null;
        }
        List<T> list = this.select(entity, 2);
        if (list == null || list.size() != 1) {
            return null;
        }
        return list.get(0);
    }

    public <T> T selectFirst(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        if (condition == null) {
            condition = BeeFactoryHelper.getCondition();
        }
        condition.size(Integer.valueOf(1));
        List<T> list = this.select(entity, condition);
        if (list == null || list.size() < 1) {
            return null;
        }
        return list.get(0);
    }

    public <T> String selectWithFun(T entity, FunctionType functionType, String fieldForFun) {
        return this.selectWithFun(entity, functionType, fieldForFun, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> String selectWithFun(T entity, FunctionType functionType, String fieldForFun, Condition condition) {
        if (entity == null) {
            return null;
        }
        if (FunctionType.COUNT == functionType) {
            return this.count(entity, condition) + "";
        }
        try {
            this.regCondition(condition);
            this.doBeforePasreEntity(entity, SuidType.SELECT);
            this._regEntityClass1(entity);
            this._regFunType(functionType);
            String rs = "";
            if (FunctionType.AVG == functionType && ShardingUtil.hadSharding() && HoneyContext.getSqlIndexLocal() == null) {
                int count = this.count(entity, condition);
                String sum = this.selectWithFun(entity, FunctionType.SUM, fieldForFun, condition);
                if (count == 0 || StringUtils.isBlank(sum)) {
                    String string = "";
                    return string;
                }
                rs = CurrencyArithmetic.divide(sum, count + "");
            } else {
                rs = this.getMongodbBeeSql().selectWithFun(entity, functionType, fieldForFun, condition);
            }
            String string = rs;
            return string;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    public <T> int count(T entity) {
        return this.count(entity, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int count(T entity, Condition condition) {
        if (entity == null) {
            return 0;
        }
        try {
            int c;
            this.regCondition(condition);
            this._regFunType(FunctionType.COUNT);
            this.doBeforePasreEntity(entity, SuidType.SELECT);
            if (condition != null) {
                condition.setSuidType(SuidType.SELECT);
            }
            int n = c = this.getMongodbBeeSql().count(entity, condition);
            return n;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    public <T> int update(T entity, IncludeType includeType, String ... updateFields) {
        return this.update(entity, this._getCondition(includeType), updateFields);
    }

    private Condition _getCondition(IncludeType includeType) {
        return BeeFactoryHelper.getCondition().setIncludeType(includeType);
    }

    public <T> List<T> select(T entity, IncludeType includeType) {
        if (entity == null) {
            return null;
        }
        return this.select(entity, this._getCondition(includeType));
    }

    public <T> int update(T entity, IncludeType includeType) {
        return this.updateBy(entity, this._getCondition(includeType), "id");
    }

    public <T> int insert(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        long a = this.insertAndReturnId(entity, includeType);
        if (a > 0L) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> long insertAndReturnId(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1L;
        }
        try {
            this.doBeforePasreEntity(entity, SuidType.INSERT);
            _ObjectToSQLHelper.setInitIdByAuto(entity);
            long returnId = this.getMongodbBeeSql().insertAndReturnId(entity, includeType);
            HoneyUtil.revertId(entity);
            long l = returnId;
            return l;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    public <T> int delete(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        return this.delete(entity, this._getCondition(includeType));
    }

    public <T> List<String[]> selectString(T entity) {
        Condition condition = null;
        return this.selectString(entity, condition);
    }

    public <T> List<String[]> selectString(T entity, String ... selectFields) {
        Condition condition = BeeFactoryHelper.getCondition();
        condition.selectField(selectFields);
        return this.selectString(entity, condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<String[]> selectString(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        try {
            this.regCondition(condition);
            this.doBeforePasreEntity(entity, SuidType.SELECT);
            List list = null;
            if (condition == null) {
                condition = BeeFactoryHelper.getCondition();
            }
            if (condition.getSelectField() == null) {
                condition.selectField(new String[]{HoneyUtil.getColumnNames(entity)});
                HoneyContext.setTrueInSysCommStrLocal("_SYS_Bee_MongoDB_select_all_fields");
            }
            list = this.getMongodbBeeSql().selectString(entity, condition);
            HoneyContext.removeSysCommStrLocal("_SYS_Bee_MongoDB_select_all_fields");
            List list2 = list;
            return list2;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    public <T> String selectJson(T entity) {
        Condition condition = null;
        return this.selectJson(entity, condition);
    }

    public <T> String selectJson(T entity, IncludeType includeType) {
        return this.selectJson(entity, this._getCondition(includeType));
    }

    public <T> String selectJson(T entity, String ... selectField) {
        Condition condition = BeeFactoryHelper.getCondition();
        return this.selectJson(entity, condition.selectField(selectField));
    }

    public <T> String selectJson(T entity, int start, int size, String ... selectFields) {
        if (entity == null) {
            return null;
        }
        if (size == 0) {
            Logger.warn(TIP_SIZE_0);
            return null;
        }
        if (size < 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        Condition condition = BeeFactoryHelper.getCondition();
        condition.selectField(selectFields).start(Integer.valueOf(start)).size(Integer.valueOf(size));
        return this.selectJson(entity, condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T selectByIdObject(Class<T> entityClass, Object id) {
        this.doBeforePasreEntity(entityClass, SuidType.SELECT);
        List list = null;
        T t = null;
        try {
            list = this.getMongodbBeeSql().selectById(entityClass, id);
            t = list == null || list.size() < 1 ? null : (T)list.get(0);
        }
        finally {
            if (list == null || list.size() < 1) {
                this.doBeforeReturn();
            } else {
                this.doBeforeReturn(list);
            }
        }
        return t;
    }

    public <T> T selectById(Class<T> entityClass, Integer id) {
        if (entityClass == null) {
            return null;
        }
        if (id == null) {
            Logger.warn(ID_IS_NULL);
            return null;
        }
        return this.selectByIdObject(entityClass, id);
    }

    public <T> T selectById(Class<T> entityClass, Long id) {
        if (entityClass == null) {
            return null;
        }
        if (id == null) {
            Logger.warn(ID_IS_NULL);
            return null;
        }
        return this.selectByIdObject(entityClass, id);
    }

    public <T> T selectById(Class<T> entityClass, String id) {
        if (entityClass == null) {
            return null;
        }
        if (id == null) {
            Logger.warn(ID_IS_NULL);
            return null;
        }
        if (id.contains(",")) {
            throw new BeeIllegalParameterException("The parameter 'id' of method selectById does not allow to contain comma!");
        }
        return this.selectByIdObject(entityClass, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> selectByIds(Class<T> entityClass, String ids) {
        if (entityClass == null) {
            return null;
        }
        if (ids == null) {
            Logger.warn("in method selectByIds,ids is null! ");
            return null;
        }
        List list = null;
        try {
            this.doBeforePasreEntity(entityClass, SuidType.SELECT);
            list = this.getMongodbBeeSql().selectById(entityClass, (Object)ids);
        }
        catch (Throwable throwable) {
            this.doBeforeReturn(list);
            throw throwable;
        }
        this.doBeforeReturn(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteByIdObject(Class c, Object id) {
        try {
            int a;
            this.doBeforePasreEntity(c, SuidType.DELETE);
            int n = a = this.getMongodbBeeSql().deleteById(c, id);
            return n;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    public int deleteById(Class c, Integer id) {
        if (id == null) {
            Logger.warn("in method deleteById,id is null! ");
        }
        if (c == null || id == null) {
            return 0;
        }
        return this.deleteByIdObject(c, id);
    }

    public int deleteById(Class c, Long id) {
        if (id == null) {
            Logger.warn("in method deleteById,id is null! ");
        }
        if (c == null || id == null) {
            return 0;
        }
        return this.deleteByIdObject(c, id);
    }

    public int deleteById(Class c, String ids) {
        if (ids == null) {
            Logger.warn("in method deleteById,ids is null! ");
        }
        if (c == null || ids == null) {
            return 0;
        }
        return this.deleteByIdObject(c, ids);
    }

    @Deprecated
    public <T> List<T> select(T entity, IncludeType includeType, Condition condition) {
        if (condition == null) {
            condition = BeeFactoryHelper.getCondition();
        }
        return this.select(entity, condition.setIncludeType(includeType));
    }

    public <T> String selectJson(T entity, IncludeType includeType, Condition condition) {
        if (entity == null) {
            return null;
        }
        if (condition == null) {
            condition = BeeFactoryHelper.getCondition();
        }
        return this.selectJson(entity, condition.setIncludeType(includeType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> String selectJson(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        try {
            String json;
            this.regCondition(condition);
            this.doBeforePasreEntity(entity, SuidType.SELECT);
            this._regEntityClass1(entity);
            String string = json = this.getMongodbBeeSql().selectJson(entity, condition);
            return string;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    public <T> int updateBy(T entity, String ... whereFields) {
        Condition condition = null;
        return this.updateBy(entity, condition, whereFields);
    }

    public <T> int updateById(T entity, Condition condition) {
        String pkName = "";
        try {
            HoneyUtil.getField(entity.getClass(), "id");
            pkName = "id";
        }
        catch (NoSuchFieldException e) {
            pkName = HoneyUtil.getPkFieldName(entity);
        }
        if (StringUtils.isBlank(pkName)) {
            throw new BeeErrorGrammarException("id(primary key) field can not empty!");
        }
        return this.updateBy(entity, condition, pkName);
    }

    public <T> int updateBy(T entity, IncludeType includeType, String ... whereFields) {
        return this.updateBy(entity, this._getCondition(includeType), whereFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int updateBy(T entity, Condition condition, String ... whereFields) {
        if (entity == null) {
            return 0;
        }
        try {
            int updateNum;
            this.doBeforePasreEntity(entity, SuidType.UPDATE);
            int n = updateNum = this.getMongodbBeeSql().updateBy(entity, condition, whereFields);
            return n;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int update(T entity, Condition condition, String ... updateFields) {
        if (entity == null) {
            return 0;
        }
        try {
            int updateNum;
            this.doBeforePasreEntity(entity, SuidType.UPDATE);
            int n = updateNum = this.getMongodbBeeSql().update(entity, condition, updateFields);
            return n;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    public <T> int update(T entity, Condition condition) {
        return this.update(entity, condition, "");
    }

    public <T> int insert(List<T> entityList) {
        if (entityList == null || entityList.size() < 1) {
            return -1;
        }
        T[] entity = this.toEntityArray(entityList);
        return this.insert(entity);
    }

    public <T> int insert(List<T> entityList, int batchSize) {
        if (entityList == null || entityList.size() < 1) {
            return -1;
        }
        T[] entity = this.toEntityArray(entityList);
        return this.insert(entity, batchSize);
    }

    public <T> int insert(List<T> entityList, String excludeFields) {
        if (entityList == null || entityList.size() < 1) {
            return -1;
        }
        T[] entity = this.toEntityArray(entityList);
        return this.insert(entity, excludeFields);
    }

    public <T> int insert(List<T> entityList, int batchSize, String excludeFields) {
        if (entityList == null || entityList.size() < 1) {
            return -1;
        }
        T[] entity = this.toEntityArray(entityList);
        return this.insert(entity, batchSize, excludeFields);
    }

    private <T> void _regEntityClass1(T entity) {
        if (entity == null) {
            return;
        }
        HoneyContext.regEntityClass(entity.getClass());
    }

    private <T> void _regFunType(FunctionType functionType) {
        HoneyContext.regFunType(functionType);
    }

    private <T> T[] toEntityArray(List<T> entityList) {
        int len = entityList.size();
        Object[] entity = new Object[len];
        for (int i = 0; i < len; ++i) {
            entity[i] = entityList.get(i);
        }
        return entity;
    }

    public SuidRich setDynamicParameter(String para, String value) {
        OneTimeParameter.setAttribute(para, value);
        return this;
    }

    public <T> boolean exist(T entity) {
        int r = this.count(entity);
        return r > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int update(T oldEntity, T newEntity) {
        String newEntityFullName;
        if (oldEntity == null || newEntity == null) {
            return -1;
        }
        if (newEntity.getClass() == String.class) {
            return this._update(oldEntity, newEntity.toString());
        }
        String oldEntityFullName = oldEntity.getClass().getName();
        if (!oldEntityFullName.equals(newEntityFullName = newEntity.getClass().getName())) {
            throw new BeeErrorGrammarException("BeeErrorGrammarException: the oldEntity and newEntity must be same type!");
        }
        try {
            int updateNum;
            this.doBeforePasreEntity(newEntity, SuidType.UPDATE);
            int n = updateNum = this.getMongodbBeeSql().update(oldEntity, newEntity);
            return n;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    public <T> int save(T entity) {
        if (entity == null) {
            return 0;
        }
        Object id = HoneyUtil.getIdValue(entity);
        if (id == null) {
            return this.insert(entity);
        }
        Object one = this.selectById(entity.getClass(), id.toString());
        if (one != null) {
            return this.update(entity);
        }
        return this.insert(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean createTable(Class<T> entityClass, boolean isDropExistTable) {
        if (entityClass == null) {
            return false;
        }
        try {
            boolean f;
            this.doBeforePasreEntity(entityClass, SuidType.DDL);
            boolean bl = f = this.getMongodbBeeSql().createTable(entityClass, isDropExistTable);
            return bl;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    public <T> void indexNormal(Class<T> entityClass, String fields, String indexName) {
        Logger.warn(MSG);
    }

    public <T> void unique(Class<T> entityClass, String fields, String indexName) {
        Logger.warn(MSG);
    }

    public <T> void primaryKey(Class<T> entityClass, String fields, String keyName) {
        Logger.warn(MSG);
    }

    public <T> void dropIndex(Class<T> entityClass, String indexName) {
        Logger.warn(MSG);
    }
}

