/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.ObjToSQL;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.api.Condition;
import org.teasoft.bee.osql.api.Suid;
import org.teasoft.bee.osql.exception.NotSupportedException;
import org.teasoft.honey.osql.core.AbstractCommOperate;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core._ObjectToSQLHelper;

public class ObjSQL
extends AbstractCommOperate
implements Suid {
    private BeeSql beeSql;
    private ObjToSQL objToSQL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> select(T entity) {
        if (entity == null) {
            return null;
        }
        List list = null;
        try {
            this.doBeforePasreEntity(entity, SuidType.SELECT);
            String sql = this.getObjToSQL().toSelectSQL(entity);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL("select SQL: ", sql);
            list = this.getBeeSql().select(sql, this.toClassT(entity));
        }
        catch (Throwable throwable) {
            this.doBeforeReturn(list);
            throw throwable;
        }
        this.doBeforeReturn(list);
        return list;
    }

    protected <T> Class<T> toClassT(T entity) {
        return entity.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int update(T entity) {
        if (entity == null) {
            return -1;
        }
        try {
            this.doBeforePasreEntity(entity, SuidType.UPDATE);
            String sql = "";
            int updateNum = -1;
            sql = this.getObjToSQL().toUpdateSQL(entity);
            this._regEntityClass(entity);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL("update SQL: ", sql);
            int n = updateNum = this.getBeeSql().modify(sql);
            return n;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int insert(T entity) {
        if (entity == null) {
            return -1;
        }
        try {
            this.doBeforePasreEntity(entity, SuidType.INSERT);
            _ObjectToSQLHelper.setInitIdByAuto(entity);
            String sql = this.getObjToSQL().toInsertSQL(entity);
            this._regEntityClass(entity);
            sql = this.doAfterCompleteSql(sql);
            int insertNum = -1;
            Logger.logSQL("insert SQL: ", sql);
            HoneyUtil.revertId(entity);
            if (OneTimeParameter.isTrue("_SYS_Bee_NullObjectInsert")) {
                Logger.warn("All fields in object is null,would ignroe it!");
                insertNum = 0;
            } else {
                insertNum = this.getBeeSql().modify(sql);
            }
            int n = insertNum;
            return n;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    private <T> void checkGenPk(T entity) {
        boolean isOk;
        boolean bl = isOk = HoneyUtil.isMysql() || HoneyUtil.isOracle() || HoneyUtil.isSQLite() || HoneyContext.isNeedGenId(entity.getClass()) || HoneyUtil.getIdValue(entity) != null || HoneyUtil.hasGenPkAnno(entity);
        if (!isOk) {
            throw new NotSupportedException("The current database don't support insert NULL to 'id' column or return the id after insert.\nYou can use the distribute id via set config information,eg: bee.distribution.genid.forAllTableLongId=true");
        }
    }

    private <T> String _toInsertAndReturnSql(T entity) {
        this.doBeforePasreEntity(entity, SuidType.INSERT);
        _ObjectToSQLHelper.setInitIdByAuto(entity);
        String sql = this.getObjToSQL().toInsertSQL(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("insert SQL: ", sql);
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> long insertAndReturnId(T entity) {
        if (entity == null) {
            return -1L;
        }
        this.checkGenPk(entity);
        try {
            String sql = this._toInsertAndReturnSql(entity);
            long l = this._insertAndReturnId(entity, sql);
            return l;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    <T> long _insertAndReturnId(T entity, String sql) {
        String pkName;
        this._regEntityClass(entity);
        Object obj = HoneyUtil.getIdValue(entity);
        HoneyUtil.revertId(entity);
        long returnId = -1L;
        if (obj != null) {
            returnId = Long.parseLong(obj.toString());
            if (returnId > 1L) {
                int insertNum = this.getBeeSql().modify(sql);
                if (insertNum == 1) {
                    return returnId;
                }
                return insertNum;
            }
            if (HoneyUtil.isOracle()) {
                Logger.debug("Need create Sequence and Trigger for auto increment id. By the way,maybe use distribute id is better!");
            }
        }
        if ("".equals(pkName = HoneyUtil.getPkFieldName(entity)) || pkName.contains(",")) {
            pkName = "id";
        }
        OneTimeParameter.setAttribute("_SYS_Bee_PK_Name_For_InsertAndReturnId", pkName);
        returnId = this.getBeeSql().insertAndReturnId(sql);
        return returnId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Object entity) {
        if (entity == null) {
            return -1;
        }
        try {
            this.doBeforePasreEntity(entity, SuidType.DELETE);
            String sql = this.getObjToSQL().toDeleteSQL(entity);
            this._regEntityClass(entity);
            sql = this.doAfterCompleteSql(sql);
            int deleteNum = -1;
            Logger.logSQL("delete SQL: ", sql);
            int n = deleteNum = this.getBeeSql().modify(sql);
            return n;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> select(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        List list = null;
        try {
            this.regCondition(condition);
            this.doBeforePasreEntity(entity, SuidType.SELECT);
            OneTimeParameter.setTrueForKey("_SYS_Bee_Check_Group_ForSharding");
            String sql = this.getObjToSQL().toSelectSQL(entity, condition);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL("select SQL: ", sql);
            list = this.getBeeSql().select(sql, this.toClassT(entity));
        }
        catch (Throwable throwable) {
            this.doBeforeReturn(list);
            throw throwable;
        }
        this.doBeforeReturn(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int delete(T entity, Condition condition) {
        if (entity == null) {
            return -1;
        }
        try {
            this.regCondition(condition);
            this.doBeforePasreEntity(entity, SuidType.DELETE);
            String sql = this.getObjToSQL().toDeleteSQL(entity, condition);
            this._regEntityClass(entity);
            sql = this.doAfterCompleteSql(sql);
            int deleteNum = -1;
            if (!"".equals(sql)) {
                Logger.logSQL("delete SQL: ", sql);
            }
            int n = deleteNum = this.getBeeSql().modify(sql);
            return n;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    public Suid setDynamicParameter(String para, String value) {
        OneTimeParameter.setAttribute(para, value);
        return this;
    }

    private <T> void _regEntityClass(T entity) {
        HoneyContext.regEntityClass(entity.getClass());
    }

    public void beginSameConnection() {
        OneTimeParameter.setTrueForKey("_SYS_Bee_SAME_CONN_BEGIN");
        if (OneTimeParameter.isTrue("_SYS_Bee_SAME_CONN_EXCEPTION")) {
            Logger.warn("Last SameConnection do not have endSameConnection() or do not run endSameConnection() after having exception.");
        }
    }

    public void endSameConnection() {
        HoneyContext.endSameConnection();
    }

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            this.beeSql = BeeFactory.getHoneyFactory().getBeeSql();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    public ObjToSQL getObjToSQL() {
        if (this.objToSQL == null) {
            this.objToSQL = BeeFactory.getHoneyFactory().getObjToSQL();
        }
        return this.objToSQL;
    }

    public void setObjToSQL(ObjToSQL objToSQL) {
        this.objToSQL = objToSQL;
    }
}

