/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.app.BeeSqlForApp;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.annotation.JoinTable;
import org.teasoft.bee.osql.annotation.customizable.Json;
import org.teasoft.bee.osql.type.SetParaTypeConvert;
import org.teasoft.bee.osql.type.TypeHandler;
import org.teasoft.honey.osql.core.AbstractBase;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MoreTableStruct;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.SqlLibEmptyForApp;
import org.teasoft.honey.osql.type.SetParaTypeConverterRegistry;
import org.teasoft.honey.osql.type.TypeHandlerRegistry;
import org.teasoft.honey.util.ObjectCreatorFactory;

public class SqlLibForApp
extends AbstractBase
implements BeeSql,
Serializable {
    private static final long serialVersionUID = 1596710362262L;
    private static boolean showSQL = HoneyConfig.getHoneyConfig().showSQL;
    private BeeSqlForApp beeSqlForApp;
    private static boolean isFirst = true;
    private static String SUCCESS_MSG = "[Bee] ==========Load BeeSqlForApp implement class successfully!";
    private static final String INDEX1 = "_SYS[index";
    private static final String INDEX2 = "]_End ";
    private static final String INDEX3 = "]";
    private static final String INSERT_ARRAY_SQL = " insert[] SQL : ";
    private static final String[] EMPTY_ARRAY = new String[0];

    public ResultSet selectRs(String sql) {
        return null;
    }

    public BeeSqlForApp getBeeSqlForApp() {
        if (this.beeSqlForApp != null) {
            return this.beeSqlForApp;
        }
        try {
            if (HoneyConfig.getHoneyConfig().isAndroid) {
                this.beeSqlForApp = (BeeSqlForApp)Class.forName("org.teasoft.beex.android.SqlLibExtForAndroid").newInstance();
            } else if (HoneyConfig.getHoneyConfig().isHarmony) {
                this.beeSqlForApp = (BeeSqlForApp)Class.forName("org.teasoft.beex.harmony.SqlLibExtForHarmony").newInstance();
            }
            if (isFirst) {
                Logger.info(SUCCESS_MSG);
                isFirst = false;
            } else {
                Logger.debug(SUCCESS_MSG);
            }
        }
        catch (Exception e) {
            Logger.warn(e.getMessage(), e);
        }
        if (this.beeSqlForApp == null) {
            Logger.warn("[Bee] ==========Load BeeSqlForApp implement class fail!");
            this.beeSqlForApp = new SqlLibEmptyForApp();
        }
        return this.beeSqlForApp;
    }

    public void setBeeSqlForApp(BeeSqlForApp beeSqlForApp) {
        this.beeSqlForApp = beeSqlForApp;
    }

    public <T> List<T> select(String sql, Class<T> entityClass) {
        return this.selectSomeField(sql, entityClass);
    }

    public <T> List<T> selectSomeField(String sql, Class<T> entityClass) {
        if (sql == null || "".equals(sql.trim())) {
            return Collections.emptyList();
        }
        boolean isReg = this.updateInfoInCache(sql, "List<T>", SuidType.SELECT, entityClass);
        if (isReg) {
            this.initRoute(SuidType.SELECT, entityClass, sql);
            Object cacheObj = this.getCache().get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                List list = (List)cacheObj;
                this.logSelectRows(list.size());
                return list;
            }
        }
        List rsList = null;
        try {
            rsList = this.getBeeSqlForApp().select(sql, entityClass, this.toStringArray(sql));
            this.addInCache(sql, rsList, rsList.size());
        }
        catch (Exception e) {
            throw ExceptionHelper.convert(e);
        }
        finally {
            this.clearContext(sql);
        }
        this.logSelectRows(rsList.size());
        return rsList;
    }

    public String selectFun(String sql) {
        Class entityClass = (Class)OneTimeParameter.getAttribute("_SYS_Bee_ROUTE_EC");
        if (sql == null || "".equals(sql.trim())) {
            return null;
        }
        boolean isReg = this.updateInfoInCache(sql, "String", SuidType.SELECT, entityClass);
        if (isReg) {
            this.initRoute(SuidType.SELECT, null, sql);
            Object cacheObj = this.getCache().get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                return (String)cacheObj;
            }
        }
        String result = null;
        try {
            result = this.getBeeSqlForApp().selectFun(sql, this.toStringArray(sql));
            this.addInCache(sql, result, 1);
        }
        catch (Exception e) {
            throw ExceptionHelper.convert(e);
        }
        finally {
            this.clearContext(sql);
        }
        return result;
    }

    public List<String[]> select(String sql) {
        Class entityClass = (Class)OneTimeParameter.getAttribute("_SYS_Bee_ROUTE_EC");
        if (sql == null || "".equals(sql.trim())) {
            return Collections.emptyList();
        }
        boolean isReg = this.updateInfoInCache(sql, "List<String[]>", SuidType.SELECT, entityClass);
        if (isReg) {
            this.initRoute(SuidType.SELECT, null, sql);
            Object cacheObj = this.getCache().get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                List list = (List)cacheObj;
                this.logSelectRows(list.size());
                return list;
            }
        }
        List<String[]> list = new ArrayList();
        try {
            list = this.getBeeSqlForApp().select(sql, this.toStringArray(sql));
            this.logSelectRows(list.size());
            this.addInCache(sql, list, list.size());
        }
        catch (Exception e) {
            throw ExceptionHelper.convert(e);
        }
        finally {
            this.clearContext(sql);
        }
        return list;
    }

    public List<Map<String, Object>> selectMapList(String sql) {
        if (sql == null || "".equals(sql.trim())) {
            return Collections.emptyList();
        }
        boolean isReg = this.updateInfoInCache(sql, "List<Map<String,Object>>", SuidType.SELECT, null);
        if (isReg) {
            this.initRoute(SuidType.SELECT, null, sql);
            Object cacheObj = this.getCache().get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                List list = (List)cacheObj;
                this.logSelectRows(list.size());
                return list;
            }
        }
        List<Map<String, Object>> list = new ArrayList();
        try {
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            list = this.getBeeSqlForApp().selectMapList(exe_sql, this.toStringArray(sql));
            this.logSelectRows(list.size());
            this.addInCache(sql, list, list.size());
        }
        catch (Exception e) {
            throw ExceptionHelper.convert(e);
        }
        finally {
            this.clearContext(sql);
        }
        return list;
    }

    public String selectJson(String sql) {
        Class entityClass = (Class)OneTimeParameter.getAttribute("_SYS_Bee_ROUTE_EC");
        if (sql == null || "".equals(sql.trim())) {
            return null;
        }
        boolean isReg = this.updateInfoInCache(sql, "StringJson", SuidType.SELECT, entityClass);
        if (isReg) {
            this.initRoute(SuidType.SELECT, entityClass, sql);
            Object cacheObj = this.getCache().get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                return (String)cacheObj;
            }
        }
        String json = "";
        try {
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            json = this.getBeeSqlForApp().selectJson(exe_sql, this.toStringArray(sql), entityClass);
            this.addInCache(sql, json, -1);
        }
        catch (Exception e) {
            throw ExceptionHelper.convert(e);
        }
        finally {
            this.clearContext(sql);
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int modify(String sql) {
        Class entityClass = (Class)OneTimeParameter.getAttribute("_SYS_Bee_ROUTE_EC");
        if (sql == null || "".equals(sql)) {
            return -2;
        }
        this.initRoute(SuidType.MODIFY, entityClass, sql);
        int num = 0;
        try {
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            num = this.getBeeSqlForApp().modify(exe_sql, this.toObjArray(sql));
        }
        finally {
            this.clearInCache(sql, "int", SuidType.MODIFY, num);
        }
        Logger.logSQL(" | <--  Affected rows: ", num + "");
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insertAndReturnId(String sql) {
        if (sql == null || "".equals(sql)) {
            return -2L;
        }
        this.initRoute(SuidType.INSERT, null, sql);
        long returnId = -1L;
        int num = 1;
        try {
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            returnId = this.getBeeSqlForApp().insertAndReturnId(exe_sql, this.toObjArray(sql));
            if (returnId == -1L) {
                num = 0;
            }
        }
        finally {
            this.clearInCache(sql, "int", SuidType.INSERT, num);
        }
        Logger.logSQL(" | <--  Affected rows: ", num + "");
        return returnId;
    }

    public int batch(String[] sql) {
        if (sql == null) {
            return -1;
        }
        int batchSize = HoneyConfig.getHoneyConfig().insertBatchSize;
        return this.batch(sql, batchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int batch(String[] sql, int batchSize) {
        if (sql == null || sql.length < 1) {
            return -1;
        }
        this.initRoute(SuidType.INSERT, null, sql[0]);
        int len = sql.length;
        int total = 0;
        int temp = 0;
        try {
            if (len <= batchSize) {
                total = this.batch(sql[0], 0, len);
            } else {
                for (int i = 0; i < len / batchSize; ++i) {
                    temp = this.batch(sql[0], i * batchSize, (i + 1) * batchSize);
                    total += temp;
                }
                if (len % batchSize != 0) {
                    temp = this.batch(sql[0], len - len % batchSize, len);
                    total += temp;
                }
            }
        }
        catch (Exception e) {
            this.clearContext(sql[0], batchSize, len);
        }
        finally {
            this.clearInCache(sql[0], "int[]", SuidType.INSERT, total);
        }
        return total;
    }

    private int batch(String sql, int start, int end) {
        int a = 0;
        ArrayList<Object[]> listBindArgs = new ArrayList<Object[]>(end - start);
        for (int i = start; i < end; ++i) {
            if (showSQL) {
                if (i == 0) {
                    Logger.logSQL(INSERT_ARRAY_SQL, sql);
                }
                OneTimeParameter.setAttribute("_SYS_Bee_BatchInsert", i + "");
                String sql_i = INDEX1 + i + INDEX2 + sql;
                Logger.logSQL(INSERT_ARRAY_SQL, sql_i);
            }
            listBindArgs.add(this.toObjArray(INDEX1 + i + INDEX2 + sql, false));
        }
        sql = HoneyUtil.deleteLastSemicolon(sql);
        a = this.getBeeSqlForApp().batchInsert(sql, listBindArgs);
        Logger.logSQL(" | <-- index[" + start + "~" + (end - 1) + INDEX3 + " Affected rows: ", a + "");
        return a;
    }

    public <T> List<T> moreTableSelect(String sql, T entity) {
        if (sql == null || "".equals(sql.trim())) {
            return Collections.emptyList();
        }
        MoreTableStruct[] moreTableStruct = HoneyUtil.getMoreTableStructAndCheckBefore(entity);
        if (moreTableStruct == null) {
            OneTimeParameter.setTrueForKey("_SYS_Bee_MoreStruct_to_SqlLib");
            moreTableStruct = HoneyUtil.getMoreTableStructAndCheckBefore(entity);
        }
        boolean subOneIsList1 = moreTableStruct[0].subOneIsList;
        boolean subTwoIsList2 = moreTableStruct[0].subTwoIsList;
        String listFieldType = "" + subOneIsList1 + subTwoIsList2 + moreTableStruct[0].oneHasOne;
        boolean isReg = this.updateInfoInCache(sql, "List<T>" + listFieldType, SuidType.SELECT, entity.getClass());
        if (isReg) {
            this.initRoute(SuidType.SELECT, entity.getClass(), sql);
            Object cacheObj = this.getCache().get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                List list = (List)cacheObj;
                this.logSelectRows(list.size());
                return list;
            }
        }
        Object targetObj = null;
        ArrayList rsList = null;
        boolean hasException = false;
        int recordRow = 0;
        try {
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            List rsMapList = this.getBeeSqlForApp().selectMapListWithColumnName(exe_sql, this.toStringArray(sql));
            rsList = new ArrayList();
            Field[] field = HoneyUtil.getFields(entity.getClass());
            boolean oneHasOne = moreTableStruct[0].oneHasOne;
            Field[] subField = new Field[2];
            String[] subUseTable = new String[2];
            String[] variableName = new String[2];
            Class[] subEntityFieldClass = new Class[2];
            for (int i = 1; i <= 2; ++i) {
                if (moreTableStruct[i] == null) continue;
                subField[i - 1] = moreTableStruct[i].subEntityField;
                variableName[i - 1] = subField[i - 1].getName();
                if (subOneIsList1 && i == 1) {
                    subEntityFieldClass[0] = moreTableStruct[1].subClass;
                } else if (subTwoIsList2 && i == 2) {
                    subEntityFieldClass[1] = moreTableStruct[2].subClass;
                } else {
                    subEntityFieldClass[i - 1] = subField[i - 1].getType();
                }
                subUseTable[i - 1] = moreTableStruct[i].useSubTableName;
            }
            Field[] fields1 = HoneyUtil.getFields(subEntityFieldClass[0]);
            Field[] fields2 = null;
            if (subField[1] != null) {
                fields2 = HoneyUtil.getFields(subEntityFieldClass[1]);
            }
            Map<String, String> dulSubFieldMap = moreTableStruct[0].subDulFieldMap;
            boolean sub1_first = true;
            boolean sub2_first = true;
            Object v1 = null;
            Object v2 = null;
            HashMap subOneMap = null;
            HashMap<String, ArrayList<Object>> subTwoMap = null;
            if (subOneIsList1) {
                subOneMap = new HashMap();
            }
            if (subTwoIsList2) {
                subTwoMap = new HashMap<String, ArrayList<Object>>();
            }
            StringBuffer checkKey = null;
            StringBuffer checkKey2ForOneHasOne = null;
            String tableName = moreTableStruct[0].tableName;
            Map rsMap = null;
            for (int m = 0; m < rsMapList.size(); ++m) {
                rsMap = (Map)rsMapList.get(m);
                ++recordRow;
                boolean isDul = false;
                String dulField = "";
                sub2_first = true;
                Object subObj2 = null;
                if (subField[1] != null) {
                    String columnName = "";
                    for (int i = 0; i < fields2.length; ++i) {
                        if (HoneyUtil.isSkipField(fields2[i])) continue;
                        boolean isRegHandlerPriority2 = false;
                        if (openFieldTypeHandler) {
                            isRegHandlerPriority2 = TypeHandlerRegistry.isPriorityType(fields2[i].getType());
                        }
                        v2 = null;
                        HoneyUtil.setAccessibleTrue(fields2[i]);
                        isDul = false;
                        dulField = "";
                        try {
                            TypeHandler<Json> jsonHandler;
                            columnName = SqlLibForApp._toColumnName(fields2[i].getName(), subEntityFieldClass[1]);
                            String tempCName2 = "";
                            if (this.isConfuseDuplicateFieldDB()) {
                                dulField = dulSubFieldMap.get(subUseTable[1] + "." + columnName);
                                if (dulField != null) {
                                    isDul = true;
                                    tempCName2 = dulField;
                                } else {
                                    tempCName2 = columnName;
                                }
                            } else {
                                tempCName2 = subUseTable[1] + "." + columnName;
                            }
                            v2 = ObjectCreatorFactory.create((String)rsMap.get(tempCName2), fields2[i].getType());
                            boolean processAsJson = false;
                            if (this.isJoson(fields2[i]) && (jsonHandler = TypeHandlerRegistry.getHandler(Json.class)) != null) {
                                v2 = this.jsonHandlerProcess(fields2[i], v2, jsonHandler);
                                processAsJson = true;
                            }
                            if (!processAsJson && isRegHandlerPriority2) {
                                v2 = TypeHandlerRegistry.handlerProcess(fields2[i].getType(), v2);
                            }
                            if (v2 == null) continue;
                            if (sub2_first) {
                                subObj2 = this.createObject(subEntityFieldClass[1]);
                                sub2_first = false;
                            }
                            HoneyUtil.setFieldValue(fields2[i], subObj2, v2);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            Logger.error(e.getMessage(), e);
                        }
                    }
                }
                sub1_first = true;
                Field subField2InOneHasOne = null;
                if (oneHasOne) {
                    checkKey2ForOneHasOne = new StringBuffer();
                }
                Object subObj1 = subEntityFieldClass[0].newInstance();
                for (int i = 0; i < fields1.length; ++i) {
                    if (oneHasOne ? HoneyUtil.isSkipFieldForMoreTable(fields1[i]) : HoneyUtil.isSkipField(fields1[i])) continue;
                    boolean isRegHandlerPriority1 = false;
                    if (openFieldTypeHandler) {
                        isRegHandlerPriority1 = TypeHandlerRegistry.isPriorityType(fields1[i].getType());
                    }
                    v1 = null;
                    HoneyUtil.setAccessibleTrue(fields1[i]);
                    isDul = false;
                    dulField = "";
                    try {
                        TypeHandler<Json> jsonHandler;
                        if (oneHasOne && fields1[i] != null && fields1[i].isAnnotationPresent(JoinTable.class)) {
                            if (subField[1] == null || !fields1[i].getName().equals(variableName[1]) || subObj2 == null) continue;
                            HoneyUtil.setAccessibleTrue(fields1[i]);
                            if (subTwoIsList2) {
                                subField2InOneHasOne = fields1[i];
                            } else {
                                HoneyUtil.setFieldValue(fields1[i], subObj1, subObj2);
                            }
                            if (!sub1_first) continue;
                            sub1_first = false;
                            continue;
                        }
                        String columnName = SqlLibForApp._toColumnName(fields1[i].getName(), subEntityFieldClass[0]);
                        String tempCName1 = "";
                        if (this.isConfuseDuplicateFieldDB()) {
                            dulField = dulSubFieldMap.get(subUseTable[0] + "." + columnName);
                            if (dulField != null) {
                                isDul = true;
                                tempCName1 = dulField;
                            } else {
                                tempCName1 = columnName;
                            }
                        } else {
                            tempCName1 = subUseTable[0] + "." + columnName;
                        }
                        v1 = ObjectCreatorFactory.create((String)rsMap.get(tempCName1), fields1[i].getType());
                        boolean processAsJson = false;
                        if (this.isJoson(fields1[i]) && (jsonHandler = TypeHandlerRegistry.getHandler(Json.class)) != null) {
                            v1 = this.jsonHandlerProcess(fields1[i], v1, jsonHandler);
                            processAsJson = true;
                        }
                        if (!processAsJson && isRegHandlerPriority1) {
                            v1 = TypeHandlerRegistry.handlerProcess(fields1[i].getType(), v1);
                        }
                        if (v1 != null) {
                            if (sub1_first) {
                                sub1_first = false;
                            }
                            HoneyUtil.setFieldValue(fields1[i], subObj1, v1);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Logger.error(e.getMessage(), e);
                    }
                    if (!oneHasOne) continue;
                    checkKey2ForOneHasOne.append(v1);
                }
                if (sub1_first && (!oneHasOne || oneHasOne && sub2_first)) {
                    subObj1 = null;
                }
                checkKey = new StringBuffer();
                Field subOneListField = null;
                Field subTwoListField = null;
                targetObj = entity.getClass().newInstance();
                for (int i = 0; i < field.length; ++i) {
                    if (HoneyUtil.isSkipFieldForMoreTable(field[i])) continue;
                    if (field[i] != null && field[i].isAnnotationPresent(JoinTable.class)) {
                        HoneyUtil.setAccessibleTrue(field[i]);
                        if (field[i].getName().equals(variableName[0])) {
                            if (subOneIsList1) {
                                subOneListField = field[i];
                                continue;
                            }
                            HoneyUtil.setFieldValue(field[i], targetObj, subObj1);
                            continue;
                        }
                        if (oneHasOne || subField[1] == null || !field[i].getName().equals(variableName[1])) continue;
                        if (subTwoIsList2) {
                            subTwoListField = field[i];
                            continue;
                        }
                        HoneyUtil.setFieldValue(field[i], targetObj, subObj2);
                        continue;
                    }
                    boolean isRegHandlerPriority = false;
                    if (openFieldTypeHandler) {
                        isRegHandlerPriority = TypeHandlerRegistry.isPriorityType(field[i].getType());
                    }
                    HoneyUtil.setAccessibleTrue(field[i]);
                    Object v = null;
                    try {
                        TypeHandler<Json> jsonHandler;
                        String tempCName = "";
                        String tempValue = null;
                        if (this.isConfuseDuplicateFieldDB()) {
                            tempCName = SqlLibForApp._toColumnName(field[i].getName(), entity.getClass());
                            tempValue = (String)rsMap.get(tempCName);
                        } else {
                            tempCName = tableName + "." + SqlLibForApp._toColumnName(field[i].getName(), entity.getClass());
                            tempValue = (String)rsMap.get(tempCName);
                            if (tempValue == null) {
                                tempValue = SqlLibForApp._toColumnName(field[i].getName(), entity.getClass());
                            }
                        }
                        v = ObjectCreatorFactory.create(tempValue, field[i].getType());
                        boolean processAsJson = false;
                        if (this.isJoson(field[i]) && (jsonHandler = TypeHandlerRegistry.getHandler(Json.class)) != null) {
                            v = this.jsonHandlerProcess(field[i], v, jsonHandler);
                            processAsJson = true;
                        }
                        if (!processAsJson && isRegHandlerPriority) {
                            v = TypeHandlerRegistry.handlerProcess(field[i].getType(), v);
                        }
                        HoneyUtil.setFieldValue(field[i], targetObj, v);
                        checkKey.append(v);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        Logger.error(e.getMessage(), e);
                        continue;
                    }
                    catch (Exception e) {
                        HoneyUtil.setFieldValue(field[i], targetObj, null);
                    }
                }
                if (oneHasOne) {
                    checkKey2ForOneHasOne.insert(0, checkKey);
                }
                if (subTwoIsList2 && oneHasOne && subObj1 != null && subField2InOneHasOne != null) {
                    ArrayList<Object> subTwoList = (ArrayList<Object>)subTwoMap.get(checkKey2ForOneHasOne.toString());
                    if (subTwoList == null) {
                        subTwoList = new ArrayList<Object>();
                        subTwoList.add(subObj2);
                        HoneyUtil.setFieldValue(subField2InOneHasOne, subObj1, subTwoList);
                        subTwoMap.put(checkKey2ForOneHasOne.toString(), subTwoList);
                    } else {
                        subTwoList.add(subObj2);
                    }
                }
                if (subOneIsList1 && subObj1 != null) {
                    ArrayList subOneList = (ArrayList)subOneMap.get(checkKey.toString());
                    if (subOneList == null) {
                        subOneList = new ArrayList();
                        subOneList.add(subObj1);
                        HoneyUtil.setFieldValue(subOneListField, targetObj, subOneList);
                        subOneMap.put(checkKey.toString(), subOneList);
                        rsList.add(targetObj);
                        continue;
                    }
                    if (!oneHasOne) {
                        subOneList.add(subObj1);
                        continue;
                    }
                    if (subObj2 != null) continue;
                    subOneList.add(subObj1);
                    continue;
                }
                if (subTwoIsList2 && !oneHasOne && subObj2 != null) {
                    ArrayList<Object> subTwoList = (ArrayList<Object>)subTwoMap.get(checkKey.toString());
                    if (subTwoList == null) {
                        subTwoList = new ArrayList<Object>();
                        subTwoList.add(subObj2);
                        HoneyUtil.setFieldValue(subTwoListField, targetObj, subTwoList);
                        subTwoMap.put(checkKey.toString(), subTwoList);
                        rsList.add(targetObj);
                        continue;
                    }
                    subTwoList.add(subObj2);
                    continue;
                }
                rsList.add(targetObj);
            }
            this.addInCache(sql, rsList, rsList.size());
        }
        catch (IllegalAccessException e) {
            hasException = true;
            throw ExceptionHelper.convert(e);
        }
        catch (InstantiationException e) {
            hasException = true;
            throw ExceptionHelper.convert(e);
        }
        finally {
            this.clearContext(sql);
        }
        entity = null;
        targetObj = null;
        if (subOneIsList1 || subTwoIsList2) {
            Logger.logSQL(" | <--  ( select raw record rows: ", recordRow + " )");
        }
        this.logSelectRows(rsList.size());
        return rsList;
    }

    private String[] toStringArray(String sql) {
        List<PreparedValue> list = HoneyContext.justGetPreparedValue(sql);
        if (list == null) {
            return EMPTY_ARRAY;
        }
        String[] str = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Object ob = list.get(i).getValue();
            str[i] = ob != null ? ob.toString() : null;
        }
        return str;
    }

    private Object[] toObjArray(String sql) {
        return this.toObjArray(sql, true);
    }

    private Object[] toObjArray(String sql, boolean justGet) {
        List<PreparedValue> list = justGet ? HoneyContext.justGetPreparedValue(sql) : HoneyContext.getAndClearPreparedValue(sql);
        if (list == null) {
            return EMPTY_ARRAY;
        }
        Object[] obj = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SetParaTypeConvert<Json> converter;
            obj[i] = list.get(i).getValue();
            Field f = list.get(i).getField();
            if (f == null || !f.isAnnotationPresent(Json.class) || (converter = SetParaTypeConverterRegistry.getConverter(Json.class)) == null) continue;
            obj[i] = converter.convert(obj[i]);
        }
        return obj;
    }
}

