/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import org.teasoft.bee.osql.Properties;
import org.teasoft.bee.osql.annotation.SysValue;
import org.teasoft.honey.osql.core.BeeProp;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.util.GroupMap;
import org.teasoft.honey.util.ObjectCreatorFactory;
import org.teasoft.honey.util.StringUtils;

public class SysValueProcessor {
    private SysValueProcessor() {
    }

    public static <T> void process(T obj) {
        SysValueProcessor.process(obj, BeeProp.getBeeProp());
    }

    public static <T> void process(T obj, Properties prop) {
        Field[] f = obj.getClass().getDeclaredFields();
        String key = "";
        boolean printOverride = OneTimeParameter.isTrue("_SYS_Bee_need_override_properties");
        for (int i = 0; i < f.length; ++i) {
            SysValue sysValue;
            String value;
            if (!f[i].isAnnotationPresent(SysValue.class) || (value = (sysValue = f[i].getAnnotation(SysValue.class)).value()) == null || "".equals(value.trim())) continue;
            if ((value = value.trim()).startsWith("${") && value.endsWith("}")) {
                key = value.substring(2, value.length() - 1);
                String proValue = prop.getProp(key);
                if (proValue == null || StringUtils.isBlank(proValue) && !String.class.equals(f[i].getType())) continue;
                if (printOverride) {
                    System.out.println("[Bee] new config,  " + key + ":" + proValue + "   ;");
                }
                try {
                    Class<?> c = f[i].getType();
                    HoneyUtil.setAccessibleTrue(f[i]);
                    HoneyUtil.setFieldValue(f[i], obj, ObjectCreatorFactory.create(proValue, c));
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw ExceptionHelper.convert(e);
                }
            }
            System.err.println("SysValue maybe wrong: " + value);
        }
        Map<String, Map<String, String>> oldDbs = HoneyConfig.getHoneyConfig().getDbs();
        GroupMap gm = SysValueProcessor.getGroupMap(prop, oldDbs);
        if (gm != null && !gm.isEmpty()) {
            try {
                Field dbsF = obj.getClass().getDeclaredField("dbs");
                HoneyUtil.setAccessibleTrue(dbsF);
                HoneyUtil.setFieldValue(dbsF, obj, gm.getMap());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static GroupMap getGroupMap(Properties prop, Map<String, Map<String, String>> oldDbs) {
        Set keySet = prop.getKeys();
        GroupMap gm = null;
        if (keySet.isEmpty()) {
            return gm;
        }
        boolean has = false;
        for (String k : keySet) {
            if (!k.startsWith("bee.db.dbs[")) continue;
            if (!has) {
                has = true;
                gm = oldDbs != null && !oldDbs.isEmpty() ? new GroupMap(oldDbs) : new GroupMap();
            }
            int end = k.indexOf(93, 11);
            String tag = k.substring(11, end);
            gm.add(tag, k.substring(end + 2), prop.getProp(k));
        }
        return gm;
    }
}

