/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.annotation.GenId;
import org.teasoft.bee.osql.annotation.GenUUID;
import org.teasoft.bee.osql.api.Condition;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.bee.osql.exception.BeeIllegalBusinessException;
import org.teasoft.bee.sharding.GroupFunStruct;
import org.teasoft.honey.distribution.GenIdFactory;
import org.teasoft.honey.distribution.UUID;
import org.teasoft.honey.osql.core.ConditionHelper;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.osql.util.AnnoUtil;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.util.ObjectUtils;
import org.teasoft.honey.util.StringUtils;

final class _ObjectToSQLHelper {
    private static final String INSERT_INTO = K.insert + K.space + K.into + K.space;
    private static final String REPLACE_INTO = K.replace + K.space + K.into + K.space;
    private static boolean showSQL = HoneyConfig.getHoneyConfig().showSQL;

    private _ObjectToSQLHelper() {
    }

    static <T> String _toSelectSQL(T entity, String fieldNameList) {
        _ObjectToSQLHelper.checkPackage(entity);
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        try {
            String tableName = _ObjectToSQLHelper._toTableName(entity);
            Field[] fields = HoneyUtil.getFields(entity.getClass());
            sqlBuffer.append(K.select).append(" ").append(fieldNameList).append(" ").append(K.from).append(" ");
            sqlBuffer.append(tableName);
            boolean firstWhere = true;
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            for (int i = 0; i < len; ++i) {
                HoneyUtil.setAccessibleTrue(fields[i]);
                if (HoneyUtil.isContinue(-1, fields[i].get(entity), fields[i])) continue;
                if (firstWhere) {
                    sqlBuffer.append(" ").append(K.where).append(" ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" ").append(K.and).append(" ");
                }
                sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName(), entity.getClass()));
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                if (AnnoUtil.isJson(fields[i])) {
                    preparedValue.setField(fields[i]);
                }
                list.add(preparedValue);
            }
            sql = sqlBuffer.toString();
            _ObjectToSQLHelper.setContext(sql, list, tableName);
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    static <T> String _toSelectSQL(T entity, int includeType, Condition condition) {
        return _ObjectToSQLHelper._toSelectSQL(entity, includeType, condition, false);
    }

    static <T> String _toSelectSQL(T entity, int includeType, Condition condition, boolean isCheckOneFunction) {
        _ObjectToSQLHelper.checkPackage(entity);
        StringBuffer sqlBuffer = new StringBuffer();
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        boolean firstWhere = true;
        try {
            Field[] fields = HoneyUtil.getFields(entity.getClass());
            String packageAndClassName = entity.getClass().getName();
            String columnNames = HoneyContext.getBeanField(packageAndClassName);
            if (columnNames == null) {
                columnNames = HoneyUtil.getBeanField(fields, entity.getClass());
                HoneyContext.addBeanField(packageAndClassName, columnNames);
            }
            if (condition != null) {
                int size;
                condition.setSuidType(SuidType.SELECT);
                boolean checkGroup = OneTimeParameter.isTrue("_SYS_Bee_Check_Group_ForSharding") && ShardingUtil.hadSharding();
                List groupNameslist = condition.getGroupByFields();
                int n = size = groupNameslist == null ? -1 : groupNameslist.size();
                if (checkGroup) {
                    checkGroup = checkGroup && size >= 1;
                }
                OneTimeParameter.setTrueForKey("_SYS_Bee_Get_GroupFunStruct");
                String fun = ConditionHelper.processFunction(columnNames, condition);
                if (isCheckOneFunction) {
                    if (fun.contains(",")) {
                        throw new BeeErrorGrammarException("The method just support use one Function!");
                    }
                    if ("".equals(fun)) {
                        throw new BeeErrorGrammarException("The method need set the Function with Condition selectFun!");
                    }
                }
                String selectField = ConditionHelper.processSelectField(columnNames, condition);
                if (isCheckOneFunction) {
                    columnNames = fun;
                } else if (selectField != null && StringUtils.isEmpty(fun)) {
                    columnNames = selectField;
                } else if (selectField != null && StringUtils.isNotEmpty(fun)) {
                    columnNames = selectField + "," + fun;
                } else if (selectField == null && StringUtils.isNotEmpty(fun)) {
                    columnNames = fun;
                }
                if (checkGroup) {
                    Map orderByMap = condition.getOrderBy();
                    boolean isEmptyOrderByMap = orderByMap.size() == 0;
                    boolean needGroupWhenNoFun = false;
                    for (String g : groupNameslist) {
                        if (!(columnNames.contains("," + g) || columnNames.contains(g + ",") || columnNames.equals(g))) {
                            columnNames = columnNames + "," + g;
                        }
                        if (isEmptyOrderByMap) {
                            condition.orderBy(g);
                            continue;
                        }
                        if (needGroupWhenNoFun || orderByMap.containsKey(g)) continue;
                        needGroupWhenNoFun = true;
                    }
                    GroupFunStruct gfStruct = null;
                    if (StringUtils.isNotEmpty(fun)) {
                        gfStruct = (GroupFunStruct)OneTimeParameter.getAttribute("_SYS_Bee_Return_GroupFunStruct");
                    }
                    if (gfStruct != null) {
                        gfStruct.setGroupFields(groupNameslist);
                        gfStruct.setNeedGroupWhenNoFun(needGroupWhenNoFun);
                        gfStruct.setColumnNames(columnNames);
                        HoneyContext.setCurrentGroupFunStruct(gfStruct);
                    }
                }
            }
            sqlBuffer.append(K.select).append(" ").append(columnNames).append(" ").append(K.from).append(" ");
            sqlBuffer.append(tableName);
            int len = fields.length;
            PreparedValue preparedValue = null;
            for (int i = 0; i < len; ++i) {
                HoneyUtil.setAccessibleTrue(fields[i]);
                if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || _ObjectToSQLHelper.isNullPkOrId(fields[i], entity)) continue;
                if (firstWhere) {
                    sqlBuffer.append(" ").append(K.where).append(" ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" ").append(K.and).append(" ");
                }
                sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName(), entity.getClass()));
                if (fields[i].get(entity) == null) {
                    sqlBuffer.append(" ").append(K.isNull);
                    continue;
                }
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                if (AnnoUtil.isJson(fields[i])) {
                    preparedValue.setField(fields[i]);
                }
                list.add(preparedValue);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        if (condition != null) {
            condition.setSuidType(SuidType.SELECT);
            if (HoneyContext.isNeedRealTimeDb()) {
                HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
                OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
            }
            OneTimeParameter.setAttribute("_SYS_Bee_COLUMN_EC", entity.getClass());
            ConditionHelper.processCondition(sqlBuffer, list, condition, firstWhere);
        }
        _ObjectToSQLHelper.setContext(sqlBuffer.toString(), list, tableName);
        return sqlBuffer.toString();
    }

    static <T> String _toSelectSQL(T entity, int includeType) {
        return _ObjectToSQLHelper._toSelectSQL(entity, includeType, null);
    }

    static <T> String _toUpdateSQL(T entity, int includeType) {
        _ObjectToSQLHelper.checkPackage(entity);
        Field field = null;
        String pkName = "";
        String alias = "";
        try {
            field = HoneyUtil.getField(entity.getClass(), "id");
            pkName = "id";
        }
        catch (NoSuchFieldException e) {
            pkName = HoneyUtil.getPkFieldName(entity);
            if (!"".equals(pkName)) {
                alias = "(" + pkName + ")";
            }
            throw new ObjSQLException("ObjSQLException: in the update(T entity) or update(T entity,IncludeType includeType), the id field is missing !");
        }
        if (field == null && !pkName.contains(",")) {
            try {
                field = HoneyUtil.getField(entity.getClass(), pkName);
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
        }
        try {
            if (field != null) {
                HoneyUtil.setAccessibleTrue(field);
                if (field.get(entity) == null) {
                    throw new ObjSQLException("ObjSQLException: in the update(T entity) or update(T entity,IncludeType includeType), the id field" + alias + " of entity must not be null !");
                }
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        String[] pks = pkName.split(",");
        return _ObjectToSQLHelper._toUpdateBySQL(entity, pks, includeType);
    }

    static <T> String _toUpdateSQL(T entity, String[] setColmn, int includeType) {
        return _ObjectToSQLHelper._toUpdateSQL(entity, setColmn, includeType, null);
    }

    static <T> String _toUpdateSQL(T entity, String[] setColmns, int includeType, Condition condition) {
        boolean notUpdateWholeRecords;
        _ObjectToSQLHelper.checkPackage(entity);
        Set updatefieldSet = null;
        if (condition != null) {
            updatefieldSet = condition.getUpdatefields();
        }
        if ((setColmns == null || setColmns.length == 1 && "".equals(setColmns[0].trim())) && ObjectUtils.isEmpty(updatefieldSet)) {
            throw new ObjSQLException("ObjSQLException: in SQL update set at least include one field.");
        }
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        boolean firstSet = true;
        boolean firstWhere = true;
        boolean isExistWhere = false;
        StringBuffer whereStament = new StringBuffer();
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        try {
            sqlBuffer.append(K.update).append(" ");
            sqlBuffer.append(tableName);
            sqlBuffer.append(" ").append(K.set).append(" ");
            if (condition != null) {
                condition.setSuidType(SuidType.UPDATE);
                OneTimeParameter.setAttribute("_SYS_Bee_COLUMN_EC", entity.getClass());
                firstSet = ConditionHelper.processConditionForUpdateSet(sqlBuffer, list, condition);
            }
            Field[] fields = HoneyUtil.getFields(entity.getClass());
            int len = fields.length;
            ArrayList<PreparedValue> whereList = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            for (int i = 0; i < len; ++i) {
                HoneyUtil.setAccessibleTrue(fields[i]);
                if (_ObjectToSQLHelper.isContainField(setColmns, fields[i].getName()) && (updatefieldSet == null || !updatefieldSet.contains(fields[i].getName()))) {
                    if (firstSet) {
                        firstSet = false;
                    } else {
                        sqlBuffer.append(", ");
                    }
                    sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName(), entity.getClass()));
                    if (fields[i].get(entity) == null) {
                        sqlBuffer.append("=").append(K.Null);
                        continue;
                    }
                    sqlBuffer.append("=");
                    sqlBuffer.append("?");
                    preparedValue = new PreparedValue();
                    preparedValue.setType(fields[i].getType().getName());
                    preparedValue.setValue(fields[i].get(entity));
                    if (AnnoUtil.isJson(fields[i])) {
                        preparedValue.setField(fields[i]);
                    }
                    list.add(preparedValue);
                    continue;
                }
                if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || _ObjectToSQLHelper.isNullPkOrId(fields[i], entity)) continue;
                if (firstWhere) {
                    whereStament.append(" ").append(K.where).append(" ");
                    firstWhere = false;
                } else {
                    whereStament.append(" ").append(K.and).append(" ");
                }
                whereStament.append(_ObjectToSQLHelper._toColumnName(fields[i].getName(), entity.getClass()));
                if (fields[i].get(entity) == null) {
                    whereStament.append(" ").append(K.isNull);
                } else {
                    whereStament.append("=");
                    whereStament.append("?");
                    preparedValue = new PreparedValue();
                    preparedValue.setType(fields[i].getType().getName());
                    preparedValue.setValue(fields[i].get(entity));
                    if (AnnoUtil.isJson(fields[i])) {
                        preparedValue.setField(fields[i]);
                    }
                    whereList.add(preparedValue);
                }
                isExistWhere = true;
            }
            sqlBuffer.append(whereStament);
            list.addAll(whereList);
            if (firstSet) {
                Logger.logSQL("update SQL(updateFields) : ", sqlBuffer.toString());
                throw new BeeErrorGrammarException("BeeErrorGrammarException: the SQL update set part is empty!");
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        if (condition != null) {
            condition.setSuidType(SuidType.UPDATE);
            OneTimeParameter.setAttribute("_SYS_Bee_COLUMN_EC", entity.getClass());
            firstWhere = ConditionHelper.processCondition(sqlBuffer, list, condition, firstWhere);
        }
        sql = sqlBuffer.toString();
        _ObjectToSQLHelper.setContext(sql, list, tableName);
        if (firstWhere && (notUpdateWholeRecords = HoneyConfig.getHoneyConfig().notUpdateWholeRecords)) {
            Logger.logSQL("update SQL: ", sql);
            throw new BeeIllegalBusinessException("BeeIllegalBusinessException: It is not allowed update whole records in one table.");
        }
        return sql;
    }

    static <T> String _toUpdateBySQL(T entity, String[] whereColumns, int includeType) {
        return _ObjectToSQLHelper._toUpdateBySQL(entity, whereColumns, includeType, null);
    }

    static <T> String _toUpdateBySQL(T entity, String[] whereColumns, int includeType, Condition condition) {
        boolean notUpdateWholeRecords;
        _ObjectToSQLHelper.checkPackage(entity);
        Set conditionFieldSet = null;
        if (condition != null) {
            conditionFieldSet = condition.getWhereFields();
        }
        Set updatefieldSet = null;
        if (condition != null) {
            updatefieldSet = condition.getUpdatefields();
        }
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        boolean firstSet = true;
        boolean firstWhere = true;
        boolean isExistWhere = false;
        StringBuffer whereStament = new StringBuffer();
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        try {
            sqlBuffer.append(K.update).append(" ");
            sqlBuffer.append(tableName);
            sqlBuffer.append(" ").append(K.set).append(" ");
            if (condition != null) {
                condition.setSuidType(SuidType.UPDATE);
                OneTimeParameter.setAttribute("_SYS_Bee_COLUMN_EC", entity.getClass());
                firstSet = ConditionHelper.processConditionForUpdateSet(sqlBuffer, list, condition);
            }
            Field[] fields = HoneyUtil.getFields(entity.getClass());
            int len = fields.length;
            ArrayList<PreparedValue> whereList = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            for (int i = 0; i < len; ++i) {
                HoneyUtil.setAccessibleTrue(fields[i]);
                if (!_ObjectToSQLHelper.isContainField(whereColumns, fields[i].getName())) {
                    if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || _ObjectToSQLHelper.isNullPkOrId(fields[i], entity)) continue;
                    if (updatefieldSet != null && updatefieldSet.contains(fields[i].getName())) {
                        Logger.warn("The field [" + fields[i].getName() + "] which value is '" + fields[i].get(entity) + "', already set in condition! It will be ignored!");
                        continue;
                    }
                    if (firstSet) {
                        firstSet = false;
                    } else {
                        sqlBuffer.append(" , ");
                    }
                    sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName(), entity.getClass()));
                    if (fields[i].get(entity) == null) {
                        sqlBuffer.append(" =").append(K.Null);
                        continue;
                    }
                    sqlBuffer.append("=");
                    sqlBuffer.append("?");
                    preparedValue = new PreparedValue();
                    preparedValue.setType(fields[i].getType().getName());
                    preparedValue.setValue(fields[i].get(entity));
                    if (AnnoUtil.isJson(fields[i])) {
                        preparedValue.setField(fields[i]);
                    }
                    list.add(preparedValue);
                    continue;
                }
                if (conditionFieldSet != null && conditionFieldSet.contains(fields[i].getName()) && HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || _ObjectToSQLHelper.isNullPkOrId(fields[i], entity)) continue;
                if (firstWhere) {
                    whereStament.append(" ").append(K.where).append(" ");
                    firstWhere = false;
                } else {
                    whereStament.append(" ").append(K.and).append(" ");
                }
                whereStament.append(_ObjectToSQLHelper._toColumnName(fields[i].getName(), entity.getClass()));
                if (fields[i].get(entity) == null) {
                    whereStament.append(" ").append(K.isNull);
                } else {
                    whereStament.append("=");
                    whereStament.append("?");
                    preparedValue = new PreparedValue();
                    preparedValue.setType(fields[i].getType().getName());
                    preparedValue.setValue(fields[i].get(entity));
                    if (AnnoUtil.isJson(fields[i])) {
                        preparedValue.setField(fields[i]);
                    }
                    whereList.add(preparedValue);
                }
                isExistWhere = true;
            }
            sqlBuffer.append(whereStament);
            list.addAll(whereList);
            if (firstSet) {
                Logger.logSQL("update SQL(updateFields) : ", sqlBuffer.toString());
                throw new BeeErrorGrammarException("BeeErrorGrammarException: the SQL update set part is empty!");
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        if (condition != null) {
            condition.setSuidType(SuidType.UPDATE);
            OneTimeParameter.setAttribute("_SYS_Bee_COLUMN_EC", entity.getClass());
            firstWhere = ConditionHelper.processCondition(sqlBuffer, list, condition, firstWhere);
        }
        sql = sqlBuffer.toString();
        _ObjectToSQLHelper.setContext(sql, list, tableName);
        if (firstWhere && (notUpdateWholeRecords = HoneyConfig.getHoneyConfig().notUpdateWholeRecords)) {
            Logger.logSQL("update SQL: ", sql);
            throw new BeeIllegalBusinessException("BeeIllegalBusinessException: It is not allowed update whole records in one table.");
        }
        return sql;
    }

    static <T> String _toInsertSQL0(T entity, int includeType, String excludeFieldList) throws IllegalAccessException {
        _ObjectToSQLHelper.checkPackage(entity);
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer sqlValue = new StringBuffer(" (");
        boolean isFirst = true;
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        if (HoneyUtil.isMysql() && AnnoUtil.isReplaceInto(entity)) {
            sqlBuffer.append(REPLACE_INTO);
        } else {
            sqlBuffer.append(INSERT_INTO);
        }
        sqlBuffer.append(tableName);
        sqlBuffer.append("(");
        Field[] fields = HoneyUtil.getFields(entity.getClass());
        int len = fields.length;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        for (int i = 0; i < len; ++i) {
            HoneyUtil.setAccessibleTrue(fields[i]);
            if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || !"".equals(excludeFieldList) && _ObjectToSQLHelper.isExcludeField(excludeFieldList, fields[i].getName())) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                sqlBuffer.append(",");
                sqlValue.append(",");
            }
            sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName(), entity.getClass()));
            sqlValue.append("?");
            preparedValue = new PreparedValue();
            preparedValue.setType(fields[i].getType().getName());
            preparedValue.setValue(fields[i].get(entity));
            if (AnnoUtil.isJson(fields[i])) {
                preparedValue.setField(fields[i]);
            }
            list.add(preparedValue);
        }
        sqlValue.append(")");
        sqlBuffer.append(") ").append(K.values);
        sqlBuffer.append(sqlValue);
        sql = sqlBuffer.toString();
        if (isFirst) {
            OneTimeParameter.setTrueForKey("_SYS_Bee_NullObjectInsert");
        }
        if (OneTimeParameter.isTrue("_SYS_Bee_Return_PlaceholderValue")) {
            OneTimeParameter.setAttribute("_SYS_Bee_PlaceholderValue", sqlValue.toString());
        }
        _ObjectToSQLHelper.setContext(sql, list, tableName);
        return sql;
    }

    static <T> List<PreparedValue> _toInsertSQL_for_ValueList(String sql_i, T entity, String excludeFieldList) throws IllegalAccessException {
        _ObjectToSQLHelper.checkPackage(entity);
        Field[] fields = HoneyUtil.getFields(entity.getClass());
        int len = fields.length;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        for (int i = 0; i < len; ++i) {
            HoneyUtil.setAccessibleTrue(fields[i]);
            if (HoneyUtil.isSkipField(fields[i]) || HoneyUtil.isSkipFieldJustFetch(fields[i]) || !"".equals(excludeFieldList) && _ObjectToSQLHelper.isExcludeField(excludeFieldList, fields[i].getName())) continue;
            preparedValue = new PreparedValue();
            preparedValue.setType(fields[i].getType().getName());
            preparedValue.setValue(fields[i].get(entity));
            if (AnnoUtil.isJson(fields[i])) {
                preparedValue.setField(fields[i]);
            }
            list.add(preparedValue);
        }
        if (!HoneyUtil.isMysql() || showSQL) {
            HoneyContext.setPreparedValue(sql_i, list);
        }
        return list;
    }

    static <T> String _toDeleteSQL(T entity, int includeType) {
        return _ObjectToSQLHelper._toDeleteSQL(entity, includeType, null);
    }

    static <T> String _toDeleteSQL(T entity, int includeType, Condition condition) {
        _ObjectToSQLHelper.checkPackage(entity);
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        boolean firstWhere = true;
        try {
            boolean notDeleteWholeRecords;
            String tableName = _ObjectToSQLHelper._toTableName(entity);
            sqlBuffer.append(K.delete).append(" ").append(K.from).append(" ");
            sqlBuffer.append(tableName);
            Field[] fields = HoneyUtil.getFields(entity.getClass());
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            for (int i = 0; i < len; ++i) {
                HoneyUtil.setAccessibleTrue(fields[i]);
                if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || _ObjectToSQLHelper.isNullPkOrId(fields[i], entity)) continue;
                if (firstWhere) {
                    sqlBuffer.append(" ").append(K.where).append(" ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" ").append(K.and).append(" ");
                }
                sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName(), entity.getClass()));
                if (fields[i].get(entity) == null) {
                    sqlBuffer.append(" ").append(K.isNull);
                    continue;
                }
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                if (AnnoUtil.isJson(fields[i])) {
                    preparedValue.setField(fields[i]);
                }
                list.add(preparedValue);
            }
            if (condition != null) {
                condition.setSuidType(SuidType.DELETE);
                OneTimeParameter.setAttribute("_SYS_Bee_COLUMN_EC", entity.getClass());
                firstWhere = ConditionHelper.processCondition(sqlBuffer, list, condition, firstWhere);
            }
            sql = sqlBuffer.toString();
            _ObjectToSQLHelper.setContext(sql, list, tableName);
            if (firstWhere && (notDeleteWholeRecords = HoneyConfig.getHoneyConfig().notDeleteWholeRecords)) {
                Logger.logSQL("delete SQL: ", sql);
                throw new BeeIllegalBusinessException("BeeIllegalBusinessException: It is not allowed delete whole records in one table.");
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    private static boolean isContainField(String[] checkFields, String fieldName) {
        if (checkFields == null) {
            return false;
        }
        int len = checkFields.length;
        for (int i = 0; i < len; ++i) {
            if (!checkFields[i].equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isExcludeField(String excludeFieldList, String checkField) {
        String[] excludeFields;
        for (String f : excludeFields = excludeFieldList.split(",")) {
            if (!f.equals(checkField)) continue;
            return true;
        }
        return false;
    }

    static void setContext(String sql, List<PreparedValue> list, String tableName) {
        HoneyContext.setContext(sql, list, tableName);
    }

    private static <T> void checkPackage(T entity) {
        HoneyUtil.checkPackage(entity);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private static String _toColumnName(String fieldName, Class entityClass) {
        return NameTranslateHandle.toColumnName(fieldName, entityClass);
    }

    static <T> void setInitIdByAuto(T entity) {
        Object id;
        if (entity == null) {
            return;
        }
        Field field = null;
        boolean hasValue = false;
        Object obj = null;
        String pkName = "";
        String pkAlias = "";
        boolean isStringField = false;
        boolean hasGenUUIDAnno = false;
        boolean useSeparatorInUUID = false;
        try {
            boolean noId = false;
            try {
                field = HoneyUtil.getField(entity.getClass(), "id");
                pkName = "id";
            }
            catch (NoSuchFieldException e) {
                noId = true;
            }
            if (noId) {
                pkName = HoneyUtil.getPkFieldName(entity);
                if ("".equals(pkName) || pkName.contains(",")) {
                    return;
                }
                field = HoneyUtil.getField(entity.getClass(), pkName);
                pkAlias = "(" + pkName + ")";
            }
            if (field == null) {
                return;
            }
            boolean replaceOldValue = HoneyConfig.getHoneyConfig().genid_replaceOldId;
            if (field.isAnnotationPresent(GenId.class)) {
                GenId genId = field.getAnnotation(GenId.class);
                replaceOldValue = replaceOldValue || genId.override();
            } else if (field.isAnnotationPresent(GenUUID.class)) {
                GenUUID gen = field.getAnnotation(GenUUID.class);
                replaceOldValue = replaceOldValue || gen.override();
                hasGenUUIDAnno = true;
                useSeparatorInUUID = gen.useSeparator();
            } else {
                boolean needGenId = HoneyContext.isNeedGenId(entity.getClass());
                if (!needGenId) {
                    return;
                }
            }
            isStringField = field.getType().equals(String.class);
            if (hasGenUUIDAnno && !isStringField) {
                Logger.warn("Gen UUID as id just support String type field!");
                return;
            }
            if (_ObjectToSQLHelper.errorType(field)) {
                Logger.warn("The id" + pkAlias + " field's " + field.getType() + " is not Long/Integer, can not generate the Long/Integer id automatically!");
                return;
            }
            HoneyUtil.setAccessibleTrue(field);
            obj = field.get(entity);
            if (obj != null) {
                if (!replaceOldValue) {
                    return;
                }
                hasValue = true;
            }
            OneTimeParameter.setTrueForKey("_SYS_Bee_OLD_ID_FOR_AUTO_ID_EXIST");
            OneTimeParameter.setAttribute("_SYS_Bee_OLD_ID_FOR_AUTO_ID", obj);
            OneTimeParameter.setAttribute("_SYS_Bee_PK_NAME", pkName);
        }
        catch (NoSuchFieldException e) {
            return;
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return;
        }
        String tableKey = _ObjectToSQLHelper._toTableName(entity);
        if (_ObjectToSQLHelper.isInt(field)) {
            int intId = (int)GenIdFactory.get(tableKey, "IntSerialIdReturnLong");
            id = intId;
        } else if (hasGenUUIDAnno && isStringField) {
            id = UUID.getId(useSeparatorInUUID);
        } else if (isStringField) {
            id = GenIdFactory.get(tableKey) + "";
        } else {
            long longId = GenIdFactory.get(tableKey);
            id = longId;
        }
        HoneyUtil.setAccessibleTrue(field);
        try {
            HoneyUtil.setFieldValue(field, entity, id);
            if (hasValue) {
                Logger.warn(" [ID WOULD BE REPLACED] " + entity.getClass() + " 's id field" + pkAlias + " value is " + obj.toString() + " would be replace by " + id);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
    }

    static boolean errorType(Field field) {
        Class<?> type = field.getType();
        return !type.equals(Long.class) && !type.equals(Integer.class) && !type.equals(Long.TYPE) && !type.equals(Integer.TYPE) && !type.equals(String.class);
    }

    static boolean isInt(Field field) {
        Class<?> type = field.getType();
        return type.equals(Integer.class) || type.equals(Integer.TYPE);
    }

    private static boolean isNullPkOrId(Field field, Object entity) {
        try {
            if (field.get(entity) == null && _ObjectToSQLHelper.isPrimaryKey(field)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean isPrimaryKey(Field field) {
        if ("id".equalsIgnoreCase(field.getName())) {
            return true;
        }
        return AnnoUtil.isPrimaryKey(field);
    }
}

