/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.mongodb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.teasoft.bee.osql.Op;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.api.Condition;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.bee.osql.exception.BeeIllegalSQLException;
import org.teasoft.honey.osql.core.ConditionImpl;
import org.teasoft.honey.osql.core.Expression;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.mongodb.EasyMapUtil;
import org.teasoft.honey.osql.mongodb.ParseExpMap;
import org.teasoft.honey.util.StringUtils;

public class MongoConditionHelper {
    private static final String OR = "or";
    private static final String AND = "and";
    private static final String GROUP_BY = "groupBy";
    private static final String HAVING = "having";

    private MongoConditionHelper() {
    }

    public static Map<String, Object> processCondition(Condition condition) throws Exception {
        if (condition == null) {
            return null;
        }
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        List<Expression> expList = conditionImpl.getExpList();
        Expression expression = null;
        Integer start = conditionImpl.getStart();
        if (start != null && SuidType.SELECT != conditionImpl.getSuidType()) {
            throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support paging with start !");
        }
        int len = expList.size();
        for (int k = 0; k < len - 2; ++k) {
            String opType;
            if (expList.get(k).getOpNum() != -2 || expList.get(k + 2).getOpNum() != -1 || !" between ".equalsIgnoreCase(opType = expList.get(k + 1).getOpType()) && !" not between ".equalsIgnoreCase(opType) && !Op.like.getOperator().equalsIgnoreCase(opType) && !Op.notLike.getOperator().equalsIgnoreCase(opType) && !Op.in.getOperator().equalsIgnoreCase(opType) && !Op.notIn.getOperator().equalsIgnoreCase(opType) && expList.get(k + 1).getOpNum() != 2) continue;
            expList.remove(k + 2);
            expList.remove(k);
            len = expList.size();
        }
        String columnName = "";
        boolean isNeedAnd = false;
        Stack<Object> stack = new Stack<Object>();
        for (int j = 0; j < expList.size(); ++j) {
            String type;
            expression = expList.get(j);
            if (expression.getOpNum() == -2) {
                stack.push("(");
                continue;
            }
            if (expression.getOpNum() == -1) {
                stack.push(")");
                isNeedAnd = true;
                continue;
            }
            if (expression.getOpNum() == 1) {
                stack.push(expression.getValue().toString().toLowerCase());
                isNeedAnd = false;
                continue;
            }
            String opType = expression.getOpType();
            if ((GROUP_BY.equalsIgnoreCase(opType) || HAVING.equalsIgnoreCase(opType)) && SuidType.SELECT != conditionImpl.getSuidType()) {
                throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support the opType: " + opType + "!");
            }
            if (GROUP_BY.equalsIgnoreCase(opType) || "orderBy".equalsIgnoreCase(opType)) continue;
            columnName = MongoConditionHelper._toColumnName(expression.getFieldName(), null);
            if ("id".equalsIgnoreCase(columnName)) {
                columnName = "_id";
            }
            if (isNeedAnd) {
                stack.push(AND);
            }
            if (Op.in.getOperator().equalsIgnoreCase(opType) || Op.notIn.getOperator().equalsIgnoreCase(opType)) {
                Object v = expression.getValue();
                if (v == null) continue;
                Object listOrSet = MongoConditionHelper.processIn(v);
                if (Op.in.getOperator().equalsIgnoreCase(opType)) {
                    stack.push(EasyMapUtil.createMap(columnName, EasyMapUtil.createMap("$in", listOrSet)));
                } else if (Op.notIn.getOperator().equalsIgnoreCase(opType)) {
                    stack.push(EasyMapUtil.createMap(columnName, EasyMapUtil.createMap("$nin", listOrSet)));
                }
                isNeedAnd = true;
                continue;
            }
            if (Op.like.getOperator().equalsIgnoreCase(opType) || Op.notLike.getOperator().equalsIgnoreCase(opType)) {
                String v = (String)expression.getValue();
                String v2 = "^$";
                if (v != null && !"".equals(v)) {
                    Op op = expression.getOp();
                    v = StringUtils.escapeMatch(v);
                    v2 = Op.likeLeft == op ? v + "$" : (Op.likeRight == op ? "^" + v : (Op.likeLeftRight == op ? v : v));
                } else if (v == null) {
                    Logger.warn("the parameter value in like is null !", (Throwable)new BeeIllegalSQLException());
                }
                stack.push(EasyMapUtil.createMap(columnName, EasyMapUtil.createMap("$regex", v2)));
                isNeedAnd = true;
                continue;
            }
            if (" between ".equalsIgnoreCase(opType) || " not between ".equalsIgnoreCase(opType)) {
                if (" between ".equalsIgnoreCase(opType)) {
                    stack.push("(");
                    stack.push(EasyMapUtil.createMap(columnName, EasyMapUtil.createMap("$gte", expression.getValue())));
                    stack.push(AND);
                    stack.push(EasyMapUtil.createMap(columnName, EasyMapUtil.createMap("$lte", expression.getValue2())));
                    stack.push(")");
                } else if (" not between ".equalsIgnoreCase(opType)) {
                    stack.push("(");
                    stack.push(EasyMapUtil.createMap(columnName, EasyMapUtil.createMap("$lt", expression.getValue())));
                    stack.push(OR);
                    stack.push(EasyMapUtil.createMap(columnName, EasyMapUtil.createMap("$gt", expression.getValue2())));
                    stack.push(")");
                }
                isNeedAnd = true;
                continue;
            }
            if (expression.getValue() == null) {
                stack.push(EasyMapUtil.createMap(columnName, null));
                isNeedAnd = true;
                continue;
            }
            boolean find = true;
            switch (type = expression.getOpType()) {
                case "=": {
                    stack.push(EasyMapUtil.createMap(columnName, expression.getValue()));
                    break;
                }
                case "!=": {
                    stack.push(EasyMapUtil.createMap(columnName, EasyMapUtil.createMap("$ne", expression.getValue())));
                    break;
                }
                case ">": {
                    stack.push(EasyMapUtil.createMap(columnName, EasyMapUtil.createMap("$gt", expression.getValue())));
                    break;
                }
                case ">=": {
                    stack.push(EasyMapUtil.createMap(columnName, EasyMapUtil.createMap("$gte", expression.getValue())));
                    break;
                }
                case "<": {
                    stack.push(EasyMapUtil.createMap(columnName, EasyMapUtil.createMap("$lt", expression.getValue())));
                    break;
                }
                case "<=": {
                    stack.push(EasyMapUtil.createMap(columnName, EasyMapUtil.createMap("$lte", expression.getValue())));
                    break;
                }
                default: {
                    find = false;
                }
            }
            if (!find) continue;
            isNeedAnd = true;
        }
        if (stack.size() == 0) {
            return null;
        }
        return ParseExpMap.parse(stack);
    }

    private static Object processIn(Object v) {
        if (List.class.isAssignableFrom(v.getClass()) || Set.class.isAssignableFrom(v.getClass())) {
            return v;
        }
        ArrayList<Object> inList = new ArrayList<Object>();
        if (HoneyUtil.isNumberArray(v.getClass())) {
            Number[] n;
            for (Number number : n = (Number[])v) {
                inList.add(number);
            }
        } else if (v instanceof String) {
            String[] values;
            for (String e : values = v.toString().trim().split(",")) {
                inList.add(e);
            }
        } else {
            inList.add(v);
        }
        return inList;
    }

    private static String _toColumnName(String fieldName, Class entityClass) {
        return NameTranslateHandle.toColumnName(fieldName, entityClass);
    }
}

