/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding;

import org.teasoft.bee.osql.BeeException;
import org.teasoft.bee.osql.annotation.DsTabHandler;
import org.teasoft.bee.sharding.DsTabStruct;
import org.teasoft.bee.sharding.ShardingSimpleStruct;
import org.teasoft.bee.sharding.algorithm.Calculate;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.algorithm.CalculateFactory;
import org.teasoft.honey.sharding.config.ShardingRegistry;
import org.teasoft.honey.util.ObjectUtils;
import org.teasoft.honey.util.StringUtils;

public class DefaultAnnoDsTabHandler
implements DsTabHandler {
    private static final String dsRuleConst = "${dsRule}";
    private static final String tabRuleConst = "${tabRule}";

    public DsTabStruct process(ShardingSimpleStruct sharding) {
        String shardingValue = ObjectUtils.string(sharding.getDsShardingValue());
        DsTabStruct dsTabStruct = null;
        if (shardingValue == null) {
            return dsTabStruct;
        }
        dsTabStruct = new DsTabStruct();
        int dsAlgorithm = sharding.getDsAlgorithm();
        String dsRule = sharding.getDsRule();
        String dsName = sharding.getDsName();
        int tabAlgorithm = sharding.getTabAlgorithm();
        String tabRule = sharding.getTabRule();
        String tabName = sharding.getTabName();
        boolean adjustSharding = false;
        if (StringUtils.isNotBlank(dsRule) && StringUtils.isNotBlank(dsName)) {
            Calculate calculate1 = CalculateFactory.getCalculate(dsAlgorithm);
            if (calculate1 == null) {
                throw new BeeException("Can not find the Calculate with dsAlgorithm: " + dsAlgorithm);
            }
            if (dsAlgorithm == 0 && !this.isNumber(shardingValue)) {
                shardingValue = ShardingUtil.hashInt(shardingValue) + "";
                adjustSharding = true;
            }
            String suffix = calculate1.process(dsRule, shardingValue);
            dsName = dsName.contains(dsRuleConst) ? dsName.replace(dsRuleConst, suffix) : dsName + suffix;
            dsTabStruct.setDsName(dsName);
        } else if (StringUtils.isNotBlank(dsName)) {
            dsTabStruct.setDsName(dsName);
        }
        String tabSuffix = "";
        boolean hasTabRule = false;
        if (StringUtils.isNotBlank(tabRule)) {
            Calculate calculate2 = CalculateFactory.getCalculate(tabAlgorithm);
            if (calculate2 == null) {
                throw new BeeException("Can not find the Calculate with dsAlgorithm: " + tabAlgorithm);
            }
            if (tabAlgorithm == 0 && !this.isNumber(shardingValue) && !adjustSharding) {
                shardingValue = ShardingUtil.hashInt(shardingValue) + "";
            }
            tabSuffix = calculate2.process(tabRule, shardingValue);
            hasTabRule = true;
        }
        if (hasTabRule && StringUtils.isNotBlank(tabName)) {
            if (tabName.contains(tabRuleConst)) {
                tabName = tabName.replace(tabRuleConst, tabSuffix);
            } else {
                String sepTab = ShardingRegistry.getSepTab(tabName);
                if (StringUtils.isNotEmpty(sepTab)) {
                    tabSuffix = sepTab + tabSuffix;
                }
                tabName = tabName + tabSuffix;
            }
            dsTabStruct.setTabName(tabName);
        } else if (StringUtils.isNotBlank(tabName)) {
            dsTabStruct.setTabName(tabName);
        } else if (hasTabRule) {
            // empty if block
        }
        dsTabStruct.setTabSuffix(tabSuffix);
        return dsTabStruct;
    }

    private boolean isNumber(String value) {
        try {
            if (value.contains(".")) {
                Double.parseDouble(value);
            } else {
                Long.parseLong(value);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

