/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding;

import java.util.HashMap;
import java.util.Map;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.sharding.ShardingSortStruct;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.sharding.config.ShardingRegistry;
import org.teasoft.honey.util.StringUtils;

public class ShardingUtil {
    private static Map<String, Integer> firstIndexMap;
    private static final int ZERO;
    private static final int ONE;

    private ShardingUtil() {
    }

    public static int firstRecordIndex() {
        String dbName = HoneyConfig.getHoneyConfig().getDbName();
        Integer i = firstIndexMap.get(dbName.toLowerCase());
        if (i != null) {
            return i;
        }
        return 0;
    }

    public static boolean isSharding() {
        return HoneyContext.isMultiDs() && HoneyConfig.getHoneyConfig().multiDS_sharding;
    }

    public static boolean hadSharding() {
        return ShardingUtil.isSharding() && ShardingUtil.isTrueInSysCommStrLocal("_SYS_Bee_HadSharding");
    }

    public static boolean hadGroupSharding() {
        return HoneyContext.getCurrentGroupFunStruct() != null;
    }

    public static boolean hadAvgSharding() {
        return ShardingUtil.hadGroupSharding() && HoneyContext.getCurrentGroupFunStruct().isHasAvg();
    }

    public static boolean hadShardingFullSelect() {
        return ShardingUtil.isSharding() && ShardingUtil.isTrueInSysCommStrLocal("_SYS_Bee_ShardingFullSelect");
    }

    public static boolean hadShardingSomeDsFullSelect() {
        return ShardingUtil.isSharding() && ShardingUtil.isTrueInSysCommStrLocal("_SYS_Bee_ShardingSomeDsFullSelect");
    }

    public static boolean isMoreTableQuery() {
        return ShardingUtil.isTrueInSysCommStrLocal("_SYS_Bee_MoreTableQuery");
    }

    public static void setTrueInSysCommStrLocal(String key) {
        HoneyContext.setSysCommStrLocal(key, "tRue");
    }

    public static boolean isTrueInSysCommStrLocal(String key) {
        return HoneyContext.isTrueInSysCommStrLocal(key);
    }

    public static void regSelectRsThreadFlag(String threadFlag) {
        HoneyContext.setSysCommStrLocal("_SYS_Bee_ShardingSelectRs_ThreadID", threadFlag);
    }

    public static boolean isShardingBatchInsertDoing() {
        return ShardingUtil.isTrueInSysCommStrLocal("_SYS_Bee_ShardingBatchInsertDoing");
    }

    public static int hashInt(String str) {
        if (str == null) {
            return 0;
        }
        int a = str.hashCode();
        return a < 0 ? -a : a;
    }

    public static ShardingSortStruct parseOrderByMap(Map<String, String> orderByMap) {
        String[] orderFields = new String[orderByMap.size()];
        OrderType[] orderTypes = new OrderType[orderByMap.size()];
        int lenA = orderFields.length;
        String orderBy = "";
        int i = 0;
        for (Map.Entry<String, String> entry : orderByMap.entrySet()) {
            String fName = entry.getKey();
            String orderType = entry.getValue();
            orderFields[i] = fName;
            orderTypes[i] = OrderType.DESC.getName().equals(orderType) ? OrderType.DESC : OrderType.ASC;
            orderBy = orderBy + fName + " " + orderType;
            if (i < lenA - 1) {
                orderBy = orderBy + ",";
            }
            ++i;
        }
        return new ShardingSortStruct(orderBy, orderFields, orderTypes);
    }

    public static String findDs(Map<String, String> tab2DsMap, String tabSuffix, String tabName) {
        String dsName = HoneyContext.getAppointDS();
        if (StringUtils.isBlank(dsName)) {
            dsName = tab2DsMap.get(tabSuffix);
        }
        if (StringUtils.isBlank(dsName)) {
            dsName = ShardingRegistry.getDsByTab(tabName);
        }
        return dsName;
    }

    static {
        ZERO = 0;
        ONE = 1;
        firstIndexMap = new HashMap<String, Integer>();
        firstIndexMap.put("MySQL".toLowerCase(), ZERO);
        firstIndexMap.put("MariaDB".toLowerCase(), ZERO);
        firstIndexMap.put("Oracle".toLowerCase(), ONE);
    }
}

