/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.sharding.config.Assign;
import org.teasoft.honey.sharding.config.ShardingConfigMeta;
import org.teasoft.honey.util.StringUtils;

public class ShardingConfigParse {
    public ShardingConfigMeta parseForSharding(String str, int assignType) {
        if (StringUtils.isBlank(str)) {
            return null;
        }
        NodeBean bean = this.parse(str, assignType);
        HashMap<String, Map<String, Set<String>>> fullNodes = new HashMap<String, Map<String, Set<String>>>();
        LinkedHashMap<String, String> tabToDsMap = new LinkedHashMap<String, String>();
        List<String> dsList = bean.getDsList();
        List<String> tabList = bean.getTabList();
        int dsNum = dsList.size();
        int tabNum = tabList.size();
        int size = (tabNum + dsNum - 1) / dsNum;
        LinkedHashMap ds2TabIndexSet = new LinkedHashMap();
        for (int i = 0; i < dsList.size(); ++i) {
            TreeSet<String> tabIndexSet = new TreeSet<String>();
            int n = size;
            for (int k = size * i; n > 0 && k < tabNum; ++k, --n) {
                tabIndexSet.add(bean.getSepTab() + tabList.get(k));
                tabToDsMap.put(bean.getTabBaseName() + bean.getSepTab() + tabList.get(k), bean.getDsBaseName() + dsList.get(i));
            }
            ds2TabIndexSet.put(bean.getDsBaseName() + dsList.get(i), tabIndexSet);
        }
        fullNodes.put(bean.getTabBaseName().toLowerCase(), ds2TabIndexSet);
        Logger.info("[Bee] fullNodes: " + ((Object)fullNodes).toString());
        Logger.info("[Bee] tabToDsMap: " + ((Object)tabToDsMap).toString());
        if (StringUtils.isNotEmpty(bean.getSepTab())) {
            Logger.info("[Bee] " + bean.getTabBaseName() + ", its sepTab is: '" + bean.getSepTab() + "'");
        }
        ShardingConfigMeta shardingConfigMeta = new ShardingConfigMeta();
        shardingConfigMeta.setFullNodes(fullNodes);
        shardingConfigMeta.setTabToDsMap(tabToDsMap);
        shardingConfigMeta.setTabSize(tabList.size());
        shardingConfigMeta.setTabBaseName(bean.getTabBaseName());
        shardingConfigMeta.setSepTab(bean.getSepTab());
        return shardingConfigMeta;
    }

    public ShardingConfigMeta parseForSharding(String str) {
        return this.parseForSharding(str, 0);
    }

    private NodeBean parse(String str, int assignType) {
        int index2;
        String tabNum;
        String[] tabNumArray;
        NodeBean nodes = new NodeBean();
        str = str.replace(" ", "");
        Logger.info(str);
        int mid = str.indexOf("].");
        int index1 = str.indexOf(91);
        String dsNum = str.substring(index1 + 1, mid);
        nodes.setDsBaseName(str.substring(0, index1));
        String[] dsNumArray = dsNum.split("\\.\\.");
        if (dsNumArray.length == 2) {
            nodes.setDsIndex0(Integer.parseInt(dsNumArray[0]));
            nodes.setDsIndex1(Integer.parseInt(dsNumArray[1]));
        } else {
            String[] dsNumArray2 = dsNum.split(",");
            ArrayList<String> dsList = new ArrayList<String>();
            for (int i = 0; i < dsNumArray2.length; ++i) {
                dsList.add(dsNumArray2[i]);
            }
            nodes.setDsList(dsList);
        }
        int dsMin = nodes.getDsIndex0();
        int dsMax = nodes.getDsIndex1();
        if (dsMin != -1) {
            nodes.setDsList(Assign.order(dsMin, dsMax));
        }
        if ((tabNumArray = (tabNum = str.substring((index2 = str.indexOf(91, mid + 2)) + 1, str.length() - 1)).split("\\.\\.")).length == 2) {
            nodes.setTabIndex0(Integer.parseInt(tabNumArray[0]));
            nodes.setTabIndex1(Integer.parseInt(tabNumArray[1]));
        } else {
            int i;
            String[] tabNumArray2 = tabNum.split(",");
            int len = tabNumArray2.length;
            ArrayList<String> tabList = new ArrayList<String>();
            if (len > 1) {
                for (i = 0; i < len; ++i) {
                    tabList.add(tabNumArray2[i]);
                }
            } else {
                len = nodes.getDsList().size();
                for (i = 0; i < len; ++i) {
                    tabList.add("");
                }
            }
            nodes.setTabList(tabList);
        }
        String temp_tabBaseName = str.substring(mid + 2, index2);
        String sepTab = "";
        if (temp_tabBaseName != null && (temp_tabBaseName.endsWith("_") || temp_tabBaseName.endsWith("-"))) {
            int len = temp_tabBaseName.length();
            sepTab = temp_tabBaseName.substring(len - 1, len);
            nodes.setSepTab(sepTab);
            temp_tabBaseName = temp_tabBaseName.substring(0, len - 1);
        }
        nodes.setTabBaseName(temp_tabBaseName);
        int tabMin = nodes.getTabIndex0();
        int tabMax = nodes.getTabIndex1();
        if (tabMin != -1) {
            if (assignType == 1) {
                nodes.setTabList(Assign.polling(tabMin, tabMax, nodes.getDsList().size()));
            } else {
                nodes.setTabList(Assign.order(tabMin, tabMax));
            }
        }
        return nodes;
    }

    private class NodeBean {
        private String dsBaseName;
        private String tabBaseName;
        private String sepTab = "";
        private int dsIndex0 = -1;
        private int dsIndex1;
        private List<String> dsList;
        private int tabIndex0 = -1;
        private int tabIndex1;
        private List<String> tabList;

        private NodeBean() {
        }

        public String toString() {
            String str = "dsBaseName:" + this.dsBaseName;
            str = str + ", tabBaseName:" + this.tabBaseName;
            if (this.dsIndex0 != -1) {
                str = str + ", dsIndex0:" + this.dsIndex0;
                str = str + ", dsIndex1:" + this.dsIndex1;
            } else {
                str = str + ", dsList:" + this.dsList.toString();
            }
            if (this.tabIndex0 != -1) {
                str = str + ", tabIndex0:" + this.tabIndex0;
                str = str + ", tabIndex1:" + this.tabIndex1;
            } else {
                str = str + ", tabList:" + this.tabList.toString();
            }
            return str;
        }

        public String getDsBaseName() {
            return this.dsBaseName;
        }

        public void setDsBaseName(String dsBaseName) {
            this.dsBaseName = dsBaseName;
        }

        public String getTabBaseName() {
            return this.tabBaseName;
        }

        public void setTabBaseName(String tabBaseName) {
            this.tabBaseName = tabBaseName;
        }

        public String getSepTab() {
            return this.sepTab;
        }

        public void setSepTab(String sepTab) {
            this.sepTab = sepTab;
        }

        public int getDsIndex0() {
            return this.dsIndex0;
        }

        public void setDsIndex0(int dsIndex0) {
            this.dsIndex0 = dsIndex0;
        }

        public int getDsIndex1() {
            return this.dsIndex1;
        }

        public void setDsIndex1(int dsIndex1) {
            this.dsIndex1 = dsIndex1;
        }

        public int getTabIndex0() {
            return this.tabIndex0;
        }

        public void setTabIndex0(int tabIndex0) {
            this.tabIndex0 = tabIndex0;
        }

        public int getTabIndex1() {
            return this.tabIndex1;
        }

        public void setTabIndex1(int tabIndex1) {
            this.tabIndex1 = tabIndex1;
        }

        public List<String> getDsList() {
            return this.dsList;
        }

        public void setDsList(List<String> dsList) {
            this.dsList = dsList;
        }

        public List<String> getTabList() {
            return this.tabList;
        }

        public void setTabList(List<String> tabList) {
            this.tabList = tabList;
        }
    }
}

