/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.OrderByPagingRewriteSql;
import org.teasoft.honey.osql.core.ShardingLogReg;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.engine.ResultMergeEngine;
import org.teasoft.honey.sharding.engine.ShardingAbstractBeeSQLExecutorEngine;
import org.teasoft.honey.sharding.engine.ThreadPoolUtil;
import org.teasoft.honey.sharding.engine.decorate.ResultPagingDecorator;
import org.teasoft.honey.sharding.engine.decorate.SortListDecorator;

public class ShardingMoreTableSelectEngine {
    private boolean showShardingSQL = this.getShowShardingSQL();

    private boolean getShowShardingSQL() {
        return HoneyConfig.getHoneyConfig().showSQL && HoneyConfig.getHoneyConfig().showShardingSQL;
    }

    public <T> List<T> asynProcess(String sql, T entity, BeeSql beeSql) {
        String[] sqls = null;
        String[] dsArray = null;
        List<String[]> list = ShardingUtil.hadShardingFullSelect() ? OrderByPagingRewriteSql.createSqlsForFullSelect(sql, entity.getClass()) : OrderByPagingRewriteSql.createSqlsAndInit(sql);
        sqls = list.get(0);
        dsArray = list.get(1);
        if (sqls == null || sqls.length == 0) {
            return null;
        }
        ExecutorService executor = ThreadPoolUtil.getThreadPool(sqls.length);
        ExecutorCompletionService completionService = new ExecutorCompletionService(executor);
        ArrayList<ShardingBeeSQLExecutorEngine<T>> tasks = new ArrayList<ShardingBeeSQLExecutorEngine<T>>();
        for (int i = 0; sqls != null && i < sqls.length; ++i) {
            tasks.add(new ShardingBeeSQLExecutorEngine<T>(sqls[i], i + 1, beeSql, dsArray[i], entity));
        }
        if (sqls != null) {
            ShardingLogReg.log(sqls.length);
        }
        int size = tasks.size();
        for (int i = 0; tasks != null && i < size; ++i) {
            completionService.submit((Callable)tasks.get(i));
        }
        List rsList = ResultMergeEngine.merge(completionService, size);
        executor.shutdown();
        SortListDecorator.sort(rsList);
        if (this.showShardingSQL) {
            Logger.debug("before ResultPagingDecorator, rows: " + rsList.size());
        }
        ResultPagingDecorator.pagingList(rsList);
        if (this.showShardingSQL) {
            Logger.debug("after  ResultPagingDecorator, rows: " + rsList.size());
        }
        return rsList;
    }

    private class ShardingBeeSQLExecutorEngine<T>
    extends ShardingAbstractBeeSQLExecutorEngine<List<T>> {
        private T entity;

        public ShardingBeeSQLExecutorEngine(String sql, int index, BeeSql beeSql, String ds, T entity) {
            super(sql, index, beeSql, ds);
            this.entity = entity;
        }

        @Override
        public List<T> shardingWork() {
            ShardingLogReg.regShardingSqlLog("select SQL", this.index, this.sql);
            return this.beeSql.moreTableSelect(this.sql, this.entity);
        }
    }
}

