/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine;

import java.security.SecureRandom;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.sharding.ShardingSortStruct;
import org.teasoft.honey.distribution.GenIdFactory;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.OrderByPagingRewriteSql;
import org.teasoft.honey.osql.core.ShardingLogReg;
import org.teasoft.honey.osql.core.ShardingSortReg;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.engine.ShardingAbstractBeeSQLExecutorEngine;
import org.teasoft.honey.sharding.engine.ThreadPoolUtil;
import org.teasoft.honey.sharding.engine.decorate.CompareResult;
import org.teasoft.honey.sharding.engine.decorate.OrderByStreamResult;

public class ShardingSelectRsEngine {
    private SecureRandom sr = new SecureRandom();

    public <T> List<T> asynProcess(String sql, Class<T> entityClass, BeeSql beeSql) {
        String[] sqls = null;
        String[] dsArray = null;
        List<String[]> list = ShardingUtil.hadShardingFullSelect() ? OrderByPagingRewriteSql.createSqlsForFullSelect(sql, entityClass) : OrderByPagingRewriteSql.createSqlsAndInit(sql);
        sqls = list.get(0);
        dsArray = list.get(1);
        if (sqls == null || sqls.length == 0) {
            return null;
        }
        ExecutorService executor = ThreadPoolUtil.getThreadPool(sqls.length);
        ExecutorCompletionService completionService = new ExecutorCompletionService(executor);
        ArrayList tasks = new ArrayList();
        String threadFlag = this.getSelectRsThreadFlag();
        ShardingUtil.regSelectRsThreadFlag(threadFlag);
        for (int i = 0; sqls != null && i < sqls.length; ++i) {
            tasks.add(new ShardingBeeSQLExecutorEngine(sqls[i], i + 1, beeSql, dsArray[i]));
        }
        if (sqls != null) {
            ShardingLogReg.log(sqls.length);
        }
        int size = tasks.size();
        for (int i = 0; tasks != null && i < size; ++i) {
            completionService.submit((Callable)tasks.get(i));
        }
        ShardingSortStruct struct = null;
        PriorityQueue<CompareResult> queue = new PriorityQueue<CompareResult>(size);
        for (int i = 0; i < size; ++i) {
            try {
                ResultSet rs = (ResultSet)completionService.take().get();
                if (i == 0) {
                    ShardingSortReg.regSort(rs.getMetaData());
                    struct = HoneyContext.getCurrentShardingSort();
                }
                queue.offer(new CompareResult(rs, struct));
                continue;
            }
            catch (InterruptedException e) {
                Logger.error(e.getMessage(), e);
                Thread.currentThread().interrupt();
                continue;
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), e);
            }
        }
        executor.shutdown();
        List<T> rsList = new OrderByStreamResult<T>(queue, entityClass).getOnePageList();
        for (int i = 0; i < size; ++i) {
            HoneyContext.clearConnForSelectRs(threadFlag + (i + 1));
        }
        return rsList;
    }

    private String getSelectRsThreadFlag() {
        long gid = GenIdFactory.get("_SYS_Bee_ShardingSelectRs_ThreadID", "OneTimeSnowflakeId");
        String threadFlag = gid + "" + this.sr.nextDouble();
        return threadFlag;
    }

    private class ShardingBeeSQLExecutorEngine<T>
    extends ShardingAbstractBeeSQLExecutorEngine<ResultSet> {
        public ShardingBeeSQLExecutorEngine(String sql, int index, BeeSql beeSql, String ds) {
            super(sql, index, beeSql, ds);
        }

        @Override
        public ResultSet shardingWork() {
            ShardingLogReg.regShardingSqlLog("select SQL", this.index, this.sql);
            return this.beeSql.selectRs(this.sql);
        }
    }
}

