/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.util;

import org.teasoft.honey.util.StringUtils;

public class StringParser {
    private StringParser() {
    }

    public static int getEndPosition(String str) {
        str = str.trim();
        char[] array = str.toCharArray();
        int len = array.length;
        boolean isStart = false;
        int single = -1;
        int dou = -1;
        boolean isComm1 = false;
        boolean isComm2 = false;
        block0: for (int i = 0; i < len; ++i) {
            int k;
            if (!isComm1 && !isComm2) {
                if (array[i] == '\'') {
                    single *= -1;
                    continue;
                }
                if (array[i] == '\"') {
                    dou *= -1;
                    continue;
                }
                if (single != -1 || dou != -1) continue;
            }
            if (isComm1 && (array[i] == '\n' || array[i] == '\r')) {
                isComm1 = false;
            }
            if (isComm2 && array[i] == '*' && i + 1 < len && array[i + 1] == '/') {
                isComm2 = false;
            }
            if (isComm1 || isComm2) continue;
            if (array[i] == '/' && i + 1 < len && array[i + 1] == '/') {
                isComm1 = true;
                ++i;
                continue;
            }
            if (array[i] == '/' && i + 1 < len && array[i + 1] == '*') {
                isComm2 = true;
                ++i;
                continue;
            }
            if (!isStart && array[i] == '(') {
                for (k = i + 1; k < len; ++k) {
                    if (array[k] == '{') {
                        isStart = true;
                        i = k;
                        break;
                    }
                    if (StringParser.isSeprate(array[k])) continue;
                    isStart = false;
                    i = k;
                    break;
                }
                if (isStart) continue;
            }
            if (!isStart || array[i] != '}') continue;
            for (k = i + 1; k < len; ++k) {
                if (array[k] == ')') {
                    i = k;
                    return k;
                }
                if (!StringParser.isSeprate(array[k])) continue block0;
            }
        }
        return -1;
    }

    public static int getKeyPosition(String str, String key, int fromIndex) {
        if (str != null && str.length() > fromIndex) {
            str = str.substring(fromIndex);
        }
        return StringParser.getKeyPosition(str, key);
    }

    public static int getKeyPosition(String str, String key) {
        return StringParser._getKeyPosition(str, key, false);
    }

    public static int getKeyPosition2(String str, String key) {
        return StringParser._getKeyPosition(str, key, true);
    }

    private static int _getKeyPosition(String str, String key, boolean isAllowSeprate) {
        if (StringUtils.isBlank(str) || StringUtils.isBlank(key)) {
            return -1;
        }
        int r = -1;
        char[] array = str.toCharArray();
        int len = array.length;
        char[] keyChar = key.toCharArray();
        int single = -1;
        int dou = -1;
        block0: for (int i = 0; i < len; ++i) {
            if (array[i] == '\'') {
                single *= -1;
                continue;
            }
            if (array[i] == '\"') {
                dou *= -1;
                continue;
            }
            if (single != -1 || dou != -1 || array[i] != keyChar[0]) continue;
            r = i;
            if (keyChar.length == 1) {
                return r;
            }
            for (int k = 1; k < keyChar.length; ++k) {
                if (isAllowSeprate) {
                    while (i + k < len && StringParser.isSeprate(array[i + k])) {
                        ++i;
                    }
                }
                if (i + k >= len || array[i + k] != keyChar[k]) continue block0;
                if (k + 1 != keyChar.length) continue;
                return r;
            }
        }
        return -1;
    }

    public static int getKeyEndPositionByStartEnd(String str, char start, char end) {
        if (StringUtils.isBlank(str)) {
            return -1;
        }
        char[] array = str.toCharArray();
        int len = array.length;
        int single = -1;
        int dou = -1;
        int startCount = -1;
        for (int i = 0; i < len; ++i) {
            if (array[i] == '\'') {
                single *= -1;
                continue;
            }
            if (array[i] == '\"') {
                dou *= -1;
                continue;
            }
            if (single != -1 || dou != -1) continue;
            if (array[i] == start) {
                ++startCount;
                continue;
            }
            if (array[i] != end || --startCount != -1) continue;
            return i;
        }
        return -1;
    }

    public static String removeComment(String str) {
        if (StringUtils.isBlank(str)) {
            return str;
        }
        str = str.trim();
        char[] array = str.toCharArray();
        int len = array.length;
        int single = -1;
        int dou = -1;
        boolean isComm1 = false;
        boolean isComm2 = false;
        int start = -1;
        int end = -1;
        for (int i = 0; i < len; ++i) {
            if (!isComm1 && !isComm2) {
                if (array[i] == '\'') {
                    single *= -1;
                    continue;
                }
                if (array[i] == '\"') {
                    dou *= -1;
                    continue;
                }
                if (single != -1 || dou != -1) continue;
            }
            if (isComm1 && (array[i] == '\n' || array[i] == '\r')) {
                isComm1 = false;
                end = i;
                break;
            }
            if (isComm2 && array[i] == '*' && i + 1 < len && array[i + 1] == '/') {
                isComm2 = false;
                end = i + 2;
                break;
            }
            if (isComm1 || isComm2) continue;
            if (array[i] == '/' && i + 1 < len && array[i + 1] == '/') {
                isComm1 = true;
                start = i++;
                continue;
            }
            if (array[i] != '/' || i + 1 >= len || array[i + 1] != '*') continue;
            isComm2 = true;
            start = i++;
        }
        if (start > 0 && end > 0 && end > start) {
            StringBuffer sb = new StringBuffer(str);
            sb.delete(start, end);
            return StringParser.removeComment(sb.toString());
        }
        return str;
    }

    private static boolean isSeprate(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }
}

