/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.teasoft.bee.file.FileCreator;
import org.teasoft.honey.osql.core.Logger;

public class FileHandle
implements FileCreator {
    private String charsetName;
    private String LINE_SEPARATOR = System.getProperty("line.separator");

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public String getCharsetName() {
        if (this.charsetName == null || "".equals(this.charsetName.trim())) {
            return "UTF-8";
        }
        return this.charsetName;
    }

    public void genFile(String fullPathAndName, String content) {
        File f = new File(fullPathAndName);
        if (f.exists()) {
            Logger.info("The file already exist.");
            this.backFile(f);
        } else if (!f.exists()) {
            String substr = fullPathAndName.substring(0, fullPathAndName.lastIndexOf(File.separator));
            new File(substr).mkdirs();
            Logger.info("Create file: " + fullPathAndName);
        }
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), this.getCharsetName()));){
            bw.write(content);
            bw.flush();
            this.logGenFile(fullPathAndName);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }

    public void genFile(String fullPath, String fileName, String content) {
        if (!fullPath.endsWith(File.separator)) {
            fullPath = fullPath + File.separator;
        }
        File folder = new File(fullPath);
        boolean needCheckExist = false;
        if (!folder.exists()) {
            folder.mkdirs();
            Logger.debug("Create folder: " + fullPath);
        } else {
            needCheckExist = true;
        }
        File entityFile = new File(fullPath + fileName);
        if (needCheckExist && entityFile.exists()) {
            Logger.info("The file already exist.");
            this.backFile(entityFile);
        }
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(entityFile), this.getCharsetName()));){
            bw.write(content);
            bw.flush();
            this.logGenFile(fullPath + fileName);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }

    public void genFile(String basePath, String packagePath, String fileName, String content) {
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separator;
        }
        String fullPath = basePath + packagePath.replace(".", File.separator) + File.separator;
        this.genFile(fullPath, fileName, content);
    }

    public void genAppendFile(String fullPathAndName, String content) {
        File f = new File(fullPathAndName);
        if (!f.exists()) {
            String substr = fullPathAndName.substring(0, fullPathAndName.lastIndexOf(File.separator));
            new File(substr).mkdirs();
        }
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f, true), this.getCharsetName()));){
            bw.write(content);
            bw.append(this.LINE_SEPARATOR);
            bw.flush();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }

    public BufferedReader readFile(String fullPathAndName) {
        File file = new File(fullPathAndName);
        return this.readFile(file);
    }

    public BufferedReader readFile(File file) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (IOException e) {
            Logger.error(e.getMessage());
        }
        return reader;
    }

    private void logGenFile(String pathAndName) {
        Logger.info("Generate file successful. path: " + pathAndName);
    }

    public void backFile(File f) {
        String originalFileName = f.getName();
        String backupFileName = originalFileName + "_" + System.currentTimeMillis() + ".bak";
        File backupFile = new File(f.getParent(), backupFileName);
        try {
            Path sourcePath = f.toPath();
            Path backupPath = backupFile.toPath();
            Files.copy(sourcePath, backupPath, StandardCopyOption.REPLACE_EXISTING);
            Logger.info("Backup file successful. path: " + backupFile.getAbsolutePath());
        }
        catch (IOException e) {
            Logger.debug("Backup file failed: " + backupFile.getAbsolutePath());
        }
    }
}

