/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.chain;

import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.chain.Select;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.honey.osql.chain.AbstractSelectToSql;
import org.teasoft.honey.osql.core.FunAndOrderTypeMap;
import org.teasoft.honey.osql.core.K;

public class SelectImpl
extends AbstractSelectToSql
implements Select {
    private static final String STAR = "*";
    private static final String DISTINCT = K.distinct;
    private static final String L_PARENTHESES = "(";
    private static final String R_PARENTHESES = ")";
    private static final String COMMA = ",";
    private static final String SPACE = " ";
    private static final String AND = " " + K.and + " ";
    private boolean isStartField = true;
    private boolean isStartOn = true;
    private boolean isStartGroupBy = true;
    private boolean isStartHaving = true;
    private boolean isStartOrderBy = true;
    private static final String START_GREAT_EQ_0 = "Parameter 'start' need >=0 .";
    private static final String SIZE_GREAT_0 = "Parameter 'size' need >0 .";

    public Select select() {
        if (this.isStartField) {
            this.sql.append(K.select).append(SPACE);
            this.sql.append(STAR);
            this.isStartField = false;
        }
        return this;
    }

    public Select select(String column) {
        this.checkExpression(column);
        if (this.isStartField) {
            this.sql.append(K.select).append(SPACE);
            this.sql.append(column);
            this.isStartField = false;
        } else {
            this.sql.append(COMMA);
            this.sql.append(column);
        }
        return this;
    }

    public Select distinct(String fieldName, String alias) {
        return this.select(K.distinct + L_PARENTHESES + fieldName + R_PARENTHESES + K.space + K.as + alias);
    }

    public Select distinct(String field) {
        this.checkFieldOrExpression(field);
        return this.select(DISTINCT + L_PARENTHESES + field + R_PARENTHESES);
    }

    public Select from(String table) {
        this.checkExpression(table);
        this._appendTable(table);
        if (this.isStartField) {
            this.sql.append(K.select).append(SPACE);
            this.sql.append(STAR);
            this.isStartField = false;
        }
        this.sql.append(SPACE).append(K.from).append(SPACE);
        this.sql.append(table);
        return this;
    }

    public Select join(String anotherTable) {
        this.checkExpression(anotherTable);
        this._appendTable(anotherTable);
        this.sql.append(SPACE).append(K.join).append(SPACE);
        this.sql.append(anotherTable);
        return this;
    }

    public Select innerJoin(String anotherTable) {
        this.checkExpression(anotherTable);
        this._appendTable(anotherTable);
        this.sql.append(SPACE).append(K.innerJoin).append(SPACE);
        this.sql.append(anotherTable);
        return this;
    }

    public Select leftJoin(String anotherTable) {
        this.checkExpression(anotherTable);
        this._appendTable(anotherTable);
        this.sql.append(SPACE).append(K.leftJoin).append(SPACE);
        this.sql.append(anotherTable);
        return this;
    }

    public Select rightJoin(String anotherTable) {
        this.checkExpression(anotherTable);
        this._appendTable(anotherTable);
        this.sql.append(SPACE).append(K.rightJoin).append(SPACE);
        this.sql.append(anotherTable);
        return this;
    }

    public Select on() {
        this.sql.append(SPACE).append(K.on).append(SPACE);
        this.isStartOn = false;
        return this;
    }

    public Select on(String expression) {
        this.checkExpression(expression);
        if (this.isStartOn) {
            this.sql.append(SPACE).append(K.on).append(SPACE);
            this.sql.append(expression);
            this.isStartOn = false;
        } else {
            if (this.isAddAnd) {
                this.sql.append(AND);
            }
            this.sql.append(expression);
            this.isAddAnd = true;
        }
        return this;
    }

    public Select groupBy(String field) {
        this.checkFieldOrExpression(field);
        if (this.isStartGroupBy) {
            this.sql.append(SPACE).append(K.groupBy).append(SPACE);
            this.sql.append(field);
            this.isStartGroupBy = false;
        } else {
            this.sql.append(COMMA);
            this.sql.append(field);
        }
        return this;
    }

    public Select having(String expression) {
        this.checkExpression(expression);
        if (this.isStartHaving) {
            this.sql.append(SPACE).append(K.having).append(SPACE);
            this.sql.append(expression);
            this.isStartHaving = false;
        } else {
            this.sql.append(AND);
            this.sql.append(expression);
        }
        return this;
    }

    public Select orderBy(String field) {
        this.checkFieldOrExpression(field);
        if (this.isStartOrderBy) {
            this.sql.append(SPACE).append(K.orderBy).append(SPACE);
            this.sql.append(field);
            this.isStartOrderBy = false;
        } else {
            this.sql.append(COMMA);
            this.sql.append(field);
        }
        return this;
    }

    public Select orderBy(String field, OrderType orderType) {
        this.checkFieldOrExpression(field);
        if (this.isStartOrderBy) {
            this.sql.append(SPACE).append(K.orderBy).append(SPACE);
            this.sql.append(field);
            this.sql.append(SPACE);
            this.sql.append(FunAndOrderTypeMap.transfer(orderType.getName()));
            this.isStartOrderBy = false;
        } else {
            this.sql.append(COMMA);
            this.sql.append(field);
            this.sql.append(SPACE);
            this.sql.append(FunAndOrderTypeMap.transfer(orderType.getName()));
        }
        return this;
    }

    private Select useSubSelect(String keyword, String subSelect) {
        this.sql.append(keyword);
        this.sql.append(SPACE);
        this.sql.append(L_PARENTHESES);
        this.sql.append(subSelect);
        this.sql.append(R_PARENTHESES);
        return this;
    }

    private Select useSubSelect(String field, String keyword, String subSelect) {
        this.checkFieldOrExpression(field);
        this.sql.append(field);
        this.sql.append(SPACE);
        this.sql.append(keyword);
        this.sql.append(SPACE);
        this.sql.append(L_PARENTHESES);
        this.sql.append(subSelect);
        this.sql.append(R_PARENTHESES);
        return this;
    }

    public Select exists(Select subSelect) {
        this.updatePvList(subSelect);
        return this.useSubSelect(K.exists, subSelect.toSQL());
    }

    public Select notExists(Select subSelect) {
        this.updatePvList(subSelect);
        return this.useSubSelect(K.notExists, subSelect.toSQL());
    }

    public Select in(String field, Select subSelect) {
        this.updatePvList(subSelect);
        return this.useSubSelect(field, K.in, subSelect.toSQL());
    }

    public Select notIn(String field, Select subSelect) {
        this.updatePvList(subSelect);
        return this.useSubSelect(field, K.notIn, subSelect.toSQL());
    }

    public Select start(int start) {
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.start = start;
        return this;
    }

    public Select size(int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        this.size = size;
        return this;
    }

    public Select forUpdate() {
        this.sql.append(SPACE).append(K.forUpdate);
        return this;
    }

    private void updatePvList(Select subSelect) {
        super.getPvList().addAll(subSelect.getPvList());
    }

    private void _appendTable(String table) {
        super.appendTable(table);
    }
}

