/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.chain;

import org.teasoft.bee.osql.chain.Update;
import org.teasoft.honey.osql.chain.WhereImpl;
import org.teasoft.honey.osql.core.K;

public class UpdateImpl
extends WhereImpl<Update>
implements Update {
    private static final String MUL = "*";
    private static final String ADD = "+";
    private boolean isStartTable = true;
    private boolean isStartSet = true;
    private static final String COMMA = ",";
    private static final String SPACE = " ";

    public Update update(String table) {
        this.checkExpression(table);
        this._appendTable(table);
        if (this.isStartTable) {
            this.sql.append(K.update).append(SPACE);
            this.sql.append(table);
            this.isStartTable = false;
        } else {
            this.sql.append(COMMA);
            this.sql.append(table);
        }
        return this;
    }

    public Update set(String field, String value) {
        this.checkExpression(field);
        this.adjustComma();
        this.sql.append(field);
        this.sql.append("=");
        if (this.isUsePlaceholder()) {
            this.sql.append("?");
            this.addValue(value);
        } else {
            this.sql.append("'");
            this.sql.append(value);
            this.sql.append("'");
        }
        return this;
    }

    public Update set(String field, Number value) {
        this.checkExpression(field);
        this.adjustComma();
        this.sql.append(field);
        this.sql.append("=");
        if (this.isUsePlaceholder()) {
            this.sql.append("?");
            this.addValue(value);
        } else {
            this.sql.append(value);
        }
        return this;
    }

    public Update setAdd(String field, Number num) {
        return this._set0(field, num, ADD);
    }

    public Update setMultiply(String field, Number num) {
        return this._set0(field, num, MUL);
    }

    private Update _set0(String field, Number value, String operator) {
        this.checkExpression(field);
        this.adjustComma();
        this.sql.append(field);
        this.sql.append("=");
        this.sql.append(field);
        this.sql.append(operator);
        if (this.isUsePlaceholder()) {
            this.sql.append("?");
            this.addValue(value);
        } else {
            this.sql.append(value);
        }
        return this;
    }

    public Update setAdd(String field, String otherFieldName) {
        return this._set1(field, otherFieldName, ADD);
    }

    public Update setMultiply(String field, String otherFieldName) {
        return this._set1(field, otherFieldName, MUL);
    }

    private Update _set1(String field, String otherFieldName, String operator) {
        this.checkExpression(field);
        this.checkExpression(otherFieldName);
        this.adjustComma();
        this.sql.append(field);
        this.sql.append("=");
        this.sql.append(field);
        this.sql.append(operator);
        this.sql.append(otherFieldName);
        return this;
    }

    public Update setWithField(String field1, String field2) {
        this.checkExpression(field1);
        this.checkExpression(field2);
        this.adjustComma();
        this.sql.append(field1);
        this.sql.append("=");
        this.sql.append(field2);
        return this;
    }

    public Update setNull(String fieldName) {
        this.checkExpression(fieldName);
        this.adjustComma();
        this.sql.append(fieldName);
        this.sql.append("=");
        this.sql.append(K.Null);
        return this;
    }

    private void _appendTable(String table) {
        super.appendTable(table);
    }

    private void adjustComma() {
        if (!this.isStartSet) {
            this.sql.append(" , ");
        }
        if (this.isStartSet) {
            this.sql.append(" set ");
            this.isStartSet = false;
        }
    }
}

