/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.chain;

import org.teasoft.bee.osql.BeeException;
import org.teasoft.bee.osql.Op;
import org.teasoft.bee.osql.chain.Where;
import org.teasoft.bee.osql.exception.BeeErrorNameException;
import org.teasoft.honey.osql.core.AbstractToSqlForChain;
import org.teasoft.honey.osql.core.ConditionHelper;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.util.NameCheckUtil;

public class WhereImpl<T>
extends AbstractToSqlForChain
implements Where<T> {
    private static final String L_PARENTHESES = "(";
    private static final String R_PARENTHESES = ")";
    private static final String SPACE = " ";
    private static final String AND = " " + K.and + " ";
    private boolean isStartWhere = true;
    protected boolean isAddAnd = false;

    public T lParentheses() {
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.isAddAnd = false;
        this.sql.append(L_PARENTHESES);
        return this.self();
    }

    public T rParentheses() {
        this.sql.append(R_PARENTHESES);
        this.isAddAnd = true;
        return this.self();
    }

    public T where() {
        this.sql.append(SPACE).append(K.where).append(SPACE);
        this.isStartWhere = false;
        return this.self();
    }

    public T where(String expression) {
        this.checkExpression(expression);
        if (this.isStartWhere) {
            this.sql.append(SPACE).append(K.where).append(SPACE);
            this.sql.append(expression);
            this.isStartWhere = false;
            this.isAddAnd = true;
        } else {
            if (this.isAddAnd) {
                this.sql.append(AND);
            }
            this.sql.append(expression);
            this.isAddAnd = true;
        }
        return this.self();
    }

    private T self() {
        return (T)this;
    }

    public T op(String field, Op opType, Object value) {
        this.checkField(field);
        if (value instanceof String) {
            return this._opWithString(field, opType, (String)value);
        }
        if (value instanceof Number) {
            return this._opWithNumber(field, opType, (Number)value);
        }
        if (opType == Op.in || opType == Op.notIn) {
            return this.inOrNotInUsePlaceholder(value);
        }
        String msg = "";
        msg = value != null ? "the value(" + value.toString() + ") of type:" + value.getClass().getName() + " not support!" : "the value of type not support!";
        throw new BeeException(msg);
    }

    private T _opWithString(String field, Op opType, String value) {
        this.checkField(field);
        if (opType == Op.in) {
            return this.in(field, value);
        }
        if (opType == Op.notIn) {
            return this.notIn(field, value);
        }
        if (Op.like == opType || Op.notLike == opType || Op.likeLeft == opType || Op.likeRight == opType || Op.likeLeftRight == opType) {
            value = ConditionHelper.processLike(opType, value);
        }
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(opType.getOperator());
        if (this.isUsePlaceholder()) {
            this.sql.append("?");
            this.addValue(value);
        } else {
            this.sql.append("'");
            this.sql.append(value);
            this.sql.append("'");
        }
        this.isAddAnd = true;
        return this.self();
    }

    private T _opWithNumber(String field, Op opType, Number value) {
        this.checkField(field);
        if (opType == Op.in) {
            return this.in(field, value);
        }
        if (opType == Op.notIn) {
            return this.notIn(field, value);
        }
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(opType.getOperator());
        if (this.isUsePlaceholder()) {
            this.sql.append("?");
            this.addValue(value);
        } else {
            this.sql.append(value);
        }
        this.isAddAnd = true;
        return this.self();
    }

    public T opWithField(String field1, Op opType, String field2) {
        this.checkField(field1);
        this.checkField(field2);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field1);
        this.sql.append(opType.getOperator());
        this.sql.append(field2);
        this.isAddAnd = true;
        return this.self();
    }

    public T op(String field, String value) {
        this.checkField(field);
        return this.op(field, Op.eq, value);
    }

    public T op(String field, Number value) {
        this.checkField(field);
        return this.op(field, Op.eq, value);
    }

    public T and() {
        this.sql.append(AND);
        this.isAddAnd = false;
        return this.self();
    }

    public T or() {
        this.sql.append(SPACE).append(K.or).append(SPACE);
        this.isAddAnd = false;
        return this.self();
    }

    public T not() {
        this.sql.append(SPACE).append("!").append(SPACE);
        return this.self();
    }

    public T in(String field, Number ... valueList) {
        this.checkField(field);
        return this.inOrNotIn(field, K.in, valueList);
    }

    public T notIn(String field, Number ... valueList) {
        this.checkField(field);
        return this.inOrNotIn(field, K.notIn, valueList);
    }

    private T inOrNotIn(String field, String op, Number ... valueList) {
        this.checkFieldOrExpression(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field + SPACE + op);
        if (this.isUsePlaceholder()) {
            return this.inOrNotInUsePlaceholder(valueList);
        }
        String value = "";
        for (int i = 0; i < valueList.length; ++i) {
            value = i == 0 ? value + valueList[i] : value + "," + valueList[i];
        }
        this.sql.append(" (" + value + R_PARENTHESES);
        return this.self();
    }

    public T in(String field, String valueList) {
        return this.inOrNotIn(field, K.in, valueList);
    }

    public T notIn(String field, String valueList) {
        return this.inOrNotIn(field, K.notIn, valueList);
    }

    private T inOrNotIn(String field, String op, String valueList) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field + SPACE + op);
        if (this.isUsePlaceholder()) {
            return this.inOrNotInUsePlaceholder(valueList);
        }
        valueList = valueList.replace(",", "','");
        this.sql.append(" ('" + valueList + "')");
        return this.self();
    }

    public T between(String field, Number low, Number high) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(SPACE).append(K.between).append(SPACE);
        if (this.isUsePlaceholder()) {
            this.sql.append("?");
            this.addValue(low);
        } else {
            this.sql.append(low);
        }
        this.sql.append(AND);
        if (this.isUsePlaceholder()) {
            this.sql.append("?");
            this.addValue(high);
        } else {
            this.sql.append(high);
        }
        this.isAddAnd = true;
        return this.self();
    }

    public T notBetween(String field, Number low, Number high) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(SPACE).append(K.notBetween).append(SPACE);
        if (this.isUsePlaceholder()) {
            this.sql.append("?");
            this.addValue(low);
        } else {
            this.sql.append(low);
        }
        this.sql.append(AND);
        if (this.isUsePlaceholder()) {
            this.sql.append("?");
            this.addValue(high);
        } else {
            this.sql.append(high);
        }
        this.isAddAnd = true;
        return this.self();
    }

    public T isNull(String field) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(SPACE).append(K.isNull).append(SPACE);
        return this.self();
    }

    public T isNotNull(String field) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(SPACE).append(K.isNotNull).append(SPACE);
        return this.self();
    }

    protected void checkFieldOrExpression(String field) {
        if (NameCheckUtil.isIllegal(field)) {
            throw new BeeErrorNameException("The field: '" + field + "' is illegal!");
        }
    }

    private void checkField(String field) {
        NameCheckUtil.checkName(field);
    }

    private T inOrNotInUsePlaceholder(Object value) {
        ConditionHelper.processIn(this.sql, this.getPvList(), value);
        return this.self();
    }
}

