/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.ArrayList;
import java.util.List;
import org.teasoft.bee.osql.chain.ToSql;
import org.teasoft.bee.osql.exception.BeeIllegalSQLException;
import org.teasoft.honey.osql.core.Check;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.util.StringUtils;

public abstract class AbstractToSqlForChain
implements ToSql {
    protected StringBuffer sql = new StringBuffer();
    protected List<PreparedValue> pvList = new ArrayList<PreparedValue>();
    private boolean isUsePlaceholder = true;
    private String table;

    public String toSQL() {
        String sql0 = this.toSQL(true);
        if (this.isUsePlaceholder()) {
            this.setContext(sql0);
        }
        return sql0;
    }

    public String toSQL(boolean noSemicolon) {
        if (noSemicolon) {
            return this.sql.toString();
        }
        return this.sql.toString() + ";";
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void appendTable(String table) {
        this.table = StringUtils.isBlank(this.table) ? table : this.table + "##" + table;
    }

    public boolean isUsePlaceholder() {
        return this.isUsePlaceholder;
    }

    public void setUsePlaceholder(boolean isUsePlaceholder) {
        this.isUsePlaceholder = isUsePlaceholder;
    }

    protected void addValue(Object v) {
        PreparedValue preparedValue = new PreparedValue();
        if (v == null) {
            preparedValue.setType(Object.class.getName());
        } else {
            preparedValue.setType(v.getClass().getName());
        }
        preparedValue.setValue(v);
        this.pvList.add(preparedValue);
    }

    protected void setContext(String sql) {
        HoneyContext.setContext(sql, this.pvList, this.table);
    }

    public List<PreparedValue> getPvList() {
        return this.pvList;
    }

    protected void checkExpression(String expression) {
        if (Check.isNotValidExpression(expression)) {
            throw new BeeIllegalSQLException("The expression: '" + expression + "' is invalid!");
        }
    }
}

