/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.Map;
import javax.sql.DataSource;
import org.teasoft.bee.osql.BeeAbstractFactory;
import org.teasoft.honey.distribution.ds.Router;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyFactory;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.ProcessDataSourceMap;

public class BeeFactory
extends BeeAbstractFactory {
    private static BeeFactory instance = new BeeFactory();

    private BeeFactory() {
    }

    public static BeeFactory getInstance() {
        return instance;
    }

    public static HoneyFactory getHoneyFactory() {
        return HoneyFactoryHolder.HF;
    }

    public DataSource getDataSource() {
        HoneyContext.refreshDataSourceMap();
        if (super.getDataSourceMap() == null) {
            return super.getDataSource();
        }
        return this._getDsFromDsMap();
    }

    private DataSource _getDsFromDsMap() {
        String dsName = Router.getDsName();
        Logger.info("[Bee] ========= the current DataSource name is :" + dsName + this.shardingIndex());
        DataSource ds = (DataSource)this.getDataSourceMap().get(dsName);
        if (ds == null) {
            Logger.warn("Can not find the DataSource from DataSource Map with dsName: " + dsName);
        }
        return ds;
    }

    private String shardingIndex() {
        Integer subThreadIndex = HoneyContext.getSqlIndexLocal();
        String index = "";
        if (subThreadIndex != null) {
            index = " (sharding " + subThreadIndex + ")";
        }
        return index;
    }

    protected void parseDbNameByDsMap() {
        Map dsMap = this.getDataSourceMap();
        if (dsMap == null) {
            return;
        }
        ProcessDataSourceMap.parseDbNameByDsMap(dsMap);
    }

    static {
        HoneyConfig.getHoneyConfig();
        HoneyContext.initLoad();
    }

    private static class HoneyFactoryHolder {
        private static final HoneyFactory HF = new HoneyFactory();

        private HoneyFactoryHolder() {
        }
    }
}

