/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.teasoft.honey.distribution.ds.Router;
import org.teasoft.honey.osql.core.CacheArrayIndex;
import org.teasoft.honey.osql.core.CacheDeleteThread;
import org.teasoft.honey.osql.core.CacheKey;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.JdkSerializer;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.util.ObjectUtils;

public final class CacheUtil {
    private static final byte[] lock = new byte[0];
    private static final int MAX_SIZE;
    private static final int timeout;
    private static ConcurrentMap<String, Integer> map;
    private static long[] time;
    private static Object[] obj;
    private static String[] keys;
    private static ConcurrentMap<String, Set<Integer>> map_tableIndexSet;
    private static ConcurrentMap<String, List<String>> map_tableNameList;
    private static CacheArrayIndex arrayIndex;
    private static Map<String, String> neverCacheTableMap;
    private static Map<String, Integer> foreverCacheTableMap;
    private static Map<String, Integer> foreverCacheTableMap_sqlkey2exist;
    private static Map<String, Integer> foreverCacheModifySynTableMap;
    private static final String NEVER = "1";
    private static final Integer FOREVER;
    private static Map<String, Set<String>> map_foreverSynTableIndexSet;
    private static Map<String, Object> foreverCacheObjectMap;
    private static Map<String, Object> foreverModifySynCacheObjectMap;
    private static boolean isShowSql;
    private static String logCacheMsg;

    static void clear() {
        map.clear();
        map_tableIndexSet.clear();
        map_tableNameList.clear();
        CacheUtil.init();
    }

    private static void init() {
        map = new ConcurrentHashMap<String, Integer>();
        time = new long[MAX_SIZE];
        obj = new Object[MAX_SIZE];
        keys = new String[MAX_SIZE];
        map_tableIndexSet = new ConcurrentHashMap<String, Set<Integer>>();
        map_tableNameList = new ConcurrentHashMap<String, List<String>>();
        arrayIndex = new CacheArrayIndex();
        CacheUtil.initSpecialTable(HoneyConfig.getHoneyConfig().cache_never, HoneyConfig.getHoneyConfig().cache_forever, HoneyConfig.getHoneyConfig().cache_modifySyn);
    }

    private CacheUtil() {
    }

    private static boolean getUseLevelTwo() {
        return HoneyConfig.getHoneyConfig().cache_useLevelTwo;
    }

    public static Object get(String sql) {
        String key = CacheKey.genKey(sql);
        if (key == null) {
            return null;
        }
        Integer index = (Integer)map.get(key);
        if (index != null) {
            if (CacheUtil._isTimeout(index)) {
                if (!arrayIndex.isStartDelete()) {
                    CacheUtil.delCache(key);
                } else {
                    new CacheDeleteThread(index).begin();
                }
                return null;
            }
            if (isShowSql) {
                Logger.logSQL(logCacheMsg, "");
            }
            HoneyContext.deleteCacheInfo(sql);
            return CacheUtil.copyObjectForGet(obj[index]);
        }
        List<String> tableNameList = CacheKey.genTableNameList(sql);
        if (tableNameList != null && tableNameList.size() == 1) {
            Integer forever = CacheUtil._getConfigCacheTableMapValue(foreverCacheTableMap, tableNameList);
            if (forever != null && foreverCacheTableMap_sqlkey2exist.get(key) != null) {
                Object obj0 = foreverCacheObjectMap.get(key);
                if (obj0 != null) {
                    HoneyContext.deleteCacheInfo(sql);
                    if (isShowSql) {
                        Logger.logSQL(logCacheMsg, "");
                    }
                }
                return CacheUtil.copyObjectForGet(obj0);
            }
            Integer foreverModifySyn = CacheUtil._getConfigCacheTableMapValue(foreverCacheModifySynTableMap, tableNameList);
            if (foreverModifySyn != null) {
                Object obj1 = foreverModifySynCacheObjectMap.get(key);
                if (obj1 != null) {
                    HoneyContext.deleteCacheInfo(sql);
                    if (isShowSql) {
                        Logger.logSQL(logCacheMsg, "");
                    }
                }
                return CacheUtil.copyObjectForGet(obj1);
            }
        }
        return null;
    }

    private static void delCache(String key) {
        if (key == null) {
            return;
        }
        Integer i = (Integer)map.get(key);
        if (i != null) {
            map.remove(key);
            CacheUtil.time[i.intValue()] = -1L;
            CacheUtil.obj[i.intValue()] = null;
            CacheUtil.keys[i.intValue()] = null;
            CacheUtil._delTableIndexSetByKey(key, i);
        }
    }

    static void delCacheInBetween(int knowIndex) {
        int low = arrayIndex.getLow();
        int high = arrayIndex.getHigh();
        int know = knowIndex;
        if (low <= high) {
            for (int i = low; i <= know; ++i) {
                CacheUtil._deleteCacheByIndex(i);
            }
            arrayIndex.setLow(know + 1);
        } else if (low < know) {
            for (int i = low; i <= know; ++i) {
                CacheUtil._deleteCacheByIndex(i);
            }
            arrayIndex.setLow((know + 1) % MAX_SIZE);
        } else if (know < high) {
            int i;
            for (i = low; i < MAX_SIZE; ++i) {
                CacheUtil._deleteCacheByIndex(i);
            }
            for (i = 0; i <= know; ++i) {
                CacheUtil._deleteCacheByIndex(i);
            }
            arrayIndex.setLow(know + 1);
        }
    }

    private static void _deleteCacheByIndex(int i) {
        CacheUtil._deleteCacheByIndex(i, true);
    }

    private static void _deleteCacheByIndex(int i, boolean includeTableName) {
        if (keys[i] != null) {
            map.remove(keys[i]);
            if (includeTableName) {
                CacheUtil._delTableIndexSetByKey(keys[i], i);
            } else {
                map_tableNameList.remove(keys[i]);
            }
        }
        CacheUtil.time[i] = -1L;
        CacheUtil.obj[i] = null;
        CacheUtil.keys[i] = null;
    }

    private static boolean _isTimeout(int index) {
        long now = System.currentTimeMillis();
        return time[index] > 0L && now - time[index] > (long)timeout;
    }

    static boolean add(String sql, Object rs) {
        return CacheUtil.addInCache(sql, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean addInCache(String sql, Object rs) {
        List<String> tableNameList;
        block19: {
            tableNameList = CacheKey.genTableNameList(sql);
            if (ObjectUtils.isEmpty(tableNameList)) {
                return false;
            }
            if (CacheUtil.getCachePrototype() == 1 || CacheUtil.getCachePrototype() == 2) {
                try {
                    boolean isSerial = CacheUtil.isSerial(rs);
                    if (!isSerial && CacheUtil.getCachePrototype() == 1) {
                        Logger.debug("bee.osql.cache.prototype=1 , the entity is not Serial, will do not put in cache!");
                        return false;
                    }
                    if (isSerial) {
                        JdkSerializer jdks = new JdkSerializer();
                        Object rsNew = jdks.unserialize(jdks.serialize(rs));
                        rs = rs instanceof String ? (String)rsNew : (rs instanceof List ? (List)rsNew : rsNew);
                    }
                }
                catch (Exception e) {
                    Logger.debug(e.getMessage(), e);
                    if (CacheUtil.getCachePrototype() != 1) break block19;
                    return false;
                }
            }
        }
        String key = CacheKey.genKey(sql);
        if (tableNameList != null && tableNameList.size() == 1 && CacheUtil._inConfigCacheTableMap(neverCacheTableMap, tableNameList)) {
            HoneyContext.deleteCacheInfo(sql);
            return false;
        }
        if (tableNameList != null && tableNameList.size() == 1) {
            if (CacheUtil._inConfigCacheTableMap(foreverCacheTableMap, tableNameList) && foreverCacheTableMap_sqlkey2exist.get(key) == null) {
                foreverCacheTableMap_sqlkey2exist.put(key, 1);
                foreverCacheObjectMap.put(key, rs);
                HoneyContext.deleteCacheInfo(sql);
                return false;
            }
            if (CacheUtil._inConfigCacheTableMap(foreverCacheModifySynTableMap, tableNameList) && CacheUtil._getConfigCacheTableMapValue(foreverCacheModifySynTableMap, tableNameList) == 0) {
                CacheUtil._regForeverSynTable(tableNameList.get(0), key);
                foreverModifySynCacheObjectMap.put(key, rs);
                HoneyContext.deleteCacheInfo(sql);
                return false;
            }
        }
        if (arrayIndex.isWouldbeFull()) {
            if (isShowSql) {
                Logger.warn("[Bee] ==========Cache would be full!");
            }
            new CacheDeleteThread(arrayIndex.getDeleteCacheIndex()).begin();
            if (arrayIndex.getUsedRate() >= 90) {
                if (isShowSql) {
                    Logger.warn("[Bee] ==========Cache already used more than 90% !");
                }
                HoneyContext.deleteCacheInfo(sql);
                return false;
            }
        }
        if (!CacheUtil.getUseLevelTwo()) {
            HoneyContext.deleteCacheInfo(sql);
        }
        int i = arrayIndex.getNext();
        long ms = System.currentTimeMillis();
        map.put(key, i);
        CacheUtil.time[i] = ms;
        CacheUtil.obj[i] = rs;
        CacheUtil.keys[i] = key;
        byte[] byArray = lock;
        synchronized (lock) {
            for (int k = 0; tableNameList != null && k < tableNameList.size(); ++k) {
                CacheUtil._regTabCache(tableNameList.get(k), i);
                CacheUtil._addIntableNameList(key, tableNameList.get(k));
            }
            // ** MonitorExit[var7_10] (shouldn't be in output)
            return true;
        }
    }

    private static void _regTabCache(String tableName, int index) {
        LinkedHashSet<Integer> set = (LinkedHashSet<Integer>)map_tableIndexSet.get(tableName);
        if (set != null) {
            set.add(index);
        } else {
            set = new LinkedHashSet<Integer>();
            set.add(index);
            map_tableIndexSet.put(tableName, set);
        }
    }

    private static void _regForeverSynTable(String tableName, String sqlKey) {
        Set<String> set = map_foreverSynTableIndexSet.get(CacheUtil.adjust(tableName));
        if (set != null) {
            set.add(sqlKey);
        } else {
            set = new HashSet<String>();
            set.add(sqlKey);
            map_foreverSynTableIndexSet.put(CacheUtil.adjust(tableName), set);
        }
    }

    private static String adjust(String tableName) {
        if (HoneyContext.isNeedDs()) {
            String ds = Router.getDsName();
            tableName = ds + "." + tableName;
        }
        return tableName;
    }

    public static void clear(String sql) {
        CacheUtil._clearForeverModifySyn(sql);
        CacheUtil._clearMoreTabCache(sql);
    }

    private static void _clearMoreTabCache(String sql) {
        List<String> tableNameList = CacheKey.genTableNameList(sql);
        HoneyContext.deleteCacheInfo(sql);
        for (int j = 0; tableNameList != null && j < tableNameList.size(); ++j) {
            CacheUtil._clearOneTabCache(tableNameList.get(j));
        }
    }

    private static void _clearForeverModifySyn(String sql) {
        List<String> tableNameList = CacheKey.genTableNameList(sql);
        if (tableNameList != null && tableNameList.size() > 0) {
            for (int j = 0; j < tableNameList.size(); ++j) {
                Integer k = CacheUtil._getConfigCacheTableMapValue(foreverCacheModifySynTableMap, tableNameList);
                if (k == null) continue;
                CacheUtil._clearOneTabCache_ForeverModifySyn(tableNameList.get(j));
            }
        }
    }

    private static void _clearOneTabCache_ForeverModifySyn(String tableName) {
        Set<String> set = map_foreverSynTableIndexSet.get(CacheUtil.adjust(tableName));
        if (set != null) {
            for (String i : set) {
                foreverModifySynCacheObjectMap.remove(i);
            }
            set = null;
            map_foreverSynTableIndexSet.remove(CacheUtil.adjust(tableName));
        }
    }

    private static void _clearOneTabCache(String tableName) {
        Set set = (Set)map_tableIndexSet.get(tableName);
        if (set != null) {
            for (Integer i : set) {
                if (keys[i] != null) {
                    List list = (List)map_tableNameList.get(keys[i]);
                    for (int j = 0; list != null && j < list.size(); ++j) {
                        if (tableName.equals(list.get(j))) continue;
                        map_tableIndexSet.remove(list.get(j));
                    }
                }
                CacheUtil._deleteCacheByIndex(i, false);
            }
            set = null;
            map_tableIndexSet.remove(tableName);
        }
    }

    private static void _addIntableNameList(String key, String tableName) {
        Vector<String> tableNameList = (Vector<String>)map_tableNameList.get(key);
        if (tableNameList != null) {
            tableNameList.add(tableName);
        } else {
            tableNameList = new Vector<String>();
            tableNameList.add(tableName);
            map_tableNameList.put(key, tableNameList);
        }
    }

    private static void _delTableIndexSetByKey(String key, int index) {
        List tableNameList = (List)map_tableNameList.get(key);
        if (tableNameList != null) {
            HashSet set = new HashSet();
            int size = tableNameList.size();
            for (int i = 0; i < size; ++i) {
                if (!set.add(tableNameList.get(i))) {
                    CacheUtil._clearOneTabCache((String)tableNameList.get(i));
                    continue;
                }
                CacheUtil._deleteTableIndexSet((String)tableNameList.get(i), index);
            }
        }
        map_tableNameList.remove(key);
    }

    private static void _deleteTableIndexSet(String tableName, int index) {
        Set set = (Set)map_tableIndexSet.get(tableName);
        if (set != null) {
            set.remove(index);
        }
    }

    private static boolean _inConfigCacheTableMap(Map map, List<String> list) {
        if (HoneyContext.isNeedDs()) {
            String tableName = list.get(0);
            if (map.get(tableName.toLowerCase()) != null) {
                return true;
            }
            String ds = Router.getDsName();
            return map.get((ds + "." + tableName).toLowerCase()) != null;
        }
        return map.get(list.get(0).toLowerCase()) != null;
    }

    private static Integer _getConfigCacheTableMapValue(Map<String, Integer> map, List<String> list) {
        if (HoneyContext.isNeedDs()) {
            String tableName = list.get(0);
            Integer v1 = map.get(tableName.toLowerCase());
            if (v1 != null) {
                return v1;
            }
            String ds = Router.getDsName();
            Integer v2 = map.get((ds + "." + tableName).toLowerCase());
            return v2;
        }
        return map.get(list.get(0).toLowerCase());
    }

    private static void initSpecialTable(String never, String forever, String foreverModifySyn) {
        int i;
        if (never != null) {
            String[] ns = never.split(",");
            for (i = 0; i < ns.length; ++i) {
                neverCacheTableMap.put(ns[i].trim().toLowerCase(), NEVER);
            }
        }
        if (forever != null) {
            String[] fs = forever.split(",");
            for (i = 0; i < fs.length; ++i) {
                foreverCacheTableMap.put(fs[i].trim().toLowerCase(), FOREVER);
            }
        }
        if (foreverModifySyn != null) {
            String[] fs_syn = foreverModifySyn.split(",");
            for (i = 0; i < fs_syn.length; ++i) {
                foreverCacheModifySynTableMap.put(fs_syn[i].trim().toLowerCase(), FOREVER);
            }
        }
    }

    private static int getCachePrototype() {
        return HoneyConfig.getHoneyConfig().cache_prototype;
    }

    private static Object copyObjectForGet(Object object) {
        block6: {
            if (CacheUtil.getCachePrototype() == 0) {
                return object;
            }
            try {
                if (CacheUtil.isSerial(object)) {
                    JdkSerializer jdks = new JdkSerializer();
                    return jdks.unserialize(jdks.serialize(object));
                }
                if (CacheUtil.getCachePrototype() == 1) {
                    return null;
                }
                if (CacheUtil.getCachePrototype() == 2) {
                    return object;
                }
            }
            catch (Exception e) {
                Logger.debug(e.getMessage(), e);
                if (CacheUtil.getCachePrototype() != 1) break block6;
                return null;
            }
        }
        return object;
    }

    private static boolean isSerial(Object rs) {
        if (rs instanceof List) {
            try {
                List list = (List)rs;
                if (list != null && list.size() > 0 && list.get(0) != null) {
                    return Serializable.class.isAssignableFrom(list.get(0).getClass());
                }
            }
            catch (Exception e) {
                Logger.debug(e.getMessage(), e);
            }
        }
        return Serializable.class.isAssignableFrom(rs.getClass());
    }

    static {
        neverCacheTableMap = new HashMap<String, String>();
        foreverCacheTableMap = new HashMap<String, Integer>();
        foreverCacheTableMap_sqlkey2exist = new HashMap<String, Integer>();
        foreverCacheModifySynTableMap = new HashMap<String, Integer>();
        FOREVER = 0;
        map_foreverSynTableIndexSet = new HashMap<String, Set<String>>();
        foreverCacheObjectMap = new HashMap<String, Object>();
        foreverModifySynCacheObjectMap = new Hashtable<String, Object>();
        isShowSql = false;
        logCacheMsg = "==========get from Cache.";
        MAX_SIZE = HoneyConfig.getHoneyConfig().cache_mapSize;
        isShowSql = HoneyConfig.getHoneyConfig().showSQL;
        timeout = HoneyConfig.getHoneyConfig().cache_timeout;
        CacheUtil.init();
    }
}

