/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.api.CallableSql;
import org.teasoft.honey.osql.core.AbstractCommOperate;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.JsonResultWrap;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.ResultAssemblerHandler;
import org.teasoft.honey.osql.core.TransformResultSet;

public class CallableSqlLib
extends AbstractCommOperate
implements CallableSql {
    private static final String VALUES = "  values: ";
    private static final String CALLABLE_SQL = "Callable SQL: ";
    private static final ThreadLocal<Map<String, Connection>> connLocal = new ThreadLocal();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> select(String callSql, T returnType, Object[] preValues) {
        Connection conn = null;
        ResultSet rs = null;
        CallableStatement cstmt = null;
        ArrayList<Object> rsList = null;
        Object targetObj = null;
        try {
            this.doBeforePasreEntity(returnType, SuidType.SELECT);
            conn = this.getConn();
            callSql = this.getCallSql(callSql);
            callSql = this.doAfterCompleteSql(callSql);
            cstmt = conn.prepareCall(callSql);
            StringBuffer values2333332 = this.initPreparedValues(cstmt, preValues);
            Logger.logSQL(CALLABLE_SQL, callSql + VALUES + values2333332);
            rs = cstmt.executeQuery();
            rsList = new ArrayList<Object>();
            while (rs.next()) {
                targetObj = ResultAssemblerHandler.rowToEntity(rs, this.toClassT(returnType));
                rsList.add(targetObj);
            }
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
                catch (IllegalAccessException e2) {
                    throw ExceptionHelper.convert(e2);
                }
                catch (InstantiationException e3) {
                    throw ExceptionHelper.convert(e3);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.checkClose(cstmt, conn);
                this.doBeforeReturn(rsList);
                targetObj = null;
                throw throwable;
            }
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception values2333332) {
            // empty catch block
        }
        this.checkClose(cstmt, conn);
        this.doBeforeReturn(rsList);
        return rsList;
    }

    private <T> Class<T> toClassT(T entity) {
        return entity.getClass();
    }

    public int modify(String callSql, Object[] preValues) {
        int result = 0;
        Connection conn = null;
        CallableStatement cstmt = null;
        try {
            this.doBeforePasreEntity2();
            conn = this.getConn();
            callSql = this.getCallSql(callSql);
            callSql = this.doAfterCompleteSql(callSql);
            cstmt = conn.prepareCall(callSql);
            StringBuffer values = this.initPreparedValues(cstmt, preValues);
            Logger.logSQL(CALLABLE_SQL, callSql + VALUES + values);
            result = cstmt.executeUpdate();
            this.checkClose(cstmt, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(cstmt, conn);
                this.doBeforeReturn();
                throw throwable;
            }
        }
        this.doBeforeReturn();
        return result;
    }

    public CallableStatement getCallableStatement(String callSql) {
        Connection conn = null;
        CallableStatement cstmt = null;
        try {
            conn = this.getConn();
            callSql = this.getCallSql(callSql);
            cstmt = conn.prepareCall(callSql);
            Logger.logSQL("Callable SQL,getCallableStatement: ", callSql);
            String key = this.getIdString(cstmt);
            this.setConnLocal(key, conn);
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
        return cstmt;
    }

    public int modify(CallableStatement cstmt) {
        int result = 0;
        try {
            String key = this.getIdString(cstmt);
            Connection conn = this.getConnLocal(key);
            result = cstmt.executeUpdate();
            this.checkClose(cstmt, conn);
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
        return result;
    }

    public List<String[]> select(String callSql, Object[] preValues) {
        List<String[]> list = null;
        Connection conn = null;
        ResultSet rs = null;
        CallableStatement cstmt = null;
        try {
            this.doBeforePasreEntity();
            conn = this.getConn();
            callSql = this.getCallSql(callSql);
            callSql = this.doAfterCompleteSql(callSql);
            cstmt = conn.prepareCall(callSql);
            StringBuffer values = this.initPreparedValues(cstmt, preValues);
            Logger.logSQL(CALLABLE_SQL, callSql + VALUES + values);
            rs = cstmt.executeQuery();
            list = TransformResultSet.toStringsList(rs);
            this.checkClose(cstmt, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(cstmt, conn);
                this.doBeforeReturn();
                throw throwable;
            }
        }
        this.doBeforeReturn();
        return list;
    }

    public String selectJson(String callSql, Object[] preValues) {
        String json = "";
        Connection conn = null;
        ResultSet rs = null;
        CallableStatement cstmt = null;
        try {
            this.doBeforePasreEntity();
            conn = this.getConn();
            callSql = this.getCallSql(callSql);
            callSql = this.doAfterCompleteSql(callSql);
            cstmt = conn.prepareCall(callSql);
            StringBuffer values = this.initPreparedValues(cstmt, preValues);
            Logger.logSQL(CALLABLE_SQL, callSql + VALUES + values);
            rs = cstmt.executeQuery();
            JsonResultWrap wrap = TransformResultSet.toJson(rs, null);
            json = wrap.getResultJson();
            int rowCount = wrap.getRowCount();
            this.logSelectRows(rowCount);
            this.checkClose(cstmt, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(cstmt, conn);
                this.doBeforeReturn();
                throw throwable;
            }
        }
        this.doBeforeReturn();
        return json;
    }

    private void logSelectRows(int size) {
        Logger.logSQL(" | <--  select rows: ", size + "");
    }

    private String getCallSql(String callSql) {
        return "{call " + callSql + "}";
    }

    private void setConnLocal(String key, Connection conn) {
        if (conn == null) {
            return;
        }
        Map<String, Connection> map = connLocal.get();
        if (map == null) {
            map = new HashMap<String, Connection>();
        }
        map.put(key, conn);
        connLocal.set(map);
    }

    private Connection getConnLocal(String key) {
        Map<String, Connection> map = connLocal.get();
        if (map == null) {
            return null;
        }
        Connection s = map.get(key);
        map.remove(key);
        connLocal.remove();
        return s;
    }

    private String getIdString(CallableStatement cstmt) {
        return cstmt.hashCode() + "";
    }

    private StringBuffer initPreparedValues(CallableStatement cstmt, Object[] preValues) throws SQLException {
        if (preValues == null) {
            return new StringBuffer("preValues is null!");
        }
        boolean isShowSQL = CallableSqlLib.isShowSQL();
        StringBuffer valueBuffer = new StringBuffer();
        int len = preValues.length;
        for (int i = 0; i < len; ++i) {
            int k = -1;
            if (preValues[i] != null) {
                k = HoneyUtil.getJavaTypeIndex(preValues[i].getClass().getName());
            }
            HoneyUtil.setPreparedValues(cstmt, k, i, preValues[i]);
            if (!isShowSQL) continue;
            valueBuffer.append(",");
            valueBuffer.append(preValues[i]);
        }
        if (isShowSQL && valueBuffer.length() > 0) {
            valueBuffer.deleteCharAt(0);
        }
        return valueBuffer;
    }

    private Connection getConn() throws SQLException {
        return HoneyContext.getConn();
    }

    protected void checkClose(Statement stmt, Connection conn) {
        HoneyContext.checkClose(stmt, conn);
    }

    private void doBeforePasreEntity() {
        Object entity = null;
        super.doBeforePasreEntity((Object)entity, SuidType.SELECT);
    }

    private void doBeforePasreEntity2() {
        Object entity = null;
        super.doBeforePasreEntity((Object)entity, SuidType.MODIFY);
    }

    private static boolean isShowSQL() {
        return HoneyConfig.getHoneyConfig().showSQL;
    }
}

