/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.Op;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.TO_DATE;
import org.teasoft.bee.osql.api.Condition;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.bee.osql.exception.BeeIllegalSQLException;
import org.teasoft.bee.sharding.FunStruct;
import org.teasoft.bee.sharding.GroupFunStruct;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.ConditionImpl;
import org.teasoft.honey.osql.core.Expression;
import org.teasoft.honey.osql.core.FunAndOrderTypeMap;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MoreTableStruct;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.UpdateSetConditionWrap;
import org.teasoft.honey.osql.core.WhereConditionWrap;
import org.teasoft.honey.osql.dialect.sqlserver.SqlServerPagingStruct;
import org.teasoft.honey.osql.util.NameCheckUtil;
import org.teasoft.honey.sharding.ShardingReg;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.util.StringUtils;

public class ConditionHelper {
    private static final String ONE_SPACE = " ";
    private static final String setAdd = "setAdd";
    private static final String setMultiply = "setMultiply";
    private static final String setAddField = "setAddField";
    private static final String setMultiplyField = "setMultiplyField";
    private static final String setWithField = "setWithField";
    private static final String GROUP_BY = "groupBy";
    private static final String HAVING = "having";

    private ConditionHelper() {
    }

    private static DbFeature getDbFeature() {
        return BeeFactory.getHoneyFactory().getDbFeature();
    }

    static boolean processConditionForUpdateSet(StringBuffer sqlBuffer, List<PreparedValue> list, Condition condition) {
        return ConditionHelper.processUpdateSetCondition(sqlBuffer, list, condition, true).isFirst();
    }

    static UpdateSetConditionWrap processUpdateSetCondition(Condition condition) {
        return ConditionHelper.processUpdateSetCondition(new StringBuffer(), new ArrayList<PreparedValue>(), condition, true);
    }

    static UpdateSetConditionWrap processUpdateSetCondition(StringBuffer sqlBuffer, List<PreparedValue> list, Condition condition, boolean firstSet) {
        Class entityClass = (Class)OneTimeParameter.getAttribute("_SYS_Bee_COLUMN_EC");
        if (condition == null) {
            return null;
        }
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        List<Expression> updateSetList = conditionImpl.getUpdateExpList();
        if (updateSetList != null && updateSetList.size() > 0 && SuidType.UPDATE != conditionImpl.getSuidType()) {
            throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support the method set ,setAdd or setMultiply!");
        }
        Expression expression = null;
        for (int j = 0; updateSetList != null && j < updateSetList.size(); ++j) {
            expression = updateSetList.get(j);
            String opType = expression.getOpType();
            if (opType != null && expression.getValue() == null) {
                throw new BeeErrorGrammarException("the value is null (" + conditionImpl.getSuidType() + ", method:" + opType + ", fieldName:" + expression.getFieldName() + ")!");
            }
            if (firstSet) {
                firstSet = false;
            } else {
                sqlBuffer.append(",");
            }
            sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), null, entityClass));
            sqlBuffer.append("=");
            if (opType == null && expression.getValue() == null) {
                sqlBuffer.append(K.Null);
                continue;
            }
            if (opType != null) {
                if (setWithField.equals(opType)) {
                    sqlBuffer.append(ConditionHelper._toColumnName((String)expression.getValue(), entityClass));
                } else {
                    sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), entityClass));
                }
            }
            if (setAddField.equals(opType)) {
                sqlBuffer.append("+");
                sqlBuffer.append(ConditionHelper._toColumnName((String)expression.getValue(), entityClass));
                continue;
            }
            if (setMultiplyField.equals(opType)) {
                sqlBuffer.append("*");
                sqlBuffer.append(ConditionHelper._toColumnName((String)expression.getValue(), entityClass));
                continue;
            }
            if (setAdd.equals(opType)) {
                sqlBuffer.append("+");
            } else if (setMultiply.equals(opType)) {
                sqlBuffer.append("*");
            }
            if (setWithField.equals(opType)) continue;
            sqlBuffer.append("?");
            ConditionHelper.addValeToPvList(list, expression.getValue());
        }
        return new UpdateSetConditionWrap(sqlBuffer, list, firstSet);
    }

    static boolean processCondition(StringBuffer sqlBuffer, List<PreparedValue> list, Condition condition, boolean firstWhere) {
        return ConditionHelper.processCondition(sqlBuffer, list, condition, firstWhere, null);
    }

    static boolean processCondition(StringBuffer sqlBuffer, List<PreparedValue> list, Condition condition, boolean firstWhere, String[] useSubTableNames) {
        List<Expression> updateSetList;
        Boolean isForUpdate;
        Class entityClass = (Class)OneTimeParameter.getAttribute("_SYS_Bee_COLUMN_EC");
        if (condition == null) {
            return firstWhere;
        }
        boolean isNeedAnd = true;
        boolean isFirstWhere = firstWhere;
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        List<Expression> expList = conditionImpl.getExpList();
        Expression expression = null;
        Integer start = conditionImpl.getStart();
        if (start != null && SuidType.SELECT != conditionImpl.getSuidType()) {
            throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support paging with start !");
        }
        String columnName = "";
        for (int j = 0; j < expList.size(); ++j) {
            Object v;
            expression = expList.get(j);
            String opType = expression.getOpType();
            columnName = ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames, entityClass);
            if ((GROUP_BY.equalsIgnoreCase(opType) || HAVING.equalsIgnoreCase(opType)) && SuidType.SELECT != conditionImpl.getSuidType()) {
                throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support the opType: " + opType + "!");
            }
            if (firstWhere) {
                if (GROUP_BY.equalsIgnoreCase(opType) || HAVING.equalsIgnoreCase(opType) || "orderBy".equalsIgnoreCase(opType)) {
                    firstWhere = false;
                } else {
                    sqlBuffer.append(ONE_SPACE).append(K.where).append(ONE_SPACE);
                    firstWhere = false;
                    isNeedAnd = false;
                    isFirstWhere = false;
                }
            }
            if (Op.in.getOperator().equalsIgnoreCase(opType) || Op.notIn.getOperator().equalsIgnoreCase(opType)) {
                v = expression.getValue();
                isNeedAnd = ConditionHelper.adjustAnd(sqlBuffer, isNeedAnd);
                sqlBuffer.append(columnName);
                if (HoneyUtil.isSqlKeyWordUpper()) {
                    sqlBuffer.append(expression.getOpType().toUpperCase());
                } else {
                    sqlBuffer.append(expression.getOpType());
                }
                ConditionHelper.processIn(sqlBuffer, list, v);
                isNeedAnd = true;
                continue;
            }
            if (Op.like.getOperator().equalsIgnoreCase(opType) || Op.notLike.getOperator().equalsIgnoreCase(opType)) {
                isNeedAnd = ConditionHelper.adjustAnd(sqlBuffer, isNeedAnd);
                sqlBuffer.append(columnName);
                if (HoneyUtil.isSqlKeyWordUpper()) {
                    sqlBuffer.append(expression.getOpType().toUpperCase());
                } else {
                    sqlBuffer.append(expression.getOpType());
                }
                sqlBuffer.append("?");
                v = (String)expression.getValue();
                v = ConditionHelper.processLike(expression.getOp(), (String)v);
                ConditionHelper.addValeToPvList(list, v);
                isNeedAnd = true;
                continue;
            }
            if (" between ".equalsIgnoreCase(opType) || " not between ".equalsIgnoreCase(opType)) {
                isNeedAnd = ConditionHelper.adjustAnd(sqlBuffer, isNeedAnd);
                sqlBuffer.append(columnName);
                sqlBuffer.append(opType);
                sqlBuffer.append("?");
                sqlBuffer.append(ONE_SPACE + K.and + ONE_SPACE);
                sqlBuffer.append("?");
                ConditionHelper.addValeToPvList(list, expression.getValue());
                ConditionHelper.addValeToPvList(list, expression.getValue2());
                isNeedAnd = true;
                continue;
            }
            if (GROUP_BY.equalsIgnoreCase(opType)) {
                if (SuidType.SELECT != conditionImpl.getSuidType()) {
                    throw new BeeErrorGrammarException("BeeErrorGrammarException: " + conditionImpl.getSuidType() + " do not support 'group by' !");
                }
                sqlBuffer.append(expression.getValue());
                sqlBuffer.append(columnName);
                continue;
            }
            if (HAVING.equalsIgnoreCase(opType)) {
                if (SuidType.SELECT != conditionImpl.getSuidType()) {
                    throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support 'having' !");
                }
                if (5 != expression.getOpNum()) continue;
                sqlBuffer.append(expression.getValue());
                sqlBuffer.append(FunAndOrderTypeMap.transfer(expression.getValue3().toString()));
                sqlBuffer.append("(");
                if (FunctionType.COUNT.getName().equals(expression.getValue3()) && "*".equals(expression.getFieldName().trim())) {
                    sqlBuffer.append("*");
                } else {
                    sqlBuffer.append(columnName);
                }
                sqlBuffer.append(")");
                sqlBuffer.append(expression.getValue4());
                sqlBuffer.append("?");
                ConditionHelper.addValeToPvList(list, expression.getValue2());
                continue;
            }
            if ("orderBy".equalsIgnoreCase(opType)) {
                if (SuidType.SELECT != conditionImpl.getSuidType()) {
                    throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support 'order by' !");
                }
                sqlBuffer.append(expression.getValue());
                if (4 == expression.getOpNum()) {
                    sqlBuffer.append(FunAndOrderTypeMap.transfer(expression.getValue3().toString()));
                    sqlBuffer.append("(");
                    sqlBuffer.append(columnName);
                    sqlBuffer.append(")");
                } else {
                    sqlBuffer.append(columnName);
                }
                if (3 != expression.getOpNum() && 4 != expression.getOpNum()) continue;
                sqlBuffer.append(ONE_SPACE);
                sqlBuffer.append(FunAndOrderTypeMap.transfer(expression.getValue2().toString()));
                continue;
            }
            if (expression.getOpNum() == -2) {
                isNeedAnd = ConditionHelper.adjustAnd(sqlBuffer, isNeedAnd);
                sqlBuffer.append(expression.getValue());
                continue;
            }
            if (expression.getOpNum() == -1) {
                sqlBuffer.append(expression.getValue());
                isNeedAnd = true;
                continue;
            }
            if (expression.getOpNum() == 1) {
                if ("!".equals(expression.getValue())) {
                    isNeedAnd = ConditionHelper.adjustAnd(sqlBuffer, isNeedAnd);
                    sqlBuffer.append(expression.getValue());
                } else {
                    sqlBuffer.append(ONE_SPACE);
                    sqlBuffer.append(expression.getValue());
                    sqlBuffer.append(ONE_SPACE);
                }
                isNeedAnd = false;
                continue;
            }
            isNeedAnd = ConditionHelper.adjustAnd(sqlBuffer, isNeedAnd);
            sqlBuffer.append(columnName);
            if (expression.getValue() == null) {
                if ("=".equals(expression.getOpType())) {
                    sqlBuffer.append(ONE_SPACE + K.isNull);
                } else {
                    sqlBuffer.append(ONE_SPACE + K.isNotNull);
                    if (!"!=".equals(expression.getOpType())) {
                        String fieldName = columnName;
                        Logger.warn(fieldName + expression.getOpType() + "null transfer to : " + fieldName + ONE_SPACE + K.isNotNull);
                    }
                }
            } else if (expression.getOpNum() == -3) {
                sqlBuffer.append(expression.getOpType());
                sqlBuffer.append(expression.getValue());
            } else {
                sqlBuffer.append(expression.getOpType());
                if (expression.getValue().getClass() == TO_DATE.class) {
                    TO_DATE to_date = (TO_DATE)expression.getValue();
                    String formatter = to_date.getFormatter();
                    if (NameCheckUtil.isContainCommentString(formatter)) {
                        throw new BeeIllegalSQLException("formatter :" + formatter + " , have sql comment character");
                    }
                    if (!HoneyUtil.isOracle()) {
                        Logger.warn("Make sure the Database support TO_DATE() function!");
                    }
                    sqlBuffer.append(K.to_date + "(?, '" + formatter + "')");
                    ConditionHelper.addValeToPvList(list, to_date.getDatetimeValue());
                } else {
                    sqlBuffer.append("?");
                    ConditionHelper.addValeToPvList(list, expression.getValue());
                }
            }
            isNeedAnd = true;
        }
        if (SuidType.SELECT == conditionImpl.getSuidType()) {
            if (!OneTimeParameter.isTrue("_SYS_Bee_Select_Fun")) {
                Map<String, String> orderByMap;
                Integer size = conditionImpl.getSize();
                String sql = "";
                if (start != null && start != -1 && size != null) {
                    HoneyUtil.regPagePlaceholder();
                    orderByMap = conditionImpl.getOrderBy();
                    ConditionHelper.adjustSqlServerPagingIfNeed(sqlBuffer, orderByMap, start, entityClass, useSubTableNames);
                    sql = ConditionHelper.getDbFeature().toPageSql(sqlBuffer.toString(), start.intValue(), size.intValue());
                    ShardingReg.regShadingPage(sqlBuffer.toString(), sql, start, size);
                    sqlBuffer.delete(0, sqlBuffer.length());
                    sqlBuffer.append(sql);
                    HoneyUtil.setPageNum(list);
                } else if (size != null) {
                    HoneyUtil.regPagePlaceholder();
                    orderByMap = conditionImpl.getOrderBy();
                    ConditionHelper.adjustSqlServerPagingIfNeed(sqlBuffer, orderByMap, 0, entityClass, useSubTableNames);
                    sql = ConditionHelper.getDbFeature().toPageSql(sqlBuffer.toString(), size.intValue());
                    ShardingReg.regShadingPage(sqlBuffer.toString(), sql, null, size);
                    sqlBuffer.delete(0, sqlBuffer.length());
                    sqlBuffer.append(sql);
                    HoneyUtil.setPageNum(list);
                }
            }
            ShardingReg.regShardingSort(conditionImpl.getOrderBy());
        }
        if (useSubTableNames == null && SuidType.SELECT == conditionImpl.getSuidType() && (isForUpdate = conditionImpl.getForUpdate()) != null && isForUpdate.booleanValue()) {
            sqlBuffer.append(ONE_SPACE + K.forUpdate + ONE_SPACE);
        }
        if (SuidType.SELECT == conditionImpl.getSuidType() && (updateSetList = conditionImpl.getUpdateExpList()) != null && updateSetList.size() > 0) {
            Logger.warn("Use Condition's set method(s) in SELECT type, but it just effect in UPDATE type! Involved field(s): " + conditionImpl.getUpdatefields());
        }
        return isFirstWhere;
    }

    public static List<PreparedValue> processIn(Object v) {
        ArrayList<PreparedValue> inList = new ArrayList<PreparedValue>();
        if (List.class.isAssignableFrom(v.getClass()) || Set.class.isAssignableFrom(v.getClass())) {
            Collection c = (Collection)v;
            for (Object e : c) {
                ConditionHelper.setPreValue(inList, e);
            }
        } else if (HoneyUtil.isNumberArray(v)) {
            Number[] n;
            for (Number number : n = (Number[])v) {
                ConditionHelper.setPreValue(inList, number);
            }
        } else if (v instanceof String) {
            String[] values;
            for (String e : values = v.toString().trim().split(",")) {
                ConditionHelper.setPreValue(inList, e);
            }
        } else {
            ConditionHelper.setPreValue(inList, v);
        }
        return inList;
    }

    private static void checkLikeEmptyException(String value) {
        if ("".equals(value)) {
            throw new BeeIllegalSQLException("Like has SQL injection risk! the value can not be empty string!");
        }
    }

    private static void setPreValue(List<PreparedValue> list, Object value) {
        ConditionHelper.addValeToPvList(list, value);
    }

    private static void adjustSqlServerPagingIfNeed(StringBuffer sqlBuffer, Map<String, String> orderByMap, Integer start, Class entityClass, String[] useSubTableNames) {
        if (!HoneyUtil.isSqlServer()) {
            return;
        }
        SqlServerPagingStruct struct = new SqlServerPagingStruct();
        boolean needAdjust = false;
        boolean justChangePk = false;
        String pkName = "id";
        int majorVersion = HoneyConfig.getHoneyConfig().getDatabaseMajorVersion();
        if (HoneyUtil.isSqlServer()) {
            if (orderByMap.size() > 0) {
                struct.setHasOrderBy(true);
                if (majorVersion >= 11) {
                    needAdjust = true;
                } else if (start > 1) {
                    String pkName0;
                    String order = orderByMap.get("id");
                    if (order != null) {
                        pkName = "id";
                        if ("desc".equals(order)) {
                            needAdjust = true;
                            struct.setOrderType(OrderType.DESC);
                        }
                    }
                    if (!needAdjust && !"".equals(pkName0 = HoneyUtil.getPkFieldNameByClass(entityClass)) && (order = orderByMap.get(pkName = pkName0.split(",")[0])) != null) {
                        if ("desc".equals(order)) {
                            needAdjust = true;
                            struct.setOrderType(OrderType.DESC);
                        } else {
                            justChangePk = true;
                            struct.setJustChangeOrderColumn(true);
                        }
                    }
                }
            } else {
                String pkName0 = HoneyUtil.getPkFieldNameByClass(entityClass);
                if (!"".equals(pkName0)) {
                    pkName = pkName0.split(",")[0];
                    justChangePk = true;
                    struct.setJustChangeOrderColumn(true);
                }
            }
        }
        if ((pkName = ConditionHelper._toColumnName(pkName, useSubTableNames, entityClass)).contains(".")) {
            justChangePk = true;
            struct.setJustChangeOrderColumn(true);
        }
        struct.setOrderColumn(pkName);
        HoneyContext.setSqlServerPagingStruct(sqlBuffer.toString(), struct);
    }

    static String processSelectField(String columnNames, Condition condition) {
        return ConditionHelper.processSelectField(columnNames, condition, null);
    }

    static String processSelectField(String columnNames, Condition condition, Map<String, String> subDulFieldMap) {
        if (condition == null) {
            return null;
        }
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        if (SuidType.SELECT != conditionImpl.getSuidType()) {
            throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support specifying partial fields by method selectField(String) !");
        }
        String[] selectField = conditionImpl.getSelectField();
        if (selectField == null) {
            return null;
        }
        return HoneyUtil.checkAndProcessSelectFieldViaString(columnNames, subDulFieldMap, selectField);
    }

    public static String processFunction(String columnNames, Condition condition) {
        boolean get_FunStructForSharding = OneTimeParameter.isTrue("_SYS_Bee_Get_GroupFunStruct");
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        List<ConditionImpl.FunExpress> funExpList = conditionImpl.getFunExpList();
        String funStr = "";
        boolean isFirst = true;
        int size = funExpList.size();
        ArrayList<FunStruct> funStructs = null;
        String funUseName = "";
        boolean bl = get_FunStructForSharding = get_FunStructForSharding && size > 0 && ShardingUtil.hadSharding();
        if (get_FunStructForSharding) {
            funStructs = new ArrayList<FunStruct>(size);
        }
        boolean hasAvg = false;
        for (int i = 0; i < funExpList.size(); ++i) {
            String columnName = "*".equals(funExpList.get(i).getField()) ? "*" : HoneyUtil.checkAndProcessSelectFieldViaString(columnNames, null, false, funExpList.get(i).getField());
            if (isFirst) {
                isFirst = false;
            } else {
                funStr = funStr + ",";
            }
            String functionTypeName = funExpList.get(i).getFunctionType();
            functionTypeName = FunAndOrderTypeMap.transfer(functionTypeName);
            funStr = funStr + functionTypeName + "(" + columnName + ")";
            String alias = funExpList.get(i).getAlias();
            if (StringUtils.isNotBlank(alias)) {
                funStr = funStr + ONE_SPACE + K.as + ONE_SPACE + alias;
                funUseName = alias;
            } else {
                funUseName = columnName;
            }
            if (!get_FunStructForSharding) continue;
            funStructs.add(new FunStruct(funUseName, functionTypeName));
            if (hasAvg || !FunctionType.AVG.getName().equalsIgnoreCase(functionTypeName)) continue;
            hasAvg = true;
            funStructs.add(new FunStruct(funUseName + "_sum_", FunctionType.SUM.getName()));
            funStructs.add(new FunStruct(funUseName + "_count_", FunctionType.COUNT.getName()));
            funStr = funStr + ", sum(" + columnName + ") " + K.as + ONE_SPACE + funUseName + "_sum_ , count(" + columnName + ") " + K.as + ONE_SPACE + funUseName + "_count_ ";
        }
        if (get_FunStructForSharding) {
            GroupFunStruct struct = new GroupFunStruct();
            struct.setFunStructs(funStructs);
            struct.setHasAvg(hasAvg);
            OneTimeParameter.setAttribute("_SYS_Bee_Return_GroupFunStruct", struct);
        }
        return funStr;
    }

    public static void processOnExpression(Condition condition, MoreTableStruct[] moreTableStruct, List<PreparedValue> list) {
        Class entityClass = (Class)OneTimeParameter.getAttribute("_SYS_Bee_COLUMN_EC");
        if (condition == null || moreTableStruct == null) {
            return;
        }
        ArrayList<PreparedValue> list2 = new ArrayList<PreparedValue>();
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        List<Expression> onExpList = conditionImpl.getOnExpList();
        StringBuffer onExpBuffer = new StringBuffer();
        Expression exp = null;
        int sub1 = 0;
        int sub2 = 0;
        for (int i = 0; i < onExpList.size(); ++i) {
            exp = onExpList.get(i);
            if (moreTableStruct[0].joinTableNum == 1 && i != 0) {
                onExpBuffer.append(K.space).append(K.and).append(K.space);
            }
            onExpBuffer.append(ConditionHelper._toColumnName(exp.getFieldName(), entityClass));
            onExpBuffer.append(K.space);
            onExpBuffer.append(exp.opType);
            onExpBuffer.append("?");
            if (moreTableStruct[0].joinTableNum == 2) {
                String fieldName = exp.getFieldName();
                if (fieldName.startsWith(moreTableStruct[2].tableName + ".") || moreTableStruct[2].hasSubAlias && fieldName.startsWith(moreTableStruct[2].subAlias + ".")) {
                    if (sub2 != 0) {
                        moreTableStruct[2].onExpression = moreTableStruct[2].onExpression + K.space + K.and + K.space;
                    }
                    moreTableStruct[2].onExpression = moreTableStruct[2].onExpression + onExpBuffer.toString();
                    ++sub2;
                    ConditionHelper.addValeToList(list2, exp);
                } else {
                    if (sub1 != 0) {
                        moreTableStruct[2].onExpression = moreTableStruct[2].onExpression + K.space + K.and + K.space;
                    }
                    moreTableStruct[1].onExpression = moreTableStruct[1].onExpression + onExpBuffer.toString();
                    ++sub1;
                    ConditionHelper.addValeToList(list, exp);
                }
                if (i != onExpList.size() - 1) {
                    onExpBuffer = new StringBuffer();
                }
            } else {
                ConditionHelper.addValeToList(list, exp);
            }
            if (i != onExpList.size() - 1) continue;
            if (moreTableStruct[0].joinTableNum == 1) {
                moreTableStruct[1].onExpression = onExpBuffer.toString();
                continue;
            }
            if (sub2 == 0) continue;
            list.addAll(list2);
        }
    }

    private static void addValeToList(List<PreparedValue> list, Expression exp) {
        PreparedValue preparedValue = new PreparedValue();
        preparedValue.setType(exp.getValue().getClass().getName());
        preparedValue.setValue(exp.getValue());
        list.add(preparedValue);
    }

    private static String _toColumnName(String fieldName, Class entityClass) {
        return NameTranslateHandle.toColumnName(fieldName, entityClass);
    }

    private static String _toColumnName(String fieldName, String[] useSubTableNames, Class entityClass) {
        if (StringUtils.isBlank(fieldName)) {
            return fieldName;
        }
        if (!fieldName.contains(",")) {
            return ConditionHelper._toColumnName0(fieldName, useSubTableNames, entityClass);
        }
        String[] str = fieldName.split(",");
        String newFields = "";
        int len = str.length;
        for (int i = 0; i < len; ++i) {
            newFields = newFields + ConditionHelper._toColumnName0(str[i], useSubTableNames, entityClass);
            if (i == len - 1) continue;
            newFields = newFields + ",";
        }
        return newFields;
    }

    private static String _toColumnName0(String fieldName, String[] useSubTableNames, Class entityClass) {
        if (useSubTableNames == null) {
            return NameTranslateHandle.toColumnName(fieldName, entityClass);
        }
        String t_fieldName = "";
        String t_tableName = "";
        String find_tableName = "";
        int index = fieldName.indexOf(46);
        if (index > -1) {
            t_fieldName = fieldName.substring(index + 1);
            t_tableName = fieldName.substring(0, index);
            if (useSubTableNames[0] != null && useSubTableNames[0].equals(t_tableName)) {
                find_tableName = t_tableName;
            } else if (useSubTableNames[1] != null && useSubTableNames[1].equals(t_tableName)) {
                find_tableName = t_tableName;
            } else {
                OneTimeParameter.setTrueForKey("_SYS_Bee_DoNotCheckAnnotation");
                find_tableName = NameTranslateHandle.toTableName(t_tableName);
            }
            return find_tableName + "." + NameTranslateHandle.toColumnName(t_fieldName, entityClass);
        }
        fieldName = useSubTableNames[2] + "." + fieldName;
        return NameTranslateHandle.toColumnName(fieldName, entityClass);
    }

    private static boolean adjustAnd(StringBuffer sqlBuffer, boolean isNeedAnd) {
        if (isNeedAnd) {
            sqlBuffer.append(ONE_SPACE + K.and + ONE_SPACE);
            isNeedAnd = false;
        }
        return isNeedAnd;
    }

    public static Integer getPageSize(Condition condition) {
        if (condition == null) {
            return null;
        }
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        return conditionImpl.getSize();
    }

    public static void processIn(StringBuffer sqlBuffer, List<PreparedValue> list, Object v) {
        sqlBuffer.append(" (");
        sqlBuffer.append("?");
        int len = 1;
        boolean needSetNull = false;
        if (v == null) {
            needSetNull = true;
        } else {
            List<PreparedValue> inList = ConditionHelper.processIn(v);
            len = inList.size();
            if (len > 0) {
                list.addAll(inList);
            } else if (len == 0) {
                needSetNull = true;
            }
        }
        if (needSetNull) {
            PreparedValue p = new PreparedValue();
            p.setValue(null);
            p.setType(Object.class.getName());
            list.add(p);
        }
        for (int i = 1; i < len; ++i) {
            sqlBuffer.append(",?");
        }
        sqlBuffer.append(")");
    }

    public static String processLike(Op op, String v) {
        if (v != null) {
            if (Op.likeLeft == op) {
                ConditionHelper.checkLikeEmptyException(v);
                v = "%" + StringUtils.escapeLike(v);
            } else if (Op.likeRight == op) {
                ConditionHelper.checkLikeEmptyException(v);
                v = StringUtils.escapeLike(v) + "%";
            } else if (Op.likeLeftRight == op) {
                ConditionHelper.checkLikeEmptyException(v);
                v = "%" + StringUtils.escapeLike(v) + "%";
            } else if (StringUtils.justLikeChar(v)) {
                throw new BeeIllegalSQLException("Like has SQL injection risk!  like '" + v + "'");
            }
        } else {
            Logger.warn("the parameter value in like is null !", (Throwable)new BeeIllegalSQLException());
        }
        return v;
    }

    static WhereConditionWrap processWhereCondition(Condition condition) {
        return ConditionHelper.processWhereCondition(condition, true, null);
    }

    static WhereConditionWrap processWhereCondition(Condition condition, boolean firstWhere, String[] useSubTableNames) {
        Class entityClass = (Class)OneTimeParameter.getAttribute("_SYS_Bee_COLUMN_EC");
        if (condition == null) {
            return null;
        }
        StringBuffer sqlBuffer = new StringBuffer();
        Vector<PreparedValue> list = new Vector<PreparedValue>();
        boolean isNeedAnd = true;
        boolean isFirstWhere = firstWhere;
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        List<Expression> expList = conditionImpl.getExpList();
        Integer start = conditionImpl.getStart();
        if (start != null && SuidType.SELECT != conditionImpl.getSuidType()) {
            throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support paging with start !");
        }
        String columnName = "";
        Expression expression = null;
        for (int j = 0; j < expList.size(); ++j) {
            Object v;
            expression = expList.get(j);
            String opType = expression.getOpType();
            columnName = ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames, entityClass);
            if ((GROUP_BY.equalsIgnoreCase(opType) || HAVING.equalsIgnoreCase(opType)) && SuidType.SELECT != conditionImpl.getSuidType()) {
                throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support the opType: " + opType + "!");
            }
            if (firstWhere) {
                if (GROUP_BY.equalsIgnoreCase(opType) || HAVING.equalsIgnoreCase(opType) || "orderBy".equalsIgnoreCase(opType)) {
                    firstWhere = false;
                } else {
                    sqlBuffer.append(ONE_SPACE).append(K.where).append(ONE_SPACE);
                    firstWhere = false;
                    isNeedAnd = false;
                    isFirstWhere = false;
                }
            }
            if (Op.in.getOperator().equalsIgnoreCase(opType) || Op.notIn.getOperator().equalsIgnoreCase(opType)) {
                v = expression.getValue();
                isNeedAnd = ConditionHelper.adjustAnd(sqlBuffer, isNeedAnd);
                sqlBuffer.append(columnName);
                if (HoneyUtil.isSqlKeyWordUpper()) {
                    sqlBuffer.append(expression.getOpType().toUpperCase());
                } else {
                    sqlBuffer.append(expression.getOpType());
                }
                ConditionHelper.processIn(sqlBuffer, list, v);
                isNeedAnd = true;
                continue;
            }
            if (Op.like.getOperator().equalsIgnoreCase(opType) || Op.notLike.getOperator().equalsIgnoreCase(opType)) {
                isNeedAnd = ConditionHelper.adjustAnd(sqlBuffer, isNeedAnd);
                sqlBuffer.append(columnName);
                if (HoneyUtil.isSqlKeyWordUpper()) {
                    sqlBuffer.append(expression.getOpType().toUpperCase());
                } else {
                    sqlBuffer.append(expression.getOpType());
                }
                sqlBuffer.append("?");
                v = (String)expression.getValue();
                v = ConditionHelper.processLike(expression.getOp(), (String)v);
                ConditionHelper.addValeToPvList(list, v);
                isNeedAnd = true;
                continue;
            }
            if (" between ".equalsIgnoreCase(opType) || " not between ".equalsIgnoreCase(opType)) {
                isNeedAnd = ConditionHelper.adjustAnd(sqlBuffer, isNeedAnd);
                sqlBuffer.append(columnName);
                sqlBuffer.append(opType);
                sqlBuffer.append("?");
                sqlBuffer.append(ONE_SPACE + K.and + ONE_SPACE);
                sqlBuffer.append("?");
                ConditionHelper.addValeToPvList(list, expression.getValue());
                ConditionHelper.addValeToPvList(list, expression.getValue2());
                isNeedAnd = true;
                continue;
            }
            if (GROUP_BY.equalsIgnoreCase(opType)) {
                if (SuidType.SELECT != conditionImpl.getSuidType()) {
                    throw new BeeErrorGrammarException("BeeErrorGrammarException: " + conditionImpl.getSuidType() + " do not support 'group by' !");
                }
                sqlBuffer.append(expression.getValue());
                sqlBuffer.append(columnName);
                continue;
            }
            if (HAVING.equalsIgnoreCase(opType)) {
                if (SuidType.SELECT != conditionImpl.getSuidType()) {
                    throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support 'having' !");
                }
                if (5 != expression.getOpNum()) continue;
                sqlBuffer.append(expression.getValue());
                sqlBuffer.append(FunAndOrderTypeMap.transfer(expression.getValue3().toString()));
                sqlBuffer.append("(");
                if (FunctionType.COUNT.getName().equals(expression.getValue3()) && "*".equals(expression.getFieldName().trim())) {
                    sqlBuffer.append("*");
                } else {
                    sqlBuffer.append(columnName);
                }
                sqlBuffer.append(")");
                sqlBuffer.append(expression.getValue4());
                sqlBuffer.append("?");
                ConditionHelper.addValeToPvList(list, expression.getValue2());
                continue;
            }
            if ("orderBy".equalsIgnoreCase(opType)) {
                if (SuidType.SELECT != conditionImpl.getSuidType()) {
                    throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support 'order by' !");
                }
                sqlBuffer.append(expression.getValue());
                if (4 == expression.getOpNum()) {
                    sqlBuffer.append(FunAndOrderTypeMap.transfer(expression.getValue3().toString()));
                    sqlBuffer.append("(");
                    sqlBuffer.append(columnName);
                    sqlBuffer.append(")");
                } else {
                    sqlBuffer.append(columnName);
                }
                if (3 != expression.getOpNum() && 4 != expression.getOpNum()) continue;
                sqlBuffer.append(ONE_SPACE);
                sqlBuffer.append(FunAndOrderTypeMap.transfer(expression.getValue2().toString()));
                continue;
            }
            if (expression.getOpNum() == -2) {
                isNeedAnd = ConditionHelper.adjustAnd(sqlBuffer, isNeedAnd);
                sqlBuffer.append(expression.getValue());
                continue;
            }
            if (expression.getOpNum() == -1) {
                sqlBuffer.append(expression.getValue());
                isNeedAnd = true;
                continue;
            }
            if (expression.getOpNum() == 1) {
                if ("!".equals(expression.getValue())) {
                    isNeedAnd = ConditionHelper.adjustAnd(sqlBuffer, isNeedAnd);
                    sqlBuffer.append(expression.getValue());
                } else {
                    sqlBuffer.append(ONE_SPACE);
                    sqlBuffer.append(expression.getValue());
                    sqlBuffer.append(ONE_SPACE);
                }
                isNeedAnd = false;
                continue;
            }
            isNeedAnd = ConditionHelper.adjustAnd(sqlBuffer, isNeedAnd);
            sqlBuffer.append(columnName);
            if (expression.getValue() == null) {
                if ("=".equals(expression.getOpType())) {
                    sqlBuffer.append(ONE_SPACE + K.isNull);
                } else {
                    sqlBuffer.append(ONE_SPACE + K.isNotNull);
                    if (!"!=".equals(expression.getOpType())) {
                        String fieldName = columnName;
                        Logger.warn(fieldName + expression.getOpType() + "null transfer to : " + fieldName + ONE_SPACE + K.isNotNull);
                    }
                }
            } else if (expression.getOpNum() == -3) {
                sqlBuffer.append(expression.getOpType());
                sqlBuffer.append(expression.getValue());
            } else {
                sqlBuffer.append(expression.getOpType());
                if (expression.getValue().getClass() == TO_DATE.class) {
                    TO_DATE to_date = (TO_DATE)expression.getValue();
                    String formatter = to_date.getFormatter();
                    if (NameCheckUtil.isContainCommentString(formatter)) {
                        throw new BeeIllegalSQLException("formatter :" + formatter + " , have sql comment character");
                    }
                    if (!HoneyUtil.isOracle()) {
                        Logger.warn("Make sure the Database support TO_DATE() function!");
                    }
                    sqlBuffer.append(K.to_date + "(?, '" + formatter + "')");
                    ConditionHelper.addValeToPvList(list, to_date.getDatetimeValue());
                } else {
                    sqlBuffer.append("?");
                    ConditionHelper.addValeToPvList(list, expression.getValue());
                }
            }
            isNeedAnd = true;
        }
        return new WhereConditionWrap(sqlBuffer, list, isFirstWhere);
    }

    private static void addValeToPvList(List<PreparedValue> list, Object value) {
        PreparedValue preparedValue = new PreparedValue();
        preparedValue.setValue(value);
        if (value == null) {
            preparedValue.setType(Object.class.getName());
        } else {
            preparedValue.setType(value.getClass().getName());
        }
        list.add(preparedValue);
    }
}

