/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import org.teasoft.bee.osql.annotation.ColumnHandler;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.util.ObjectUtils;

public class DefaultColumnHandler
implements ColumnHandler {
    private final String field2Column = "_SYS_Bee_Field2Column";

    public String toColumnName(String fieldName, Class entityClass) {
        String s1 = this.toColumnName0(fieldName, entityClass);
        if (s1 == null && DefaultColumnHandler.isOpenEntityCanExtend()) {
            Class superClass = null;
            Class currentClass = entityClass;
            while (HoneyUtil.isSuperEntity(superClass = currentClass.getSuperclass())) {
                s1 = this.toColumnName0(fieldName, superClass);
                currentClass = superClass;
                if (s1 == null) continue;
            }
        }
        return s1;
    }

    private String toColumnName0(String fieldName, Class entityClass) {
        if (HoneyUtil.isJavaPackage(entityClass)) {
            Logger.debug("The parameter entityClass is from Java library");
            return null;
        }
        if (entityClass != null) {
            String defineColumn;
            String entityFullName = entityClass.getName();
            Boolean flag = HoneyContext.getCustomFlagMap("_SYS_Bee_Field2Column" + entityFullName);
            if (flag == null) {
                this.initDefineColumn(entityClass);
                flag = HoneyContext.getCustomFlagMap("_SYS_Bee_Field2Column" + entityFullName);
            }
            if (ObjectUtils.isTrue(flag) && (defineColumn = HoneyContext.getCustomMapValue("_SYS_Bee_Field2Column" + entityFullName, fieldName)) != null) {
                return defineColumn;
            }
        }
        return null;
    }

    public String toFieldName(String columnName, Class entityClass) {
        String s1 = this.toFieldName0(columnName, entityClass);
        if (s1 == null && DefaultColumnHandler.isOpenEntityCanExtend()) {
            Class superClass = null;
            Class currentClass = entityClass;
            while (HoneyUtil.isSuperEntity(superClass = currentClass.getSuperclass())) {
                s1 = this.toFieldName0(columnName, superClass);
                currentClass = superClass;
                if (s1 == null) continue;
            }
        }
        return s1;
    }

    private String toFieldName0(String columnName, Class entityClass) {
        if (HoneyUtil.isJavaPackage(entityClass)) {
            Logger.debug("The parameter entityClass is from Java library");
            return null;
        }
        if (entityClass != null) {
            String fieldName;
            String entityFullName = entityClass.getName();
            Boolean flag = HoneyContext.getCustomFlagMap("_SYS_Bee_Field2Column" + entityFullName);
            if (ObjectUtils.isTrue(flag) && (fieldName = HoneyContext.getCustomMapValue("_SYS_Bee_Column2Field:" + entityFullName, columnName)) != null) {
                return fieldName;
            }
        }
        return null;
    }

    void initDefineColumn(Class entityClass) {
        HoneyContext.initParseDefineColumn(entityClass);
    }

    private static boolean isOpenEntityCanExtend() {
        return HoneyConfig.getHoneyConfig().openEntityCanExtend;
    }
}

