/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.teasoft.bee.mongodb.MongodbBeeSql;
import org.teasoft.bee.mongodb.MongodbRawSql;
import org.teasoft.bee.mvc.service.ObjSQLRichService;
import org.teasoft.bee.mvc.service.ObjSQLService;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.Cache;
import org.teasoft.bee.osql.MoreObjToSQL;
import org.teasoft.bee.osql.NameTranslate;
import org.teasoft.bee.osql.ObjToSQL;
import org.teasoft.bee.osql.ObjToSQLRich;
import org.teasoft.bee.osql.api.CallableSql;
import org.teasoft.bee.osql.api.Condition;
import org.teasoft.bee.osql.api.MapSql;
import org.teasoft.bee.osql.api.MapSuid;
import org.teasoft.bee.osql.api.MoreTable;
import org.teasoft.bee.osql.api.PreparedSql;
import org.teasoft.bee.osql.api.Suid;
import org.teasoft.bee.osql.api.SuidRich;
import org.teasoft.bee.osql.chain.UnionSelect;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.dialect.DbFeatureRegistry;
import org.teasoft.bee.osql.exception.NoConfigException;
import org.teasoft.bee.osql.interccept.InterceptorChain;
import org.teasoft.honey.osql.chain.UnionSelectImpl;
import org.teasoft.honey.osql.core.CallableSqlLib;
import org.teasoft.honey.osql.core.ConditionImpl;
import org.teasoft.honey.osql.core.DefaultBeeExtCache;
import org.teasoft.honey.osql.core.DefaultCache;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MapSqlImpl;
import org.teasoft.honey.osql.core.MapSuidImpl;
import org.teasoft.honey.osql.core.MongodbObjSQL;
import org.teasoft.honey.osql.core.MongodbObjSQLRich;
import org.teasoft.honey.osql.core.MongodbRawSqlLib;
import org.teasoft.honey.osql.core.MoreObjSQL;
import org.teasoft.honey.osql.core.MoreObjectToSQL;
import org.teasoft.honey.osql.core.NoCache;
import org.teasoft.honey.osql.core.ObjSQL;
import org.teasoft.honey.osql.core.ObjSQLRich;
import org.teasoft.honey.osql.core.ObjectToSQL;
import org.teasoft.honey.osql.core.ObjectToSQLRich;
import org.teasoft.honey.osql.core.PreparedSqlLib;
import org.teasoft.honey.osql.core.SqlLib;
import org.teasoft.honey.osql.core.SqlLibForApp;
import org.teasoft.honey.osql.dialect.HSqlDbFrontLimitPaging;
import org.teasoft.honey.osql.dialect.LimitOffsetPaging;
import org.teasoft.honey.osql.dialect.NoPagingSupported;
import org.teasoft.honey.osql.dialect.OffsetFetchPaging;
import org.teasoft.honey.osql.dialect.mysql.MySqlFeature;
import org.teasoft.honey.osql.dialect.oracle.OracleFeature;
import org.teasoft.honey.osql.dialect.sqlserver.SqlServerFeature;
import org.teasoft.honey.osql.interccept.InterceptorChainRegistry;
import org.teasoft.honey.osql.mongodb.MongodbBeeSqlRegister;
import org.teasoft.honey.osql.name.DbUpperAndJavaLower;
import org.teasoft.honey.osql.name.OriginalName;
import org.teasoft.honey.osql.name.UnderScoreAndCamelName;
import org.teasoft.honey.osql.name.UpperCaseUnderScoreAndCamelName;
import org.teasoft.honey.osql.serviceimpl.ObjSQLRichServiceImpl;
import org.teasoft.honey.osql.serviceimpl.ObjSQLServiceImpl;

public class HoneyFactory {
    private Suid suid;
    private SuidRich suidRich;
    private BeeSql beeSql;
    private ObjToSQL objToSQL;
    private ObjToSQLRich objToSQLRich;
    private PreparedSql preparedSql;
    private CallableSql callableSql;
    private Condition condition;
    private MoreTable moreTable;
    private MoreObjToSQL moreObjToSQL;
    private MapSql mapSql;
    private MapSuid mapSuid;
    private DbFeature dbFeature;
    private NameTranslate nameTranslate;
    private static Cache cache;
    private UnionSelect unionSelect;
    private InterceptorChain interceptorChain;
    private MongodbBeeSql mongodbBeeSql;
    private MongodbRawSql mongodbRawSql;
    private ObjSQLService objSQLService;
    private ObjSQLRichService objSQLRichService;
    private boolean isOceanBasePrintFirst = true;
    private static final byte[] lock;

    HoneyFactory() {
    }

    private static boolean getUseLevelTwo() {
        return HoneyConfig.getHoneyConfig().cache_useLevelTwo;
    }

    private static Cache initCache() {
        Object cache;
        boolean nocache = HoneyConfig.getHoneyConfig().cache_nocache;
        boolean useLevelTwo = HoneyFactory.getUseLevelTwo();
        if (nocache) {
            Logger.warn("[Bee] ==========Now the Cache type is: nocache.");
            cache = new NoCache();
        } else if (useLevelTwo) {
            ServiceLoader<Cache> caches = ServiceLoader.load(Cache.class);
            Object cache1 = null;
            Object cache2 = null;
            int num = 0;
            Iterator<Cache> cacheIterator = caches.iterator();
            while (cacheIterator.hasNext()) {
                try {
                    Cache ca = cacheIterator.next();
                    ++num;
                    String className = ca.getClass().getName();
                    if ("org.teasoft.beex.cache.redis.BeeExtRedisCache".equals(className)) {
                        cache1 = ca;
                    } else {
                        cache2 = ca;
                    }
                    Logger.warn("[Bee] ==========load Cache's Service by ServiceLoader:" + className);
                }
                catch (ServiceConfigurationError e) {
                    Logger.error(e.getMessage(), e);
                }
            }
            if (num != 0) {
                Logger.warn("[Bee] ==========load Cache's Service number: " + num);
            }
            if (cache2 != null) {
                cache = cache2;
                Logger.warn("[Bee] ==========use Cache's Service is:" + cache2.getClass().getName());
            } else if (cache1 != null) {
                cache = cache1;
                Logger.warn("[Bee] ==========use Cache's Service is:" + cache1.getClass().getName());
            } else {
                cache = new DefaultBeeExtCache();
            }
        } else {
            cache = new DefaultCache();
        }
        return cache;
    }

    public Suid getSuid() {
        if (this.suid == null) {
            if (this.isMongodb()) {
                return new MongodbObjSQL();
            }
            return new ObjSQL();
        }
        return this.suid;
    }

    public void setSuid(Suid suid) {
        this.suid = suid;
    }

    public SuidRich getSuidRich() {
        if (this.suidRich == null) {
            if (this.isMongodb()) {
                return new MongodbObjSQLRich();
            }
            return new ObjSQLRich();
        }
        return this.suidRich;
    }

    private boolean isMongodb() {
        boolean justMongodb = HoneyConfig.getHoneyConfig().multiDS_justMongodb;
        boolean enableMultiDs = HoneyConfig.getHoneyConfig().multiDS_enable;
        boolean isDifferentDbType = HoneyConfig.getHoneyConfig().multiDS_differentDbType;
        return justMongodb || (enableMultiDs && isDifferentDbType || !enableMultiDs) && HoneyUtil.isMongoDB();
    }

    public void setSuidRich(SuidRich suidRich) {
        this.suidRich = suidRich;
    }

    public Suid getSuidForMongodb() {
        return new MongodbObjSQL();
    }

    public SuidRich getSuidRichForMongodb() {
        return new MongodbObjSQLRich();
    }

    public MoreTable getMoreTable() {
        if (this.moreTable == null) {
            return new MoreObjSQL();
        }
        return this.moreTable;
    }

    public void setMoreTable(MoreTable moreTable) {
        this.moreTable = moreTable;
    }

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            boolean isAndroid = HoneyConfig.getHoneyConfig().isAndroid;
            boolean isHarmony = HoneyConfig.getHoneyConfig().isHarmony;
            if (isAndroid || isHarmony) {
                this.beeSql = new SqlLibForApp();
                return this.beeSql;
            }
            return new SqlLib();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    public MongodbBeeSql getMongodbBeeSql() {
        if (this.mongodbBeeSql == null) {
            return MongodbBeeSqlRegister.getInstance();
        }
        return this.mongodbBeeSql;
    }

    public void setMongodbBeeSql(MongodbBeeSql mongodbBeeSql) {
        this.mongodbBeeSql = mongodbBeeSql;
    }

    public MongodbRawSql getMongodbRawSql() {
        if (this.mongodbBeeSql == null) {
            return new MongodbRawSqlLib();
        }
        return this.mongodbRawSql;
    }

    public void setMongodbRawSql(MongodbRawSql mongodbRawSql) {
        this.mongodbRawSql = mongodbRawSql;
    }

    public ObjToSQL getObjToSQL() {
        if (this.objToSQL == null) {
            return new ObjectToSQL();
        }
        return this.objToSQL;
    }

    public void setObjToSQL(ObjToSQL objToSQL) {
        this.objToSQL = objToSQL;
    }

    public ObjToSQLRich getObjToSQLRich() {
        if (this.objToSQLRich == null) {
            return new ObjectToSQLRich();
        }
        return this.objToSQLRich;
    }

    public void setObjToSQLRich(ObjToSQLRich objToSQLRich) {
        this.objToSQLRich = objToSQLRich;
    }

    public MoreObjToSQL getMoreObjToSQL() {
        if (this.moreObjToSQL == null) {
            return new MoreObjectToSQL();
        }
        return this.moreObjToSQL;
    }

    public void setMoreObjToSQL(MoreObjToSQL moreObjToSQL) {
        this.moreObjToSQL = moreObjToSQL;
    }

    public PreparedSql getPreparedSql() {
        if (this.preparedSql == null) {
            return new PreparedSqlLib();
        }
        return this.preparedSql;
    }

    public void setPreparedSql(PreparedSql preparedSql) {
        this.preparedSql = preparedSql;
    }

    public CallableSql getCallableSql() {
        if (this.callableSql == null) {
            return new CallableSqlLib();
        }
        return this.callableSql;
    }

    public void setCallableSql(CallableSql callableSql) {
        this.callableSql = callableSql;
    }

    public Condition getCondition() {
        if (this.condition == null) {
            return new ConditionImpl();
        }
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public MapSql getMapSql() {
        if (this.mapSql == null) {
            return new MapSqlImpl();
        }
        return this.mapSql;
    }

    public void setMapSql(MapSql mapSql) {
        this.mapSql = mapSql;
    }

    public MapSuid getMapSuid() {
        if (this.mapSuid == null) {
            return new MapSuidImpl();
        }
        return this.mapSuid;
    }

    public void setMapSuid(MapSuid mapSuid) {
        this.mapSuid = mapSuid;
    }

    public UnionSelect getUnionSelect() {
        if (this.unionSelect == null) {
            return new UnionSelectImpl();
        }
        return this.unionSelect;
    }

    public void setUnionSelect(UnionSelect unionSelect) {
        this.unionSelect = unionSelect;
    }

    public ObjSQLService getObjSQLService() {
        if (this.objSQLService == null) {
            return new ObjSQLServiceImpl();
        }
        return this.objSQLService;
    }

    public void setObjSQLService(ObjSQLService objSQLService) {
        this.objSQLService = objSQLService;
    }

    public ObjSQLRichService getObjSQLRichService() {
        if (this.objSQLRichService == null) {
            return new ObjSQLRichServiceImpl();
        }
        return this.objSQLRichService;
    }

    public void setObjSQLRichService(ObjSQLRichService objSQLRichService) {
        this.objSQLRichService = objSQLRichService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cache getCache() {
        if (cache != null) return cache;
        byte[] byArray = lock;
        synchronized (lock) {
            if (cache != null) return cache;
            HoneyFactory._setCache(HoneyFactory.initCache());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cache;
        }
    }

    public void setCache(Cache cache) {
        HoneyFactory._setCache(cache);
    }

    private static void _setCache(Cache cache) {
        HoneyFactory.cache = cache;
    }

    public DbFeature getDbFeature() {
        String dbName = HoneyContext.getRealTimeDbName();
        if (dbName != null) {
            String logMsg = "========= get the dbName in real time is :" + dbName;
            Logger.logSQL(logMsg, "");
            return this._getDbDialectFeature(dbName);
        }
        if (this.dbFeature != null) {
            return this.dbFeature;
        }
        return this._getDbDialectFeature();
    }

    public void setDbFeature(DbFeature dbFeature) {
        this.dbFeature = dbFeature;
    }

    NameTranslate getInitNameTranslate() {
        if (this.nameTranslate == null) {
            int translateType = HoneyConfig.getHoneyConfig().naming_translateType;
            this.nameTranslate = translateType == 1 ? new UnderScoreAndCamelName() : (translateType == 2 ? new UpperCaseUnderScoreAndCamelName() : (translateType == 3 ? new OriginalName() : (translateType == 4 ? new DbUpperAndJavaLower() : new UnderScoreAndCamelName())));
            return this.nameTranslate;
        }
        return this.nameTranslate;
    }

    DbFeature _getDbDialectFeature() {
        return this._getDbDialectFeature(HoneyContext.getDbDialect());
    }

    private DbFeature _getDbDialectFeature(String dbName) {
        DbFeature dbFeature = DbFeatureRegistry.getDbFeature((String)dbName);
        if (dbFeature != null) {
            return dbFeature;
        }
        if ("MySQL".equalsIgnoreCase(dbName) || "MariaDB".equalsIgnoreCase(dbName)) {
            return new MySqlFeature();
        }
        if ("Oracle".equalsIgnoreCase(dbName)) {
            return new OracleFeature();
        }
        if ("Microsoft SQL Server".equalsIgnoreCase(dbName)) {
            return new SqlServerFeature();
        }
        if (this._isLimitOffsetDB()) {
            return new LimitOffsetPaging();
        }
        if (this._isFrontLimitDB()) {
            return new HSqlDbFrontLimitPaging();
        }
        if (this._isOffsetFetchDB()) {
            return new OffsetFetchPaging();
        }
        if (this._isLimitMN()) {
            return new MySqlFeature();
        }
        if ("OceanBase".equalsIgnoreCase(dbName)) {
            String oceanbaseMode = HoneyConfig.getHoneyConfig().oceanbaseMode;
            boolean isDifferentDbType = HoneyConfig.getHoneyConfig().multiDS_differentDbType;
            if (isDifferentDbType || this.isOceanBasePrintFirst) {
                this.isOceanBasePrintFirst = false;
                Logger.logSQL("Using OceanBase,the Mode is : " + oceanbaseMode, "");
            }
            if ("Oracle".equalsIgnoreCase(oceanbaseMode)) {
                return new OracleFeature();
            }
            return new MySqlFeature();
        }
        if (dbName != null) {
            return new NoPagingSupported();
        }
        throw new NoConfigException("Error: Do not set the DbFeature implements class or do not set the database name. ");
    }

    private boolean _isLimitOffsetDB() {
        boolean comm;
        String dbName = HoneyContext.getDbDialect();
        boolean bl = comm = "H2".equalsIgnoreCase(dbName) || "SQLite".equalsIgnoreCase(dbName) || "PostgreSQL".equalsIgnoreCase(dbName) || "Microsoft Access".equalsIgnoreCase(dbName);
        if (comm) {
            return comm;
        }
        boolean other = HoneyConfig.getHoneyConfig().pagingWithLimitOffset;
        return comm || other;
    }

    private boolean _isLimitMN() {
        String dbName = HoneyContext.getDbDialect();
        boolean f = "Cubrid".equalsIgnoreCase(dbName);
        return f;
    }

    private boolean _isFrontLimitDB() {
        String dbName = HoneyContext.getDbDialect();
        boolean comm = "HSQL Database".equalsIgnoreCase(dbName) || "HSQL Database Engine".equalsIgnoreCase(dbName);
        return comm;
    }

    private boolean _isOffsetFetchDB() {
        String dbName = HoneyContext.getDbDialect();
        boolean comm = "Apache Derby".equalsIgnoreCase(dbName) || "Firebird".equalsIgnoreCase(dbName);
        return comm;
    }

    public InterceptorChain getInterceptorChain() {
        if (this.interceptorChain == null) {
            return InterceptorChainRegistry.getInterceptorChain();
        }
        return HoneyUtil.copy(this.interceptorChain);
    }

    public void setInterceptorChain(InterceptorChain interceptorChain) {
        this.interceptorChain = interceptorChain;
    }

    static {
        lock = new byte[0];
        cache = HoneyFactory.initCache();
    }
}

